/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.components;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.http.HttpMethod;
import io.apiman.gateway.engine.components.http.IHttpClientRequest;
import io.apiman.gateway.engine.components.http.IHttpClientResponse;
import io.apiman.gateway.platforms.servlet.components.HttpClientResponseImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HttpClientRequestImpl
implements IHttpClientRequest {
    private String endpoint;
    private HttpMethod method;
    private Map<String, String> headers = new HashMap<String, String>();
    private IAsyncResultHandler<IHttpClientResponse> handler;
    private HttpURLConnection connection;
    private OutputStream outputStream;

    public HttpClientRequestImpl(String endpoint, HttpMethod method, IAsyncResultHandler<IHttpClientResponse> handler) {
        this.endpoint = endpoint;
        this.method = method;
        this.handler = handler;
    }

    public void addHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public void removeHeader(String headerName) {
        this.headers.remove(headerName);
    }

    public void write(byte[] data) {
        if (this.connection == null) {
            this.connect();
        }
        try {
            if (this.outputStream == null) {
                this.outputStream = this.connection.getOutputStream();
            }
            this.connection.getOutputStream().write(data);
        }
        catch (IOException e) {
            this.connection.disconnect();
            this.handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public void write(String data, String charsetName) {
        if (this.connection == null) {
            this.connect();
        }
        try {
            this.connection.getOutputStream().write(data.getBytes(charsetName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void end() {
        if (this.connection == null) {
            this.connect();
        }
        if (this.outputStream != null) {
            IOUtils.closeQuietly((OutputStream)this.outputStream);
            this.outputStream = null;
        }
        HttpClientResponseImpl clientResponse = new HttpClientResponseImpl(this.connection);
        this.handler.handle((Object)AsyncResultImpl.create((Object)clientResponse));
    }

    private void connect() {
        try {
            URL url = new URL(this.endpoint);
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setReadTimeout(15000);
            this.connection.setConnectTimeout(10000);
            this.connection.setRequestMethod(this.method.name());
            if (this.method == HttpMethod.POST || this.method == HttpMethod.PUT) {
                this.connection.setDoOutput(true);
            } else {
                this.connection.setDoOutput(false);
            }
            this.connection.setDoInput(true);
            this.connection.setUseCaches(false);
            for (String headerName : this.headers.keySet()) {
                String headerValue = this.headers.get(headerName);
                this.connection.setRequestProperty(headerName, headerValue);
            }
            this.connection.connect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

