/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.connectors.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CipherSelectingSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory delegate;
    private String[] ciphers;
    private String[] protocols;
    private boolean clientAuth;

    public CipherSelectingSSLSocketFactory(SSLSocketFactory delegate, String[] ciphers, String[] protocols, boolean needClientAuth) {
        this.delegate = delegate;
        this.ciphers = ciphers;
        this.protocols = protocols;
        this.clientAuth = needClientAuth;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(s, host, port, autoClose);
        this.prepareSSLSocket(socket);
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.createSocket(host, port);
        return this.prepareSSLSocket(socket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.createSocket(host, port);
        return this.prepareSSLSocket(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.createSocket(host, port, localHost, localPort);
        return this.prepareSSLSocket(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.createSocket(address, port, localAddress, localPort);
        return this.prepareSSLSocket(socket);
    }

    private Socket prepareSSLSocket(SSLSocket socket) {
        socket.setEnabledCipherSuites(this.ciphers);
        socket.setEnabledProtocols(this.protocols);
        socket.setNeedClientAuth(this.clientAuth);
        return socket;
    }
}

