/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.test.server;

import io.apiman.gateway.api.rest.impl.ApplicationResourceImpl;
import io.apiman.gateway.api.rest.impl.ServiceResourceImpl;
import io.apiman.gateway.api.rest.impl.SystemResourceImpl;
import io.apiman.gateway.api.rest.impl.mappers.RestExceptionMapper;
import io.apiman.gateway.platforms.war.listeners.WarGatewayBootstrapper;
import io.apiman.gateway.platforms.war.servlets.WarGatewayServlet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;

public class GatewayServer {
    private Server server;
    private int port;

    public GatewayServer(int port) {
        this.port = port;
    }

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Server (" + this.getClass().getSimpleName() + ")");
        this.preStart();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        this.server = new Server(this.port);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    private void preStart() {
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler server = new ServletContextHandler(1);
        server.setContextPath("/");
        server.addEventListener((EventListener)new WarGatewayBootstrapper());
        ServletHolder servlet = new ServletHolder((Servlet)new WarGatewayServlet());
        server.addServlet(servlet, "/gateway/*");
        servlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        servlet.setInitParameter("javax.ws.rs.Application", TestGatewayApplication.class.getName());
        servlet.setInitParameter("resteasy.servlet.mapping.prefix", "/api");
        servlet.setInitOrder(1);
        server.addServlet(servlet, "/api/*");
        handlers.addHandler((Handler)server);
    }

    @ApplicationPath(value="/")
    public static class TestGatewayApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            HashSet classes = new HashSet();
            classes.add(SystemResourceImpl.class);
            classes.add(ServiceResourceImpl.class);
            classes.add(ApplicationResourceImpl.class);
            classes.add(RestExceptionMapper.class);
            return classes;
        }
    }
}

