/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.test.server;

import io.apiman.gateway.api.rest.impl.ApplicationResourceImpl;
import io.apiman.gateway.api.rest.impl.ServiceResourceImpl;
import io.apiman.gateway.api.rest.impl.SystemResourceImpl;
import io.apiman.gateway.api.rest.impl.mappers.RestExceptionMapper;
import io.apiman.gateway.engine.es.ESClientFactory;
import io.apiman.gateway.platforms.war.listeners.WarGatewayBootstrapper;
import io.apiman.gateway.platforms.war.servlets.WarGatewayServlet;
import io.apiman.gateway.test.server.GatewayTestType;
import io.apiman.gateway.test.server.GatewayTestUtils;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.indices.DeleteIndex;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;

public class GatewayServer {
    public static GatewayServer gatewayServer;
    private static final String ES_CLUSTER_NAME = "_apimantest";
    public static JestClient ES_CLIENT;
    private Server server;
    private int port;
    private Node node = null;
    private JestClient client = null;

    public GatewayServer(int port) {
        this.port = port;
        gatewayServer = this;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Server (" + this.getClass().getSimpleName() + ")");
        this.preStart();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        this.server = new Server(this.port);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    private void preStart() throws IOException {
        if (GatewayTestUtils.getTestType() == GatewayTestType.es && this.node == null) {
            System.out.println("******* Creating the ES node for gateway testing.");
            File esHome = new File("target/es");
            String esHomeSP = System.getProperty("apiman.test.es-home", null);
            if (esHomeSP != null) {
                esHome = new File(esHomeSP);
            }
            if (esHome.isDirectory()) {
                FileUtils.deleteDirectory((File)esHome);
            }
            ImmutableSettings.Builder settings = NodeBuilder.nodeBuilder().settings();
            settings.put("path.home", esHome.getAbsolutePath());
            settings.put("http.port", "6500-6600");
            settings.put("transport.tcp.port", "6600-6700");
            settings.put("script.disable_dynamic", "false");
            String clusterName = System.getProperty("apiman.test.es-cluster-name", ES_CLUSTER_NAME);
            boolean isPersistent = "true".equals(System.getProperty("apiman.test.es-persistence", "false"));
            if (!isPersistent) {
                settings.put("index.store.type", "memory").put("gateway.type", "none").put("index.number_of_shards", 1).put("index.number_of_replicas", 1);
                this.node = NodeBuilder.nodeBuilder().client(false).clusterName(clusterName).data(true).local(true).settings((Settings.Builder)settings).build();
            } else {
                this.node = NodeBuilder.nodeBuilder().client(false).clusterName(clusterName).data(true).local(false).settings((Settings.Builder)settings).build();
            }
            System.out.println("Starting the ES node.");
            this.node.start();
            System.out.println("ES node was successfully started.");
            String connectionUrl = "http://localhost:6500";
            JestClientFactory factory = new JestClientFactory();
            factory.setHttpClientConfig(((HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true)).build());
            ES_CLIENT = this.client = factory.getObject();
        }
    }

    public void stop() throws Exception {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.node != null && "true".equals(System.getProperty("apiman.test.es-delete-index", "true"))) {
            this.client.execute((Action)new DeleteIndex.Builder("apiman_gateway").build());
            ESClientFactory.clearClientCache();
        }
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler server = new ServletContextHandler(1);
        server.setContextPath("/");
        server.addEventListener((EventListener)new WarGatewayBootstrapper());
        ServletHolder servlet = new ServletHolder((Servlet)new WarGatewayServlet());
        server.addServlet(servlet, "/gateway/*");
        servlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        servlet.setInitParameter("javax.ws.rs.Application", TestGatewayApplication.class.getName());
        servlet.setInitParameter("resteasy.servlet.mapping.prefix", "/api");
        servlet.setInitOrder(1);
        server.addServlet(servlet, "/api/*");
        handlers.addHandler((Handler)server);
    }

    static {
        ES_CLIENT = null;
    }

    @ApplicationPath(value="/")
    public static class TestGatewayApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            HashSet classes = new HashSet();
            classes.add(SystemResourceImpl.class);
            classes.add(ServiceResourceImpl.class);
            classes.add(ApplicationResourceImpl.class);
            classes.add(RestExceptionMapper.class);
            return classes;
        }
    }
}

