/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core;

import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.core.exceptions.AlreadyExistsException;
import io.apiman.manager.api.core.exceptions.DoesNotExistException;
import io.apiman.manager.api.core.exceptions.StorageException;
import java.util.Set;

public interface IIdmStorage {
    public void createUser(UserBean var1) throws StorageException, AlreadyExistsException;

    public UserBean getUser(String var1) throws StorageException, DoesNotExistException;

    public void updateUser(UserBean var1) throws StorageException, DoesNotExistException;

    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean var1) throws StorageException;

    public void createRole(RoleBean var1) throws StorageException, AlreadyExistsException;

    public RoleBean getRole(String var1) throws StorageException, DoesNotExistException;

    public void updateRole(RoleBean var1) throws StorageException, DoesNotExistException;

    public void deleteRole(RoleBean var1) throws StorageException, DoesNotExistException;

    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean var1) throws StorageException;

    public void createMembership(RoleMembershipBean var1) throws StorageException, AlreadyExistsException;

    public void deleteMembership(String var1, String var2, String var3) throws StorageException, DoesNotExistException;

    public void deleteMemberships(String var1, String var2) throws StorageException;

    public Set<RoleMembershipBean> getUserMemberships(String var1) throws StorageException;

    public Set<RoleMembershipBean> getUserMemberships(String var1, String var2) throws StorageException;

    public Set<RoleMembershipBean> getOrgMemberships(String var1) throws StorageException;

    public Set<PermissionBean> getPermissions(String var1) throws StorageException;
}

