/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core;

import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.core.exceptions.AlreadyExistsException;
import io.apiman.manager.api.core.exceptions.DoesNotExistException;
import io.apiman.manager.api.core.exceptions.StorageException;

public interface IStorage {
    public void beginTx() throws StorageException;

    public void commitTx() throws StorageException;

    public void rollbackTx();

    public <T> void create(T var1) throws StorageException, AlreadyExistsException;

    public <T> void update(T var1) throws StorageException, DoesNotExistException;

    public <T> void delete(T var1) throws StorageException, DoesNotExistException;

    public <T> T get(Long var1, Class<T> var2) throws StorageException, DoesNotExistException;

    public <T> T get(String var1, Class<T> var2) throws StorageException, DoesNotExistException;

    public <T> T get(String var1, String var2, Class<T> var3) throws StorageException, DoesNotExistException;

    public <T> SearchResultsBean<T> find(SearchCriteriaBean var1, Class<T> var2) throws StorageException;

    public void createAuditEntry(AuditEntryBean var1) throws StorageException;

    public <T> SearchResultsBean<AuditEntryBean> auditEntity(String var1, String var2, String var3, Class<T> var4, PagingBean var5) throws StorageException;

    public <T> SearchResultsBean<AuditEntryBean> auditUser(String var1, PagingBean var2) throws StorageException;
}

