/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core;

import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.core.exceptions.AlreadyExistsException;
import io.apiman.manager.api.core.exceptions.DoesNotExistException;
import io.apiman.manager.api.core.exceptions.StorageException;

public interface IStorage {
    public void beginTx() throws StorageException;

    public void commitTx() throws StorageException;

    public void rollbackTx();

    public void createOrganization(OrganizationBean var1) throws StorageException, AlreadyExistsException;

    public void createApplication(ApplicationBean var1) throws StorageException, AlreadyExistsException;

    public void createApplicationVersion(ApplicationVersionBean var1) throws StorageException, AlreadyExistsException;

    public void createContract(ContractBean var1) throws StorageException, AlreadyExistsException;

    public void createService(ServiceBean var1) throws StorageException, AlreadyExistsException;

    public void createServiceVersion(ServiceVersionBean var1) throws StorageException, AlreadyExistsException;

    public void createPlan(PlanBean var1) throws StorageException, AlreadyExistsException;

    public void createPlanVersion(PlanVersionBean var1) throws StorageException, AlreadyExistsException;

    public void createPolicy(PolicyBean var1) throws StorageException, AlreadyExistsException;

    public void createGateway(GatewayBean var1) throws StorageException, AlreadyExistsException;

    public void createPolicyDefinition(PolicyDefinitionBean var1) throws StorageException, AlreadyExistsException;

    public void createRole(RoleBean var1) throws StorageException, AlreadyExistsException;

    public void createAuditEntry(AuditEntryBean var1) throws StorageException;

    public void updateOrganization(OrganizationBean var1) throws StorageException, DoesNotExistException;

    public void updateApplication(ApplicationBean var1) throws StorageException, DoesNotExistException;

    public void updateApplicationVersion(ApplicationVersionBean var1) throws StorageException, DoesNotExistException;

    public void updateContract(ContractBean var1) throws StorageException, DoesNotExistException;

    public void updateService(ServiceBean var1) throws StorageException, DoesNotExistException;

    public void updateServiceVersion(ServiceVersionBean var1) throws StorageException, DoesNotExistException;

    public void updatePlan(PlanBean var1) throws StorageException, DoesNotExistException;

    public void updatePlanVersion(PlanVersionBean var1) throws StorageException, DoesNotExistException;

    public void updatePolicy(PolicyBean var1) throws StorageException, DoesNotExistException;

    public void updateGateway(GatewayBean var1) throws StorageException, DoesNotExistException;

    public void updatePolicyDefinition(PolicyDefinitionBean var1) throws StorageException, DoesNotExistException;

    public void updateRole(RoleBean var1) throws StorageException, DoesNotExistException;

    public void deleteOrganization(OrganizationBean var1) throws StorageException, DoesNotExistException;

    public void deleteApplication(ApplicationBean var1) throws StorageException, DoesNotExistException;

    public void deleteApplicationVersion(ApplicationVersionBean var1) throws StorageException, DoesNotExistException;

    public void deleteContract(ContractBean var1) throws StorageException, DoesNotExistException;

    public void deleteService(ServiceBean var1) throws StorageException, DoesNotExistException;

    public void deleteServiceVersion(ServiceVersionBean var1) throws StorageException, DoesNotExistException;

    public void deletePlan(PlanBean var1) throws StorageException, DoesNotExistException;

    public void deletePlanVersion(PlanVersionBean var1) throws StorageException, DoesNotExistException;

    public void deletePolicy(PolicyBean var1) throws StorageException, DoesNotExistException;

    public void deleteGateway(GatewayBean var1) throws StorageException, DoesNotExistException;

    public void deletePolicyDefinition(PolicyDefinitionBean var1) throws StorageException, DoesNotExistException;

    public void deleteRole(RoleBean var1) throws StorageException, DoesNotExistException;

    public OrganizationBean getOrganization(String var1) throws StorageException, DoesNotExistException;

    public ApplicationBean getApplication(String var1, String var2) throws StorageException, DoesNotExistException;

    public ApplicationVersionBean getApplicationVersion(String var1, String var2, String var3) throws StorageException, DoesNotExistException;

    public ContractBean getContract(Long var1) throws StorageException, DoesNotExistException;

    public ServiceBean getService(String var1, String var2) throws StorageException, DoesNotExistException;

    public ServiceVersionBean getServiceVersion(String var1, String var2, String var3) throws StorageException, DoesNotExistException;

    public PlanBean getPlan(String var1, String var2) throws StorageException, DoesNotExistException;

    public PlanVersionBean getPlanVersion(String var1, String var2, String var3) throws StorageException, DoesNotExistException;

    public PolicyBean getPolicy(Long var1) throws StorageException, DoesNotExistException;

    public GatewayBean getGateway(String var1) throws StorageException, DoesNotExistException;

    public PolicyDefinitionBean getPolicyDefinition(String var1) throws StorageException, DoesNotExistException;

    public RoleBean getRole(String var1) throws StorageException, DoesNotExistException;
}

