/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core.util;

import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.core.IApplicationValidator;
import io.apiman.manager.api.core.IServiceValidator;
import io.apiman.manager.api.core.IStorageQuery;
import java.util.List;
import javax.inject.Inject;

public class EntityValidator
implements IServiceValidator,
IApplicationValidator {
    @Inject
    private IStorageQuery storageQuery;

    @Override
    public boolean isReady(ApplicationVersionBean application) throws Exception {
        boolean hasContracts = true;
        List<ContractSummaryBean> contracts = this.storageQuery.getApplicationContracts(application.getApplication().getOrganization().getId(), application.getApplication().getId(), application.getVersion());
        if (contracts.isEmpty()) {
            hasContracts = false;
        }
        return this.isReady(application, hasContracts);
    }

    @Override
    public boolean isReady(ApplicationVersionBean application, boolean hasContracts) throws Exception {
        boolean ready = hasContracts;
        return ready;
    }

    @Override
    public boolean isReady(ServiceVersionBean service) {
        boolean ready = true;
        if (service.getEndpoint() == null || service.getEndpoint().trim().length() == 0) {
            ready = false;
        }
        if (!service.isPublicService() && (service.getPlans() == null || service.getPlans().isEmpty())) {
            ready = false;
        }
        if (service.getGateways() == null || service.getGateways().isEmpty()) {
            ready = false;
        }
        return ready;
    }

    public IStorageQuery getStorageQuery() {
        return this.storageQuery;
    }

    public void setStorageQuery(IStorageQuery storageQuery) {
        this.storageQuery = storageQuery;
    }
}

