/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core.util;

import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionTemplateBean;
import io.apiman.manager.api.core.i18n.Messages;
import io.apiman.manager.api.core.util.PolicyConfigMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class PolicyTemplateUtil {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Map<String, CompiledTemplate> templateCache = new HashMap<String, CompiledTemplate>();

    public static void clearCache() {
        templateCache.clear();
    }

    public static void generatePolicyDescription(PolicyBean policy) throws Exception {
        PolicyDefinitionBean def = policy.getDefinition();
        PolicyDefinitionTemplateBean templateBean = PolicyTemplateUtil.getTemplateBean(def);
        if (templateBean == null) {
            return;
        }
        String cacheKey = def.getId() + "::" + templateBean.getLanguage();
        CompiledTemplate template = templateCache.get(cacheKey);
        if (template == null) {
            template = TemplateCompiler.compileTemplate((String)templateBean.getTemplate());
            templateCache.put(cacheKey, template);
        }
        try {
            String jsonConfig = policy.getConfiguration();
            Map configMap = (Map)mapper.readValue(jsonConfig, Map.class);
            configMap = new PolicyConfigMap(configMap);
            String desc = (String)TemplateRuntime.execute((CompiledTemplate)template, (Map)configMap);
            policy.setDescription(desc);
        }
        catch (Exception e) {
            policy.setDescription(templateBean.getTemplate());
        }
    }

    private static PolicyDefinitionTemplateBean getTemplateBean(PolicyDefinitionBean def) {
        Locale currentLocale = Messages.i18n.getLocale();
        String lang = currentLocale.getLanguage();
        String country = lang + "_" + currentLocale.getCountry();
        PolicyDefinitionTemplateBean nullBean = null;
        PolicyDefinitionTemplateBean langBean = null;
        PolicyDefinitionTemplateBean countryBean = null;
        for (PolicyDefinitionTemplateBean pdtb : def.getTemplates()) {
            if (pdtb.getLanguage() == null) {
                nullBean = pdtb;
                continue;
            }
            if (pdtb.getLanguage().equals(country)) {
                countryBean = pdtb;
                break;
            }
            if (!pdtb.getLanguage().equals(lang)) continue;
            langBean = pdtb;
        }
        if (countryBean != null) {
            return countryBean;
        }
        if (langBean != null) {
            return langBean;
        }
        if (nullBean != null) {
            return nullBean;
        }
        return null;
    }
}

