/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core.plugin;

import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.plugin.PluginSpec;
import io.apiman.common.plugin.PluginUtils;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.exceptions.InvalidPluginException;
import io.apiman.manager.api.core.i18n.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class AbstractPluginRegistry
implements IPluginRegistry {
    private File pluginsDir;
    private Map<PluginCoordinates, Plugin> pluginCache = new HashMap<PluginCoordinates, Plugin>();
    private Object mutex = new Object();

    public AbstractPluginRegistry() {
    }

    public AbstractPluginRegistry(File pluginsDir) {
        this.setPluginsDir(pluginsDir);
    }

    @Override
    public Plugin loadPlugin(PluginCoordinates coordinates) throws InvalidPluginException {
        if (this.pluginCache.containsKey(coordinates)) {
            return this.pluginCache.get(coordinates);
        }
        Object object = this.mutex;
        synchronized (object) {
            PluginClassLoader pluginClassLoader;
            File pluginFile;
            String pluginRelativePath = PluginUtils.getPluginRelativePath((PluginCoordinates)coordinates);
            File pluginDir = new File(this.pluginsDir, pluginRelativePath);
            if (!pluginDir.exists()) {
                pluginDir.mkdirs();
            }
            if (!(pluginFile = new File(pluginDir, "plugin." + coordinates.getType())).exists()) {
                this.downloadPlugin(pluginFile, coordinates);
            }
            if (!pluginFile.exists()) {
                throw new InvalidPluginException(Messages.i18n.format("AbstractPluginRegistry.PluginNotFound", new Object[0]));
            }
            try {
                pluginClassLoader = this.createPluginClassLoader(pluginFile);
            }
            catch (IOException e) {
                throw new InvalidPluginException(Messages.i18n.format("AbstractPluginRegistry.InvalidPlugin", new Object[]{pluginFile.getAbsolutePath()}), e);
            }
            URL specFile = pluginClassLoader.getResource("META-INF/apiman/plugin.json");
            if (specFile == null) {
                throw new InvalidPluginException(Messages.i18n.format("AbstractPluginRegistry.MissingPluginSpecFile", new Object[]{"META-INF/apiman/plugin.json"}));
            }
            try {
                PluginSpec spec = PluginUtils.readPluginSpecFile((URL)specFile);
                Plugin plugin = new Plugin(spec, coordinates, pluginClassLoader);
                return plugin;
            }
            catch (Exception e) {
                throw new InvalidPluginException(Messages.i18n.format("AbstractPluginRegistry.FailedToReadSpecFile", new Object[]{"META-INF/apiman/plugin.json"}), e);
            }
        }
    }

    protected PluginClassLoader createPluginClassLoader(final File pluginFile) throws IOException {
        PluginClassLoader cl = new PluginClassLoader(pluginFile, Thread.currentThread().getContextClassLoader()){

            protected File createWorkDir(File pluginArtifactFile) throws IOException {
                File workDir = new File(pluginFile.getParentFile(), ".work");
                workDir.mkdirs();
                return workDir;
            }
        };
        return cl;
    }

    protected void downloadPlugin(File pluginFile, PluginCoordinates coordinates) {
        File artifactFile;
        File m2Dir = PluginUtils.getUserM2Repository();
        if (m2Dir != null && (artifactFile = PluginUtils.getM2Path((File)m2Dir, (PluginCoordinates)coordinates)).isFile()) {
            try {
                FileUtils.copyFile((File)artifactFile, (File)pluginFile);
                return;
            }
            catch (IOException e) {
                artifactFile.delete();
                throw new RuntimeException(e);
            }
        }
        Set<URL> repositories = this.getMavenRepositories();
        for (URL mavenRepoUrl : repositories) {
            if (!this.downloadFromMavenRepo(pluginFile, coordinates, mavenRepoUrl)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean downloadFromMavenRepo(File pluginFile, PluginCoordinates coordinates, URL mavenRepoUrl) {
        boolean bl;
        String artifactSubPath = PluginUtils.getMavenPath((PluginCoordinates)coordinates);
        InputStream istream = null;
        FileOutputStream ostream = null;
        try {
            URL artifactUrl = new URL(mavenRepoUrl, artifactSubPath);
            istream = artifactUrl.openStream();
            ostream = new FileOutputStream(pluginFile);
            IOUtils.copy((InputStream)istream, (OutputStream)ostream);
            ostream.flush();
            bl = true;
            IOUtils.closeQuietly((InputStream)istream);
        }
        catch (Exception e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            IOUtils.closeQuietly(istream);
            IOUtils.closeQuietly(ostream);
        }
        IOUtils.closeQuietly((OutputStream)ostream);
        return bl;
    }

    protected Set<URL> getMavenRepositories() {
        return PluginUtils.getDefaultMavenRepositories();
    }

    public void setPluginsDir(File pluginsDir) {
        this.pluginsDir = pluginsDir;
        if (!this.pluginsDir.exists()) {
            this.pluginsDir.mkdirs();
        }
    }
}

