/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core.logging;

import io.apiman.manager.api.core.logging.DefaultTimeImpl;
import io.apiman.manager.api.core.logging.IApimanDelegateLogger;
import io.apiman.manager.api.core.logging.IApimanLogger;
import io.apiman.manager.api.core.logging.Time;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonLoggerImpl
implements IApimanDelegateLogger {
    private static Time time = new DefaultTimeImpl();
    private static ObjectMapper mapper = new ObjectMapper();
    private Logger delegatedLogger;
    private Class<?> klazz;

    @Override
    public IApimanLogger createLogger(Class<?> klazz) {
        this.delegatedLogger = LogManager.getLogger(klazz);
        this.klazz = klazz;
        return this;
    }

    @Override
    public IApimanLogger createLogger(String name) {
        this.delegatedLogger = LogManager.getLogger((String)name);
        return this;
    }

    public static void setTimeImpl(Time timeImpl) {
        time = timeImpl;
    }

    @Override
    public void info(String message) {
        this.delegatedLogger.info(this.jsonify(message, LogLevel.INFO));
    }

    @Override
    public void warn(String message) {
        this.delegatedLogger.warn(this.jsonify(message, LogLevel.WARN));
    }

    @Override
    public void debug(String message) {
        this.delegatedLogger.debug(this.jsonify(message, LogLevel.DEBUG));
    }

    @Override
    public void trace(String message) {
        this.delegatedLogger.trace(this.jsonify(message, LogLevel.TRACE));
    }

    @Override
    public void error(String message, Throwable error) {
        this.delegatedLogger.error(this.jsonify(message, LogLevel.ERROR, error));
    }

    @Override
    public void error(Throwable error) {
        this.delegatedLogger.error(this.jsonify(error.getMessage(), LogLevel.ERROR, error));
    }

    private String jsonify(String message, LogLevel level) {
        return this.jsonify(message, level, null);
    }

    private String jsonify(String message, LogLevel level, Throwable t) {
        try {
            int traceLen = t == null ? 0 : t.getStackTrace().length * 800;
            StringWriter sw = new StringWriter(100 + message.length() + traceLen);
            JsonGenerator generator = mapper.getJsonFactory().createJsonGenerator((Writer)sw);
            generator.writeStartObject();
            generator.writeStringField("@timestamp", time.currentTimeIso8601());
            generator.writeStringField("level", level.toString());
            generator.writeStringField("loggerName", this.klazz.getCanonicalName());
            generator.writeStringField("thread", Thread.currentThread().getName());
            generator.writeStringField("message", message);
            if (t != null) {
                generator.writeObjectFieldStart("throwable");
                generator.writeStringField("message", t.getLocalizedMessage());
                generator.writeObjectField("cause", (Object)t);
                generator.writeEndObject();
            }
            generator.writeEndObject();
            generator.close();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum LogLevel {
        INFO,
        DEBUG,
        WARN,
        TRACE,
        ERROR;

    }
}

