/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core.catalog;

import io.apiman.manager.api.beans.summary.AvailableServiceBean;
import io.apiman.manager.api.beans.summary.ServiceCatalogBean;
import io.apiman.manager.api.core.IServiceCatalog;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonServiceCatalog
implements IServiceCatalog {
    private static final ObjectMapper mapper = new ObjectMapper();
    private URL catalogUrl;
    private List<AvailableServiceBean> services;

    public JsonServiceCatalog(Map<String, String> config) {
        String cu = config.get("catalog-url");
        try {
            this.catalogUrl = new URL(cu);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<AvailableServiceBean> search(String keyword) {
        if (this.services == null) {
            this.services = JsonServiceCatalog.loadServices(this.catalogUrl);
        }
        ArrayList<AvailableServiceBean> rval = new ArrayList<AvailableServiceBean>();
        for (AvailableServiceBean service : this.services) {
            if (!service.getName().toLowerCase().contains(keyword.toLowerCase())) continue;
            rval.add(service);
        }
        return rval;
    }

    private static List<AvailableServiceBean> loadServices(URL catalogUrl) {
        try {
            ServiceCatalogBean catalog = (ServiceCatalogBean)mapper.reader(ServiceCatalogBean.class).readValue(catalogUrl);
            return catalog.getServices();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

