/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core.config;

import io.apiman.common.config.ConfigFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public abstract class ApiManagerConfig {
    public static final String APIMAN_MANAGER_CONFIG_LOGGER = "apiman-manager.config.logger";
    public static final String APIMAN_MANAGER_STORAGE_TYPE = "apiman-manager.storage.type";
    public static final String APIMAN_MANAGER_STORAGE_ES_PROTOCOL = "apiman-manager.storage.es.protocol";
    public static final String APIMAN_MANAGER_STORAGE_ES_HOST = "apiman-manager.storage.es.host";
    public static final String APIMAN_MANAGER_STORAGE_ES_PORT = "apiman-manager.storage.es.port";
    public static final String APIMAN_MANAGER_STORAGE_ES_CLUSTER_NAME = "apiman-manager.storage.es.cluster-name";
    public static final String APIMAN_MANAGER_STORAGE_ES_USERNAME = "apiman-manager.storage.es.username";
    public static final String APIMAN_MANAGER_STORAGE_ES_PASSWORD = "apiman-manager.storage.es.password";
    public static final String APIMAN_MANAGER_STORAGE_ES_INITIALIZE = "apiman-manager.storage.es.initialize";
    public static final String APIMAN_MANAGER_STORAGE_QUERY_TYPE = "apiman-manager.storage-query.type";
    public static final String APIMAN_MANAGER_IDM_STORAGE_TYPE = "apiman-manager.idm-storage.type";
    public static final String APIMAN_MANAGER_SERVICE_CATALOG_TYPE = "apiman-manager.service-catalog.type";
    public static final String APIMAN_MANAGER_METRICS_TYPE = "apiman-manager.metrics.type";
    public static final String APIMAN_MANAGER_METRICS_ES_PROTOCOL = "apiman-manager.metrics.es.protocol";
    public static final String APIMAN_MANAGER_METRICS_ES_HOST = "apiman-manager.metrics.es.host";
    public static final String APIMAN_MANAGER_METRICS_ES_PORT = "apiman-manager.metrics.es.port";
    public static final String APIMAN_MANAGER_METRICS_ES_CLUSTER_NAME = "apiman-manager.metrics.es.cluster-name";
    public static final String APIMAN_MANAGER_METRICS_ES_USERNAME = "apiman-manager.metrics.es.username";
    public static final String APIMAN_MANAGER_METRICS_ES_PASSWORD = "apiman-manager.metrics.es.password";
    public static final String APIMAN_MANAGER_SECURITY_CONTEXT_TYPE = "apiman-manager.security-context.type";
    public static final String APIMAN_PLUGIN_REPOSITORIES = "apiman.plugins.repositories";
    public static final String APIMAN_PLUGIN_REGISTRIES = "apiman-manager.plugins.registries";
    public static final String DEFAULT_ES_CLUSTER_NAME = "apiman";
    private final Configuration config = this.loadProperties();

    protected Configuration loadProperties() {
        return ConfigFactory.createConfig();
    }

    public Set<URL> getPluginRepositories() {
        HashSet<URL> rval = new HashSet<URL>();
        String repositories = this.config.getString(APIMAN_PLUGIN_REPOSITORIES);
        if (repositories != null) {
            String[] split;
            for (String repository : split = repositories.split(",")) {
                try {
                    rval.add(new URL(repository.trim()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return rval;
    }

    public Set<URL> getPluginRegistries() {
        HashSet<URL> rval = new HashSet<URL>();
        String registries = this.config.getString(APIMAN_PLUGIN_REGISTRIES);
        if (registries != null) {
            String[] split;
            for (String registry : split = registries.split(",")) {
                try {
                    rval.add(new URL(registry.trim()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return rval;
    }

    public String getSecurityContextType() {
        return this.config.getString(APIMAN_MANAGER_SECURITY_CONTEXT_TYPE, "default");
    }

    public String getStorageType() {
        return this.config.getString(APIMAN_MANAGER_STORAGE_TYPE, "jpa");
    }

    public String getStorageQueryType() {
        return this.config.getString(APIMAN_MANAGER_STORAGE_QUERY_TYPE, "jpa");
    }

    public String getIdmStorageType() {
        return this.config.getString(APIMAN_MANAGER_IDM_STORAGE_TYPE, this.getStorageType());
    }

    public String getServiceCatalogType() {
        return this.config.getString(APIMAN_MANAGER_SERVICE_CATALOG_TYPE, null);
    }

    public String getStorageESProtocol() {
        return this.config.getString(APIMAN_MANAGER_STORAGE_ES_PROTOCOL, "http");
    }

    public String getStorageESHost() {
        return this.config.getString(APIMAN_MANAGER_STORAGE_ES_HOST, "localhost");
    }

    public int getStorageESPort() {
        return this.config.getInt(APIMAN_MANAGER_STORAGE_ES_PORT, 19300);
    }

    public String getStorageESClusterName() {
        return this.config.getString(APIMAN_MANAGER_STORAGE_ES_CLUSTER_NAME, DEFAULT_ES_CLUSTER_NAME);
    }

    public String getStorageESUsername() {
        return this.config.getString(APIMAN_MANAGER_STORAGE_ES_USERNAME, null);
    }

    public String getStorageESPassword() {
        return this.config.getString(APIMAN_MANAGER_STORAGE_ES_PASSWORD, null);
    }

    public boolean isInitializeStorageES() {
        return this.config.getBoolean(APIMAN_MANAGER_STORAGE_ES_INITIALIZE, true);
    }

    public String getMetricsType() {
        return this.config.getString(APIMAN_MANAGER_METRICS_TYPE, "es");
    }

    public String getMetricsESProtocol() {
        return this.config.getString(APIMAN_MANAGER_METRICS_ES_PROTOCOL, "http");
    }

    public String getMetricsESHost() {
        return this.config.getString(APIMAN_MANAGER_METRICS_ES_HOST, "localhost");
    }

    public int getMetricsESPort() {
        return this.config.getInt(APIMAN_MANAGER_METRICS_ES_PORT, 19200);
    }

    public String getMetricsESClusterName() {
        return this.config.getString(APIMAN_MANAGER_METRICS_ES_CLUSTER_NAME, DEFAULT_ES_CLUSTER_NAME);
    }

    public String getMetricsESUsername() {
        return this.config.getString(APIMAN_MANAGER_METRICS_ES_USERNAME, null);
    }

    public String getMetricsESPassword() {
        return this.config.getString(APIMAN_MANAGER_METRICS_ES_PASSWORD, null);
    }

    public Map<String, String> getStorageProperties() {
        return this.getPrefixedProperties("apiman-manager.storage.");
    }

    public Map<String, String> getStorageQueryProperties() {
        return this.getPrefixedProperties("apiman-manager.storage-query.type.");
    }

    public Map<String, String> getIdmStorageProperties() {
        return this.getPrefixedProperties("apiman-manager.idm-storage.");
    }

    public Map<String, String> getMetricsProperties() {
        return this.getPrefixedProperties("apiman-manager.metrics.");
    }

    public Map<String, String> getServiceCatalogProperties() {
        return this.getPrefixedProperties("apiman-manager.service-catalog.");
    }

    protected Map<String, String> getPrefixedProperties(String prefix) {
        HashMap<String, String> rval = new HashMap<String, String>();
        Iterator keys = this.getConfig().getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(prefix)) continue;
            String value = this.getConfig().getString(key);
            key = key.substring(prefix.length());
            rval.put(key, value);
        }
        return rval;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getLoggerName() {
        return this.config.getString(APIMAN_MANAGER_CONFIG_LOGGER);
    }
}

