/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.core;

import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plugins.PluginBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.core.exceptions.StorageException;
import java.io.InputStream;
import java.util.List;

public interface IStorage {
    public void beginTx() throws StorageException;

    public void commitTx() throws StorageException;

    public void rollbackTx();

    public void createOrganization(OrganizationBean var1) throws StorageException;

    public void createApplication(ApplicationBean var1) throws StorageException;

    public void createApplicationVersion(ApplicationVersionBean var1) throws StorageException;

    public void createContract(ContractBean var1) throws StorageException;

    public void createService(ServiceBean var1) throws StorageException;

    public void createServiceVersion(ServiceVersionBean var1) throws StorageException;

    public void createPlan(PlanBean var1) throws StorageException;

    public void createPlanVersion(PlanVersionBean var1) throws StorageException;

    public void createPolicy(PolicyBean var1) throws StorageException;

    public void createGateway(GatewayBean var1) throws StorageException;

    public void createPlugin(PluginBean var1) throws StorageException;

    public void createPolicyDefinition(PolicyDefinitionBean var1) throws StorageException;

    public void createAuditEntry(AuditEntryBean var1) throws StorageException;

    public void updateOrganization(OrganizationBean var1) throws StorageException;

    public void updateApplication(ApplicationBean var1) throws StorageException;

    public void updateApplicationVersion(ApplicationVersionBean var1) throws StorageException;

    public void updateService(ServiceBean var1) throws StorageException;

    public void updateServiceVersion(ServiceVersionBean var1) throws StorageException;

    public void updateServiceDefinition(ServiceVersionBean var1, InputStream var2) throws StorageException;

    public void updatePlan(PlanBean var1) throws StorageException;

    public void updatePlanVersion(PlanVersionBean var1) throws StorageException;

    public void updatePolicy(PolicyBean var1) throws StorageException;

    public void updateGateway(GatewayBean var1) throws StorageException;

    public void updatePolicyDefinition(PolicyDefinitionBean var1) throws StorageException;

    public void updatePlugin(PluginBean var1) throws StorageException;

    public void deleteOrganization(OrganizationBean var1) throws StorageException;

    public void deleteApplication(ApplicationBean var1) throws StorageException;

    public void deleteApplicationVersion(ApplicationVersionBean var1) throws StorageException;

    public void deleteContract(ContractBean var1) throws StorageException;

    public void deleteService(ServiceBean var1) throws StorageException;

    public void deleteServiceVersion(ServiceVersionBean var1) throws StorageException;

    public void deleteServiceDefinition(ServiceVersionBean var1) throws StorageException;

    public void deletePlan(PlanBean var1) throws StorageException;

    public void deletePlanVersion(PlanVersionBean var1) throws StorageException;

    public void deletePolicy(PolicyBean var1) throws StorageException;

    public void deleteGateway(GatewayBean var1) throws StorageException;

    public void deletePlugin(PluginBean var1) throws StorageException;

    public void deletePolicyDefinition(PolicyDefinitionBean var1) throws StorageException;

    public OrganizationBean getOrganization(String var1) throws StorageException;

    public ApplicationBean getApplication(String var1, String var2) throws StorageException;

    public ApplicationVersionBean getApplicationVersion(String var1, String var2, String var3) throws StorageException;

    public ContractBean getContract(Long var1) throws StorageException;

    public ServiceBean getService(String var1, String var2) throws StorageException;

    public ServiceVersionBean getServiceVersion(String var1, String var2, String var3) throws StorageException;

    public InputStream getServiceDefinition(ServiceVersionBean var1) throws StorageException;

    public PlanBean getPlan(String var1, String var2) throws StorageException;

    public PlanVersionBean getPlanVersion(String var1, String var2, String var3) throws StorageException;

    public PolicyBean getPolicy(PolicyType var1, String var2, String var3, String var4, Long var5) throws StorageException;

    public GatewayBean getGateway(String var1) throws StorageException;

    public PluginBean getPlugin(long var1) throws StorageException;

    public PluginBean getPlugin(String var1, String var2) throws StorageException;

    public PolicyDefinitionBean getPolicyDefinition(String var1) throws StorageException;

    public void reorderPolicies(PolicyType var1, String var2, String var3, String var4, List<Long> var5) throws StorageException;
}

