/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.es;

import io.apiman.manager.api.beans.metrics.AppUsagePerServiceBean;
import io.apiman.manager.api.beans.metrics.HistogramBean;
import io.apiman.manager.api.beans.metrics.HistogramDataPoint;
import io.apiman.manager.api.beans.metrics.HistogramIntervalType;
import io.apiman.manager.api.beans.metrics.ResponseStatsDataPoint;
import io.apiman.manager.api.beans.metrics.ResponseStatsHistogramBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerAppBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerPlanBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsSummaryBean;
import io.apiman.manager.api.beans.metrics.UsageDataPoint;
import io.apiman.manager.api.beans.metrics.UsageHistogramBean;
import io.apiman.manager.api.beans.metrics.UsagePerAppBean;
import io.apiman.manager.api.beans.metrics.UsagePerPlanBean;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.core.logging.IApimanLogger;
import io.apiman.manager.api.es.ApimanTermsAggregation;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.DateHistogramAggregation;
import io.searchbox.core.search.aggregation.FilterAggregation;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.lang.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@ApplicationScoped
@Alternative
public class ESMetricsAccessor
implements IMetricsAccessor {
    private static final String INDEX_NAME = "apiman_metrics";
    @Inject
    @ApimanLogger(value=ESMetricsAccessor.class)
    IApimanLogger log;
    @Inject
    @Named(value="metrics")
    private JestClient esClient;

    public UsageHistogramBean getUsage(String organizationId, String serviceId, String version, HistogramIntervalType interval, DateTime from, DateTime to) {
        UsageHistogramBean rval = new UsageHistogramBean();
        Map<String, UsageDataPoint> index = ESMetricsAccessor.generateHistogramSkeleton(rval, from, to, interval, UsageDataPoint.class);
        try {
            String query = "{  \"query\": {    \"filtered\" : {      \"query\" : {        \"range\" : {          \"requestStart\" : {            \"gte\": \"${from}\",            \"lte\": \"${to}\"          }        }      },      \"filter\": {        \"and\" : [          { \"term\" : { \"serviceOrgId\" : \"${serviceOrgId}\" } },          { \"term\" : { \"serviceId\" : \"${serviceId}\" } },          { \"term\" : { \"serviceVersion\" : \"${serviceVersion}\" } }        ]      }    }  },  \"size\": 0,   \"aggs\" : {      \"histogram\" : {          \"date_histogram\" : {              \"field\" : \"requestStart\",              \"interval\" : \"${interval}\"          }      }  }}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("from", ESMetricsAccessor.formatDate(from));
            params.put("to", ESMetricsAccessor.formatDate(to));
            params.put("serviceOrgId", organizationId.replace('\"', '_'));
            params.put("serviceId", serviceId.replace('\"', '_'));
            params.put("serviceVersion", version.replace('\"', '_'));
            params.put("interval", interval.name());
            StrSubstitutor ss = new StrSubstitutor(params);
            query = ss.replace(query);
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
            SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
            MetricAggregation aggregations = response.getAggregations();
            DateHistogramAggregation aggregation = aggregations.getDateHistogramAggregation("histogram");
            if (aggregation != null) {
                List buckets = aggregation.getBuckets();
                for (DateHistogramAggregation.DateHistogram entry : buckets) {
                    String keyAsString = entry.getTimeAsString();
                    if (!index.containsKey(keyAsString)) continue;
                    index.get(keyAsString).setCount(entry.getCount().longValue());
                }
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return rval;
    }

    public static <T extends HistogramDataPoint> Map<String, T> generateHistogramSkeleton(HistogramBean<T> rval, DateTime from, DateTime to, HistogramIntervalType interval, Class<T> dataType) {
        HashMap<String, HistogramDataPoint> index = new HashMap<String, HistogramDataPoint>();
        GregorianCalendar fromCal = from.toGregorianCalendar();
        GregorianCalendar toCal = to.toGregorianCalendar();
        switch (interval) {
            case day: {
                fromCal.set(11, 0);
                fromCal.set(12, 0);
                fromCal.set(13, 0);
                fromCal.set(14, 0);
                break;
            }
            case hour: {
                fromCal.set(12, 0);
                fromCal.set(13, 0);
                fromCal.set(14, 0);
                break;
            }
            case minute: {
                fromCal.set(13, 0);
                fromCal.set(14, 0);
                break;
            }
            case month: {
                fromCal.set(5, 1);
                fromCal.set(11, 0);
                fromCal.set(12, 0);
                fromCal.set(13, 0);
                fromCal.set(14, 0);
                break;
            }
            case week: {
                fromCal.set(7, 1);
                fromCal.set(11, 0);
                fromCal.set(12, 0);
                fromCal.set(13, 0);
                fromCal.set(14, 0);
                break;
            }
        }
        while (fromCal.before(toCal)) {
            HistogramDataPoint point;
            String label = ESMetricsAccessor.formatDateWithMillis(fromCal);
            try {
                point = (HistogramDataPoint)dataType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            point.setLabel(label);
            rval.addDataPoint(point);
            index.put(label, point);
            switch (interval) {
                case day: {
                    ((Calendar)fromCal).add(6, 1);
                    break;
                }
                case hour: {
                    ((Calendar)fromCal).add(11, 1);
                    break;
                }
                case minute: {
                    ((Calendar)fromCal).add(12, 1);
                    break;
                }
                case month: {
                    ((Calendar)fromCal).add(2, 1);
                    break;
                }
                case week: {
                    ((Calendar)fromCal).add(3, 1);
                    break;
                }
            }
        }
        return index;
    }

    public UsagePerAppBean getUsagePerApp(String organizationId, String serviceId, String version, DateTime from, DateTime to) {
        UsagePerAppBean rval;
        block3: {
            rval = new UsagePerAppBean();
            try {
                String query = "{  \"query\": {    \"filtered\" : {      \"query\" : {        \"range\" : {          \"requestStart\" : {            \"gte\": \"${from}\",            \"lte\": \"${to}\"          }        }      },      \"filter\": {        \"and\" : [          { \"term\" : { \"serviceOrgId\" : \"${serviceOrgId}\" } },          { \"term\" : { \"serviceId\" : \"${serviceId}\" } },          { \"term\" : { \"serviceVersion\" : \"${serviceVersion}\" } }        ]      }    }  },  \"size\": 0,   \"aggs\" : {      \"usage_by_app\" : {        \"terms\" : {          \"field\" : \"applicationId\"        }      }  }}";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("from", ESMetricsAccessor.formatDate(from));
                params.put("to", ESMetricsAccessor.formatDate(to));
                params.put("serviceOrgId", organizationId.replace('\"', '_'));
                params.put("serviceId", serviceId.replace('\"', '_'));
                params.put("serviceVersion", version.replace('\"', '_'));
                StrSubstitutor ss = new StrSubstitutor(params);
                query = ss.replace(query);
                Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
                SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
                MetricAggregation aggregations = response.getAggregations();
                ApimanTermsAggregation aggregation = (ApimanTermsAggregation)aggregations.getAggregation("usage_by_app", ApimanTermsAggregation.class);
                if (aggregation == null) break block3;
                List<ApimanTermsAggregation.Entry> buckets = aggregation.getBuckets();
                int counter = 0;
                for (ApimanTermsAggregation.Entry entry : buckets) {
                    rval.getData().put(entry.getKey(), entry.getCount());
                    if (++counter <= 5) continue;
                    break;
                }
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
        return rval;
    }

    public UsagePerPlanBean getUsagePerPlan(String organizationId, String serviceId, String version, DateTime from, DateTime to) {
        UsagePerPlanBean rval = new UsagePerPlanBean();
        try {
            String query = "{  \"query\": {    \"filtered\" : {      \"query\" : {        \"range\" : {          \"requestStart\" : {            \"gte\": \"${from}\",            \"lte\": \"${to}\"          }        }      },      \"filter\": {        \"and\" : [          { \"term\" : { \"serviceOrgId\" : \"${serviceOrgId}\" } },          { \"term\" : { \"serviceId\" : \"${serviceId}\" } },          { \"term\" : { \"serviceVersion\" : \"${serviceVersion}\" } }        ]      }    }  },  \"size\": 0,   \"aggs\" : {      \"usage_by_plan\" : {        \"terms\" : {          \"field\" : \"planId\"        }      }  }}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("from", ESMetricsAccessor.formatDate(from));
            params.put("to", ESMetricsAccessor.formatDate(to));
            params.put("serviceOrgId", organizationId.replace('\"', '_'));
            params.put("serviceId", serviceId.replace('\"', '_'));
            params.put("serviceVersion", version.replace('\"', '_'));
            StrSubstitutor ss = new StrSubstitutor(params);
            query = ss.replace(query);
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
            SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
            MetricAggregation aggregations = response.getAggregations();
            ApimanTermsAggregation aggregation = (ApimanTermsAggregation)aggregations.getAggregation("usage_by_plan", ApimanTermsAggregation.class);
            if (aggregation != null) {
                List<ApimanTermsAggregation.Entry> buckets = aggregation.getBuckets();
                for (ApimanTermsAggregation.Entry entry : buckets) {
                    rval.getData().put(entry.getKey(), entry.getCount());
                }
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return rval;
    }

    public ResponseStatsHistogramBean getResponseStats(String organizationId, String serviceId, String version, HistogramIntervalType interval, DateTime from, DateTime to) {
        ResponseStatsHistogramBean rval = new ResponseStatsHistogramBean();
        Map<String, ResponseStatsDataPoint> index = ESMetricsAccessor.generateHistogramSkeleton(rval, from, to, interval, ResponseStatsDataPoint.class);
        try {
            String query = "{  \"query\": {    \"filtered\" : {      \"query\" : {        \"range\" : {          \"requestStart\" : {            \"gte\": \"${from}\",            \"lte\": \"${to}\"          }        }      },      \"filter\": {        \"and\" : [          { \"term\" : { \"serviceOrgId\" : \"${serviceOrgId}\" } },          { \"term\" : { \"serviceId\" : \"${serviceId}\" } },          { \"term\" : { \"serviceVersion\" : \"${serviceVersion}\" } }        ]      }    }  },  \"size\": 0,   \"aggs\" : {      \"histogram\" : {          \"date_histogram\" : {              \"field\" : \"requestStart\",              \"interval\" : \"${interval}\"          },          \"aggs\" : {              \"total_failures\" : {                  \"filter\" : { \"term\": { \"failure\": true } }              },              \"total_errors\" : {                  \"filter\" : { \"term\": { \"error\": true } }              }          }      }  }}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("from", ESMetricsAccessor.formatDate(from));
            params.put("to", ESMetricsAccessor.formatDate(to));
            params.put("serviceOrgId", organizationId.replace('\"', '_'));
            params.put("serviceId", serviceId.replace('\"', '_'));
            params.put("serviceVersion", version.replace('\"', '_'));
            params.put("interval", interval.name());
            StrSubstitutor ss = new StrSubstitutor(params);
            query = ss.replace(query);
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
            SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
            MetricAggregation aggregations = response.getAggregations();
            DateHistogramAggregation aggregation = aggregations.getDateHistogramAggregation("histogram");
            if (aggregation != null) {
                List buckets = aggregation.getBuckets();
                for (DateHistogramAggregation.DateHistogram entry : buckets) {
                    String keyAsString = entry.getTimeAsString();
                    if (!index.containsKey(keyAsString)) continue;
                    FilterAggregation totalFailuresAgg = entry.getFilterAggregation("total_failures");
                    FilterAggregation totalErrorsAgg = entry.getFilterAggregation("total_errors");
                    long failures = totalFailuresAgg.getCount();
                    long errors = totalErrorsAgg.getCount();
                    ResponseStatsDataPoint point = index.get(keyAsString);
                    point.setTotal(entry.getCount().longValue());
                    point.setFailures(failures);
                    point.setErrors(errors);
                }
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return rval;
    }

    public ResponseStatsSummaryBean getResponseStatsSummary(String organizationId, String serviceId, String version, DateTime from, DateTime to) {
        ResponseStatsSummaryBean rval = new ResponseStatsSummaryBean();
        try {
            String query = "{  \"query\": {    \"filtered\" : {      \"query\" : {        \"range\" : {          \"requestStart\" : {            \"gte\": \"${from}\",            \"lte\": \"${to}\"          }        }      },      \"filter\": {        \"and\" : [          { \"term\" : { \"serviceOrgId\" : \"${serviceOrgId}\" } },          { \"term\" : { \"serviceId\" : \"${serviceId}\" } },          { \"term\" : { \"serviceVersion\" : \"${serviceVersion}\" } }        ]      }    }  },  \"size\": 0,   \"aggs\" : {    \"total_failures\" : {      \"filter\" : { \"term\": { \"failure\": true } }    },    \"total_errors\" : {      \"filter\" : { \"term\": { \"error\": true } }    }  }}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("from", ESMetricsAccessor.formatDate(from));
            params.put("to", ESMetricsAccessor.formatDate(to));
            params.put("serviceOrgId", organizationId.replace('\"', '_'));
            params.put("serviceId", serviceId.replace('\"', '_'));
            params.put("serviceVersion", version.replace('\"', '_'));
            StrSubstitutor ss = new StrSubstitutor(params);
            query = ss.replace(query);
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
            SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
            rval.setTotal((long)response.getTotal().intValue());
            rval.setFailures(response.getAggregations().getFilterAggregation("total_failures").getCount().longValue());
            rval.setErrors(response.getAggregations().getFilterAggregation("total_errors").getCount().longValue());
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return rval;
    }

    public ResponseStatsPerAppBean getResponseStatsPerApp(String organizationId, String serviceId, String version, DateTime from, DateTime to) {
        ResponseStatsPerAppBean rval;
        block3: {
            rval = new ResponseStatsPerAppBean();
            try {
                String query = "{  \"query\": {    \"filtered\" : {      \"query\" : {        \"range\" : {          \"requestStart\" : {            \"gte\": \"${from}\",            \"lte\": \"${to}\"          }        }      },      \"filter\": {        \"and\" : [          { \"term\" : { \"serviceOrgId\" : \"${serviceOrgId}\" } },          { \"term\" : { \"serviceId\" : \"${serviceId}\" } },          { \"term\" : { \"serviceVersion\" : \"${serviceVersion}\" } }        ]      }    }  },  \"size\": 0,   \"aggs\" : {      \"by_app\" : {        \"terms\" : {          \"field\" : \"applicationId\"        },        \"aggs\" : {          \"total_failures\" : {            \"filter\" : { \"term\": { \"failure\": true } }          },          \"total_errors\" : {            \"filter\" : { \"term\": { \"error\": true } }          }        }      }  }}";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("from", ESMetricsAccessor.formatDate(from));
                params.put("to", ESMetricsAccessor.formatDate(to));
                params.put("serviceOrgId", organizationId.replace('\"', '_'));
                params.put("serviceId", serviceId.replace('\"', '_'));
                params.put("serviceVersion", version.replace('\"', '_'));
                StrSubstitutor ss = new StrSubstitutor(params);
                query = ss.replace(query);
                Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
                SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
                MetricAggregation aggregations = response.getAggregations();
                ApimanTermsAggregation aggregation = (ApimanTermsAggregation)aggregations.getAggregation("by_app", ApimanTermsAggregation.class);
                if (aggregation == null) break block3;
                List<ApimanTermsAggregation.Entry> buckets = aggregation.getBuckets();
                int counter = 0;
                for (ApimanTermsAggregation.Entry entry : buckets) {
                    ResponseStatsDataPoint point = new ResponseStatsDataPoint();
                    point.setTotal(entry.getCount().longValue());
                    rval.addDataPoint(entry.getKey(), entry.getCount().longValue(), entry.getFilterAggregation("total_failures").getCount().longValue(), entry.getFilterAggregation("total_errors").getCount().longValue());
                    if (++counter <= 10) continue;
                    break;
                }
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
        return rval;
    }

    public ResponseStatsPerPlanBean getResponseStatsPerPlan(String organizationId, String serviceId, String version, DateTime from, DateTime to) {
        ResponseStatsPerPlanBean rval;
        block3: {
            rval = new ResponseStatsPerPlanBean();
            try {
                String query = "{  \"query\": {    \"filtered\" : {      \"query\" : {        \"range\" : {          \"requestStart\" : {            \"gte\": \"${from}\",            \"lte\": \"${to}\"          }        }      },      \"filter\": {        \"and\" : [          { \"term\" : { \"serviceOrgId\" : \"${serviceOrgId}\" } },          { \"term\" : { \"serviceId\" : \"${serviceId}\" } },          { \"term\" : { \"serviceVersion\" : \"${serviceVersion}\" } }        ]      }    }  },  \"size\": 0,   \"aggs\" : {      \"by_plan\" : {        \"terms\" : {          \"field\" : \"planId\"        },        \"aggs\" : {          \"total_failures\" : {            \"filter\" : { \"term\": { \"failure\": true } }          },          \"total_errors\" : {            \"filter\" : { \"term\": { \"error\": true } }          }        }      }  }}";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("from", ESMetricsAccessor.formatDate(from));
                params.put("to", ESMetricsAccessor.formatDate(to));
                params.put("serviceOrgId", organizationId.replace('\"', '_'));
                params.put("serviceId", serviceId.replace('\"', '_'));
                params.put("serviceVersion", version.replace('\"', '_'));
                StrSubstitutor ss = new StrSubstitutor(params);
                query = ss.replace(query);
                Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
                SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
                MetricAggregation aggregations = response.getAggregations();
                ApimanTermsAggregation aggregation = (ApimanTermsAggregation)aggregations.getAggregation("by_plan", ApimanTermsAggregation.class);
                if (aggregation == null) break block3;
                List<ApimanTermsAggregation.Entry> buckets = aggregation.getBuckets();
                int counter = 0;
                for (ApimanTermsAggregation.Entry entry : buckets) {
                    ResponseStatsDataPoint point = new ResponseStatsDataPoint();
                    point.setTotal(entry.getCount().longValue());
                    rval.addDataPoint(entry.getKey(), entry.getCount().longValue(), entry.getFilterAggregation("total_failures").getCount().longValue(), entry.getFilterAggregation("total_errors").getCount().longValue());
                    if (++counter <= 10) continue;
                    break;
                }
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
        return rval;
    }

    public AppUsagePerServiceBean getAppUsagePerService(String organizationId, String applicationId, String version, DateTime from, DateTime to) {
        AppUsagePerServiceBean rval = new AppUsagePerServiceBean();
        try {
            String query = "{  \"query\": {\n    \"filtered\" : {\n      \"query\" : {\n        \"range\" : {\n          \"requestStart\" : {\n            \"gte\": \"${from}\",\n            \"lte\": \"${to}\"\n          }\n        }\n      },\n      \"filter\": {\n        \"and\" : [\n          { \"term\" : { \"applicationOrgId\" : \"${applicationOrgId}\" } },\n          { \"term\" : { \"applicationId\" : \"${applicationId}\" } },\n          { \"term\" : { \"applicationVersion\" : \"${applicationVersion}\" } }\n        ]\n      }\n    }\n  },\n  \"size\": 0, \n  \"aggs\" : {\n      \"usage_by_service\" : {\n        \"terms\" : {\n          \"field\" : \"serviceId\"\n        }\n      }\n  }\n}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("from", ESMetricsAccessor.formatDate(from));
            params.put("to", ESMetricsAccessor.formatDate(to));
            params.put("applicationOrgId", organizationId.replace('\"', '_'));
            params.put("applicationId", applicationId.replace('\"', '_'));
            params.put("applicationVersion", version.replace('\"', '_'));
            StrSubstitutor ss = new StrSubstitutor(params);
            query = ss.replace(query);
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType("request")).build();
            SearchResult response = (SearchResult)this.getEsClient().execute((Action)search);
            MetricAggregation aggregations = response.getAggregations();
            ApimanTermsAggregation aggregation = (ApimanTermsAggregation)aggregations.getAggregation("usage_by_service", ApimanTermsAggregation.class);
            if (aggregation != null) {
                List<ApimanTermsAggregation.Entry> buckets = aggregation.getBuckets();
                for (ApimanTermsAggregation.Entry entry : buckets) {
                    rval.getData().put(entry.getKey(), entry.getCount());
                }
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return rval;
    }

    protected static String formatDate(DateTime date) {
        return ISODateTimeFormat.dateTimeNoMillis().print((ReadableInstant)date);
    }

    protected static String formatDateWithMillis(DateTime date) {
        return ISODateTimeFormat.dateTime().print((ReadableInstant)date);
    }

    protected static String formatDate(Calendar date) {
        return DateFormatUtils.formatUTC((long)date.getTimeInMillis(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    protected static String formatDateWithMillis(Calendar date) {
        return DateFormatUtils.formatUTC((long)date.getTimeInMillis(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public JestClient getEsClient() {
        return this.esClient;
    }

    public void setEsClient(JestClient esClient) {
        this.esClient = esClient;
    }
}

