/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.es;

import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntityType;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plugins.PluginBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.search.OrderByBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceGatewayBean;
import io.apiman.manager.api.beans.services.ServicePlanBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.beans.summary.ApiEntryBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.beans.summary.ApplicationSummaryBean;
import io.apiman.manager.api.beans.summary.ApplicationVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PluginSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.beans.summary.ServicePlanSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceVersionSummaryBean;
import io.apiman.manager.api.core.IIdmStorage;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.util.PolicyTemplateUtil;
import io.apiman.manager.api.es.EsMarshalling;
import io.apiman.manager.api.es.beans.PoliciesBean;
import io.apiman.manager.api.es.beans.ServiceDefinitionBean;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.cluster.Health;
import io.searchbox.core.Delete;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.IndicesExists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

@ApplicationScoped
@Alternative
public class EsStorage
implements IStorage,
IStorageQuery,
IIdmStorage {
    private static final String INDEX_NAME = "apiman_manager";
    private static int guidCounter = 100;
    @Inject
    @Named(value="storage")
    JestClient esClient;

    public void initialize() {
        try {
            this.esClient.execute((Action)new Health.Builder().build());
            IndicesExists action = new IndicesExists.Builder(INDEX_NAME).build();
            JestResult result = this.esClient.execute((Action)action);
            if (!result.isSucceeded()) {
                this.createIndex(INDEX_NAME);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createIndex(String indexName) throws Exception {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        URL settings = this.getClass().getResource("index-settings.json");
        String source = IOUtils.toString((URL)settings);
        request.source(source);
        JestResult response = this.esClient.execute((Action)new CreateIndex.Builder(indexName).settings((Object)source).build());
        if (!response.isSucceeded()) {
            throw new StorageException("Failed to create index " + indexName + ": " + response.getErrorMessage());
        }
    }

    public void beginTx() throws StorageException {
    }

    public void commitTx() throws StorageException {
    }

    public void rollbackTx() {
    }

    public void createOrganization(OrganizationBean organization) throws StorageException {
        this.indexEntity("organization", organization.getId(), EsMarshalling.marshall(organization), true);
    }

    public void createApplication(ApplicationBean application) throws StorageException {
        this.indexEntity("application", EsStorage.id(application.getOrganization().getId(), application.getId()), EsMarshalling.marshall(application));
    }

    public void createApplicationVersion(ApplicationVersionBean version) throws StorageException {
        ApplicationBean application = version.getApplication();
        String id = EsStorage.id(application.getOrganization().getId(), application.getId(), version.getVersion());
        this.indexEntity("applicationVersion", id, EsMarshalling.marshall(version));
        PoliciesBean policies = PoliciesBean.from(PolicyType.Application, application.getOrganization().getId(), application.getId(), version.getVersion());
        this.indexEntity("applicationPolicies", id, EsMarshalling.marshall(policies));
    }

    public void createContract(ContractBean contract) throws StorageException {
        List<ContractSummaryBean> contracts = this.getApplicationContracts(contract.getApplication().getApplication().getOrganization().getId(), contract.getApplication().getApplication().getId(), contract.getApplication().getVersion());
        for (ContractSummaryBean csb : contracts) {
            if (!csb.getServiceOrganizationId().equals(contract.getService().getService().getOrganization().getId()) || !csb.getServiceId().equals(contract.getService().getService().getId()) || !csb.getServiceVersion().equals(contract.getService().getVersion()) || !csb.getPlanId().equals(contract.getPlan().getPlan().getId())) continue;
            throw new StorageException("Error creating contract: duplicate contract detected.");
        }
        contract.setId(EsStorage.generateGuid());
        this.indexEntity("contract", String.valueOf(contract.getId()), EsMarshalling.marshall(contract), true);
    }

    public void createService(ServiceBean service) throws StorageException {
        this.indexEntity("service", EsStorage.id(service.getOrganization().getId(), service.getId()), EsMarshalling.marshall(service));
    }

    public void createServiceVersion(ServiceVersionBean version) throws StorageException {
        ServiceBean service = version.getService();
        String id = EsStorage.id(service.getOrganization().getId(), service.getId(), version.getVersion());
        this.indexEntity("serviceVersion", id, EsMarshalling.marshall(version));
        PoliciesBean policies = PoliciesBean.from(PolicyType.Service, service.getOrganization().getId(), service.getId(), version.getVersion());
        this.indexEntity("servicePolicies", id, EsMarshalling.marshall(policies));
    }

    public void createPlan(PlanBean plan) throws StorageException {
        this.indexEntity("plan", EsStorage.id(plan.getOrganization().getId(), plan.getId()), EsMarshalling.marshall(plan));
    }

    public void createPlanVersion(PlanVersionBean version) throws StorageException {
        PlanBean plan = version.getPlan();
        String id = EsStorage.id(plan.getOrganization().getId(), plan.getId(), version.getVersion());
        this.indexEntity("planVersion", id, EsMarshalling.marshall(version));
        PoliciesBean policies = PoliciesBean.from(PolicyType.Plan, plan.getOrganization().getId(), plan.getId(), version.getVersion());
        this.indexEntity("planPolicies", id, EsMarshalling.marshall(policies));
    }

    public void createPolicy(PolicyBean policy) throws StorageException {
        String id;
        String docType = EsStorage.getPoliciesDocType(policy.getType());
        Map<String, Object> source = this.getEntity(docType, id = EsStorage.id(policy.getOrganizationId(), policy.getEntityId(), policy.getEntityVersion()));
        if (source == null) {
            throw new StorageException("Failed to create policy (missing PoliciesBean).");
        }
        PoliciesBean policies = EsMarshalling.unmarshallPolicies(source);
        policy.setId(EsStorage.generateGuid());
        policies.getPolicies().add(policy);
        this.orderPolicies(policies);
        this.updateEntity(docType, id, EsMarshalling.marshall(policies));
    }

    public void reorderPolicies(PolicyType type, String organizationId, String entityId, String entityVersion, List<Long> newOrder) throws StorageException {
        String pid;
        String docType = EsStorage.getPoliciesDocType(type);
        Map<String, Object> source = this.getEntity(docType, pid = EsStorage.id(organizationId, entityId, entityVersion));
        if (source == null) {
            return;
        }
        PoliciesBean policiesBean = EsMarshalling.unmarshallPolicies(source);
        List<PolicyBean> policies = policiesBean.getPolicies();
        ArrayList<PolicyBean> reordered = new ArrayList<PolicyBean>(policies.size());
        block0: for (Long policyId : newOrder) {
            ListIterator<PolicyBean> iterator = policies.listIterator();
            while (iterator.hasNext()) {
                PolicyBean policyBean = iterator.next();
                if (!policyBean.getId().equals(policyId)) continue;
                iterator.remove();
                reordered.add(policyBean);
                continue block0;
            }
        }
        for (PolicyBean policyBean : policies) {
            reordered.add(policyBean);
        }
        policiesBean.setPolicies(reordered);
        this.updateEntity(docType, pid, EsMarshalling.marshall(policiesBean));
    }

    private void orderPolicies(PoliciesBean policies) {
        int idx = 1;
        for (PolicyBean policy : policies.getPolicies()) {
            policy.setOrderIndex(idx++);
        }
    }

    public void createGateway(GatewayBean gateway) throws StorageException {
        this.indexEntity("gateway", gateway.getId(), EsMarshalling.marshall(gateway));
    }

    public void createPlugin(PluginBean plugin) throws StorageException {
        plugin.setId(EsStorage.generateGuid());
        this.indexEntity("plugin", String.valueOf(plugin.getId()), EsMarshalling.marshall(plugin), true);
    }

    public void createPolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        this.indexEntity("policyDef", policyDef.getId(), EsMarshalling.marshall(policyDef));
    }

    public void createRole(RoleBean role) throws StorageException {
        this.indexEntity("role", role.getId(), EsMarshalling.marshall(role));
    }

    public void createAuditEntry(AuditEntryBean entry) throws StorageException {
        if (entry == null) {
            return;
        }
        entry.setId(EsStorage.generateGuid());
        this.indexEntity("auditEntry", String.valueOf(entry.getId()), EsMarshalling.marshall(entry));
    }

    public void updateOrganization(OrganizationBean organization) throws StorageException {
        this.updateEntity("organization", organization.getId(), EsMarshalling.marshall(organization));
    }

    public void updateApplication(ApplicationBean application) throws StorageException {
        this.updateEntity("application", EsStorage.id(application.getOrganization().getId(), application.getId()), EsMarshalling.marshall(application));
    }

    public void updateApplicationVersion(ApplicationVersionBean version) throws StorageException {
        ApplicationBean application = version.getApplication();
        this.updateEntity("applicationVersion", EsStorage.id(application.getOrganization().getId(), application.getId(), version.getVersion()), EsMarshalling.marshall(version));
    }

    public void updateService(ServiceBean service) throws StorageException {
        this.updateEntity("service", EsStorage.id(service.getOrganization().getId(), service.getId()), EsMarshalling.marshall(service));
    }

    public void updateServiceVersion(ServiceVersionBean version) throws StorageException {
        ServiceBean service = version.getService();
        this.updateEntity("serviceVersion", EsStorage.id(service.getOrganization().getId(), service.getId(), version.getVersion()), EsMarshalling.marshall(version));
    }

    public void updateServiceDefinition(ServiceVersionBean version, InputStream definitionStream) throws StorageException {
        InputStream serviceDefinition;
        block5: {
            serviceDefinition = null;
            try {
                String id = EsStorage.id(version.getService().getOrganization().getId(), version.getService().getId(), version.getVersion()) + ":def";
                serviceDefinition = this.getServiceDefinition(version);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)definitionStream, (OutputStream)baos);
                String data = Base64.encodeBytes((byte[])baos.toByteArray());
                ServiceDefinitionBean definition = new ServiceDefinitionBean();
                definition.setData(data);
                if (serviceDefinition == null) {
                    this.indexEntity("serviceDefinition", id, EsMarshalling.marshall(definition));
                    break block5;
                }
                this.updateEntity("serviceDefinition", id, EsMarshalling.marshall(definition));
            }
            catch (IOException e) {
                try {
                    throw new StorageException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(serviceDefinition);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)serviceDefinition);
    }

    public void updatePlan(PlanBean plan) throws StorageException {
        this.updateEntity("plan", EsStorage.id(plan.getOrganization().getId(), plan.getId()), EsMarshalling.marshall(plan));
    }

    public void updatePlanVersion(PlanVersionBean version) throws StorageException {
        PlanBean plan = version.getPlan();
        this.updateEntity("planVersion", EsStorage.id(plan.getOrganization().getId(), plan.getId(), version.getVersion()), EsMarshalling.marshall(version));
    }

    public void updatePolicy(PolicyBean policy) throws StorageException {
        String pid;
        String docType = EsStorage.getPoliciesDocType(policy.getType());
        Map<String, Object> source = this.getEntity(docType, pid = EsStorage.id(policy.getOrganizationId(), policy.getEntityId(), policy.getEntityVersion()));
        if (source == null) {
            throw new StorageException("Policy not found.");
        }
        PoliciesBean policies = EsMarshalling.unmarshallPolicies(source);
        List<PolicyBean> policyBeans = policies.getPolicies();
        boolean found = false;
        if (policyBeans != null) {
            for (PolicyBean policyBean : policyBeans) {
                if (!policyBean.getId().equals(policy.getId())) continue;
                policyBean.setConfiguration(policy.getConfiguration());
                policyBean.setModifiedBy(policy.getModifiedBy());
                policyBean.setModifiedOn(policy.getModifiedOn());
                found = true;
                break;
            }
        }
        if (!found) {
            throw new StorageException("Policy not found.");
        }
        this.updateEntity(docType, pid, EsMarshalling.marshall(policies));
    }

    public void updateGateway(GatewayBean gateway) throws StorageException {
        this.updateEntity("gateway", gateway.getId(), EsMarshalling.marshall(gateway));
    }

    public void updatePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        this.updateEntity("policyDef", policyDef.getId(), EsMarshalling.marshall(policyDef));
    }

    public void updateRole(RoleBean role) throws StorageException {
        this.updateEntity("role", role.getId(), EsMarshalling.marshall(role));
    }

    public void deleteOrganization(OrganizationBean organization) throws StorageException {
        this.deleteEntity("organization", organization.getId());
    }

    public void deleteApplication(ApplicationBean application) throws StorageException {
        this.deleteEntity("application", EsStorage.id(application.getOrganization().getId(), application.getId()));
    }

    public void deleteApplicationVersion(ApplicationVersionBean version) throws StorageException {
        ApplicationBean application = version.getApplication();
        this.deleteEntity("applicationVersion", EsStorage.id(application.getOrganization().getId(), application.getId(), version.getVersion()));
    }

    public void deleteContract(ContractBean contract) throws StorageException {
        this.deleteEntity("contract", String.valueOf(contract.getId()));
    }

    public void deleteService(ServiceBean service) throws StorageException {
        this.deleteEntity("service", EsStorage.id(service.getOrganization().getId(), service.getId()));
    }

    public void deleteServiceVersion(ServiceVersionBean version) throws StorageException {
        ServiceBean service = version.getService();
        this.deleteEntity("serviceVersion", EsStorage.id(service.getOrganization().getId(), service.getId(), version.getVersion()));
    }

    public void deleteServiceDefinition(ServiceVersionBean version) throws StorageException {
        String id = EsStorage.id(version.getService().getOrganization().getId(), version.getService().getId(), version.getVersion()) + ":def";
        this.deleteEntity("serviceDefinition", id);
    }

    public void deletePlan(PlanBean plan) throws StorageException {
        this.deleteEntity("plan", EsStorage.id(plan.getOrganization().getId(), plan.getId()));
    }

    public void deletePlanVersion(PlanVersionBean version) throws StorageException {
        PlanBean plan = version.getPlan();
        this.deleteEntity("planVersion", EsStorage.id(plan.getOrganization().getId(), plan.getId(), version.getVersion()));
    }

    public void deletePolicy(PolicyBean policy) throws StorageException {
        String pid;
        String docType = EsStorage.getPoliciesDocType(policy.getType());
        Map<String, Object> source = this.getEntity(docType, pid = EsStorage.id(policy.getOrganizationId(), policy.getEntityId(), policy.getEntityVersion()));
        if (source == null) {
            throw new StorageException("Policy not found.");
        }
        PoliciesBean policies = EsMarshalling.unmarshallPolicies(source);
        if (policies == null) {
            throw new StorageException("Policy not found.");
        }
        List<PolicyBean> policyBeans = policies.getPolicies();
        boolean found = false;
        if (policyBeans != null) {
            for (PolicyBean policyBean : policyBeans) {
                if (!policyBean.getId().equals(policy.getId())) continue;
                policies.getPolicies().remove(policyBean);
                found = true;
                break;
            }
        }
        if (!found) {
            throw new StorageException("Policy not found.");
        }
        this.updateEntity(docType, pid, EsMarshalling.marshall(policies));
    }

    public void deleteGateway(GatewayBean gateway) throws StorageException {
        this.deleteEntity("gateway", gateway.getId());
    }

    public void deletePlugin(PluginBean plugin) throws StorageException {
        this.deleteEntity("plugin", String.valueOf(plugin.getId()));
    }

    public void deletePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        this.deleteEntity("policyDef", policyDef.getId());
    }

    public void deleteRole(RoleBean role) throws StorageException {
        this.deleteEntity("role", role.getId());
    }

    public OrganizationBean getOrganization(String id) throws StorageException {
        Map<String, Object> source = this.getEntity("organization", id);
        return EsMarshalling.unmarshallOrganization(source);
    }

    public ApplicationBean getApplication(String organizationId, String id) throws StorageException {
        Map<String, Object> source = this.getEntity("application", EsStorage.id(organizationId, id));
        if (source == null) {
            return null;
        }
        ApplicationBean bean = EsMarshalling.unmarshallApplication(source);
        bean.setOrganization(this.getOrganization(organizationId));
        return bean;
    }

    public ApplicationVersionBean getApplicationVersion(String organizationId, String applicationId, String version) throws StorageException {
        Map<String, Object> source = this.getEntity("applicationVersion", EsStorage.id(organizationId, applicationId, version));
        if (source == null) {
            return null;
        }
        ApplicationVersionBean bean = EsMarshalling.unmarshallApplicationVersion(source);
        bean.setApplication(this.getApplication(organizationId, applicationId));
        return bean;
    }

    public ContractBean getContract(Long id) throws StorageException {
        Map<String, Object> source = this.getEntity("contract", String.valueOf(id));
        ContractBean contract = EsMarshalling.unmarshallContract(source);
        String appOrgId = (String)source.get("appOrganizationId");
        String appId = (String)source.get("appId");
        String appVersion = (String)source.get("appVersion");
        String svcOrgId = (String)source.get("serviceOrganizationId");
        String svcId = (String)source.get("serviceId");
        String svcVersion = (String)source.get("serviceVersion");
        String planId = (String)source.get("planId");
        String planVersion = (String)source.get("planVersion");
        ApplicationVersionBean avb = this.getApplicationVersion(appOrgId, appId, appVersion);
        ServiceVersionBean svb = this.getServiceVersion(svcOrgId, svcId, svcVersion);
        PlanVersionBean pvb = this.getPlanVersion(svcOrgId, planId, planVersion);
        contract.setApplication(avb);
        contract.setPlan(pvb);
        contract.setService(svb);
        return contract;
    }

    public ServiceBean getService(String organizationId, String id) throws StorageException {
        Map<String, Object> source = this.getEntity("service", EsStorage.id(organizationId, id));
        if (source == null) {
            return null;
        }
        ServiceBean bean = EsMarshalling.unmarshallService(source);
        bean.setOrganization(this.getOrganization(organizationId));
        return bean;
    }

    public ServiceVersionBean getServiceVersion(String organizationId, String serviceId, String version) throws StorageException {
        Map<String, Object> source = this.getEntity("serviceVersion", EsStorage.id(organizationId, serviceId, version));
        if (source == null) {
            return null;
        }
        ServiceVersionBean bean = EsMarshalling.unmarshallServiceVersion(source);
        bean.setService(this.getService(organizationId, serviceId));
        return bean;
    }

    public InputStream getServiceDefinition(ServiceVersionBean version) throws StorageException {
        try {
            String id = EsStorage.id(version.getService().getOrganization().getId(), version.getService().getId(), version.getVersion()) + ":def";
            Map<String, Object> source = this.getEntity("serviceDefinition", id);
            if (source == null) {
                return null;
            }
            ServiceDefinitionBean def = EsMarshalling.unmarshallServiceDefinition(source);
            if (def == null) {
                return null;
            }
            String data = def.getData();
            return new ByteArrayInputStream(Base64.decode((String)data));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public PlanBean getPlan(String organizationId, String id) throws StorageException {
        Map<String, Object> source = this.getEntity("plan", EsStorage.id(organizationId, id));
        if (source == null) {
            return null;
        }
        PlanBean bean = EsMarshalling.unmarshallPlan(source);
        bean.setOrganization(this.getOrganization(organizationId));
        return bean;
    }

    public PlanVersionBean getPlanVersion(String organizationId, String planId, String version) throws StorageException {
        Map<String, Object> source = this.getEntity("planVersion", EsStorage.id(organizationId, planId, version));
        if (source == null) {
            return null;
        }
        PlanVersionBean bean = EsMarshalling.unmarshallPlanVersion(source);
        bean.setPlan(this.getPlan(organizationId, planId));
        return bean;
    }

    public PolicyBean getPolicy(PolicyType type, String organizationId, String entityId, String version, Long id) throws StorageException {
        String pid;
        String docType = EsStorage.getPoliciesDocType(type);
        Map<String, Object> source = this.getEntity(docType, pid = EsStorage.id(organizationId, entityId, version));
        if (source == null) {
            return null;
        }
        PoliciesBean policies = EsMarshalling.unmarshallPolicies(source);
        if (policies == null) {
            return null;
        }
        List<PolicyBean> policyBeans = policies.getPolicies();
        if (policyBeans != null) {
            for (PolicyBean policyBean : policyBeans) {
                if (!policyBean.getId().equals(id)) continue;
                PolicyDefinitionBean def = this.getPolicyDefinition(policyBean.getDefinition().getId());
                policyBean.setDefinition(def);
                return policyBean;
            }
        }
        return null;
    }

    public GatewayBean getGateway(String id) throws StorageException {
        Map<String, Object> source = this.getEntity("gateway", id);
        return EsMarshalling.unmarshallGateway(source);
    }

    public PluginBean getPlugin(long id) throws StorageException {
        Map<String, Object> source = this.getEntity("plugin", String.valueOf(id));
        return EsMarshalling.unmarshallPlugin(source);
    }

    public PluginBean getPlugin(String groupId, String artifactId) throws StorageException {
        try {
            FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"groupId", (String)groupId), FilterBuilders.termFilter((String)"artifactId", (String)artifactId)}));
            SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)qb).size(2);
            SearchRequest request = new SearchRequest(new String[]{INDEX_NAME});
            request.types(new String[]{"plugin"});
            request.source(builder);
            List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("plugin", builder);
            if (hits.size() == 1) {
                SearchResult.Hit<Map<String, Object>, Void> hit = hits.iterator().next();
                return EsMarshalling.unmarshallPlugin((Map)hit.source);
            }
            return null;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public PolicyDefinitionBean getPolicyDefinition(String id) throws StorageException {
        Map<String, Object> source = this.getEntity("policyDef", id);
        return EsMarshalling.unmarshallPolicyDefinition(source);
    }

    public RoleBean getRole(String id) throws StorageException {
        Map<String, Object> source = this.getEntity("role", id);
        return EsMarshalling.unmarshallRole(source);
    }

    public List<PluginSummaryBean> listPlugins() throws StorageException {
        String[] fields = new String[]{"id", "artifactId", "groupId", "version", "classifier", "type", "name", "description", "createdBy", "createdOn"};
        SearchSourceBuilder builder = new SearchSourceBuilder().fetchSource(fields, null).sort("name.raw", SortOrder.ASC).size(200);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("plugin", builder);
        ArrayList<PluginSummaryBean> rval = new ArrayList<PluginSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            PluginSummaryBean bean = EsMarshalling.unmarshallPluginSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<GatewaySummaryBean> listGateways() throws StorageException {
        String[] fields = new String[]{"id", "name", "description", "type"};
        SearchSourceBuilder builder = new SearchSourceBuilder().fetchSource(fields, null).sort("name.raw", SortOrder.ASC).size(100);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("gateway", builder);
        ArrayList<GatewaySummaryBean> rval = new ArrayList<GatewaySummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            GatewaySummaryBean bean = EsMarshalling.unmarshallGatewaySummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public SearchResultsBean<OrganizationSummaryBean> findOrganizations(SearchCriteriaBean criteria) throws StorageException {
        return this.find(criteria, "organization", new IUnmarshaller<OrganizationSummaryBean>(){

            @Override
            public OrganizationSummaryBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallOrganizationSummary(source);
            }
        });
    }

    public SearchResultsBean<ApplicationSummaryBean> findApplications(SearchCriteriaBean criteria) throws StorageException {
        return this.find(criteria, "application", new IUnmarshaller<ApplicationSummaryBean>(){

            @Override
            public ApplicationSummaryBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallApplicationSummary(source);
            }
        });
    }

    public SearchResultsBean<ServiceSummaryBean> findServices(SearchCriteriaBean criteria) throws StorageException {
        return this.find(criteria, "service", new IUnmarshaller<ServiceSummaryBean>(){

            @Override
            public ServiceSummaryBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallServiceSummary(source);
            }
        });
    }

    public SearchResultsBean<PlanSummaryBean> findPlans(String organizationId, SearchCriteriaBean criteria) throws StorageException {
        criteria.addFilter("organizationId", organizationId, SearchCriteriaFilterOperator.eq);
        return this.find(criteria, "plan", new IUnmarshaller<PlanSummaryBean>(){

            @Override
            public PlanSummaryBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallPlanSummary(source);
            }
        });
    }

    public <T> SearchResultsBean<AuditEntryBean> auditEntity(String organizationId, String entityId, String entityVersion, Class<T> type, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("createdOn", false);
        if (organizationId != null) {
            criteria.addFilter("organizationId", organizationId, SearchCriteriaFilterOperator.eq);
        }
        if (entityId != null) {
            criteria.addFilter("entityId", entityId, SearchCriteriaFilterOperator.eq);
        }
        if (entityVersion != null) {
            criteria.addFilter("entityVersion", entityVersion, SearchCriteriaFilterOperator.eq);
        }
        if (type != null) {
            AuditEntityType entityType = null;
            if (type == OrganizationBean.class) {
                entityType = AuditEntityType.Organization;
            } else if (type == ApplicationBean.class) {
                entityType = AuditEntityType.Application;
            } else if (type == ServiceBean.class) {
                entityType = AuditEntityType.Service;
            } else if (type == PlanBean.class) {
                entityType = AuditEntityType.Plan;
            }
            if (entityType != null) {
                criteria.addFilter("entityType", entityType.name(), SearchCriteriaFilterOperator.eq);
            }
        }
        return this.find(criteria, "auditEntry", new IUnmarshaller<AuditEntryBean>(){

            @Override
            public AuditEntryBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallAuditEntry(source);
            }
        });
    }

    public <T> SearchResultsBean<AuditEntryBean> auditUser(String userId, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("createdOn", false);
        if (userId != null) {
            criteria.addFilter("who", userId, SearchCriteriaFilterOperator.eq);
        }
        return this.find(criteria, "auditEntry", new IUnmarshaller<AuditEntryBean>(){

            @Override
            public AuditEntryBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallAuditEntry(source);
            }
        });
    }

    public List<OrganizationSummaryBean> getOrgs(Set<String> organizationIds) throws StorageException {
        ArrayList<OrganizationSummaryBean> orgs = new ArrayList<OrganizationSummaryBean>();
        if (organizationIds == null || organizationIds.isEmpty()) {
            return orgs;
        }
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.termsFilter((String)"id", (Object[])organizationIds.toArray()));
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("name.raw", SortOrder.ASC).query((QueryBuilder)query).size(500);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("organization", builder);
        ArrayList<OrganizationSummaryBean> rval = new ArrayList<OrganizationSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            OrganizationSummaryBean bean = EsMarshalling.unmarshallOrganizationSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<ApplicationSummaryBean> getApplicationsInOrgs(Set<String> organizationIds) throws StorageException {
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("organizationName.raw", SortOrder.ASC).sort("name.raw", SortOrder.ASC).size(500);
        TermsQueryBuilder query = QueryBuilders.termsQuery((String)"organizationId", (String[])organizationIds.toArray(new String[organizationIds.size()]));
        builder.query((QueryBuilder)query);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("application", builder);
        ArrayList<ApplicationSummaryBean> rval = new ArrayList<ApplicationSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            ApplicationSummaryBean bean = EsMarshalling.unmarshallApplicationSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<ApplicationSummaryBean> getApplicationsInOrg(String organizationId) throws StorageException {
        HashSet<String> orgs = new HashSet<String>();
        orgs.add(organizationId);
        return this.getApplicationsInOrgs(orgs);
    }

    public List<ApplicationVersionSummaryBean> getApplicationVersions(String organizationId, String applicationId) throws StorageException {
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"organizationId", (String)organizationId), FilterBuilders.termFilter((String)"applicationId", (String)applicationId)}));
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("createdOn", SortOrder.DESC).query((QueryBuilder)query).size(500);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("applicationVersion", builder);
        ArrayList<ApplicationVersionSummaryBean> rval = new ArrayList<ApplicationVersionSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            ApplicationVersionSummaryBean bean = EsMarshalling.unmarshallApplicationVersionSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<ContractSummaryBean> getApplicationContracts(String organizationId, String applicationId, String version) throws StorageException {
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"appOrganizationId", (String)organizationId), FilterBuilders.termFilter((String)"appId", (String)applicationId), FilterBuilders.termFilter((String)"appVersion", (String)version)}));
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("serviceOrganizationId", SortOrder.ASC).sort("serviceId", SortOrder.ASC).query((QueryBuilder)query).size(500);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("contract", builder);
        ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            ContractSummaryBean bean = EsMarshalling.unmarshallContractSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public ApiRegistryBean getApiRegistry(String organizationId, String applicationId, String version) throws StorageException {
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"appOrganizationId", (String)organizationId), FilterBuilders.termFilter((String)"appId", (String)applicationId), FilterBuilders.termFilter((String)"appVersion", (String)version)}));
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("id", SortOrder.ASC).query((QueryBuilder)query).size(500);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("contract", builder);
        ApiRegistryBean registry = new ApiRegistryBean();
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            ApiEntryBean bean = EsMarshalling.unmarshallApiEntry((Map)hit.source);
            ServiceVersionBean svb = this.getServiceVersion(bean.getServiceOrgId(), bean.getServiceId(), bean.getServiceVersion());
            Set gateways = svb.getGateways();
            if (gateways != null && gateways.size() > 0) {
                ServiceGatewayBean sgb = (ServiceGatewayBean)gateways.iterator().next();
                bean.setGatewayId(sgb.getGatewayId());
            }
            registry.getApis().add(bean);
        }
        return registry;
    }

    public List<ServiceSummaryBean> getServicesInOrgs(Set<String> organizationIds) throws StorageException {
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("organizationName.raw", SortOrder.ASC).sort("name.raw", SortOrder.ASC).size(500);
        TermsQueryBuilder query = QueryBuilders.termsQuery((String)"organizationId", (String[])organizationIds.toArray(new String[organizationIds.size()]));
        builder.query((QueryBuilder)query);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("service", builder);
        ArrayList<ServiceSummaryBean> rval = new ArrayList<ServiceSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            ServiceSummaryBean bean = EsMarshalling.unmarshallServiceSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<ServiceSummaryBean> getServicesInOrg(String organizationId) throws StorageException {
        HashSet<String> orgs = new HashSet<String>();
        orgs.add(organizationId);
        return this.getServicesInOrgs(orgs);
    }

    public List<ServiceVersionSummaryBean> getServiceVersions(String organizationId, String serviceId) throws StorageException {
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"organizationId", (String)organizationId), FilterBuilders.termFilter((String)"serviceId", (String)serviceId)}));
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("createdOn", SortOrder.DESC).query((QueryBuilder)query).size(500);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("serviceVersion", builder);
        ArrayList<ServiceVersionSummaryBean> rval = new ArrayList<ServiceVersionSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            ServiceVersionSummaryBean bean = EsMarshalling.unmarshallServiceVersionSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<ServicePlanSummaryBean> getServiceVersionPlans(String organizationId, String serviceId, String version) throws StorageException {
        Set plans;
        ArrayList<ServicePlanSummaryBean> rval = new ArrayList<ServicePlanSummaryBean>();
        ServiceVersionBean versionBean = this.getServiceVersion(organizationId, serviceId, version);
        if (versionBean != null && (plans = versionBean.getPlans()) != null) {
            for (ServicePlanBean spb : plans) {
                PlanBean planBean = this.getPlan(organizationId, spb.getPlanId());
                ServicePlanSummaryBean plan = new ServicePlanSummaryBean();
                plan.setPlanId(spb.getPlanId());
                plan.setVersion(spb.getVersion());
                plan.setPlanName(planBean.getName());
                plan.setPlanDescription(planBean.getDescription());
                rval.add(plan);
            }
        }
        return rval;
    }

    public List<PlanSummaryBean> getPlansInOrgs(Set<String> organizationIds) throws StorageException {
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("organizationName.raw", SortOrder.ASC).sort("name.raw", SortOrder.ASC).size(500);
        TermsQueryBuilder query = QueryBuilders.termsQuery((String)"organizationId", (String[])organizationIds.toArray(new String[organizationIds.size()]));
        builder.query((QueryBuilder)query);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("plan", builder);
        ArrayList<PlanSummaryBean> rval = new ArrayList<PlanSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            PlanSummaryBean bean = EsMarshalling.unmarshallPlanSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<PlanSummaryBean> getPlansInOrg(String organizationId) throws StorageException {
        HashSet<String> orgs = new HashSet<String>();
        orgs.add(organizationId);
        return this.getPlansInOrgs(orgs);
    }

    public List<PlanVersionSummaryBean> getPlanVersions(String organizationId, String planId) throws StorageException {
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"organizationId", (String)organizationId), FilterBuilders.termFilter((String)"planId", (String)planId)}));
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("createdOn", SortOrder.DESC).query((QueryBuilder)query).size(500);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("planVersion", builder);
        ArrayList<PlanVersionSummaryBean> rval = new ArrayList<PlanVersionSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            PlanVersionSummaryBean bean = EsMarshalling.unmarshallPlanVersionSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<PolicySummaryBean> getPolicies(String organizationId, String entityId, String version, PolicyType type) throws StorageException {
        try {
            String docType = EsStorage.getPoliciesDocType(type);
            String pid = EsStorage.id(organizationId, entityId, version);
            ArrayList<PolicySummaryBean> rval = new ArrayList<PolicySummaryBean>();
            Map<String, Object> source = this.getEntity(docType, pid);
            if (source == null) {
                return rval;
            }
            PoliciesBean policies = EsMarshalling.unmarshallPolicies(source);
            if (policies == null) {
                return rval;
            }
            List<PolicyBean> policyBeans = policies.getPolicies();
            if (policyBeans != null) {
                for (PolicyBean policyBean : policyBeans) {
                    PolicyDefinitionBean def = this.getPolicyDefinition(policyBean.getDefinition().getId());
                    policyBean.setDefinition(def);
                    PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policyBean);
                    PolicySummaryBean psb = new PolicySummaryBean();
                    psb.setCreatedBy(policyBean.getCreatedBy());
                    psb.setCreatedOn(policyBean.getCreatedOn());
                    psb.setDescription(policyBean.getDescription());
                    psb.setIcon(def.getIcon());
                    psb.setId(policyBean.getId());
                    psb.setName(policyBean.getName());
                    psb.setPolicyDefinitionId(def.getId());
                    rval.add(psb);
                }
            }
            return rval;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public List<PolicyDefinitionSummaryBean> listPolicyDefinitions() throws StorageException {
        String[] fields = new String[]{"id", "policyImpl", "name", "description", "icon", "pluginId", "formType"};
        SearchSourceBuilder builder = new SearchSourceBuilder().fetchSource(fields, null).sort("name.raw", SortOrder.ASC).size(100);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("policyDef", builder);
        ArrayList<PolicyDefinitionSummaryBean> rval = new ArrayList<PolicyDefinitionSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            PolicyDefinitionSummaryBean bean = EsMarshalling.unmarshallPolicyDefinitionSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public List<ContractSummaryBean> getServiceContracts(String organizationId, String serviceId, String version, int page, int pageSize) throws StorageException {
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"serviceOrganizationId", (String)organizationId), FilterBuilders.termFilter((String)"serviceId", (String)serviceId), FilterBuilders.termFilter((String)"serviceVersion", (String)version)}));
        SearchSourceBuilder builder = new SearchSourceBuilder().sort("appOrganizationId", SortOrder.ASC).sort("appId", SortOrder.ASC).query((QueryBuilder)query).size(500);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("contract", builder);
        ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            ContractSummaryBean bean = EsMarshalling.unmarshallContractSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public int getMaxPolicyOrderIndex(String organizationId, String entityId, String entityVersion, PolicyType type) throws StorageException {
        return -1;
    }

    public List<PolicyDefinitionSummaryBean> listPluginPolicyDefs(Long pluginId) throws StorageException {
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.termFilter((String)"pluginId", (Object)pluginId));
        String[] fields = new String[]{"id", "policyImpl", "name", "description", "icon", "pluginId", "formType"};
        SearchSourceBuilder builder = new SearchSourceBuilder().fetchSource(fields, null).query((QueryBuilder)qb).sort("name.raw", SortOrder.ASC).size(100);
        List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("policyDef", builder);
        ArrayList<PolicyDefinitionSummaryBean> rval = new ArrayList<PolicyDefinitionSummaryBean>(hits.size());
        for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
            PolicyDefinitionSummaryBean bean = EsMarshalling.unmarshallPolicyDefinitionSummary((Map)hit.source);
            rval.add(bean);
        }
        return rval;
    }

    public void createUser(UserBean user) throws StorageException {
        this.indexEntity("user", user.getUsername(), EsMarshalling.marshall(user));
    }

    public UserBean getUser(String userId) throws StorageException {
        Map<String, Object> source = this.getEntity("user", userId);
        return EsMarshalling.unmarshallUser(source);
    }

    public void updateUser(UserBean user) throws StorageException {
        this.updateEntity("user", user.getUsername(), EsMarshalling.marshall(user));
    }

    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean criteria) throws StorageException {
        return this.find(criteria, "user", new IUnmarshaller<UserBean>(){

            @Override
            public UserBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallUser(source);
            }
        });
    }

    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean criteria) throws StorageException {
        return this.find(criteria, "role", new IUnmarshaller<RoleBean>(){

            @Override
            public RoleBean unmarshal(Map<String, Object> source) {
                return EsMarshalling.unmarshallRole(source);
            }
        });
    }

    public void createMembership(RoleMembershipBean membership) throws StorageException {
        membership.setId(EsStorage.generateGuid());
        String id = EsStorage.id(membership.getOrganizationId(), membership.getUserId(), membership.getRoleId());
        this.indexEntity("roleMembership", id, EsMarshalling.marshall(membership), true);
    }

    public RoleMembershipBean getMembership(String userId, String roleId, String organizationId) throws StorageException {
        String id = EsStorage.id(organizationId, userId, roleId);
        Map<String, Object> source = this.getEntity("roleMembership", id);
        if (source == null) {
            return null;
        }
        return EsMarshalling.unmarshallRoleMembership(source);
    }

    public void deleteMembership(String userId, String roleId, String organizationId) throws StorageException {
        String id = EsStorage.id(organizationId, userId, roleId);
        this.deleteEntity("roleMembership", id);
    }

    public void deleteMemberships(String userId, String organizationId) throws StorageException {
        FilteredQueryBuilder query = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"organizationId", (String)organizationId), FilterBuilders.termFilter((String)"userId", (String)userId)}));
        String string = query.toString();
        if (string.indexOf("query") < 0 || string.indexOf("query") > 7) {
            string = "{ \"query\" : " + string + "}";
        }
        DeleteByQuery deleteByQuery = ((DeleteByQuery.Builder)((DeleteByQuery.Builder)new DeleteByQuery.Builder(string).addIndex(INDEX_NAME)).addType("roleMembership")).build();
        try {
            JestResult response = this.esClient.execute((Action)deleteByQuery);
            if (!response.isSucceeded()) {
                throw new StorageException(response.getErrorMessage());
            }
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId) throws StorageException {
        try {
            FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.termFilter((String)"userId", (String)userId));
            SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)qb).size(2);
            List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("roleMembership", builder);
            HashSet<RoleMembershipBean> rval = new HashSet<RoleMembershipBean>();
            for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
                RoleMembershipBean roleMembership = EsMarshalling.unmarshallRoleMembership((Map)hit.source);
                rval.add(roleMembership);
            }
            return rval;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId, String organizationId) throws StorageException {
        try {
            FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"userId", (String)userId), FilterBuilders.termFilter((String)"organizationId", (String)organizationId)}));
            SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)qb).size(2);
            List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("roleMembership", builder);
            HashSet<RoleMembershipBean> rval = new HashSet<RoleMembershipBean>();
            for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
                RoleMembershipBean roleMembership = EsMarshalling.unmarshallRoleMembership((Map)hit.source);
                rval.add(roleMembership);
            }
            return rval;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Set<RoleMembershipBean> getOrgMemberships(String organizationId) throws StorageException {
        try {
            FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.termFilter((String)"organizationId", (String)organizationId));
            SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)qb).size(500);
            List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("roleMembership", builder);
            HashSet<RoleMembershipBean> rval = new HashSet<RoleMembershipBean>();
            for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
                RoleMembershipBean roleMembership = EsMarshalling.unmarshallRoleMembership((Map)hit.source);
                rval.add(roleMembership);
            }
            return rval;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Set<PermissionBean> getPermissions(String userId) throws StorageException {
        try {
            FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.termFilter((String)"userId", (String)userId));
            SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)qb).size(500);
            List<SearchResult.Hit<Map<String, Object>, Void>> hits = this.listEntities("roleMembership", builder);
            HashSet<PermissionBean> rval = new HashSet<PermissionBean>(hits.size());
            if (hits.size() > 0) {
                for (SearchResult.Hit<Map<String, Object>, Void> hit : hits) {
                    Map source = (Map)hit.source;
                    String roleId = String.valueOf(source.get("roleId"));
                    String qualifier = String.valueOf(source.get("organizationId"));
                    RoleBean role = this.getRole(roleId);
                    if (role == null) continue;
                    for (PermissionType permission : role.getPermissions()) {
                        PermissionBean p = new PermissionBean();
                        p.setName(permission);
                        p.setOrganizationId(qualifier);
                        rval.add(p);
                    }
                }
            }
            return rval;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void indexEntity(String type, String id, XContentBuilder sourceEntity) throws StorageException {
        this.indexEntity(type, id, sourceEntity, false);
    }

    private void indexEntity(String type, String id, XContentBuilder sourceEntity, boolean refresh) throws StorageException {
        try {
            String json = sourceEntity.string();
            JestResult response = this.esClient.execute((Action)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)json).refresh(refresh)).index(INDEX_NAME)).setParameter("op_type", (Object)"create")).type(type)).id(id)).build());
            if (!response.isSucceeded()) {
                throw new StorageException("Failed to index document " + id + " of type " + type + ": " + response.getErrorMessage());
            }
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private Map<String, Object> getEntity(String type, String id) throws StorageException {
        try {
            JestResult response = this.esClient.execute((Action)((Get.Builder)new Get.Builder(INDEX_NAME, id).type(type)).build());
            if (!response.isSucceeded()) {
                return null;
            }
            return (Map)response.getSourceAsObject(Map.class);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private List<SearchResult.Hit<Map<String, Object>, Void>> listEntities(String type, SearchSourceBuilder searchSourceBuilder) throws StorageException {
        try {
            String query = searchSourceBuilder.toString();
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType(type)).build();
            SearchResult response = (SearchResult)this.esClient.execute((Action)search);
            List thehits = response.getHits(Map.class);
            return thehits;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void deleteEntity(String type, String id) throws StorageException {
        try {
            JestResult response = this.esClient.execute((Action)((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(INDEX_NAME)).type(type)).build());
            if (!response.isSucceeded()) {
                throw new StorageException("Document could not be deleted because it did not exist:" + response.getErrorMessage());
            }
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void updateEntity(String type, String id, XContentBuilder source) throws StorageException {
        try {
            String doc = source.string();
            this.esClient.execute((Action)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)doc).setParameter("op_type", (Object)"index")).index(INDEX_NAME)).type(type)).id(id)).build());
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private <T> SearchResultsBean<T> find(SearchCriteriaBean criteria, String type, IUnmarshaller<T> unmarshaller) throws StorageException {
        try {
            SearchResultsBean rval = new SearchResultsBean();
            PagingBean paging = criteria.getPaging();
            if (paging == null) {
                paging = new PagingBean();
                paging.setPage(1);
                paging.setPageSize(20);
            }
            int page = paging.getPage();
            int pageSize = paging.getPageSize();
            int start = (page - 1) * pageSize;
            SearchSourceBuilder builder = new SearchSourceBuilder().size(pageSize).from(start).fetchSource(true);
            OrderByBean orderBy = criteria.getOrderBy();
            if (orderBy != null) {
                String name = orderBy.getName();
                if (name.equals("name") || name.equals("fullName")) {
                    name = name + ".raw";
                }
                if (orderBy.isAscending()) {
                    builder.sort(name, SortOrder.ASC);
                } else {
                    builder.sort(name, SortOrder.DESC);
                }
            }
            List filters = criteria.getFilters();
            MatchAllQueryBuilder q = QueryBuilders.matchAllQuery();
            if (filters != null && !filters.isEmpty()) {
                AndFilterBuilder andFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
                int filterCount = 0;
                for (SearchCriteriaFilterBean filter : filters) {
                    if (filter.getOperator() == SearchCriteriaFilterOperator.eq) {
                        andFilter.add((FilterBuilder)FilterBuilders.termFilter((String)filter.getName(), (String)filter.getValue()));
                        ++filterCount;
                        continue;
                    }
                    if (filter.getOperator() == SearchCriteriaFilterOperator.like) {
                        q = QueryBuilders.wildcardQuery((String)filter.getName(), (String)filter.getValue().toLowerCase().replace('%', '*'));
                        continue;
                    }
                    if (filter.getOperator() != SearchCriteriaFilterOperator.bool_eq) continue;
                    andFilter.add((FilterBuilder)FilterBuilders.termFilter((String)filter.getName(), (Object)"true".equals(filter.getValue())));
                    ++filterCount;
                }
                if (filterCount > 0) {
                    q = QueryBuilders.filteredQuery((QueryBuilder)q, (FilterBuilder)andFilter);
                }
            }
            builder.query((QueryBuilder)q);
            String query = builder.toString();
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(INDEX_NAME)).addType(type)).build();
            SearchResult response = (SearchResult)this.esClient.execute((Action)search);
            List thehits = response.getHits(Map.class);
            rval.setTotalSize(response.getTotal().intValue());
            for (SearchResult.Hit hit : thehits) {
                Map sourceAsMap = (Map)hit.source;
                T bean = unmarshaller.unmarshal(sourceAsMap);
                rval.getBeans().add(bean);
            }
            return rval;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static synchronized Long generateGuid() {
        StringBuilder builder = new StringBuilder();
        builder.append(System.currentTimeMillis());
        builder.append(guidCounter++);
        if (guidCounter > 999) {
            guidCounter = 100;
        }
        return Long.parseLong(builder.toString());
    }

    private static String getPoliciesDocType(PolicyType type) {
        String docType = "planPolicies";
        if (type == PolicyType.Service) {
            docType = "servicePolicies";
        } else if (type == PolicyType.Application) {
            docType = "applicationPolicies";
        }
        return docType;
    }

    private static String id(String organizationId, String entityId) {
        return organizationId + ":" + entityId;
    }

    private static String id(String organizationId, String entityId, String version) {
        return organizationId + ':' + entityId + ':' + version;
    }

    private static interface IUnmarshaller<T> {
        public T unmarshal(Map<String, Object> var1);
    }
}

