/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.es;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.Aggregation;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ApimanTermsAggregation
extends Aggregation {
    public static final String TYPE = "terms";
    private List<Entry> buckets = new LinkedList<Entry>();

    public ApimanTermsAggregation(String name, JsonObject termAggregation) {
        super(name, termAggregation);
        if (termAggregation.has(String.valueOf(AggregationField.BUCKETS)) && termAggregation.get(String.valueOf(AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(termAggregation.get(String.valueOf(AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketElement : bucketsSource) {
            JsonObject bucket = (JsonObject)bucketElement;
            Entry entry = new Entry(bucket, bucket.get(String.valueOf(AggregationField.KEY)).getAsString(), bucket.get(String.valueOf(AggregationField.DOC_COUNT)).getAsLong());
            this.buckets.add(entry);
        }
    }

    public List<Entry> getBuckets() {
        return this.buckets;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ApimanTermsAggregation rhs = (ApimanTermsAggregation)((Object)obj);
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.buckets, rhs.buckets).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.buckets).toHashCode();
    }

    public class Entry
    extends Bucket {
        private String key;

        public Entry(JsonObject bucket, String key, Long count) {
            super(bucket, count);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Entry rhs = (Entry)((Object)obj);
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.key, (Object)rhs.key).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getCount()).append((Object)this.getKey()).toHashCode();
        }
    }
}

