/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.es;

import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationStatus;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntityType;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.AuditEntryType;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.gateways.GatewayType;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plugins.PluginBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionTemplateBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.services.EndpointType;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceDefinitionType;
import io.apiman.manager.api.beans.services.ServiceGatewayBean;
import io.apiman.manager.api.beans.services.ServicePlanBean;
import io.apiman.manager.api.beans.services.ServiceStatus;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.beans.summary.ApiEntryBean;
import io.apiman.manager.api.beans.summary.ApplicationSummaryBean;
import io.apiman.manager.api.beans.summary.ApplicationVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PluginSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyFormType;
import io.apiman.manager.api.beans.summary.ServiceSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceVersionSummaryBean;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.es.beans.PoliciesBean;
import io.apiman.manager.api.es.beans.ServiceDefinitionBean;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class EsMarshalling {
    public static XContentBuilder marshall(PoliciesBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("organizationId", bean.getOrganizationId()).field("entityId", bean.getEntityId()).field("entityVersion", bean.getEntityVersion()).field("type", (Object)bean.getType());
            List<PolicyBean> policies = bean.getPolicies();
            if (policies != null && !policies.isEmpty()) {
                builder.startArray("policies");
                for (PolicyBean policy : policies) {
                    builder.startObject().field("id", policy.getId()).field("name", policy.getName()).field("configuration", policy.getConfiguration()).field("createdBy", policy.getCreatedBy()).field("createdOn", policy.getCreatedOn().getTime()).field("modifiedBy", policy.getModifiedBy()).field("modifiedOn", policy.getModifiedOn().getTime()).field("definitionId", policy.getDefinition().getId()).field("orderIndex", policy.getOrderIndex()).endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(GatewayBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("type", (Object)bean.getType()).field("configuration", bean.getConfiguration()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).field("modifiedBy", bean.getModifiedBy()).field("modifiedOn", bean.getModifiedOn().getTime()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(ServiceDefinitionBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("data", bean.getData()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(ContractBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("apiKey", bean.getApikey()).field("appOrganizationId", bean.getApplication().getApplication().getOrganization().getId()).field("appOrganizationName", bean.getApplication().getApplication().getOrganization().getName()).field("appId", bean.getApplication().getApplication().getId()).field("appName", bean.getApplication().getApplication().getName()).field("appVersion", bean.getApplication().getVersion()).field("serviceOrganizationId", bean.getService().getService().getOrganization().getId()).field("serviceOrganizationName", bean.getService().getService().getOrganization().getName()).field("serviceId", bean.getService().getService().getId()).field("serviceName", bean.getService().getService().getName()).field("serviceVersion", bean.getService().getVersion()).field("serviceDescription", bean.getService().getService().getDescription()).field("planName", bean.getPlan().getPlan().getName()).field("planId", bean.getPlan().getPlan().getId()).field("planVersion", bean.getPlan().getVersion()).field("createdOn", bean.getCreatedOn().getTime()).field("createdBy", bean.getCreatedBy()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(PlanBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("organizationId", bean.getOrganization().getId()).field("organizationName", bean.getOrganization().getName()).field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(PlanVersionBean bean) throws StorageException {
        try {
            PlanBean plan = bean.getPlan();
            OrganizationBean org = plan.getOrganization();
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("organizationId", org.getId()).field("organizationName", org.getName()).field("planId", plan.getId()).field("planName", plan.getName()).field("planDescription", plan.getDescription()).field("version", bean.getVersion()).field("status", (Object)bean.getStatus()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).field("modifiedBy", bean.getModifiedBy()).field("modifiedOn", bean.getModifiedOn().getTime()).field("lockedOn", bean.getLockedOn() != null ? Long.valueOf(bean.getLockedOn().getTime()) : null).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(ServiceBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("organizationId", bean.getOrganization().getId()).field("organizationName", bean.getOrganization().getName()).field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(ServiceVersionBean bean) throws StorageException {
        try {
            Map endpointProperties;
            Set plans;
            ServiceBean service = bean.getService();
            OrganizationBean org = service.getOrganization();
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("organizationId", org.getId()).field("organizationName", org.getName()).field("serviceId", service.getId()).field("serviceName", service.getName()).field("serviceDescription", service.getDescription()).field("version", bean.getVersion()).field("status", (Object)bean.getStatus()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).field("modifiedBy", bean.getModifiedBy()).field("modifiedOn", bean.getModifiedOn().getTime()).field("publishedOn", bean.getPublishedOn() != null ? Long.valueOf(bean.getPublishedOn().getTime()) : null).field("retiredOn", bean.getRetiredOn() != null ? Long.valueOf(bean.getRetiredOn().getTime()) : null).field("publicService", bean.isPublicService()).field("endpoint", bean.getEndpoint()).field("endpointType", (Object)bean.getEndpointType()).field("definitionType", (Object)bean.getDefinitionType());
            Set gateways = bean.getGateways();
            if (gateways != null) {
                builder.startArray("gateways");
                for (ServiceGatewayBean gateway : gateways) {
                    builder.startObject().field("gatewayId", gateway.getGatewayId()).endObject();
                }
                builder.endArray();
            }
            if ((plans = bean.getPlans()) != null) {
                builder.startArray("plans");
                for (ServicePlanBean plan : plans) {
                    builder.startObject().field("planId", plan.getPlanId()).field("version", plan.getVersion()).endObject();
                }
                builder.endArray();
            }
            if ((endpointProperties = bean.getEndpointProperties()) != null) {
                builder.startObject("endpointProperties");
                for (Map.Entry property : endpointProperties.entrySet()) {
                    builder.field((String)property.getKey(), (String)property.getValue());
                }
                builder.endObject();
            }
            builder.endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(ApplicationBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("organizationId", bean.getOrganization().getId()).field("organizationName", bean.getOrganization().getName()).field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(ApplicationVersionBean bean) throws StorageException {
        try {
            ApplicationBean app = bean.getApplication();
            OrganizationBean org = app.getOrganization();
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("organizationId", org.getId()).field("organizationName", org.getName()).field("applicationId", app.getId()).field("applicationName", app.getName()).field("applicationDescription", app.getDescription()).field("version", bean.getVersion()).field("status", (Object)bean.getStatus()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).field("modifiedBy", bean.getModifiedBy()).field("modifiedOn", bean.getModifiedOn().getTime()).field("publishedOn", bean.getPublishedOn() != null ? Long.valueOf(bean.getPublishedOn().getTime()) : null).field("retiredOn", bean.getRetiredOn() != null ? Long.valueOf(bean.getRetiredOn().getTime()) : null).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(AuditEntryBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("organizationId", bean.getOrganizationId()).field("entityId", bean.getEntityId()).field("entityType", (Object)bean.getEntityType()).field("entityVersion", bean.getEntityVersion()).field("data", bean.getData()).field("who", bean.getWho()).field("what", (Object)bean.getWhat()).field("createdOn", bean.getCreatedOn().getTime()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(OrganizationBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).field("modifiedBy", bean.getModifiedBy()).field("modifiedOn", bean.getModifiedOn().getTime()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(RoleMembershipBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("organizationId", bean.getOrganizationId()).field("roleId", bean.getRoleId()).field("userId", bean.getUserId()).field("createdOn", bean.getCreatedOn().getTime()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(UserBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("username", bean.getUsername()).field("email", bean.getEmail()).field("fullName", bean.getFullName()).field("joinedOn", bean.getJoinedOn() == null ? null : Long.valueOf(bean.getJoinedOn().getTime())).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(RoleBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).field("autoGrant", (Object)bean.getAutoGrant());
            Set permissions = bean.getPermissions();
            if (permissions != null && !permissions.isEmpty()) {
                builder.array("permissions", permissions.toArray());
            }
            builder.endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(PolicyDefinitionBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("form", bean.getForm()).field("formType", (Object)bean.getFormType()).field("icon", bean.getIcon()).field("pluginId", bean.getPluginId()).field("policyImpl", bean.getPolicyImpl()).field("deleted", bean.isDeleted());
            Set templates = bean.getTemplates();
            if (templates != null) {
                builder.field("templates").startArray();
                for (PolicyDefinitionTemplateBean template : templates) {
                    builder.startObject();
                    builder.field("language", template.getLanguage());
                    builder.field("template", template.getTemplate());
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static XContentBuilder marshall(PluginBean bean) throws StorageException {
        try {
            EsMarshalling.preMarshall(bean);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("id", bean.getId()).field("name", bean.getName()).field("description", bean.getDescription()).field("createdBy", bean.getCreatedBy()).field("createdOn", bean.getCreatedOn().getTime()).field("groupId", bean.getGroupId()).field("artifactId", bean.getArtifactId()).field("version", bean.getVersion()).field("classifier", bean.getClassifier()).field("type", bean.getType()).field("deleted", bean.isDeleted()).endObject();
            EsMarshalling.postMarshall(bean);
            return builder;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static PoliciesBean unmarshallPolicies(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        PoliciesBean bean = new PoliciesBean();
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setEntityId(EsMarshalling.asString(source.get("entityId")));
        bean.setEntityVersion(EsMarshalling.asString(source.get("entityVersion")));
        bean.setType(EsMarshalling.asEnum(source.get("type"), PolicyType.class));
        List policies = (List)source.get("policies");
        if (policies != null) {
            for (Map policyMap : policies) {
                PolicyBean policy = new PolicyBean();
                policy.setOrganizationId(bean.getOrganizationId());
                policy.setEntityId(bean.getEntityId());
                policy.setEntityVersion(bean.getEntityVersion());
                policy.setType(bean.getType());
                policy.setConfiguration(EsMarshalling.asString(policyMap.get("configuration")));
                policy.setCreatedBy(EsMarshalling.asString(policyMap.get("createdBy")));
                policy.setCreatedOn(EsMarshalling.asDate(policyMap.get("createdOn")));
                PolicyDefinitionBean def = new PolicyDefinitionBean();
                def.setId(EsMarshalling.asString(policyMap.get("definitionId")));
                policy.setDefinition(def);
                policy.setId(EsMarshalling.asLong(policyMap.get("id")));
                policy.setModifiedBy(EsMarshalling.asString(policyMap.get("modifiedBy")));
                policy.setModifiedOn(EsMarshalling.asDate(policyMap.get("modifiedOn")));
                policy.setName(EsMarshalling.asString(policyMap.get("name")));
                policy.setOrderIndex(EsMarshalling.asInt(policyMap.get("orderIndex")).intValue());
                bean.getPolicies().add(policy);
            }
        }
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static GatewayBean unmarshallGateway(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        GatewayBean bean = new GatewayBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setType(EsMarshalling.asEnum(source.get("type"), GatewayType.class));
        bean.setConfiguration(EsMarshalling.asString(source.get("configuration")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setModifiedBy(EsMarshalling.asString(source.get("modifiedBy")));
        bean.setModifiedOn(EsMarshalling.asDate(source.get("modifiedOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ServiceDefinitionBean unmarshallServiceDefinition(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ServiceDefinitionBean bean = new ServiceDefinitionBean();
        bean.setData(EsMarshalling.asString(source.get("data")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ContractBean unmarshallContract(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ContractBean bean = new ContractBean();
        bean.setId(EsMarshalling.asLong(source.get("id")));
        bean.setApikey(EsMarshalling.asString(source.get("apiKey")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ContractSummaryBean unmarshallContractSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ContractSummaryBean bean = new ContractSummaryBean();
        bean.setContractId(EsMarshalling.asLong(source.get("id")));
        bean.setApikey(EsMarshalling.asString(source.get("apiKey")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setAppOrganizationId(EsMarshalling.asString(source.get("appOrganizationId")));
        bean.setAppOrganizationName(EsMarshalling.asString(source.get("appOrganizationName")));
        bean.setAppId(EsMarshalling.asString(source.get("appId")));
        bean.setAppName(EsMarshalling.asString(source.get("appName")));
        bean.setAppVersion(EsMarshalling.asString(source.get("appVersion")));
        bean.setServiceOrganizationId(EsMarshalling.asString(source.get("serviceOrganizationId")));
        bean.setServiceOrganizationName(EsMarshalling.asString(source.get("serviceOrganizationName")));
        bean.setServiceId(EsMarshalling.asString(source.get("serviceId")));
        bean.setServiceName(EsMarshalling.asString(source.get("serviceName")));
        bean.setServiceVersion(EsMarshalling.asString(source.get("serviceVersion")));
        bean.setServiceDescription(EsMarshalling.asString(source.get("serviceDescription")));
        bean.setPlanName(EsMarshalling.asString(source.get("planName")));
        bean.setPlanId(EsMarshalling.asString(source.get("planId")));
        bean.setPlanVersion(EsMarshalling.asString(source.get("planVersion")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ApiEntryBean unmarshallApiEntry(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ApiEntryBean bean = new ApiEntryBean();
        bean.setApiKey(EsMarshalling.asString(source.get("apiKey")));
        bean.setServiceOrgId(EsMarshalling.asString(source.get("serviceOrganizationId")));
        bean.setServiceOrgName(EsMarshalling.asString(source.get("serviceOrganizationName")));
        bean.setServiceId(EsMarshalling.asString(source.get("serviceId")));
        bean.setServiceName(EsMarshalling.asString(source.get("serviceName")));
        bean.setServiceVersion(EsMarshalling.asString(source.get("serviceVersion")));
        bean.setPlanName(EsMarshalling.asString(source.get("planName")));
        bean.setPlanId(EsMarshalling.asString(source.get("planId")));
        bean.setPlanVersion(EsMarshalling.asString(source.get("planVersion")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PlanBean unmarshallPlan(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        PlanBean bean = new PlanBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PlanSummaryBean unmarshallPlanSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        PlanSummaryBean bean = new PlanSummaryBean();
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setOrganizationName(EsMarshalling.asString(source.get("organizationName")));
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PlanVersionBean unmarshallPlanVersion(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        PlanVersionBean bean = new PlanVersionBean();
        bean.setVersion(EsMarshalling.asString(source.get("version")));
        bean.setStatus(EsMarshalling.asEnum(source.get("status"), PlanStatus.class));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setModifiedBy(EsMarshalling.asString(source.get("modifiedBy")));
        bean.setModifiedOn(EsMarshalling.asDate(source.get("modifiedOn")));
        bean.setLockedOn(EsMarshalling.asDate(source.get("lockedOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PlanVersionSummaryBean unmarshallPlanVersionSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        PlanVersionSummaryBean bean = new PlanVersionSummaryBean();
        bean.setDescription(EsMarshalling.asString(source.get("planDescription")));
        bean.setId(EsMarshalling.asString(source.get("planId")));
        bean.setName(EsMarshalling.asString(source.get("planName")));
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setOrganizationName(EsMarshalling.asString(source.get("organizationName")));
        bean.setStatus(EsMarshalling.asEnum(source.get("status"), PlanStatus.class));
        bean.setVersion(EsMarshalling.asString(source.get("version")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ServiceBean unmarshallService(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ServiceBean bean = new ServiceBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ServiceSummaryBean unmarshallServiceSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ServiceSummaryBean bean = new ServiceSummaryBean();
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setOrganizationName(EsMarshalling.asString(source.get("organizationName")));
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ServiceVersionBean unmarshallServiceVersion(Map<String, Object> source) {
        Map endpointProperties;
        if (source == null) {
            return null;
        }
        ServiceVersionBean bean = new ServiceVersionBean();
        bean.setVersion(EsMarshalling.asString(source.get("version")));
        bean.setStatus(EsMarshalling.asEnum(source.get("status"), ServiceStatus.class));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setModifiedBy(EsMarshalling.asString(source.get("modifiedBy")));
        bean.setModifiedOn(EsMarshalling.asDate(source.get("modifiedOn")));
        bean.setPublishedOn(EsMarshalling.asDate(source.get("publishedOn")));
        bean.setRetiredOn(EsMarshalling.asDate(source.get("retiredOn")));
        bean.setEndpoint(EsMarshalling.asString(source.get("endpoint")));
        bean.setEndpointType(EsMarshalling.asEnum(source.get("endpointType"), EndpointType.class));
        bean.setPublicService(EsMarshalling.asBoolean(source.get("publicService")).booleanValue());
        bean.setDefinitionType(EsMarshalling.asEnum(source.get("definitionType"), ServiceDefinitionType.class));
        bean.setGateways(new HashSet());
        List gateways = (List)source.get("gateways");
        if (gateways != null) {
            for (Map gatewayMap : gateways) {
                ServiceGatewayBean gatewayBean = new ServiceGatewayBean();
                gatewayBean.setGatewayId(EsMarshalling.asString(gatewayMap.get("gatewayId")));
                bean.getGateways().add(gatewayBean);
            }
        }
        bean.setPlans(new HashSet());
        List plans = (List)source.get("plans");
        if (plans != null) {
            for (Map planMap : plans) {
                ServicePlanBean planBean = new ServicePlanBean();
                planBean.setPlanId(EsMarshalling.asString(planMap.get("planId")));
                planBean.setVersion(EsMarshalling.asString(planMap.get("version")));
                bean.getPlans().add(planBean);
            }
        }
        if ((endpointProperties = (Map)source.get("endpointProperties")) != null) {
            bean.setEndpointProperties(new HashMap());
            for (Map.Entry entry : endpointProperties.entrySet()) {
                bean.getEndpointProperties().put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ServiceVersionSummaryBean unmarshallServiceVersionSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ServiceVersionSummaryBean bean = new ServiceVersionSummaryBean();
        bean.setDescription(EsMarshalling.asString(source.get("serviceDescription")));
        bean.setId(EsMarshalling.asString(source.get("serviceId")));
        bean.setName(EsMarshalling.asString(source.get("serviceName")));
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setOrganizationName(EsMarshalling.asString(source.get("organizationName")));
        bean.setStatus(EsMarshalling.asEnum(source.get("status"), ServiceStatus.class));
        bean.setVersion(EsMarshalling.asString(source.get("version")));
        bean.setPublicService(EsMarshalling.asBoolean(source.get("publicService")).booleanValue());
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ApplicationBean unmarshallApplication(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ApplicationBean bean = new ApplicationBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ApplicationSummaryBean unmarshallApplicationSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ApplicationSummaryBean bean = new ApplicationSummaryBean();
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setOrganizationName(EsMarshalling.asString(source.get("organizationName")));
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ApplicationVersionBean unmarshallApplicationVersion(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ApplicationVersionBean bean = new ApplicationVersionBean();
        bean.setVersion(EsMarshalling.asString(source.get("version")));
        bean.setStatus(EsMarshalling.asEnum(source.get("status"), ApplicationStatus.class));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setModifiedBy(EsMarshalling.asString(source.get("modifiedBy")));
        bean.setModifiedOn(EsMarshalling.asDate(source.get("modifiedOn")));
        bean.setPublishedOn(EsMarshalling.asDate(source.get("publishedOn")));
        bean.setRetiredOn(EsMarshalling.asDate(source.get("retiredOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static ApplicationVersionSummaryBean unmarshallApplicationVersionSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ApplicationVersionSummaryBean bean = new ApplicationVersionSummaryBean();
        bean.setDescription(EsMarshalling.asString(source.get("applicationDescription")));
        bean.setId(EsMarshalling.asString(source.get("applicationId")));
        bean.setName(EsMarshalling.asString(source.get("applicationName")));
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setOrganizationName(EsMarshalling.asString(source.get("organizationName")));
        bean.setStatus(EsMarshalling.asEnum(source.get("status"), ApplicationStatus.class));
        bean.setVersion(EsMarshalling.asString(source.get("version")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static RoleBean unmarshallRole(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        RoleBean bean = new RoleBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setAutoGrant(EsMarshalling.asBoolean(source.get("autoGrant")));
        List permissions = (List)source.get("permissions");
        if (permissions != null && !permissions.isEmpty()) {
            bean.setPermissions(new HashSet());
            for (Object permission : permissions) {
                bean.getPermissions().add(EsMarshalling.asEnum(permission, PermissionType.class));
            }
        }
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static UserBean unmarshallUser(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        UserBean bean = new UserBean();
        bean.setUsername(EsMarshalling.asString(source.get("username")));
        bean.setEmail(EsMarshalling.asString(source.get("email")));
        bean.setFullName(EsMarshalling.asString(source.get("fullName")));
        bean.setJoinedOn(EsMarshalling.asDate(source.get("joinedOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static OrganizationBean unmarshallOrganization(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        OrganizationBean bean = new OrganizationBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setModifiedOn(EsMarshalling.asDate(source.get("modifiedOn")));
        bean.setModifiedBy(EsMarshalling.asString(source.get("modifiedBy")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static OrganizationSummaryBean unmarshallOrganizationSummary(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        OrganizationSummaryBean bean = new OrganizationSummaryBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static RoleMembershipBean unmarshallRoleMembership(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        RoleMembershipBean bean = new RoleMembershipBean();
        bean.setId(EsMarshalling.asLong(source.get("id")));
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setRoleId(EsMarshalling.asString(source.get("roleId")));
        bean.setUserId(EsMarshalling.asString(source.get("userId")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static AuditEntryBean unmarshallAuditEntry(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        AuditEntryBean bean = new AuditEntryBean();
        bean.setId(EsMarshalling.asLong(source.get("id")));
        bean.setOrganizationId(EsMarshalling.asString(source.get("organizationId")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setData(EsMarshalling.asString(source.get("data")));
        bean.setEntityId(EsMarshalling.asString(source.get("entityId")));
        bean.setEntityType(EsMarshalling.asEnum(source.get("entityType"), AuditEntityType.class));
        bean.setEntityVersion(EsMarshalling.asString(source.get("entityVersion")));
        bean.setWhat(EsMarshalling.asEnum(source.get("what"), AuditEntryType.class));
        bean.setWho(EsMarshalling.asString(source.get("who")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static GatewaySummaryBean unmarshallGatewaySummary(Map<String, Object> map) {
        GatewaySummaryBean bean = new GatewaySummaryBean();
        bean.setId(EsMarshalling.asString(map.get("id")));
        bean.setName(EsMarshalling.asString(map.get("name")));
        if (map.containsKey("description")) {
            bean.setDescription(EsMarshalling.asString(map.get("description")));
        }
        bean.setType(EsMarshalling.asEnum(map.get("type"), GatewayType.class));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PolicyDefinitionBean unmarshallPolicyDefinition(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        PolicyDefinitionBean bean = new PolicyDefinitionBean();
        bean.setId(EsMarshalling.asString(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setForm(EsMarshalling.asString(source.get("form")));
        bean.setFormType(EsMarshalling.asEnum(source.get("formType"), PolicyFormType.class));
        bean.setIcon(EsMarshalling.asString(source.get("icon")));
        bean.setPluginId(EsMarshalling.asLong(source.get("pluginId")));
        bean.setPolicyImpl(EsMarshalling.asString(source.get("policyImpl")));
        bean.setDeleted(EsMarshalling.asBoolean(source.get("deleted")));
        List templates = (List)source.get("templates");
        if (templates != null && !templates.isEmpty()) {
            bean.setTemplates(new HashSet());
            for (Map templateMap : templates) {
                PolicyDefinitionTemplateBean template = new PolicyDefinitionTemplateBean();
                template.setLanguage(EsMarshalling.asString(templateMap.get("language")));
                template.setTemplate(EsMarshalling.asString(templateMap.get("template")));
                bean.getTemplates().add(template);
            }
        }
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PolicyDefinitionSummaryBean unmarshallPolicyDefinitionSummary(Map<String, Object> map) {
        PolicyDefinitionSummaryBean bean = new PolicyDefinitionSummaryBean();
        bean.setId(EsMarshalling.asString(map.get("id")));
        bean.setName(EsMarshalling.asString(map.get("name")));
        if (map.containsKey("description")) {
            bean.setDescription(EsMarshalling.asString(map.get("description")));
        }
        bean.setPolicyImpl(EsMarshalling.asString(map.get("policyImpl")));
        if (map.containsKey("icon")) {
            bean.setIcon(EsMarshalling.asString(map.get("icon")));
        }
        if (map.containsKey("pluginId")) {
            bean.setPluginId(EsMarshalling.asLong(map.get("pluginId")));
        }
        if (map.containsKey("formType")) {
            bean.setFormType(EsMarshalling.asEnum(map.get("formType"), PolicyFormType.class));
        }
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PluginBean unmarshallPlugin(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        PluginBean bean = new PluginBean();
        bean.setId(EsMarshalling.asLong(source.get("id")));
        bean.setName(EsMarshalling.asString(source.get("name")));
        bean.setDescription(EsMarshalling.asString(source.get("description")));
        bean.setCreatedBy(EsMarshalling.asString(source.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(source.get("createdOn")));
        bean.setGroupId(EsMarshalling.asString(source.get("groupId")));
        bean.setArtifactId(EsMarshalling.asString(source.get("artifactId")));
        bean.setVersion(EsMarshalling.asString(source.get("version")));
        bean.setType(EsMarshalling.asString(source.get("type")));
        bean.setClassifier(EsMarshalling.asString(source.get("classifier")));
        bean.setDeleted(EsMarshalling.asBoolean(source.get("deleted")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    public static PluginSummaryBean unmarshallPluginSummary(Map<String, Object> map) {
        PluginSummaryBean bean = new PluginSummaryBean();
        bean.setId(EsMarshalling.asLong(map.get("id")));
        bean.setName(EsMarshalling.asString(map.get("name")));
        if (map.containsKey("description")) {
            bean.setDescription(EsMarshalling.asString(map.get("description")));
        }
        bean.setGroupId(EsMarshalling.asString(map.get("groupId")));
        bean.setArtifactId(EsMarshalling.asString(map.get("artifactId")));
        bean.setVersion(EsMarshalling.asString(map.get("version")));
        if (map.containsKey("type")) {
            bean.setType(EsMarshalling.asString(map.get("type")));
        }
        if (map.containsKey("classifier")) {
            bean.setClassifier(EsMarshalling.asString(map.get("classifier")));
        }
        bean.setCreatedBy(EsMarshalling.asString(map.get("createdBy")));
        bean.setCreatedOn(EsMarshalling.asDate(map.get("createdOn")));
        EsMarshalling.postMarshall(bean);
        return bean;
    }

    private static String asString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    private static Long asLong(Object object) {
        if (object == null) {
            return null;
        }
        Number n = (Number)object;
        return n.longValue();
    }

    private static Integer asInt(Object object) {
        if (object == null) {
            return null;
        }
        Number n = (Number)object;
        return n.intValue();
    }

    private static <T> T asEnum(Object object, Class<T> type) {
        if (object == null) {
            return null;
        }
        return Enum.valueOf(type, String.valueOf(object));
    }

    private static Date asDate(Object object) {
        if (object == null) {
            return null;
        }
        Number n = (Number)object;
        return new Date(n.longValue());
    }

    private static Boolean asBoolean(Object object) {
        if (object == null) {
            return null;
        }
        return (Boolean)object;
    }

    private static void preMarshall(Object bean) {
        try {
            Method method = bean.getClass().getDeclaredMethod("encryptData", new Class[0]);
            if (method != null) {
                method.invoke(bean, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static void postMarshall(Object bean) {
        try {
            Method method = bean.getClass().getDeclaredMethod("decryptData", new Class[0]);
            if (method != null) {
                method.invoke(bean, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }
}

