/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.gateway.rest;

import io.apiman.gateway.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceEndpoint;
import io.apiman.gateway.engine.beans.SystemStatus;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.manager.api.gateway.i18n.Messages;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.codehaus.jackson.map.ObjectMapper;

public class GatewayClient {
    private static final String SYSTEM_STATUS = "/system/status";
    private static final String SERVICES = "/services";
    private static final String APPLICATIONS = "/applications";
    private static final ObjectMapper mapper = new ObjectMapper();
    private String endpoint;
    private CloseableHttpClient httpClient;

    public GatewayClient(String endpoint, CloseableHttpClient httpClient) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
    }

    public SystemStatus getStatus() {
        SystemStatus systemStatus;
        InputStream is = null;
        try {
            URI uri = new URI(this.endpoint + SYSTEM_STATUS);
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode != 200) {
                throw new Exception("System status check failed: " + actualStatusCode);
            }
            is = response.getEntity().getContent();
            systemStatus = (SystemStatus)mapper.reader(SystemStatus.class).readValue(is);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return systemStatus;
    }

    public ServiceEndpoint getServiceEndpoint(String organizationId, String serviceId, String version) throws NotAuthorizedException {
        ServiceEndpoint serviceEndpoint;
        InputStream is = null;
        try {
            URI uri = new URI(this.endpoint + SERVICES + "/" + organizationId + "/" + serviceId + "/" + version + "/endpoint");
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode != 200) {
                throw new Exception("Failed to get the service endpoint: " + actualStatusCode);
            }
            is = response.getEntity().getContent();
            serviceEndpoint = (ServiceEndpoint)mapper.reader(ServiceEndpoint.class).readValue(is);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return serviceEndpoint;
    }

    public void register(Application application) throws RegistrationException, NotAuthorizedException {
        try {
            URI uri = new URI(this.endpoint + APPLICATIONS);
            HttpPut put = new HttpPut(uri);
            put.setHeader("Content-Type", "application/json");
            String jsonPayload = mapper.writer().writeValueAsString((Object)application);
            StringEntity entity = new StringEntity(jsonPayload);
            put.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.AppRegistrationFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregister(String organizationId, String applicationId, String version) throws RegistrationException, NotAuthorizedException {
        try {
            URI uri = new URI(this.endpoint + APPLICATIONS + "/" + organizationId + "/" + applicationId + "/" + version);
            HttpDelete put = new HttpDelete(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.AppUnregistrationFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void publish(Service service) throws PublishingException, NotAuthorizedException {
        try {
            URI uri = new URI(this.endpoint + SERVICES);
            HttpPut put = new HttpPut(uri);
            put.setHeader("Content-Type", "application/json");
            String jsonPayload = mapper.writer().writeValueAsString((Object)service);
            StringEntity entity = new StringEntity(jsonPayload);
            put.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.ServicePublishingFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void retire(String organizationId, String serviceId, String version) throws RegistrationException, NotAuthorizedException {
        try {
            URI uri = new URI(this.endpoint + SERVICES + "/" + organizationId + "/" + serviceId + "/" + version);
            HttpDelete put = new HttpDelete(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.ServiceRetiringFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

