/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.gateway.rest;

import io.apiman.gateway.api.rest.contract.exceptions.GatewayApiErrorBean;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceEndpoint;
import io.apiman.gateway.engine.beans.SystemStatus;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.i18n.Messages;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.codehaus.jackson.map.ObjectMapper;

public class GatewayClient {
    private static final String SYSTEM_STATUS = "/system/status";
    private static final String SERVICES = "/services";
    private static final String APPLICATIONS = "/applications";
    private static final ObjectMapper mapper = new ObjectMapper();
    private String endpoint;
    private CloseableHttpClient httpClient;

    public GatewayClient(String endpoint, CloseableHttpClient httpClient) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SystemStatus getStatus() throws GatewayAuthenticationException {
        SystemStatus systemStatus;
        InputStream is = null;
        try {
            URI uri = new URI(this.endpoint + SYSTEM_STATUS);
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode != 200) {
                throw new Exception("System status check failed: " + actualStatusCode);
            }
            is = response.getEntity().getContent();
            systemStatus = (SystemStatus)mapper.reader(SystemStatus.class).readValue(is);
        }
        catch (GatewayAuthenticationException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return systemStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceEndpoint getServiceEndpoint(String organizationId, String serviceId, String version) throws GatewayAuthenticationException {
        ServiceEndpoint serviceEndpoint;
        InputStream is = null;
        try {
            URI uri = new URI(this.endpoint + SERVICES + "/" + organizationId + "/" + serviceId + "/" + version + "/endpoint");
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode != 200) {
                throw new Exception("Failed to get the service endpoint: " + actualStatusCode);
            }
            is = response.getEntity().getContent();
            serviceEndpoint = (ServiceEndpoint)mapper.reader(ServiceEndpoint.class).readValue(is);
        }
        catch (GatewayAuthenticationException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return serviceEndpoint;
    }

    public void register(Application application) throws RegistrationException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + APPLICATIONS);
            HttpPut put = new HttpPut(uri);
            put.setHeader("Content-Type", "application/json; charset=utf-8");
            String jsonPayload = mapper.writer().writeValueAsString((Object)application);
            StringEntity entity = new StringEntity(jsonPayload);
            put.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                RegistrationException re = this.readRegistrationException((HttpResponse)response);
                throw re;
            }
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.AppRegistrationFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (RegistrationException | GatewayAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregister(String organizationId, String applicationId, String version) throws RegistrationException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + APPLICATIONS + "/" + organizationId + "/" + applicationId + "/" + version);
            HttpDelete put = new HttpDelete(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                RegistrationException re = this.readRegistrationException((HttpResponse)response);
                throw re;
            }
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.AppUnregistrationFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (RegistrationException | GatewayAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void publish(Service service) throws PublishingException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + SERVICES);
            HttpPut put = new HttpPut(uri);
            put.setHeader("Content-Type", "application/json; charset=utf-8");
            String jsonPayload = mapper.writer().writeValueAsString((Object)service);
            StringEntity entity = new StringEntity(jsonPayload);
            put.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                PublishingException pe = this.readPublishingException((HttpResponse)response);
                throw pe;
            }
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.ServicePublishingFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (PublishingException | GatewayAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void retire(String organizationId, String serviceId, String version) throws RegistrationException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + SERVICES + "/" + organizationId + "/" + serviceId + "/" + version);
            HttpDelete put = new HttpDelete(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                PublishingException pe = this.readPublishingException((HttpResponse)response);
                throw pe;
            }
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.ServiceRetiringFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (PublishingException | GatewayAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishingException readPublishingException(HttpResponse response) {
        PublishingException exception;
        InputStream is = null;
        try {
            is = response.getEntity().getContent();
            GatewayApiErrorBean error = (GatewayApiErrorBean)mapper.reader(GatewayApiErrorBean.class).readValue(is);
            exception = new PublishingException(error.getMessage());
            exception.setStackTrace(GatewayClient.parseStackTrace(error.getStacktrace()));
        }
        catch (Exception e) {
            exception = new PublishingException(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistrationException readRegistrationException(HttpResponse response) {
        RegistrationException exception;
        InputStream is = null;
        try {
            is = response.getEntity().getContent();
            GatewayApiErrorBean error = (GatewayApiErrorBean)mapper.reader(GatewayApiErrorBean.class).readValue(is);
            exception = new RegistrationException(error.getMessage());
            exception.setStackTrace(GatewayClient.parseStackTrace(error.getStacktrace()));
        }
        catch (Exception e) {
            exception = new RegistrationException(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return exception;
    }

    protected static StackTraceElement[] parseStackTrace(String stacktrace) {
        try {
            ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
            BufferedReader reader = new BufferedReader(new StringReader(stacktrace));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("\tat ")) continue;
                int openParenIdx = line.indexOf(40);
                int closeParenIdx = line.indexOf(41);
                String classAndMethod = line.substring(4, openParenIdx);
                String fileAndLineNum = line.substring(openParenIdx + 1, closeParenIdx);
                String className = classAndMethod.substring(0, classAndMethod.lastIndexOf(46));
                String methodName = classAndMethod.substring(classAndMethod.lastIndexOf(46) + 1);
                String[] split = fileAndLineNum.split(":");
                String fileName = split[0];
                String lineNum = split[1];
                elements.add(new StackTraceElement(className, methodName, fileName, new Integer(lineNum)));
            }
            return elements.toArray(new StackTraceElement[elements.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

