/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.gateway.rest;

import io.apiman.common.util.AesEncrypter;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceEndpoint;
import io.apiman.gateway.engine.beans.SystemStatus;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.gateways.RestGatewayConfigBean;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.i18n.Messages;
import io.apiman.manager.api.gateway.rest.GatewayClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

public class RestGatewayLink
implements IGatewayLink {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static SSLConnectionSocketFactory sslConnectionFactory;
    private GatewayBean gateway;
    private CloseableHttpClient httpClient;
    private GatewayClient gatewayClient;
    private RestGatewayConfigBean config;

    public RestGatewayLink(GatewayBean gateway) {
        try {
            this.gateway = gateway;
            String cfg = gateway.getConfiguration();
            this.setConfig((RestGatewayConfigBean)mapper.reader(RestGatewayConfigBean.class).readValue(cfg));
            this.getConfig().setPassword(AesEncrypter.decrypt((String)this.getConfig().getPassword()));
            this.httpClient = HttpClientBuilder.create().setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    RestGatewayLink.this.configureBasicAuth(request);
                }
            }).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isGatewayUp() throws GatewayAuthenticationException {
        SystemStatus status = this.getClient().getStatus();
        return status.isUp();
    }

    @Override
    public SystemStatus getStatus() throws GatewayAuthenticationException {
        return this.getClient().getStatus();
    }

    @Override
    public ServiceEndpoint getServiceEndpoint(String organizationId, String serviceId, String version) throws GatewayAuthenticationException {
        return this.getClient().getServiceEndpoint(organizationId, serviceId, version);
    }

    @Override
    public void publishService(Service service) throws PublishingException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new PublishingException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().publish(service);
    }

    @Override
    public void retireService(Service service) throws PublishingException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new PublishingException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().retire(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    @Override
    public void registerApplication(Application application) throws RegistrationException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new RegistrationException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().register(application);
    }

    @Override
    public void unregisterApplication(Application application) throws RegistrationException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new RegistrationException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().unregister(application.getOrganizationId(), application.getApplicationId(), application.getVersion());
    }

    protected void configureBasicAuth(HttpRequest request) {
        try {
            String username = this.getConfig().getUsername();
            String password = this.getConfig().getPassword();
            String up = username + ":" + password;
            String base64 = new String(Base64.encodeBase64((byte[])up.getBytes("UTF-8")));
            String authHeader = "Basic " + base64;
            request.setHeader("Authorization", authHeader);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected GatewayClient getClient() {
        if (this.gatewayClient == null) {
            this.gatewayClient = this.createClient();
        }
        return this.gatewayClient;
    }

    private GatewayClient createClient() {
        String gatewayEndpoint = this.getConfig().getEndpoint();
        return new GatewayClient(gatewayEndpoint, this.httpClient);
    }

    public RestGatewayConfigBean getConfig() {
        return this.config;
    }

    public void setConfig(RestGatewayConfigBean config) {
        this.config = config;
    }

    static {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            sslConnectionFactory = new SSLConnectionSocketFactory(builder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

