/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.gateway.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.gateway.api.rest.exceptions.GatewayApiErrorBean;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.ApiEndpoint;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.GatewayEndpoint;
import io.apiman.gateway.engine.beans.IPolicyProbeResponse;
import io.apiman.gateway.engine.beans.SystemStatus;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.policies.probe.ProbeRegistry;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.i18n.Messages;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class GatewayClient {
    private static final String SYSTEM_STATUS = "/system/status";
    private static final String SYSTEM_ENDPOINT = "/system/endpoint";
    private static final String APIs = "/apis";
    private static final String CLIENTS = "/clients";
    private static final ObjectMapper mapper = new ObjectMapper();
    private String endpoint;
    private CloseableHttpClient httpClient;

    public GatewayClient(String endpoint, CloseableHttpClient httpClient) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
    }

    public IPolicyProbeResponse probePolicy(String orgId, String apiId, String apiVersion, int idx) throws GatewayAuthenticationException {
        return this.probePolicy(orgId, apiId, apiVersion, idx, "", "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPolicyProbeResponse probePolicy(String orgId, String apiId, String apiVersion, int idx, String apiKey, String rawPayload) throws GatewayAuthenticationException {
        IPolicyProbeResponse iPolicyProbeResponse;
        InputStream probeResponseIs = null;
        try {
            UriBuilder probeUrl = UriBuilder.fromUri((String)this.endpoint).path("organizations").path(orgId).path("apis").path(apiId).path("versions").path(apiVersion).path("policies").path(String.valueOf(idx));
            if (apiKey != null && !apiKey.isBlank()) {
                probeUrl.queryParam("apiKey", new Object[]{apiKey});
            }
            HttpPost post = new HttpPost(probeUrl.build(new Object[0]));
            post.setHeader("Content-Type", "application/json");
            ByteArrayEntity entity = new ByteArrayEntity(rawPayload.getBytes(StandardCharsets.UTF_8), ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode / 100 != 2) {
                throw new RuntimeException("System status check failed: " + actualStatusCode + ": " + response.getStatusLine());
            }
            probeResponseIs = response.getEntity().getContent();
            iPolicyProbeResponse = ProbeRegistry.deserialize((InputStream)probeResponseIs);
        }
        catch (GatewayAuthenticationException | RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(probeResponseIs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)probeResponseIs);
        return iPolicyProbeResponse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SystemStatus getStatus() throws GatewayAuthenticationException {
        SystemStatus systemStatus;
        InputStream is = null;
        try {
            URI uri = new URI(this.endpoint + SYSTEM_STATUS);
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode != 200) {
                throw new RuntimeException("System status check failed: " + actualStatusCode);
            }
            is = response.getEntity().getContent();
            systemStatus = (SystemStatus)mapper.reader(SystemStatus.class).readValue(is);
        }
        catch (GatewayAuthenticationException | RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return systemStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GatewayEndpoint getGatewayEndpoint() throws GatewayAuthenticationException {
        GatewayEndpoint gatewayEndpoint;
        InputStream is = null;
        try {
            URI uri = new URI(this.endpoint + SYSTEM_ENDPOINT);
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode != 200) {
                throw new RuntimeException("Failed to get the API endpoint: " + actualStatusCode);
            }
            is = response.getEntity().getContent();
            gatewayEndpoint = (GatewayEndpoint)mapper.reader(GatewayEndpoint.class).readValue(is);
        }
        catch (GatewayAuthenticationException | RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return gatewayEndpoint;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiEndpoint getApiEndpoint(String organizationId, String apiId, String version) throws GatewayAuthenticationException {
        ApiEndpoint apiEndpoint;
        InputStream is = null;
        try {
            URI uri = new URI(this.endpoint + "/apis/" + organizationId + "/" + apiId + "/" + version + "/endpoint");
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode != 200) {
                throw new RuntimeException("Failed to get the API endpoint: " + actualStatusCode);
            }
            is = response.getEntity().getContent();
            apiEndpoint = (ApiEndpoint)mapper.reader(ApiEndpoint.class).readValue(is);
        }
        catch (GatewayAuthenticationException | RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return apiEndpoint;
    }

    public void register(Client client) throws RegistrationException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + CLIENTS);
            HttpPut put = new HttpPut(uri);
            put.setHeader("Content-Type", "application/json; charset=utf-8");
            String jsonPayload = mapper.writer().writeValueAsString((Object)client);
            StringEntity entity = new StringEntity(jsonPayload);
            put.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                throw this.readRegistrationException((HttpResponse)response);
            }
            if (actualStatusCode >= 300) {
                throw new RuntimeException(Messages.i18n.format("GatewayClient.ClientRegistrationFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (GatewayAuthenticationException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregister(String organizationId, String clientId, String version) throws RegistrationException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + "/clients/" + organizationId + "/" + clientId + "/" + version);
            HttpDelete put = new HttpDelete(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                RegistrationException re = this.readRegistrationException((HttpResponse)response);
                throw re;
            }
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.ClientUnregistrationFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (RegistrationException | GatewayAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void publish(Api api) throws PublishingException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + APIs);
            HttpPut put = new HttpPut(uri);
            put.setHeader("Content-Type", "application/json; charset=utf-8");
            String jsonPayload = mapper.writer().writeValueAsString((Object)api);
            StringEntity entity = new StringEntity(jsonPayload);
            put.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                PublishingException pe = this.readPublishingException((HttpResponse)response);
                throw pe;
            }
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.ApiPublishingFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (PublishingException | GatewayAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void retire(String organizationId, String apiId, String version) throws RegistrationException, GatewayAuthenticationException {
        try {
            Header[] headers;
            URI uri = new URI(this.endpoint + "/apis/" + organizationId + "/" + apiId + "/" + version);
            HttpDelete put = new HttpDelete(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            int actualStatusCode = response.getStatusLine().getStatusCode();
            if (actualStatusCode == 401 || actualStatusCode == 403) {
                throw new GatewayAuthenticationException();
            }
            if (actualStatusCode == 500 && (headers = response.getHeaders("X-API-Gateway-Error")) != null && headers.length > 0) {
                PublishingException pe = this.readPublishingException((HttpResponse)response);
                throw pe;
            }
            if (actualStatusCode >= 300) {
                throw new Exception(Messages.i18n.format("GatewayClient.ApiRetiringFailed", new Object[]{actualStatusCode}));
            }
        }
        catch (PublishingException | GatewayAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishingException readPublishingException(HttpResponse response) {
        PublishingException exception;
        InputStream is = null;
        try {
            is = response.getEntity().getContent();
            GatewayApiErrorBean error = (GatewayApiErrorBean)mapper.reader(GatewayApiErrorBean.class).readValue(is);
            exception = new PublishingException(error.getMessage());
            StackTraceElement[] stack = GatewayClient.parseStackTrace(error.getStacktrace());
            if (stack != null) {
                exception.setStackTrace(stack);
            }
        }
        catch (Exception e) {
            exception = new PublishingException(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistrationException readRegistrationException(HttpResponse response) {
        RegistrationException exception;
        InputStream is = null;
        try {
            is = response.getEntity().getContent();
            GatewayApiErrorBean error = (GatewayApiErrorBean)mapper.reader(GatewayApiErrorBean.class).readValue(is);
            exception = new RegistrationException(error.getMessage());
            StackTraceElement[] stack = GatewayClient.parseStackTrace(error.getStacktrace());
            if (stack != null) {
                exception.setStackTrace(stack);
            }
        }
        catch (Exception e) {
            exception = new RegistrationException(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return exception;
    }

    protected static StackTraceElement[] parseStackTrace(String stacktrace) {
        StackTraceElement[] stackTraceElementArray;
        BufferedReader reader = new BufferedReader(new StringReader(stacktrace));
        try {
            String line;
            ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("\tat ")) continue;
                int openParenIdx = line.indexOf(40);
                int closeParenIdx = line.indexOf(41);
                String classAndMethod = line.substring(4, openParenIdx);
                String fileAndLineNum = line.substring(openParenIdx + 1, closeParenIdx);
                String className = classAndMethod.substring(0, classAndMethod.lastIndexOf(46));
                String methodName = classAndMethod.substring(classAndMethod.lastIndexOf(46) + 1);
                String[] split = fileAndLineNum.split(":");
                if (split.length == 1) {
                    elements.add(new StackTraceElement(className, methodName, fileAndLineNum, -1));
                    continue;
                }
                String fileName = split[0];
                String lineNum = split[1];
                elements.add(new StackTraceElement(className, methodName, fileName, Integer.parseInt(lineNum)));
            }
            stackTraceElementArray = elements.toArray(new StackTraceElement[elements.size()]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        reader.close();
        return stackTraceElementArray;
    }
}

