/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.gateway.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.util.AesEncrypter;
import io.apiman.common.util.ApimanStrLookup;
import io.apiman.common.util.crypt.CurrentDataEncrypter;
import io.apiman.common.util.crypt.DataEncryptionContext;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.ApiEndpoint;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.GatewayEndpoint;
import io.apiman.gateway.engine.beans.IPolicyProbeResponse;
import io.apiman.gateway.engine.beans.SystemStatus;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.gateways.RestGatewayConfigBean;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.i18n.Messages;
import io.apiman.manager.api.gateway.rest.GatewayClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;

public class RestGatewayLink
implements IGatewayLink {
    private static final StrLookup LOOKUP = new ApimanStrLookup();
    private static final StrSubstitutor PROPERTY_SUBSTITUTOR = new StrSubstitutor(LOOKUP);
    private static final ObjectMapper mapper;
    private static final SSLConnectionSocketFactory sslConnectionFactory;
    private GatewayBean gateway;
    private final CloseableHttpClient httpClient;
    private GatewayClient gatewayClient;
    private RestGatewayConfigBean config;

    public RestGatewayLink(GatewayBean gateway) {
        try {
            this.gateway = gateway;
            String cfg = gateway.getConfiguration();
            cfg = CurrentDataEncrypter.instance.decrypt(cfg, new DataEncryptionContext());
            cfg = PROPERTY_SUBSTITUTOR.replace(cfg);
            this.setConfig((RestGatewayConfigBean)mapper.reader(RestGatewayConfigBean.class).readValue(cfg));
            this.getConfig().setPassword(AesEncrypter.decrypt((String)this.getConfig().getPassword()));
            this.httpClient = HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    RestGatewayLink.this.configureBasicAuth(request);
                }
            }).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isGatewayUp() throws GatewayAuthenticationException {
        SystemStatus status = this.getClient().getStatus();
        return status.isUp();
    }

    @Override
    public SystemStatus getStatus() throws GatewayAuthenticationException {
        return this.getClient().getStatus();
    }

    @Override
    public GatewayEndpoint getGatewayEndpoint() throws GatewayAuthenticationException {
        return this.getClient().getGatewayEndpoint();
    }

    @Override
    public ApiEndpoint getApiEndpoint(String organizationId, String apiId, String version) throws GatewayAuthenticationException {
        return this.getClient().getApiEndpoint(organizationId, apiId, version);
    }

    @Override
    public void publishApi(Api api) throws PublishingException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new PublishingException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().publish(api);
    }

    @Override
    public void retireApi(Api api) throws PublishingException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new PublishingException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().retire(api.getOrganizationId(), api.getApiId(), api.getVersion());
    }

    @Override
    public void registerClient(Client client) throws RegistrationException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new RegistrationException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().register(client);
    }

    @Override
    public void unregisterClient(Client client) throws RegistrationException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new RegistrationException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        this.getClient().unregister(client.getOrganizationId(), client.getClientId(), client.getVersion());
    }

    public IPolicyProbeResponse probe(String orgId, String apiId, String apiVersion, int idx) throws RegistrationException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new RegistrationException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        return this.getClient().probePolicy(orgId, apiId, apiVersion, idx);
    }

    @Override
    public IPolicyProbeResponse probe(String orgId, String apiId, String apiVersion, int idx, String apiKey, String rawPayload) throws RegistrationException, GatewayAuthenticationException {
        if (!this.isGatewayUp()) {
            throw new RegistrationException(Messages.i18n.format("RestGatewayLink.GatewayNotRunning", new Object[0]));
        }
        return this.getClient().probePolicy(orgId, apiId, apiVersion, idx, apiKey, rawPayload);
    }

    protected void configureBasicAuth(HttpRequest request) {
        String username = this.getConfig().getUsername();
        String password = this.getConfig().getPassword();
        String up = username + ":" + password;
        String base64 = new String(Base64.encodeBase64((byte[])up.getBytes(StandardCharsets.UTF_8)));
        String authHeader = "Basic " + base64;
        request.setHeader("Authorization", authHeader);
    }

    protected GatewayClient getClient() {
        if (this.gatewayClient == null) {
            this.gatewayClient = this.createClient();
        }
        return this.gatewayClient;
    }

    private GatewayClient createClient() {
        String gatewayEndpoint = this.getConfig().getEndpoint();
        return new GatewayClient(gatewayEndpoint, this.httpClient);
    }

    public RestGatewayConfigBean getConfig() {
        return this.config;
    }

    public void setConfig(RestGatewayConfigBean config) {
        this.config = config;
    }

    static {
        PROPERTY_SUBSTITUTOR.setValueDelimiter(':');
        mapper = new ObjectMapper();
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            sslConnectionFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

