/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.war;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.configuration.Configuration;
import org.overlord.commons.config.ConfigurationFactory;

@ApplicationScoped
public class ApiManagerConfig {
    public static final String APIMAN_MANAGER_CONFIG_FILE_NAME = "apiman-manager.config.file.name";
    public static final String APIMAN_MANAGER_CONFIG_FILE_REFRESH = "apiman-manager.config.file.refresh";
    public static final String APIMAN_PLUGIN_REPOSITORIES = "apiman.plugins.repositories";
    private static Configuration config;

    public Set<URL> getPluginRepositories() {
        HashSet<URL> rval = new HashSet<URL>();
        String repositories = config.getString(APIMAN_PLUGIN_REPOSITORIES);
        if (repositories != null) {
            String[] split;
            for (String repository : split = repositories.split(",")) {
                try {
                    rval.add(new URL(repository.trim()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return rval;
    }

    public Configuration getConfig() {
        return config;
    }

    static {
        String configFile = System.getProperty(APIMAN_MANAGER_CONFIG_FILE_NAME);
        String refreshDelayStr = System.getProperty(APIMAN_MANAGER_CONFIG_FILE_REFRESH);
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        config = ConfigurationFactory.createConfig((String)configFile, (String)"apiman.properties", (Long)refreshDelay, null, ApiManagerConfig.class);
    }
}

