/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.war;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.configuration.Configuration;
import org.overlord.commons.config.ConfigurationFactory;

@ApplicationScoped
public class WarApiManagerConfig {
    public static final String APIMAN_MANAGER_CONFIG_FILE_NAME = "apiman-manager.config.file.name";
    public static final String APIMAN_MANAGER_CONFIG_FILE_REFRESH = "apiman-manager.config.file.refresh";
    public static final String APIMAN_MANAGER_STORAGE_TYPE = "apiman-manager.storage.type";
    public static final String APIMAN_MANAGER_STORAGE_ES_HOST = "apiman-manager.storage.es.host";
    public static final String APIMAN_MANAGER_STORAGE_ES_PORT = "apiman-manager.storage.es.port";
    public static final String APIMAN_MANAGER_STORAGE_ES_CLUSTER_NAME = "apiman-manager.storage.es.cluster-name";
    public static final String APIMAN_MANAGER_STORAGE_ES_INITIALIZE = "apiman-manager.storage.es.initialize";
    public static final String APIMAN_PLUGIN_REPOSITORIES = "apiman.plugins.repositories";
    public static final String DEFAULT_ES_CLUSTER_NAME = "apiman";
    private static Configuration config;

    public Set<URL> getPluginRepositories() {
        HashSet<URL> rval = new HashSet<URL>();
        String repositories = config.getString(APIMAN_PLUGIN_REPOSITORIES);
        if (repositories != null) {
            String[] split;
            for (String repository : split = repositories.split(",")) {
                try {
                    rval.add(new URL(repository.trim()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return rval;
    }

    public String getStorageType() {
        return config.getString(APIMAN_MANAGER_STORAGE_TYPE, "jpa");
    }

    public String getESHost() {
        return config.getString(APIMAN_MANAGER_STORAGE_ES_HOST, "localhost");
    }

    public int getESPort() {
        return config.getInt(APIMAN_MANAGER_STORAGE_ES_PORT, 9300);
    }

    public String getESClusterName() {
        return config.getString(APIMAN_MANAGER_STORAGE_ES_CLUSTER_NAME, DEFAULT_ES_CLUSTER_NAME);
    }

    public boolean isInitializeES() {
        return config.getBoolean(APIMAN_MANAGER_STORAGE_ES_INITIALIZE, true);
    }

    public Configuration getConfig() {
        return config;
    }

    static {
        String configFile = System.getProperty(APIMAN_MANAGER_CONFIG_FILE_NAME);
        String refreshDelayStr = System.getProperty(APIMAN_MANAGER_CONFIG_FILE_REFRESH);
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        config = ConfigurationFactory.createConfig((String)configFile, (String)"apiman.properties", (Long)refreshDelay, null, WarApiManagerConfig.class);
    }
}

