/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.war;

import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IIdmStorage;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.es.EsStorage;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.jpa.roles.JpaIdmStorage;
import io.apiman.manager.api.war.WarApiManagerConfig;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
public class WarCdiFactory {
    private static TransportClient sESClient;
    private static EsStorage sESStorage;

    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(WarApiManagerConfig config, @New JpaStorage jpaStorage, @New EsStorage esStorage) {
        if ("jpa".equals(config.getStorageType())) {
            return jpaStorage;
        }
        if ("es".equals(config.getStorageType())) {
            return WarCdiFactory.initES((WarApiManagerConfig)config, (EsStorage)esStorage);
        }
        throw new RuntimeException("Unknown storage type: " + config.getStorageType());
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(WarApiManagerConfig config, @New JpaStorage jpaStorage, @New EsStorage esStorage) {
        if ("jpa".equals(config.getStorageType())) {
            return jpaStorage;
        }
        if ("es".equals(config.getStorageType())) {
            return WarCdiFactory.initES((WarApiManagerConfig)config, (EsStorage)esStorage);
        }
        throw new RuntimeException("Unknown storage type: " + config.getStorageType());
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(@New UuidApiKeyGenerator uuidApiKeyGen) {
        return uuidApiKeyGen;
    }

    @Produces
    @ApplicationScoped
    public static IIdmStorage provideIdmStorage(WarApiManagerConfig config, @New JpaIdmStorage jpaIdmStorage, @New EsStorage esStorage) {
        if ("jpa".equals(config.getStorageType())) {
            return jpaIdmStorage;
        }
        if ("es".equals(config.getStorageType())) {
            return WarCdiFactory.initES((WarApiManagerConfig)config, (EsStorage)esStorage);
        }
        throw new RuntimeException("Unknown storage type: " + config.getStorageType());
    }

    @Produces
    @ApplicationScoped
    public static TransportClient provideTransportClient(WarApiManagerConfig config) {
        if ("es".equals(config.getStorageType()) && sESClient == null) {
            sESClient = WarCdiFactory.createTransportClient((WarApiManagerConfig)config);
        }
        return sESClient;
    }

    private static TransportClient createTransportClient(WarApiManagerConfig config) {
        TransportClient client = new TransportClient(ImmutableSettings.settingsBuilder().put("cluster.name", config.getESClusterName()).build());
        client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(config.getESHost(), config.getESPort()));
        return client;
    }

    private static EsStorage initES(WarApiManagerConfig config, EsStorage esStorage) {
        if (sESStorage == null) {
            sESStorage = esStorage;
            if (config.isInitializeES()) {
                sESStorage.initialize();
            }
        }
        return sESStorage;
    }
}

