/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.war;

import io.apiman.common.config.ConfigFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.exportimport.json.JsonImportReader;
import io.apiman.manager.api.exportimport.manager.StorageImportDispatcher;
import io.apiman.manager.api.exportimport.read.IImportReaderDispatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class WarApiManagerBootstrapperServlet
extends HttpServlet {
    private static final long serialVersionUID = -362982634664023862L;
    @Inject
    @ApimanLogger(value=WarApiManagerBootstrapperServlet.class)
    private IApimanLogger logger;
    @Inject
    private StorageImportDispatcher importer;
    private static Configuration config = ConfigFactory.createConfig();

    public void init() throws ServletException {
        Thread t = new Thread(() -> {
            File dataDir;
            if (this.isImportEnabled() && (dataDir = WarApiManagerBootstrapperServlet.getDataDir()) != null && dataDir.isDirectory()) {
                this.logger.info("Checking for bootstrap files in " + dataDir);
                Collection files = FileUtils.listFiles((File)dataDir, (String[])new String[]{"json"}, (boolean)false);
                TreeSet sortedFiles = new TreeSet(files);
                for (File file : sortedFiles) {
                    File alreadyProcessed = new File(file.getAbsolutePath() + ".imported");
                    if (!alreadyProcessed.isFile()) {
                        this.doImport(file);
                        continue;
                    }
                    this.logger.debug("Skipping (already processed) file: " + file);
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private void doImport(File file) {
        JsonImportReader reader;
        FileInputStream importData = null;
        try {
            importData = new FileInputStream(file);
            reader = new JsonImportReader(this.logger, (InputStream)importData);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(importData);
            this.logger.error((Throwable)e);
            return;
        }
        try {
            this.importer.setLogger(this.logger);
            this.importer.start();
            reader.setDispatcher((IImportReaderDispatcher)this.importer);
            reader.read();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)importData);
        }
    }

    private static File getDataDir() {
        File rval = null;
        String dataDir = config.getString("apiman.bootstrap.data_dir");
        if (dataDir != null) {
            rval = new File(dataDir);
        }
        if (rval == null && (dataDir = System.getProperty("jboss.server.data.dir")) != null) {
            rval = new File(dataDir, "bootstrap");
        }
        if (rval == null && (dataDir = System.getProperty("catalina.home")) != null) {
            rval = new File(dataDir, "data/bootstrap");
        }
        return rval;
    }

    private boolean isImportEnabled() {
        return !Boolean.getBoolean("apiman.bootstrap.disabled");
    }
}

