/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.war;

import io.apiman.common.es.util.DefaultEsClientFactory;
import io.apiman.common.es.util.IEsClientFactory;
import io.apiman.common.logging.IApimanDelegateLogger;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.util.ReflectionUtils;
import io.apiman.common.util.crypt.CurrentDataEncrypter;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.manager.api.core.IApiCatalog;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.INewUserBootstrapper;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.core.crypt.DefaultDataEncrypter;
import io.apiman.manager.api.core.i18n.Messages;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.core.logging.JsonLoggerImpl;
import io.apiman.manager.api.core.logging.StandardLoggerImpl;
import io.apiman.manager.api.core.noop.NoOpMetricsAccessor;
import io.apiman.manager.api.es.EsMetricsAccessor;
import io.apiman.manager.api.es.EsStorage;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.jpa.JpaStorageInitializer;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.security.impl.DefaultSecurityContext;
import io.apiman.manager.api.security.impl.KeycloakSecurityContext;
import io.apiman.manager.api.war.WarApiManagerConfig;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
public class WarCdiFactory {
    private static IEsClientFactory sStorageEsClientFactory;
    private static JpaStorage sJpaStorage;

    @Produces
    @ApimanLogger
    public static IApimanLogger provideLogger(WarApiManagerConfig config, InjectionPoint injectionPoint) {
        try {
            ApimanLogger logger = (ApimanLogger)injectionPoint.getAnnotated().getAnnotation(ApimanLogger.class);
            Class klazz = logger.value();
            return ((IApimanDelegateLogger)WarCdiFactory.getDelegate((WarApiManagerConfig)config).newInstance()).createLogger(klazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format(Messages.i18n.format("LoggerFactory.InstantiationFailed", new Object[0]), new Object[0]), e);
        }
    }

    @Produces
    @ApplicationScoped
    public static INewUserBootstrapper provideNewUserBootstrapper(WarApiManagerConfig config, IPluginRegistry pluginRegistry) {
        String type = config.getNewUserBootstrapperType();
        if (type == null) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        try {
            return (INewUserBootstrapper)WarCdiFactory.createCustomComponent(INewUserBootstrapper.class, (String)config.getNewUserBootstrapperType(), (Map)config.getNewUserBootstrapperProperties(), (IPluginRegistry)pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown user bootstrapper type: " + config.getNewUserBootstrapperType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static ISecurityContext provideSecurityContext(WarApiManagerConfig config, @New DefaultSecurityContext defaultSC, @New KeycloakSecurityContext keycloakSC) {
        if ("default".equals(config.getSecurityContextType())) {
            return defaultSC;
        }
        if ("keycloak".equals(config.getSecurityContextType())) {
            return keycloakSC;
        }
        throw new RuntimeException("Unknown security context type: " + config.getSecurityContextType());
    }

    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(WarApiManagerConfig config, @New JpaStorage jpaStorage, IPluginRegistry pluginRegistry) {
        JpaStorage storage;
        if ("jpa".equals(config.getStorageType())) {
            storage = WarCdiFactory.initJpaStorage((ApiManagerConfig)config, (JpaStorage)jpaStorage);
        } else if ("es".equals(config.getStorageType())) {
            storage = new EsStorage(config.getStorageESClientFactoryConfig());
        } else {
            try {
                storage = (IStorage)WarCdiFactory.createCustomComponent(IStorage.class, (String)config.getStorageType(), (Map)config.getStorageProperties(), (IPluginRegistry)pluginRegistry);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error or unknown storage type: " + config.getStorageType(), t);
            }
        }
        return storage;
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(WarApiManagerConfig config, @New JpaStorage jpaStorage, IStorage storage, IPluginRegistry pluginRegistry) {
        if ("jpa".equals(config.getStorageType())) {
            return WarCdiFactory.initJpaStorage((ApiManagerConfig)config, (JpaStorage)jpaStorage);
        }
        if ("es".equals(config.getStorageType())) {
            return new EsStorage(config.getStorageESClientFactoryConfig());
        }
        if (storage != null && storage instanceof IStorageQuery) {
            return (IStorageQuery)storage;
        }
        try {
            return (IStorageQuery)WarCdiFactory.createCustomComponent(IStorageQuery.class, (String)config.getStorageQueryType(), (Map)config.getStorageQueryProperties(), (IPluginRegistry)pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown storage query type: " + config.getStorageType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IMetricsAccessor provideMetricsAccessor(WarApiManagerConfig config, @New NoOpMetricsAccessor noopMetrics, IPluginRegistry pluginRegistry) {
        EsMetricsAccessor metrics;
        if ("es".equals(config.getMetricsType())) {
            metrics = new EsMetricsAccessor(config.getStorageESClientFactoryConfig());
        } else if (config.getMetricsType().equals(EsMetricsAccessor.class.getName())) {
            metrics = new EsMetricsAccessor(config.getStorageESClientFactoryConfig());
        } else if ("noop".equals(config.getMetricsType())) {
            metrics = noopMetrics;
        } else if (config.getMetricsType().equals(NoOpMetricsAccessor.class.getName())) {
            metrics = noopMetrics;
        } else {
            try {
                metrics = (IMetricsAccessor)WarCdiFactory.createCustomComponent(IMetricsAccessor.class, (String)config.getMetricsType(), (Map)config.getMetricsProperties(), (IPluginRegistry)pluginRegistry);
            }
            catch (Throwable t) {
                System.err.println("Unknown apiman metrics accessor type: " + config.getMetricsType());
                metrics = noopMetrics;
            }
        }
        return metrics;
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(WarApiManagerConfig config, @New UuidApiKeyGenerator uuidApiKeyGen, IPluginRegistry pluginRegistry) {
        UuidApiKeyGenerator apiKeyGenerator;
        String type = config.getApiKeyGeneratorType();
        if ("uuid".equals(type)) {
            apiKeyGenerator = uuidApiKeyGen;
        } else {
            try {
                apiKeyGenerator = (IApiKeyGenerator)WarCdiFactory.createCustomComponent(IApiKeyGenerator.class, (String)type, (Map)config.getApiKeyGeneratorProperties(), (IPluginRegistry)pluginRegistry);
            }
            catch (Exception e) {
                System.err.println("Unknown apiman API key generator type: " + type);
                System.err.println("Automatically falling back to UUID style API Keys.");
                apiKeyGenerator = uuidApiKeyGen;
            }
        }
        return apiKeyGenerator;
    }

    @Produces
    @ApplicationScoped
    public static IDataEncrypter provideDataEncrypter(@New DefaultDataEncrypter defaultEncrypter, WarApiManagerConfig config, IPluginRegistry pluginRegistry) {
        try {
            IDataEncrypter encrypter;
            CurrentDataEncrypter.instance = encrypter = (IDataEncrypter)WarCdiFactory.createCustomComponent(IDataEncrypter.class, (String)config.getDataEncrypterType(), (Map)config.getDataEncrypterProperties(), (IPluginRegistry)pluginRegistry, (Object)defaultEncrypter);
            return encrypter;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown data encrypter type: " + config.getDataEncrypterType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IApiCatalog provideApiCatalog(WarApiManagerConfig config, IPluginRegistry pluginRegistry) {
        try {
            return (IApiCatalog)WarCdiFactory.createCustomComponent(IApiCatalog.class, (String)config.getApiCatalogType(), (Map)config.getApiCatalogProperties(), (IPluginRegistry)pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown API catalog type: " + config.getApiCatalogType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    @Named(value="storage-factory")
    public static IEsClientFactory provideStorageESClientFactory(WarApiManagerConfig config, IPluginRegistry pluginRegistry) {
        if ("es".equals(config.getStorageType()) && sStorageEsClientFactory == null) {
            try {
                String factoryClass = config.getStorageESClientFactory();
                if (factoryClass == null) {
                    factoryClass = DefaultEsClientFactory.class.getName();
                }
                sStorageEsClientFactory = (IEsClientFactory)WarCdiFactory.createCustomComponent(IEsClientFactory.class, (String)factoryClass, null, (IPluginRegistry)pluginRegistry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sStorageEsClientFactory;
    }

    private static JpaStorage initJpaStorage(ApiManagerConfig config, JpaStorage jpaStorage) {
        if (sJpaStorage == null) {
            sJpaStorage = jpaStorage;
            if (config.isInitializeStorageJPA()) {
                JpaStorageInitializer initializer = new JpaStorageInitializer(config.getHibernateDataSource(), config.getHibernateDialect());
                initializer.initialize();
            }
        }
        return sJpaStorage;
    }

    private static <T> T createCustomComponent(Class<T> componentType, String componentSpec, Map<String, String> configProperties, IPluginRegistry pluginRegistry) throws Exception {
        return (T)WarCdiFactory.createCustomComponent(componentType, (String)componentSpec, configProperties, (IPluginRegistry)pluginRegistry, null);
    }

    private static <T> T createCustomComponent(Class<T> componentType, String componentSpec, Map<String, String> configProperties, IPluginRegistry pluginRegistry, T defaultComponent) throws Exception {
        if (componentSpec == null && defaultComponent == null) {
            throw new IllegalArgumentException("Null component type.");
        }
        if (componentSpec == null && defaultComponent != null) {
            return defaultComponent;
        }
        if (componentSpec.startsWith("class:")) {
            Class c = ReflectionUtils.loadClass((String)componentSpec.substring("class:".length()));
            return (T)WarCdiFactory.createCustomComponent(componentType, (Class)c, configProperties);
        }
        if (componentSpec.startsWith("plugin:")) {
            PluginCoordinates coordinates = PluginCoordinates.fromPolicySpec((String)componentSpec);
            if (coordinates == null) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            int ssidx = componentSpec.indexOf(47);
            if (ssidx == -1) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            String classname = componentSpec.substring(ssidx + 1);
            Plugin plugin = pluginRegistry.loadPlugin(coordinates);
            PluginClassLoader classLoader = plugin.getLoader();
            Class class1 = classLoader.loadClass(classname);
            return (T)WarCdiFactory.createCustomComponent(componentType, (Class)class1, configProperties);
        }
        Class c = ReflectionUtils.loadClass((String)componentSpec);
        return (T)WarCdiFactory.createCustomComponent(componentType, (Class)c, configProperties);
    }

    private static <T> T createCustomComponent(Class<T> componentType, Class<?> componentClass, Map<String, String> configProperties) throws Exception {
        if (componentClass == null) {
            throw new IllegalArgumentException("Invalid component spec (class not found).");
        }
        try {
            Constructor<?> constructor = componentClass.getConstructor(Map.class);
            return (T)constructor.newInstance(configProperties);
        }
        catch (Exception exception) {
            return (T)componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    private static Class<? extends IApimanDelegateLogger> getDelegate(WarApiManagerConfig config) {
        if (config.getLoggerName() == null || StringUtils.isEmpty((CharSequence)config.getLoggerName())) {
            System.err.println(Messages.i18n.format("LoggerFactory.NoLoggerSpecified", new Object[0]));
            return StandardLoggerImpl.class;
        }
        switch (config.getLoggerName().toLowerCase()) {
            case "json": {
                return JsonLoggerImpl.class;
            }
            case "standard": {
                return StandardLoggerImpl.class;
            }
        }
        return WarCdiFactory.loadByFQDN((String)config.getLoggerName());
    }

    private static Class<? extends IApimanDelegateLogger> loadByFQDN(String fqdn) {
        try {
            return Class.forName(fqdn);
        }
        catch (ClassNotFoundException e) {
            System.err.println(String.format(Messages.i18n.format("LoggerFactory.LoggerNotFoundOnClasspath", new Object[0]), fqdn));
            return StandardLoggerImpl.class;
        }
    }
}

