/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IIdmStorage;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.es.EsStorage;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.jpa.roles.JpaIdmStorage;
import io.apiman.manager.test.server.ManagerApiTestServer;
import io.apiman.manager.test.server.TestEsIdmStorageWrapper;
import io.apiman.manager.test.server.TestEsStorageQueryWrapper;
import io.apiman.manager.test.server.TestEsStorageWrapper;
import io.apiman.manager.test.util.ManagerTestUtils;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import org.elasticsearch.client.Client;

@ApplicationScoped
public class TestCdiFactory {
    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(@New JpaStorage jpaStorage, @New EsStorage esStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            esStorage.initialize();
            return new TestEsStorageWrapper(ManagerApiTestServer.ES_CLIENT, (IStorage)esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(@New JpaStorage jpaStorage, @New EsStorage esStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            esStorage.initialize();
            return new TestEsStorageQueryWrapper(ManagerApiTestServer.ES_CLIENT, (IStorageQuery)esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(@New UuidApiKeyGenerator uuidApiKeyGen) {
        return uuidApiKeyGen;
    }

    @Produces
    @ApplicationScoped
    public static IIdmStorage provideIdmStorage(@New JpaIdmStorage jpaIdmStorage, @New EsStorage esStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaIdmStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            esStorage.initialize();
            return new TestEsIdmStorageWrapper(ManagerApiTestServer.ES_CLIENT, (IIdmStorage)esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    public static Client provideTransportClient() {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return null;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            return ManagerApiTestServer.ES_CLIENT;
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }
}

