/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.core.IIdmStorage;
import io.apiman.manager.api.core.exceptions.StorageException;
import java.util.Set;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.client.Client;

public class TestEsIdmStorageWrapper
implements IIdmStorage {
    private Client esClient;
    private IIdmStorage delegate;

    public TestEsIdmStorageWrapper(Client esClient, IIdmStorage delegate) {
        this.esClient = esClient;
        this.delegate = delegate;
    }

    public void createUser(UserBean user) throws StorageException {
        this.delegate.createUser(user);
    }

    public UserBean getUser(String userId) throws StorageException {
        return this.delegate.getUser(userId);
    }

    public void updateUser(UserBean user) throws StorageException {
        this.delegate.updateUser(user);
    }

    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findUsers(criteria);
    }

    public void createRole(RoleBean role) throws StorageException {
        this.delegate.createRole(role);
    }

    public RoleBean getRole(String roleId) throws StorageException {
        return this.delegate.getRole(roleId);
    }

    public void updateRole(RoleBean role) throws StorageException {
        this.delegate.updateRole(role);
    }

    public void deleteRole(RoleBean role) throws StorageException {
        this.delegate.deleteRole(role);
    }

    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findRoles(criteria);
    }

    public void createMembership(RoleMembershipBean membership) throws StorageException {
        this.delegate.createMembership(membership);
    }

    public void deleteMembership(String userId, String roleId, String organizationId) throws StorageException {
        this.delegate.deleteMembership(userId, roleId, organizationId);
    }

    public void deleteMemberships(String userId, String organizationId) throws StorageException {
        this.refresh();
        this.delegate.deleteMemberships(userId, organizationId);
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId) throws StorageException {
        this.refresh();
        return this.delegate.getUserMemberships(userId);
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId, String organizationId) throws StorageException {
        this.refresh();
        return this.delegate.getUserMemberships(userId);
    }

    public Set<RoleMembershipBean> getOrgMemberships(String organizationId) throws StorageException {
        this.refresh();
        return this.delegate.getOrgMemberships(organizationId);
    }

    public Set<PermissionBean> getPermissions(String userId) throws StorageException {
        this.refresh();
        return this.delegate.getPermissions(userId);
    }

    private void refresh() {
        try {
            this.esClient.admin().indices().refresh(new RefreshRequest(new String[]{"apiman_manager"})).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

