/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.util;

import io.apiman.manager.api.core.util.PolicyTemplateUtil;
import io.apiman.manager.test.server.ManagerApiTestServer;
import io.apiman.manager.test.server.MockGatewayServlet;
import io.apiman.test.common.util.TestPlanRunner;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractTestPlanTest {
    protected static ManagerApiTestServer testServer = new ManagerApiTestServer();
    private static final boolean USE_PROXY = false;
    private static final int PROXY_PORT = 7071;

    @BeforeClass
    public static void setup() throws Exception {
        if (!"true".equals(System.getProperty("apiman.junit.no-server", "false"))) {
            AbstractTestPlanTest.startServer();
        } else {
            System.out.println("**** APIMan Server suppressed - assuming running tests against a live server. ****");
        }
    }

    protected void runTestPlan(String planPath, ClassLoader classLoader) {
        PolicyTemplateUtil.clearCache();
        MockGatewayServlet.reset();
        String baseApiUrl = "http://localhost:" + this.getTestServerPort() + this.getBaseApiContext();
        TestPlanRunner runner = new TestPlanRunner(baseApiUrl);
        this.configureSystemProperties();
        runner.runTestPlan(planPath, classLoader);
    }

    protected String getBaseApiContext() {
        return System.getProperty("apiman.junit.server-api-context", "/apiman");
    }

    protected int getTestServerPort() {
        String spPort = System.getProperty("apiman.junit.server-port");
        if (spPort != null) {
            return Integer.parseInt(spPort);
        }
        return testServer.serverPort();
    }

    private void configureSystemProperties() {
        System.setProperty("apiman.test.gateway.endpoint", "http://localhost:" + this.getTestServerPort() + "/mock-gateway");
        System.setProperty("apiman.test.gateway.username", "admin");
        System.setProperty("apiman.test.gateway.password", "admin");
        System.setProperty("apiman.manager.require-auto-granted-org", "false");
    }

    @AfterClass
    public static void shutdown() throws Exception {
        if (!"true".equals(System.getProperty("apiman.junit.no-server", "false"))) {
            AbstractTestPlanTest.stopServer();
        }
    }

    protected static void startServer() throws Exception {
        testServer.start();
    }

    protected static void stopServer() throws Exception {
        testServer.stop();
    }
}

