/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.beans.summary.ApplicationSummaryBean;
import io.apiman.manager.api.beans.summary.ApplicationVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PluginSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.beans.summary.ServicePlanSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceVersionSummaryBean;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.client.Client;

public class TestEsStorageQueryWrapper
implements IStorageQuery {
    private Client esClient;
    private IStorageQuery delegate;

    public TestEsStorageQueryWrapper(Client esClient, IStorageQuery delegate) {
        this.esClient = esClient;
        this.delegate = delegate;
    }

    public List<PluginSummaryBean> listPlugins() throws StorageException {
        this.refresh();
        return this.delegate.listPlugins();
    }

    public List<GatewaySummaryBean> listGateways() throws StorageException {
        this.refresh();
        return this.delegate.listGateways();
    }

    public SearchResultsBean<OrganizationSummaryBean> findOrganizations(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findOrganizations(criteria);
    }

    public SearchResultsBean<ApplicationSummaryBean> findApplications(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findApplications(criteria);
    }

    public SearchResultsBean<ServiceSummaryBean> findServices(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findServices(criteria);
    }

    public SearchResultsBean<PlanSummaryBean> findPlans(String organizationId, SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findPlans(organizationId, criteria);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditEntity(String organizationId, String entityId, String entityVersion, Class<T> type, PagingBean paging) throws StorageException {
        this.refresh();
        return this.delegate.auditEntity(organizationId, entityId, entityVersion, type, paging);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditUser(String userId, PagingBean paging) throws StorageException {
        this.refresh();
        return this.delegate.auditUser(userId, paging);
    }

    public List<OrganizationSummaryBean> getOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getOrgs(orgIds);
    }

    public List<ApplicationSummaryBean> getApplicationsInOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getApplicationsInOrgs(orgIds);
    }

    public List<ApplicationSummaryBean> getApplicationsInOrg(String orgId) throws StorageException {
        this.refresh();
        return this.delegate.getApplicationsInOrg(orgId);
    }

    public List<ApplicationVersionSummaryBean> getApplicationVersions(String organizationId, String applicationId) throws StorageException {
        this.refresh();
        return this.delegate.getApplicationVersions(organizationId, applicationId);
    }

    public List<ContractSummaryBean> getApplicationContracts(String organizationId, String applicationId, String version) throws StorageException {
        this.refresh();
        return this.delegate.getApplicationContracts(organizationId, applicationId, version);
    }

    public ApiRegistryBean getApiRegistry(String organizationId, String applicationId, String version) throws StorageException {
        this.refresh();
        return this.delegate.getApiRegistry(organizationId, applicationId, version);
    }

    public List<ServiceSummaryBean> getServicesInOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getServicesInOrgs(orgIds);
    }

    public List<ServiceSummaryBean> getServicesInOrg(String orgId) throws StorageException {
        this.refresh();
        return this.delegate.getServicesInOrg(orgId);
    }

    public List<ServiceVersionSummaryBean> getServiceVersions(String orgId, String serviceId) throws StorageException {
        this.refresh();
        return this.delegate.getServiceVersions(orgId, serviceId);
    }

    public List<ServicePlanSummaryBean> getServiceVersionPlans(String organizationId, String serviceId, String version) throws StorageException {
        this.refresh();
        return this.delegate.getServiceVersionPlans(organizationId, serviceId, version);
    }

    public List<PlanSummaryBean> getPlansInOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getPlansInOrgs(orgIds);
    }

    public List<PlanSummaryBean> getPlansInOrg(String orgId) throws StorageException {
        this.refresh();
        return this.delegate.getPlansInOrg(orgId);
    }

    public List<PlanVersionSummaryBean> getPlanVersions(String organizationId, String planId) throws StorageException {
        this.refresh();
        return this.delegate.getPlanVersions(organizationId, planId);
    }

    public List<PolicySummaryBean> getPolicies(String organizationId, String entityId, String version, PolicyType type) throws StorageException {
        this.refresh();
        return this.delegate.getPolicies(organizationId, entityId, version, type);
    }

    public List<PolicyDefinitionSummaryBean> listPolicyDefinitions() throws StorageException {
        this.refresh();
        return this.delegate.listPolicyDefinitions();
    }

    public List<ContractSummaryBean> getServiceContracts(String organizationId, String serviceId, String version, int page, int pageSize) throws StorageException {
        this.refresh();
        return this.delegate.getServiceContracts(organizationId, serviceId, version, page, pageSize);
    }

    public int getMaxPolicyOrderIndex(String organizationId, String entityId, String entityVersion, PolicyType type) throws StorageException {
        this.refresh();
        return this.delegate.getMaxPolicyOrderIndex(organizationId, entityId, entityVersion, type);
    }

    public List<PolicyDefinitionSummaryBean> listPluginPolicyDefs(Long pluginId) throws StorageException {
        this.refresh();
        return this.delegate.listPluginPolicyDefs(pluginId);
    }

    private void refresh() {
        try {
            this.esClient.admin().indices().refresh(new RefreshRequest(new String[]{"apiman_manager"})).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

