/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plugins.PluginBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.exceptions.StorageException;
import java.io.InputStream;
import java.util.List;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.client.Client;

public class TestEsStorageWrapper
implements IStorage {
    private Client esClient;
    private IStorage delegate;

    public TestEsStorageWrapper(Client esClient, IStorage delegate) {
        this.esClient = esClient;
        this.delegate = delegate;
    }

    public void beginTx() throws StorageException {
        this.delegate.beginTx();
    }

    public void commitTx() throws StorageException {
        this.delegate.commitTx();
    }

    public void rollbackTx() {
        this.delegate.rollbackTx();
    }

    public void createOrganization(OrganizationBean organization) throws StorageException {
        this.delegate.createOrganization(organization);
    }

    public void createApplication(ApplicationBean application) throws StorageException {
        this.delegate.createApplication(application);
    }

    public void createApplicationVersion(ApplicationVersionBean version) throws StorageException {
        this.delegate.createApplicationVersion(version);
    }

    public void createContract(ContractBean contract) throws StorageException {
        this.delegate.createContract(contract);
    }

    public void createService(ServiceBean service) throws StorageException {
        this.delegate.createService(service);
    }

    public void createServiceVersion(ServiceVersionBean version) throws StorageException {
        this.delegate.createServiceVersion(version);
    }

    public void createPlan(PlanBean plan) throws StorageException {
        this.delegate.createPlan(plan);
    }

    public void createPlanVersion(PlanVersionBean version) throws StorageException {
        this.delegate.createPlanVersion(version);
    }

    public void createPolicy(PolicyBean policy) throws StorageException {
        this.delegate.createPolicy(policy);
    }

    public void createGateway(GatewayBean gateway) throws StorageException {
        this.delegate.createGateway(gateway);
    }

    public void createPlugin(PluginBean plugin) throws StorageException {
        this.delegate.createPlugin(plugin);
    }

    public void createPolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        this.delegate.createPolicyDefinition(policyDef);
    }

    public void createAuditEntry(AuditEntryBean entry) throws StorageException {
        this.delegate.createAuditEntry(entry);
    }

    public void updateOrganization(OrganizationBean organization) throws StorageException {
        this.delegate.updateOrganization(organization);
    }

    public void updateApplication(ApplicationBean application) throws StorageException {
        this.delegate.updateApplication(application);
    }

    public void updateApplicationVersion(ApplicationVersionBean version) throws StorageException {
        this.delegate.updateApplicationVersion(version);
    }

    public void updateService(ServiceBean service) throws StorageException {
        this.delegate.updateService(service);
    }

    public void updateServiceVersion(ServiceVersionBean version) throws StorageException {
        this.delegate.updateServiceVersion(version);
    }

    public void updatePlan(PlanBean plan) throws StorageException {
        this.delegate.updatePlan(plan);
    }

    public void updatePlanVersion(PlanVersionBean version) throws StorageException {
        this.delegate.updatePlanVersion(version);
    }

    public void updatePolicy(PolicyBean policy) throws StorageException {
        this.delegate.updatePolicy(policy);
    }

    public void updateGateway(GatewayBean gateway) throws StorageException {
        this.delegate.updateGateway(gateway);
    }

    public void updatePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        this.delegate.updatePolicyDefinition(policyDef);
    }

    public void deleteOrganization(OrganizationBean organization) throws StorageException {
        this.delegate.deleteOrganization(organization);
    }

    public void deleteApplication(ApplicationBean application) throws StorageException {
        this.delegate.deleteApplication(application);
    }

    public void deleteApplicationVersion(ApplicationVersionBean version) throws StorageException {
        this.delegate.deleteApplicationVersion(version);
    }

    public void deleteContract(ContractBean contract) throws StorageException {
        this.delegate.deleteContract(contract);
    }

    public void deleteService(ServiceBean service) throws StorageException {
        this.delegate.deleteService(service);
    }

    public void deleteServiceVersion(ServiceVersionBean version) throws StorageException {
        this.delegate.deleteServiceVersion(version);
    }

    public void deletePlan(PlanBean plan) throws StorageException {
        this.delegate.deletePlan(plan);
    }

    public void deletePlanVersion(PlanVersionBean version) throws StorageException {
        this.delegate.deletePlanVersion(version);
    }

    public void deletePolicy(PolicyBean policy) throws StorageException {
        this.delegate.deletePolicy(policy);
    }

    public void deleteGateway(GatewayBean gateway) throws StorageException {
        this.delegate.deleteGateway(gateway);
    }

    public void deletePlugin(PluginBean plugin) throws StorageException {
        this.delegate.deletePlugin(plugin);
    }

    public void deletePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        this.delegate.deletePolicyDefinition(policyDef);
    }

    public OrganizationBean getOrganization(String id) throws StorageException {
        return this.delegate.getOrganization(id);
    }

    public ApplicationBean getApplication(String organizationId, String id) throws StorageException {
        return this.delegate.getApplication(organizationId, id);
    }

    public ApplicationVersionBean getApplicationVersion(String organizationId, String applicationId, String version) throws StorageException {
        return this.delegate.getApplicationVersion(organizationId, applicationId, version);
    }

    public ContractBean getContract(Long id) throws StorageException {
        return this.delegate.getContract(id);
    }

    public ServiceBean getService(String organizationId, String id) throws StorageException {
        return this.delegate.getService(organizationId, id);
    }

    public ServiceVersionBean getServiceVersion(String organizationId, String serviceId, String version) throws StorageException {
        return this.delegate.getServiceVersion(organizationId, serviceId, version);
    }

    public PlanBean getPlan(String organizationId, String id) throws StorageException {
        return this.delegate.getPlan(organizationId, id);
    }

    public PlanVersionBean getPlanVersion(String organizationId, String planId, String version) throws StorageException {
        return this.delegate.getPlanVersion(organizationId, planId, version);
    }

    public PolicyBean getPolicy(PolicyType type, String organizationId, String entityId, String version, Long id) throws StorageException {
        return this.delegate.getPolicy(type, organizationId, entityId, version, id);
    }

    public GatewayBean getGateway(String id) throws StorageException {
        return this.delegate.getGateway(id);
    }

    public PluginBean getPlugin(long id) throws StorageException {
        return this.delegate.getPlugin(id);
    }

    public PluginBean getPlugin(String groupId, String artifactId) throws StorageException {
        this.refresh();
        return this.delegate.getPlugin(groupId, artifactId);
    }

    public void reorderPolicies(PolicyType type, String organizationId, String entityId, String entityVersion, List<Long> newOrder) throws StorageException {
        this.delegate.reorderPolicies(type, organizationId, entityId, entityVersion, newOrder);
    }

    public PolicyDefinitionBean getPolicyDefinition(String id) throws StorageException {
        return this.delegate.getPolicyDefinition(id);
    }

    public void deleteServiceDefinition(ServiceVersionBean version) throws StorageException {
        this.delegate.deleteServiceDefinition(version);
    }

    public InputStream getServiceDefinition(ServiceVersionBean serviceVersion) throws StorageException {
        return this.delegate.getServiceDefinition(serviceVersion);
    }

    public void updateServiceDefinition(ServiceVersionBean version, InputStream definitionStream) throws StorageException {
        this.delegate.updateServiceDefinition(version, definitionStream);
    }

    private void refresh() {
        try {
            this.esClient.admin().indices().refresh(new RefreshRequest(new String[]{"apiman_manager"})).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

