/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.common.servlet.ApimanCorsFilter;
import io.apiman.common.servlet.AuthenticationFilter;
import io.apiman.common.servlet.DisableCachingFilter;
import io.apiman.manager.api.security.impl.DefaultSecurityContextFilter;
import io.apiman.manager.api.war.TransactionWatchdogFilter;
import io.apiman.manager.test.server.DatabaseSeedFilter;
import io.apiman.manager.test.server.MockGatewayServlet;
import io.apiman.manager.test.server.TestManagerApiApplication;
import io.apiman.manager.test.server.TestUsers;
import io.apiman.manager.test.util.ManagerTestUtils;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.indices.DeleteIndex;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.EventListener;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Credential;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.weld.environment.servlet.BeanManagerResourceBindingListener;
import org.jboss.weld.environment.servlet.Listener;

public class ManagerApiTestServer {
    private static final String ES_CLUSTER_NAME = "_apimantest";
    public static JestClient ES_CLIENT = null;
    private Server server;
    private BasicDataSource ds = null;
    private Node node = null;
    private JestClient client = null;

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Server (" + this.getClass().getSimpleName() + ")");
        this.preStart();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        int serverPort = this.serverPort();
        this.server = new Server(serverPort);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    public void stop() throws Exception {
        this.server.stop();
        if (this.ds != null) {
            this.ds.close();
            InitialContext ctx = new InitialContext();
            ctx.unbind("java:comp/env/jdbc/ApiManagerDS");
        }
        if (this.node != null && "true".equals(System.getProperty("apiman.test.es-delete-index", "true"))) {
            this.client.execute((Action)new DeleteIndex.Builder("apiman_manager").build());
        }
    }

    public int serverPort() {
        return 7070;
    }

    protected void preStart() throws Exception {
        if (ManagerTestUtils.getTestType() == ManagerTestUtils.TestType.jpa) {
            System.setProperty("apiman.hibernate.hbm2ddl.auto", "create-drop");
            try {
                InitialContext ctx = new InitialContext();
                this.ensureCtx(ctx, "java:/comp/env");
                this.ensureCtx(ctx, "java:/comp/env/jdbc");
                String dbOutputPath = System.getProperty("apiman.test.h2-output-dir", null);
                this.ds = dbOutputPath != null ? ManagerApiTestServer.createFileDatasource(new File(dbOutputPath)) : ManagerApiTestServer.createInMemoryDatasource();
                ctx.bind("java:/comp/env/jdbc/ApiManagerDS", (Object)this.ds);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (ManagerTestUtils.getTestType() == ManagerTestUtils.TestType.es && this.node == null) {
            System.out.println("Creating the ES node.");
            File esHome = new File("target/es");
            String esHomeSP = System.getProperty("apiman.test.es-home", null);
            if (esHomeSP != null) {
                esHome = new File(esHomeSP);
            }
            if (esHome.isDirectory()) {
                FileUtils.deleteDirectory((File)esHome);
            }
            ImmutableSettings.Builder settings = NodeBuilder.nodeBuilder().settings();
            settings.put("path.home", esHome.getAbsolutePath());
            settings.put("http.port", "6500-6600");
            settings.put("transport.tcp.port", "6600-6700");
            String clusterName = System.getProperty("apiman.test.es-cluster-name", ES_CLUSTER_NAME);
            boolean isPersistent = "true".equals(System.getProperty("apiman.test.es-persistence", "false"));
            if (!isPersistent) {
                settings.put("index.store.type", "memory").put("gateway.type", "none").put("index.number_of_shards", 1).put("index.number_of_replicas", 1);
                this.node = NodeBuilder.nodeBuilder().client(false).clusterName(clusterName).data(true).local(true).settings((Settings.Builder)settings).build();
            } else {
                this.node = NodeBuilder.nodeBuilder().client(false).clusterName(clusterName).data(true).local(false).settings((Settings.Builder)settings).build();
            }
            System.out.println("Starting the ES node.");
            this.node.start();
            System.out.println("ES node was successfully started.");
            String connectionUrl = "http://localhost:6500";
            JestClientFactory factory = new JestClientFactory();
            factory.setHttpClientConfig(((HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true)).build());
            ES_CLIENT = this.client = factory.getObject();
        }
    }

    private void ensureCtx(InitialContext ctx, String name) throws NamingException {
        try {
            ctx.bind(name, (Object)new InitialContext());
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            // empty catch block
        }
    }

    private static BasicDataSource createInMemoryDatasource() throws SQLException {
        System.setProperty("apiman.hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(Driver.class.getName());
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        Connection connection = ds.getConnection();
        connection.close();
        System.out.println("DataSource created and bound to JNDI.");
        return ds;
    }

    private static BasicDataSource createFileDatasource(File outputDirectory) throws SQLException {
        System.setProperty("apiman.hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(Driver.class.getName());
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setUrl("jdbc:h2:" + outputDirectory.toString() + "/apiman-manager-api;MVCC=true");
        Connection connection = ds.getConnection();
        connection.close();
        System.out.println("DataSource created and bound to JNDI.");
        return ds;
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler apiManServer = new ServletContextHandler(1);
        apiManServer.setSecurityHandler(this.createSecurityHandler());
        apiManServer.setContextPath("/apiman");
        apiManServer.addEventListener((EventListener)new Listener());
        apiManServer.addEventListener((EventListener)new BeanManagerResourceBindingListener());
        apiManServer.addEventListener((EventListener)new ResteasyBootstrap());
        apiManServer.addFilter(DatabaseSeedFilter.class, "/db-seeder", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(ApimanCorsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(DisableCachingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(DefaultSecurityContextFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(TransactionWatchdogFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder resteasyServlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        resteasyServlet.setInitParameter("javax.ws.rs.Application", TestManagerApiApplication.class.getName());
        apiManServer.addServlet(resteasyServlet, "/*");
        apiManServer.setInitParameter("resteasy.injector.factory", "org.jboss.resteasy.cdi.CdiInjectorFactory");
        apiManServer.setInitParameter("resteasy.scan", "true");
        apiManServer.setInitParameter("resteasy.servlet.mapping.prefix", "");
        handlers.addHandler((Handler)apiManServer);
        ServletContextHandler mockGatewayServer = new ServletContextHandler(1);
        mockGatewayServer.setSecurityHandler(this.createSecurityHandler());
        mockGatewayServer.setContextPath("/mock-gateway");
        ServletHolder mockGatewayServlet = new ServletHolder((Servlet)new MockGatewayServlet());
        mockGatewayServer.addServlet(mockGatewayServlet, "/*");
        handlers.addHandler((Handler)mockGatewayServer);
    }

    private SecurityHandler createSecurityHandler() {
        HashLoginService l = new HashLoginService();
        for (String[] userInfo : TestUsers.USERS) {
            String user = userInfo[0];
            String pwd = userInfo[1];
            String[] roles = new String[]{"apiuser"};
            if (user.startsWith("admin")) {
                roles = new String[]{"apiuser", "apiadmin"};
            }
            l.putUser(user, Credential.getCredential((String)pwd), roles);
        }
        l.setName("apimanrealm");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("apimanrealm");
        csh.setLoginService((LoginService)l);
        return csh;
    }

    public Node getESNode() {
        return this.node;
    }

    public JestClient getESClient() {
        return this.client;
    }
}

