/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.common.config.SystemPropertiesConfiguration;
import io.apiman.manager.api.beans.services.EndpointType;
import io.apiman.manager.api.beans.summary.AvailableServiceBean;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IIdmStorage;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.IServiceCatalog;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.core.logging.IApimanLogger;
import io.apiman.manager.api.core.logging.StandardLoggerImpl;
import io.apiman.manager.api.es.ESMetricsAccessor;
import io.apiman.manager.api.es.EsStorage;
import io.apiman.manager.api.jpa.IJpaProperties;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.jpa.roles.JpaIdmStorage;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.security.impl.DefaultSecurityContext;
import io.apiman.manager.test.server.ManagerApiTestServer;
import io.apiman.manager.test.server.TestEsIdmStorageWrapper;
import io.apiman.manager.test.server.TestEsStorageQueryWrapper;
import io.apiman.manager.test.server.TestEsStorageWrapper;
import io.apiman.manager.test.server.TestMetricsAccessor;
import io.apiman.manager.test.util.ManagerTestUtils;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;

@ApplicationScoped
@Named(value="ApimanLogFactory")
public class TestCdiFactory {
    @Produces
    @ApplicationScoped
    public static ISecurityContext provideSecurityContext(@New DefaultSecurityContext defaultSC) {
        return defaultSC;
    }

    @Produces
    @ApimanLogger
    public static IApimanLogger provideLogger(InjectionPoint injectionPoint) {
        ApimanLogger logger = (ApimanLogger)injectionPoint.getAnnotated().getAnnotation(ApimanLogger.class);
        Class klazz = logger.value();
        return new StandardLoggerImpl().createLogger(klazz);
    }

    @Produces
    @ApplicationScoped
    public static IJpaProperties provideJpaProperties() {
        return new IJpaProperties(){

            public Map<String, String> getAllHibernateProperties() {
                SystemPropertiesConfiguration config = new SystemPropertiesConfiguration();
                HashMap<String, String> rval = new HashMap<String, String>();
                Iterator keys = config.getKeys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (!key.startsWith("apiman.hibernate.")) continue;
                    String value = config.getString(key);
                    key = key.substring("apiman.".length());
                    rval.put(key, value);
                }
                return rval;
            }
        };
    }

    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(@New JpaStorage jpaStorage, @New EsStorage esStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            esStorage.initialize();
            return new TestEsStorageWrapper(ManagerApiTestServer.ES_CLIENT, (IStorage)esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(@New JpaStorage jpaStorage, @New EsStorage esStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            esStorage.initialize();
            return new TestEsStorageQueryWrapper(ManagerApiTestServer.ES_CLIENT, (IStorageQuery)esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(@New UuidApiKeyGenerator uuidApiKeyGen) {
        return uuidApiKeyGen;
    }

    @Produces
    @ApplicationScoped
    public static IServiceCatalog provideServiceCatalog(IPluginRegistry pluginRegistry) {
        return new IServiceCatalog(){

            public List<AvailableServiceBean> search(String keyword) {
                ArrayList<AvailableServiceBean> rval = new ArrayList<AvailableServiceBean>();
                AvailableServiceBean asb = new AvailableServiceBean();
                asb.setName("Test Service 1");
                asb.setDescription("The first test service.");
                asb.setEndpoint("http://service1.example.org/api");
                asb.setEndpointType(EndpointType.rest);
                rval.add(asb);
                asb = new AvailableServiceBean();
                asb.setName("Test Service 2");
                asb.setDescription("The second test service.");
                asb.setEndpoint("http://service2.example.org/api");
                asb.setEndpointType(EndpointType.rest);
                rval.add(asb);
                return rval;
            }
        };
    }

    @Produces
    @ApplicationScoped
    public static IIdmStorage provideIdmStorage(@New JpaIdmStorage jpaIdmStorage, @New EsStorage esStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaIdmStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            esStorage.initialize();
            return new TestEsIdmStorageWrapper(ManagerApiTestServer.ES_CLIENT, (IIdmStorage)esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    @Named(value="storage")
    public static JestClient provideStorageJestClient() {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return null;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            return ManagerApiTestServer.ES_CLIENT;
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    @Named(value="metrics")
    public static JestClient provideMetricsJestClient() {
        boolean enableESMetrics = "true".equals(System.getProperty("apiman-test.es-metrics", "false"));
        if (enableESMetrics) {
            String host = System.getProperty("apiman-test.es-metrics.host", "localhost");
            String port = System.getProperty("apiman-test.es-metrics.port", "9200");
            String connectionUrl = "http://" + host + ":" + port + "";
            JestClientFactory factory = new JestClientFactory();
            factory.setHttpClientConfig(((HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true)).build());
            return factory.getObject();
        }
        return null;
    }

    @Produces
    @ApplicationScoped
    public static IMetricsAccessor provideMetricsAccessor(@New TestMetricsAccessor testMetrics, @New ESMetricsAccessor esMetrics) {
        boolean enableESMetrics = "true".equals(System.getProperty("apiman-test.es-metrics", "false"));
        if (enableESMetrics) {
            return esMetrics;
        }
        return testMetrics;
    }
}

