/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.plugin.PluginUtils;
import io.apiman.manager.api.core.plugin.AbstractPluginRegistry;
import java.io.File;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.io.FileUtils;

@ApplicationScoped
public class ApiManagerTestPluginRegistry
extends AbstractPluginRegistry {
    private static File getTestPluginDir() {
        File targetDir = new File("target").getAbsoluteFile();
        if (!targetDir.isDirectory()) {
            throw new RuntimeException("Maven 'target' directory does not exist!");
        }
        File pluginDir = new File(targetDir, "plugintmp");
        try {
            FileUtils.deleteDirectory((File)pluginDir);
            pluginDir.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pluginDir;
    }

    public ApiManagerTestPluginRegistry() {
        super(ApiManagerTestPluginRegistry.getTestPluginDir());
    }

    protected void downloadPlugin(File pluginFile, PluginCoordinates coordinates) {
        String testM2Path = System.getProperty("apiman.test.m2-path");
        if (testM2Path == null) {
            return;
        }
        File testM2Dir = new File(testM2Path).getAbsoluteFile();
        File pluginArtifactFile = new File(testM2Dir, PluginUtils.getMavenPath((PluginCoordinates)coordinates));
        if (!pluginArtifactFile.isFile()) {
            return;
        }
        try {
            FileUtils.copyFile((File)pluginArtifactFile, (File)pluginFile);
        }
        catch (IOException e) {
            pluginArtifactFile.delete();
        }
    }
}

