/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server;

import io.apiman.manager.ui.server.IUIConfig;
import io.apiman.manager.ui.server.beans.ApiAuthType;
import io.apiman.manager.ui.server.servlets.SystemPropertiesConfiguration;
import java.io.File;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class UIConfig
implements IUIConfig {
    public static final String APIMAN_MANAGER_UI_API_ENDPOINT = "apiman-manager-ui.api.endpoint";
    public static final String APIMAN_MANAGER_UI_API_AUTH_TYPE = "apiman-manager-ui.api.authentication.type";
    public static final String APIMAN_MANAGER_UI_API_BASIC_AUTH_USER = "apiman-manager-ui.api.authentication.basic.user";
    public static final String APIMAN_MANAGER_UI_API_BASIC_AUTH_PASS = "apiman-manager-ui.api.authentication.basic.password";
    public static final String APIMAN_MANAGER_UI_API_AUTH_TOKEN_GENERATOR = "apiman-manager-ui.api.authentication.token.generator";
    public static final String APIMAN_MANAGER_UI_LOGOUT_URL = "apiman-manager-ui.logout-url";
    private static Configuration config;

    public String getManagementApiEndpoint() {
        return config.getString(APIMAN_MANAGER_UI_API_ENDPOINT);
    }

    public ApiAuthType getManagementApiAuthType() {
        String at = config.getString(APIMAN_MANAGER_UI_API_AUTH_TYPE);
        try {
            return ApiAuthType.valueOf((String)at);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid API authentication type: " + at);
        }
    }

    public String getLogoutUrl() {
        return config.getString(APIMAN_MANAGER_UI_LOGOUT_URL, "/apimanui/logout");
    }

    public String getManagementApiAuthUsername() {
        return config.getString(APIMAN_MANAGER_UI_API_BASIC_AUTH_USER);
    }

    public String getManagementApiAuthPassword() {
        return config.getString(APIMAN_MANAGER_UI_API_BASIC_AUTH_PASS);
    }

    public String getManagementApiAuthTokenGenerator() {
        return config.getString(APIMAN_MANAGER_UI_API_AUTH_TOKEN_GENERATOR);
    }

    public Configuration getConfig() {
        return config;
    }

    static {
        File dirFile;
        File confFile;
        String jbossConfigUrl;
        File dirFile2;
        File confFile2;
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration((Configuration)new SystemPropertiesConfiguration());
        File configFile = null;
        String jbossConfigDir = System.getProperty("jboss.server.config.dir");
        if (jbossConfigDir != null && (confFile2 = new File(dirFile2 = new File(jbossConfigDir), "apiman.properties")).isFile()) {
            configFile = confFile2;
        }
        if ((jbossConfigUrl = System.getProperty("jboss.server.config.url")) != null && (confFile = new File(dirFile = new File(jbossConfigUrl), "apiman.properties")).isFile()) {
            configFile = confFile;
        }
        if (configFile != null && configFile.isFile()) {
            try {
                compositeConfig.addConfiguration((Configuration)new PropertiesConfiguration(configFile));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        config = compositeConfig;
    }
}

