/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server.servlets;

import io.apiman.manager.ui.server.auth.ITokenGenerator;
import io.apiman.manager.ui.server.beans.ApiAuthType;
import io.apiman.manager.ui.server.beans.BearerTokenCredentialsBean;
import io.apiman.manager.ui.server.servlets.AbstractUIServlet;
import io.apiman.manager.ui.server.servlets.ApiManagerProxyServlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class ApiManagerProxyServlet
extends AbstractUIServlet {
    private static final long serialVersionUID = -4532742030638806510L;
    private static Set<String> EXCLUDE_HEADERS = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            String pathInfo;
            StringBuilder url = new StringBuilder();
            String endpoint = this.getConfig().getManagementApiEndpoint();
            if (endpoint == null) {
                endpoint = this.getDefaultEndpoint(req);
            }
            url.append(endpoint);
            if (!url.toString().endsWith("/")) {
                url.append('/');
            }
            if ((pathInfo = req.getPathInfo()) != null && pathInfo.startsWith("/")) {
                url.append(pathInfo.substring(1));
            } else {
                url.append(pathInfo);
            }
            String authHeaderValue = null;
            ApiAuthType authType = this.getConfig().getManagementApiAuthType();
            switch (1.$SwitchMap$io$apiman$manager$ui$server$beans$ApiAuthType[authType.ordinal()]) {
                case 1: {
                    String username = this.getConfig().getManagementApiAuthUsername();
                    String password = this.getConfig().getManagementApiAuthPassword();
                    String encoded = this.base64Encode(username + ":" + password);
                    authHeaderValue = "Basic " + encoded;
                    break;
                }
                case 2: {
                    ITokenGenerator tokenGenerator = this.getTokenGenerator();
                    BearerTokenCredentialsBean creds = tokenGenerator.generateToken(req);
                    String token = creds.getToken();
                    authHeaderValue = "AUTH-TOKEN " + token;
                    break;
                }
                case 3: {
                    ITokenGenerator tokenGenerator = this.getTokenGenerator();
                    BearerTokenCredentialsBean creds = tokenGenerator.generateToken(req);
                    String token = creds.getToken();
                    authHeaderValue = "Bearer " + token;
                    break;
                }
                case 4: {
                    ITokenGenerator tokenGenerator = this.getTokenGenerator();
                    BearerTokenCredentialsBean creds = tokenGenerator.generateToken(req);
                    String token = creds.getToken();
                    authHeaderValue = "Basic SAML-BEARER-TOKEN:" + token;
                    break;
                }
            }
            URL remoteUrl = new URL(url.toString());
            HttpURLConnection remoteConn = (HttpURLConnection)remoteUrl.openConnection();
            InputStream remoteIS = null;
            ServletOutputStream responseOS = null;
            try {
                if (authHeaderValue != null) {
                    remoteConn.setRequestProperty("Authorization", authHeaderValue);
                }
                remoteConn.connect();
                Map<String, List<String>> headerFields = remoteConn.getHeaderFields();
                for (String headerName : headerFields.keySet()) {
                    if (headerName == null || EXCLUDE_HEADERS.contains(headerName)) continue;
                    String headerValue = remoteConn.getHeaderField(headerName);
                    resp.setHeader(headerName, headerValue);
                    if (!url.toString().contains("apiregistry")) continue;
                    String type = "json";
                    if (url.toString().endsWith("xml")) {
                        type = "xml";
                    }
                    resp.setHeader("Content-Disposition", "attachment; filename=api-registry." + type);
                }
                resp.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
                remoteIS = remoteConn.getInputStream();
                responseOS = resp.getOutputStream();
                IOUtils.copy((InputStream)remoteIS, (OutputStream)responseOS);
                resp.flushBuffer();
                IOUtils.closeQuietly((OutputStream)responseOS);
            }
            catch (Exception e) {
                resp.sendError(500, e.getMessage());
                break block18;
            }
            finally {
                IOUtils.closeQuietly(responseOS);
                IOUtils.closeQuietly(remoteIS);
            }
            IOUtils.closeQuietly((InputStream)remoteIS);
        }
    }

    private String base64Encode(String value) throws UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])value.getBytes("UTF-8"));
    }

    static {
        EXCLUDE_HEADERS.add("ETag");
        EXCLUDE_HEADERS.add("Last-Modified");
        EXCLUDE_HEADERS.add("Date");
        EXCLUDE_HEADERS.add("Cache-control");
    }
}

