/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server.servlets;

import io.apiman.manager.ui.server.auth.ITokenGenerator;
import io.apiman.manager.ui.server.beans.BearerTokenCredentialsBean;
import io.apiman.manager.ui.server.servlets.AbstractUIServlet;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRefreshServlet
extends AbstractUIServlet {
    private static final long serialVersionUID = 7721708152826837757L;
    private static Logger logger = LoggerFactory.getLogger(TokenRefreshServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug("Refreshing authentication token.");
        ITokenGenerator tokenGenerator = this.getTokenGenerator();
        BearerTokenCredentialsBean tokenBean = tokenGenerator.generateToken(req);
        ObjectMapper mapper = new ObjectMapper();
        resp.setContentType("application/json");
        resp.setDateHeader("Date", System.currentTimeMillis());
        resp.setDateHeader("Expires", System.currentTimeMillis() - 86400000L);
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
        mapper.writer().writeValue((OutputStream)resp.getOutputStream(), (Object)tokenBean);
    }
}

