/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server.servlets;

import io.apiman.common.util.ServiceRegistryUtil;
import io.apiman.manager.ui.server.IUIConfig;
import io.apiman.manager.ui.server.auth.ITokenGenerator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractUIServlet
extends HttpServlet {
    private static final long serialVersionUID = -7455553362628233074L;
    private IUIConfig config;
    private transient ITokenGenerator tokenGenerator;

    protected IUIConfig getConfig() {
        if (this.config == null) {
            this.config = (IUIConfig)ServiceRegistryUtil.getSingleService(IUIConfig.class);
        }
        return this.config;
    }

    protected ITokenGenerator getTokenGenerator() throws ServletException {
        if (this.tokenGenerator == null) {
            String tokenGeneratorClassName = this.getConfig().getManagementApiAuthTokenGenerator();
            if (tokenGeneratorClassName == null) {
                throw new ServletException("No token generator class specified.");
            }
            try {
                Class<?> c = Class.forName(tokenGeneratorClassName);
                this.tokenGenerator = (ITokenGenerator)c.newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Error creating token generator.");
            }
        }
        return this.tokenGenerator;
    }

    protected String getDefaultEndpoint(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append("/apiman");
        return builder.toString();
    }
}

