/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server.kc;

import io.apiman.manager.ui.server.auth.ITokenGenerator;
import io.apiman.manager.ui.server.beans.BearerTokenCredentialsBean;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.common.util.Time;

public class KeyCloakBearerTokenGenerator
implements ITokenGenerator {
    public BearerTokenCredentialsBean generateToken(HttpServletRequest request) {
        BearerTokenCredentialsBean bean = new BearerTokenCredentialsBean();
        KeycloakSecurityContext session = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (session != null) {
            bean.setToken(session.getTokenString());
            int nowInSeconds = this.getCurrentTime();
            long expiresInSeconds = session.getToken().getExp();
            if (expiresInSeconds <= (long)nowInSeconds) {
                bean.setRefreshPeriod(1L);
            } else {
                bean.setRefreshPeriod(expiresInSeconds - (long)nowInSeconds);
            }
        } else {
            bean.setToken("LOGGED_OUT");
            bean.setRefreshPeriod(30L);
        }
        return bean;
    }

    protected int getCurrentTime() {
        try {
            return Time.currentTime();
        }
        catch (Throwable e) {
            try {
                Class<?> tc = Class.forName("org.keycloak.util.Time");
                Method method = tc.getMethod("currentTime", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                return (Integer)object;
            }
            catch (Throwable e1) {
                return (int)(System.currentTimeMillis() / 1000L);
            }
        }
    }
}

