/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server;

import io.apiman.manager.ui.client.shared.beans.ApiAuthType;
import io.apiman.manager.ui.server.IUIConfig;
import org.apache.commons.configuration.Configuration;
import org.overlord.commons.config.ConfigurationFactory;

public class UIConfig
implements IUIConfig {
    public static final String APIMAN_MANAGER_UI_CONFIG_FILE_NAME = "apiman-manager-ui.config.file.name";
    public static final String APIMAN_MANAGER_UI_CONFIG_FILE_REFRESH = "apiman-manager-ui.config.file.refresh";
    public static final String APIMAN_MANAGER_UI_API_ENDPOINT = "apiman-manager-ui.api.endpoint";
    public static final String APIMAN_MANAGER_UI_API_AUTH_TYPE = "apiman-manager-ui.api.authentication.type";
    public static final String APIMAN_MANAGER_UI_API_BASIC_AUTH_USER = "apiman-manager-ui.api.authentication.basic.user";
    public static final String APIMAN_MANAGER_UI_API_BASIC_AUTH_PASS = "apiman-manager-ui.api.authentication.basic.password";
    public static final String APIMAN_MANAGER_UI_API_AUTH_TOKEN_GENERATOR = "apiman-manager-ui.api.authentication.token.generator";
    public static final String APIMAN_MANAGER_UI_LOGOUT_URL = "apiman-manager-ui.logout-url";
    private static Configuration config;

    public String getManagementApiEndpoint() {
        return config.getString(APIMAN_MANAGER_UI_API_ENDPOINT);
    }

    public ApiAuthType getManagementApiAuthType() {
        String at = config.getString(APIMAN_MANAGER_UI_API_AUTH_TYPE);
        try {
            return ApiAuthType.valueOf((String)at);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid API authentication type: " + at);
        }
    }

    public String getLogoutUrl() {
        return config.getString(APIMAN_MANAGER_UI_LOGOUT_URL, "logout");
    }

    public String getManagementApiAuthUsername() {
        return config.getString(APIMAN_MANAGER_UI_API_BASIC_AUTH_USER);
    }

    public String getManagementApiAuthPassword() {
        return config.getString(APIMAN_MANAGER_UI_API_BASIC_AUTH_PASS);
    }

    public String getManagementApiAuthTokenGenerator() {
        return config.getString(APIMAN_MANAGER_UI_API_AUTH_TOKEN_GENERATOR);
    }

    public Configuration getConfig() {
        return config;
    }

    static {
        String configFile = System.getProperty(APIMAN_MANAGER_UI_CONFIG_FILE_NAME);
        String refreshDelayStr = System.getProperty(APIMAN_MANAGER_UI_CONFIG_FILE_REFRESH);
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        config = ConfigurationFactory.createConfig((String)configFile, (String)"apiman.properties", (Long)refreshDelay, null, UIConfig.class);
    }
}

