/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server.wildfly8;

import io.apiman.manager.ui.client.shared.beans.BearerTokenCredentialsBean;
import io.apiman.manager.ui.server.auth.ITokenGenerator;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.util.Time;

public class KeyCloakBearerTokenGenerator
implements ITokenGenerator {
    public BearerTokenCredentialsBean generateToken(HttpServletRequest request) {
        BearerTokenCredentialsBean bean = new BearerTokenCredentialsBean();
        KeycloakSecurityContext session = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (session != null) {
            bean.setToken(session.getTokenString());
            int nowInSeconds = Time.currentTime();
            int expiresInSeconds = session.getToken().getExpiration();
            if (expiresInSeconds <= nowInSeconds) {
                bean.setRefreshPeriod(1);
            } else {
                bean.setRefreshPeriod(expiresInSeconds - nowInSeconds);
            }
        } else {
            bean.setToken("LOGGED_OUT");
            bean.setRefreshPeriod(30);
        }
        return bean;
    }
}

