/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server;

import io.apiman.common.config.ConfigFactory;
import io.apiman.manager.ui.server.IUIConfig;
import io.apiman.manager.ui.server.beans.ApiAuthType;
import org.apache.commons.configuration.Configuration;

public class UIConfig
implements IUIConfig {
    public static final String APIMAN_MANAGER_UI_API_ENDPOINT = "apiman-manager-ui.api.endpoint";
    public static final String APIMAN_MANAGER_UI_API_AUTH_TYPE = "apiman-manager-ui.api.authentication.type";
    public static final String APIMAN_MANAGER_UI_API_BASIC_AUTH_USER = "apiman-manager-ui.api.authentication.basic.user";
    public static final String APIMAN_MANAGER_UI_API_BASIC_AUTH_PASS = "apiman-manager-ui.api.authentication.basic.password";
    public static final String APIMAN_MANAGER_UI_API_AUTH_TOKEN_GENERATOR = "apiman-manager-ui.api.authentication.token.generator";
    public static final String APIMAN_MANAGER_UI_ENABLE_METRICS = "apiman-manager-ui.metrics.enable";
    public static final String APIMAN_MANAGER_UI_PLATFORM = "apiman-manager-ui.platform";
    public static final String APIMAN_MANAGER_UI_ORG_CREATE_ADMIN_ONLY = "apiman-manager-ui.org-create-admin-only";
    public static final String APIMAN_MANAGER_UI_LOGOUT_URL = "apiman-manager-ui.logout-url";
    private static Configuration config = ConfigFactory.createConfig();

    public boolean isMetricsEnabled() {
        return config.getBoolean(APIMAN_MANAGER_UI_ENABLE_METRICS, true);
    }

    public String getPlatform() {
        return config.getString(APIMAN_MANAGER_UI_PLATFORM);
    }

    public boolean isAdminOnlyOrgCreationEnabled() {
        return config.getBoolean(APIMAN_MANAGER_UI_ORG_CREATE_ADMIN_ONLY, false);
    }

    public String getManagementApiEndpoint() {
        return config.getString(APIMAN_MANAGER_UI_API_ENDPOINT);
    }

    public ApiAuthType getManagementApiAuthType() {
        String at = config.getString(APIMAN_MANAGER_UI_API_AUTH_TYPE);
        try {
            return ApiAuthType.valueOf((String)at);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid API authentication type: " + at);
        }
    }

    public String getLogoutUrl() {
        return config.getString(APIMAN_MANAGER_UI_LOGOUT_URL, "/apimanui/logout");
    }

    public String getManagementApiAuthUsername() {
        return config.getString(APIMAN_MANAGER_UI_API_BASIC_AUTH_USER);
    }

    public String getManagementApiAuthPassword() {
        return config.getString(APIMAN_MANAGER_UI_API_BASIC_AUTH_PASS);
    }

    public String getManagementApiAuthTokenGenerator() {
        return config.getString(APIMAN_MANAGER_UI_API_AUTH_TOKEN_GENERATOR);
    }

    public Configuration getConfig() {
        return config;
    }
}

