/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class UIVersion {
    private static final UIVersion instance = new UIVersion();
    private String versionString;
    private String versionDate;

    public static final UIVersion get() {
        return instance;
    }

    private UIVersion() {
        this.load();
    }

    private void load() {
        URL url = UIVersion.class.getResource("version.properties");
        if (url == null) {
            this.versionString = "Unknown";
            this.versionDate = new Date().toString();
        } else {
            InputStream is = null;
            Properties props = new Properties();
            try {
                is = url.openStream();
                props.load(is);
                this.versionString = props.getProperty("version", "Unknown");
                this.versionDate = props.getProperty("date", new Date().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getVersionDate() {
        return this.versionDate;
    }
}

