/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.ui.server.servlets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.manager.ui.server.UIVersion;
import io.apiman.manager.ui.server.auth.ITokenGenerator;
import io.apiman.manager.ui.server.beans.ApiAuthConfigurationBean;
import io.apiman.manager.ui.server.beans.ApiAuthType;
import io.apiman.manager.ui.server.beans.ApiConfigurationBean;
import io.apiman.manager.ui.server.beans.AppConfigurationBean;
import io.apiman.manager.ui.server.beans.BasicAuthCredentialsBean;
import io.apiman.manager.ui.server.beans.ConfigurationBean;
import io.apiman.manager.ui.server.beans.UiConfigurationBean;
import io.apiman.manager.ui.server.beans.UserConfigurationBean;
import io.apiman.manager.ui.server.servlets.AbstractUIServlet;
import io.apiman.manager.ui.server.servlets.ConfigurationServlet;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class ConfigurationServlet
extends AbstractUIServlet {
    private static final long serialVersionUID = -1529967410524613367L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Class.forName("io.apiman.manager.ui.server.UIConfig");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        JsonGenerator g = null;
        try {
            response.getOutputStream().write("window.APIMAN_CONFIG_DATA = ".getBytes("UTF-8"));
            JsonFactory f = new JsonFactory();
            g = f.createGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            g.setCodec((ObjectCodec)mapper);
            g.useDefaultPrettyPrinter();
            String endpoint = this.getConfig().getManagementApiEndpoint();
            if (endpoint == null) {
                endpoint = this.getDefaultEndpoint(request);
            }
            UIVersion version = UIVersion.get();
            ApiAuthType authType = this.getConfig().getManagementApiAuthType();
            ConfigurationBean configBean = new ConfigurationBean();
            configBean.setApiman(new AppConfigurationBean());
            configBean.setUser(new UserConfigurationBean());
            configBean.setUi(new UiConfigurationBean());
            configBean.setApi(new ApiConfigurationBean());
            configBean.getUi().setHeader("community");
            configBean.getUi().setMetrics(Boolean.valueOf(this.getConfig().isMetricsEnabled()));
            configBean.getUi().setPlatform(this.getConfig().getPlatform());
            configBean.getUi().setAdminOnlyOrgCreation(Boolean.valueOf(this.getConfig().isAdminOnlyOrgCreationEnabled()));
            configBean.getApiman().setVersion(version.getVersionString());
            configBean.getApiman().setBuiltOn(version.getVersionDate());
            configBean.getApiman().setLogoutUrl(this.getConfig().getLogoutUrl());
            configBean.getUser().setUsername(request.getRemoteUser());
            configBean.getApi().setEndpoint(endpoint);
            configBean.getApi().setAuth(new ApiAuthConfigurationBean());
            switch (1.$SwitchMap$io$apiman$manager$ui$server$beans$ApiAuthType[authType.ordinal()]) {
                case 1: {
                    configBean.getApi().getAuth().setType(ApiAuthType.authToken);
                    String tokenGeneratorClassName = this.getConfig().getManagementApiAuthTokenGenerator();
                    if (tokenGeneratorClassName == null) {
                        throw new ServletException("No token generator class specified.");
                    }
                    Class<?> c = Class.forName(tokenGeneratorClassName);
                    ITokenGenerator tokenGenerator = (ITokenGenerator)c.newInstance();
                    configBean.getApi().getAuth().setBearerToken(tokenGenerator.generateToken(request));
                    break;
                }
                case 2: {
                    configBean.getApi().getAuth().setType(ApiAuthType.basic);
                    configBean.getApi().getAuth().setBasic(new BasicAuthCredentialsBean());
                    String username = this.getConfig().getManagementApiAuthUsername();
                    String password = this.getConfig().getManagementApiAuthPassword();
                    configBean.getApi().getAuth().getBasic().setUsername(username);
                    configBean.getApi().getAuth().getBasic().setPassword(password);
                    break;
                }
                case 3: {
                    configBean.getApi().getAuth().setType(ApiAuthType.bearerToken);
                    String tokenGeneratorClassName = this.getConfig().getManagementApiAuthTokenGenerator();
                    if (tokenGeneratorClassName == null) {
                        throw new ServletException("No token generator class specified.");
                    }
                    Class<?> c = Class.forName(tokenGeneratorClassName);
                    ITokenGenerator tokenGenerator = (ITokenGenerator)c.newInstance();
                    configBean.getApi().getAuth().setBearerToken(tokenGenerator.generateToken(request));
                    break;
                }
                case 4: {
                    configBean.getApi().getAuth().setType(ApiAuthType.samlBearerToken);
                    String tokenGeneratorClassName = this.getConfig().getManagementApiAuthTokenGenerator();
                    if (tokenGeneratorClassName == null) {
                        throw new ServletException("No token generator class specified.");
                    }
                    Class<?> c = Class.forName(tokenGeneratorClassName);
                    ITokenGenerator tokenGenerator = (ITokenGenerator)c.newInstance();
                    configBean.getApi().getAuth().setBearerToken(tokenGenerator.generateToken(request));
                    break;
                }
            }
            g.writeObject((Object)configBean);
            g.flush();
            response.getOutputStream().write(";".getBytes("UTF-8"));
        }
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(g);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)g);
    }
}

