/// <reference path="../typings-custom/tsd.d.ts"/>
/// <reference path="../typings/main.d.ts"/>

/// <reference path='../../includes.ts'/>
var Apiman;
(function (Apiman) {
    Apiman.pluginName = 'api-manager';
    Apiman.log = Logger.get(Apiman.pluginName);
    Apiman.templatePath = 'plugins/api-manager/html';
})(Apiman || (Apiman = {}));

/// <reference path='../../includes.ts'/>
/// <reference path='apimanGlobals.ts'/>
var Apiman;
(function (Apiman) {
    Apiman._module = angular.module(Apiman.pluginName, [
        'angular-clipboard',
        'ngRoute',
        'ngSanitize',
        'ui.bootstrap',
        'ui.select',
        'ui.sortable',
        'xeditable',
        'ngFileUpload',
        'ngAnimate',
        'ApimanRPC',
        'ApimanFilters',
        'ApimanLogger',
        'ApimanConfiguration',
        'ApimanTranslation',
        'ApimanPageLifecycle',
        'ApimanCurrentUser',
        'ApimanModals'
    ]);
    Apiman._module.config([
        '$locationProvider',
        '$routeProvider',
        'uiSelectConfig', ($locationProvider, $routeProvider, uiSelectConfig) => {
            var path = 'plugins/api-manager/html/';
            var prefix = '/api-manager';
            uiSelectConfig.theme = 'select2';
            uiSelectConfig.searchEnabled = false;
            // Define Routes
            $routeProvider
                .when(prefix + '/', {
                templateUrl: path + 'dash.html'
            })
                .when(prefix + '/about', {
                templateUrl: path + 'about.html'
            })
                .when(prefix + '/profile', {
                templateUrl: path + 'user/user-profile.html'
            })
                .when(prefix + '/admin/gateways', {
                templateUrl: path + 'admin/admin-gateways.html'
            })
                .when(prefix + '/admin/plugins', {
                templateUrl: path + 'admin/admin-plugins.html'
            })
                .when(prefix + '/admin/policyDefs', {
                templateUrl: path + 'admin/admin-policyDefs.html'
            })
                .when(prefix + '/admin/roles', {
                templateUrl: path + 'admin/admin-roles.html'
            })
                .when(prefix + '/admin/export', {
                templateUrl: path + 'admin/admin-export.html'
            })
                .when(prefix + '/admin/gateways/:gateway', {
                templateUrl: path + 'forms/edit-gateway.html'
            })
                .when(prefix + '/admin/plugins/:plugin', {
                templateUrl: path + 'forms/edit-plugin.html'
            })
                .when(prefix + '/admin/policyDefs/:policyDef', {
                templateUrl: path + 'forms/edit-policyDef.html'
            })
                .when(prefix + '/admin/roles/:role', {
                templateUrl: path + 'forms/edit-role.html'
            })
                .when(prefix + '/orgs/:org/:type/:id/:ver/policies/:policy', {
                templateUrl: path + 'forms/edit-policy.html'
            })
                .when(prefix + '/orgs/:org/:type/:id/:ver/new-policy', {
                templateUrl: path + 'forms/new-policy.html'
            })
                .when(prefix + '/orgs/:org/clients/:client', {
                templateUrl: path + 'client/client.html'
            })
                .when(prefix + '/orgs/:org/clients/:client/:version', {
                templateUrl: path + 'client/client-overview.html'
            })
                .when(prefix + '/orgs/:org/clients/:client/:version/contracts', {
                templateUrl: path + 'client/client-contracts.html'
            })
                .when(prefix + '/orgs/:org/clients/:client/:version/apis', {
                templateUrl: path + 'client/client-apis.html'
            })
                .when(prefix + '/orgs/:org/clients/:client/:version/metrics', {
                templateUrl: path + 'client/client-metrics.html'
            })
                .when(prefix + '/orgs/:org/clients/:client/:version/policies', {
                templateUrl: path + 'client/client-policies.html'
            })
                .when(prefix + '/orgs/:org/clients/:client/:version/activity', {
                templateUrl: path + 'client/client-activity.html'
            })
                .when(prefix + '/orgs/:org/clients/:client/:version/new-version', {
                templateUrl: path + 'forms/new-clientversion.html'
            })
                .when(prefix + '/orgs/:org/plans/:plan', {
                templateUrl: path + 'plan/plan.html'
            })
                .when(prefix + '/orgs/:org/plans/:plan/:version', {
                templateUrl: path + 'plan/plan-overview.html'
            })
                .when(prefix + '/orgs/:org/plans/:plan/:version/policies', {
                templateUrl: path + 'plan/plan-policies.html'
            })
                .when(prefix + '/orgs/:org/plans/:plan/:version/activity', {
                templateUrl: path + 'plan/plan-activity.html'
            })
                .when(prefix + '/orgs/:org/plans/:plan/:version/new-version', {
                templateUrl: path + 'forms/new-planversion.html'
            })
                .when(prefix + '/orgs/:org/apis/:api', {
                templateUrl: path + 'api/api.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version', {
                templateUrl: path + 'api/api-overview.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/impl', {
                templateUrl: path + 'api/api-impl.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/def', {
                templateUrl: path + 'api/api-def.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/plans', {
                templateUrl: path + 'api/api-plans.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/policies', {
                templateUrl: path + 'api/api-policies.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/endpoint', {
                templateUrl: path + 'api/api-endpoint.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/contracts', {
                templateUrl: path + 'api/api-contracts.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/metrics', {
                templateUrl: path + 'api/api-metrics.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/activity', {
                templateUrl: path + 'api/api-activity.html'
            })
                .when(prefix + '/orgs/:org/apis/:api/:version/new-version', {
                templateUrl: path + 'forms/new-apiversion.html'
            })
                .when(prefix + '/orgs/:org/import/apis', {
                templateUrl: path + 'api/import-apis.html'
            })
                .when(prefix + '/catalog/api-catalog', {
                templateUrl: path + 'catalog/api-catalog.html'
            })
                .when(prefix + '/catalog/api-catalog/:name/def', {
                templateUrl: path + 'catalog/api-catalog-def.html'
            })
                .when(prefix + '/browse/orgs', {
                templateUrl: path + 'consumer/consumer-orgs.html'
            })
                .when(prefix + '/browse/apis', {
                templateUrl: path + 'consumer/consumer-apis.html'
            })
                .when(prefix + '/browse/orgs/:org', {
                templateUrl: path + 'consumer/consumer-org.html'
            })
                .when(prefix + '/browse/orgs/:org/:api', {
                templateUrl: path + 'consumer/consumer-api-redirect.html'
            })
                .when(prefix + '/browse/orgs/:org/:api/:version', {
                templateUrl: path + 'consumer/consumer-api.html'
            })
                .when(prefix + '/browse/orgs/:org/:api/:version/def', {
                templateUrl: path + 'consumer/consumer-api-def.html'
            })
                .when(prefix + '/new-client', {
                templateUrl: path + 'forms/new-client.html'
            })
                .when(prefix + '/new-contract', {
                templateUrl: path + 'forms/new-contract.html'
            })
                .when(prefix + '/new-gateway', {
                templateUrl: path + 'forms/new-gateway.html'
            })
                .when(prefix + '/new-org', {
                templateUrl: path + 'forms/new-org.html'
            })
                .when(prefix + '/new-plan', {
                templateUrl: path + 'forms/new-plan.html'
            })
                .when(prefix + '/new-plugin', {
                templateUrl: path + 'forms/new-plugin.html'
            })
                .when(prefix + '/new-role', {
                templateUrl: path + 'forms/new-role.html'
            })
                .when(prefix + '/new-api', {
                templateUrl: path + 'forms/new-api.html'
            })
                .when(prefix + '/import-policyDefs', {
                templateUrl: path + 'forms/import-policyDefs.html'
            })
                .when(prefix + '/orgs/:org', {
                templateUrl: path + 'org/org.html'
            })
                .when(prefix + '/orgs/:org/plans', {
                templateUrl: path + 'org/org-plans.html'
            })
                .when(prefix + '/orgs/:org/apis', {
                templateUrl: path + 'org/org-apis.html'
            })
                .when(prefix + '/orgs/:org/clients', {
                templateUrl: path + 'org/org-clients.html'
            })
                .when(prefix + '/orgs/:org/members', {
                templateUrl: path + 'org/org-members.html'
            })
                .when(prefix + '/orgs/:org/manage-members', {
                templateUrl: path + 'org/org-manage-members.html'
            })
                .when(prefix + '/orgs/:org/activity', {
                templateUrl: path + 'org/org-activity.html'
            })
                .when(prefix + '/orgs/:org/new-member', {
                templateUrl: path + 'org/org-new-member.html'
            })
                .when(prefix + '/users/:user', {
                templateUrl: path + 'user/user.html'
            })
                .when(prefix + '/users/:user/activity', {
                templateUrl: path + 'user/user-activity.html'
            })
                .when(prefix + '/users/:user/clients', {
                templateUrl: path + 'user/user-clients.html'
            })
                .when(prefix + '/users/:user/orgs', {
                templateUrl: path + 'user/user-orgs.html'
            })
                .when(prefix + '/users/:user/apis', {
                templateUrl: path + 'user/user-apis.html'
            })
                .when(prefix + '/errors/invalid_server', {
                templateUrl: path + 'errors/invalid_server.html'
            })
                .when(prefix + '/errors/400', {
                templateUrl: path + 'errors/400.html'
            })
                .when(prefix + '/errors/403', {
                templateUrl: path + 'errors/403.html'
            })
                .when(prefix + '/errors/404', {
                templateUrl: path + 'errors/404.html'
            })
                .when(prefix + '/errors/409', {
                templateUrl: path + 'errors/409.html'
            })
                .when(prefix + '/errors/409-8002', {
                templateUrl: path + 'errors/409-8002.html'
            })
                .when(prefix + '/errors/500', {
                templateUrl: path + 'errors/500.html'
            })
                .when(prefix + '/def', {
                templateUrl: path + 'rest-documentation.html'
            })
                .otherwise({ redirectTo: prefix + '/' });
            $locationProvider.html5Mode(true);
        }]);
    Apiman._module.factory('authInterceptor', ['$q', '$timeout', 'Configuration', 'Logger',
            ($q, $timeout, Configuration, Logger) => {
            var refreshBearerToken = function () {
                Logger.info('Refreshing bearer token now.');
                // Note: we need to use jquery directly for this call, otherwise we will have
                // a circular dependency in angular.
                $.get('rest/tokenRefresh', function (reply) {
                    Logger.info('Bearer token successfully refreshed: {0}', reply);
                    Configuration.api.auth.bearerToken.token = reply.token;
                    var refreshPeriod = reply.refreshPeriod;
                    if (!refreshPeriod || refreshPeriod < 1) {
                        Logger.info('Refresh period was invalid! (using 60s)');
                        refreshPeriod = 60;
                    }
                    $timeout(refreshBearerToken, refreshPeriod * 1000);
                }).fail(function (error) {
                    Logger.error('Failed to refresh bearer token: {0}', error);
                });
            };
            if (Configuration.api.auth.type == 'bearerToken') {
                var refreshPeriod = Configuration.api.auth.bearerToken.refreshPeriod;
                $timeout(refreshBearerToken, refreshPeriod * 1000);
            }
            var requestInterceptor = {
                request: function (config) {
                    var authHeader = Configuration.getAuthorizationHeader();
                    if (authHeader) {
                        config.headers.Authorization = authHeader;
                    }
                    return config;
                }
            };
            return requestInterceptor;
        }]);
    Apiman._module.config(['$httpProvider', function ($httpProvider) {
            $httpProvider.interceptors.push('authInterceptor');
        }]);
    Apiman._module.run([
        '$rootScope',
        'SystemSvcs',
        'Configuration',
        '$location', ($rootScope, SystemSvcs, Configuration, $location) => {
            $rootScope.isDirty = false;
            $rootScope.$on('$locationChangeStart', function (event, newUrl, oldUrl) {
                if ($rootScope.isDirty) {
                    if (confirm('You have unsaved changes. Are you sure you would like to navigate away from this page? You will lose these changes.') != true) {
                        event.preventDefault();
                    }
                }
            });
            $rootScope.pluginName = Apiman.pluginName;
        }]);
    // Load the configuration jsonp script
    $.getScript('apiman/config.js')
        .done((script, textStatus) => {
        Apiman.log.info('Loaded the config.js config!');
    })
        .fail((response) => {
        Apiman.log.debug('Error fetching configuration: ', response);
    })
        .always(() => {
        // Load the i18n jsonp script
        $.getScript('apiman/translations.js').done((script, textStatus) => {
            Apiman.log.info('Loaded the translations.js bundle!');
            angular.element(document).ready(function () {
                angular.bootstrap(document, ['api-manager']);
            });
        }).fail((response) => {
            Apiman.log.debug('Error fetching translations: ', response);
        });
    });
})(Apiman || (Apiman = {}));

/// <reference path="apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.DashController = Apiman._module.controller("Apiman.AboutController", ['$scope', 'PageLifecycle', 'CurrentUser', 'Configuration',
            ($scope, PageLifecycle, CurrentUser, Configuration) => {
            PageLifecycle.loadPage('About', undefined, undefined, $scope, function () {
                $scope.github = "http://github.com/apiman/apiman";
                $scope.site = "http://apiman.io/";
                $scope.userGuide = "http://www.apiman.io/latest/user-guide.html";
                $scope.tutorials = "http://www.apiman.io/latest/tutorials.html";
                $scope.version = Configuration.apiman.version;
                $scope.builtOn = Configuration.apiman.builtOn;
                $scope.apiEndpoint = Configuration.api.endpoint;
                PageLifecycle.setPageTitle('about');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path='../../includes.ts'/>
var ApimanConfiguration;
(function (ApimanConfiguration) {
    ApimanConfiguration._module = angular.module('ApimanConfiguration', []);
    ApimanConfiguration.Configuration = ApimanConfiguration._module.factory('Configuration', ['$window',
        function ($window) {
            var cdata = {};
            if ($window['APIMAN_CONFIG_DATA']) {
                cdata = angular.copy($window['APIMAN_CONFIG_DATA']);
                delete $window['APIMAN_CONFIG_DATA'];
            }
            else {
                console.log('***  Missing variable: APIMAN_CONFIG_DATA  ***');
            }
            cdata.getAuthorizationHeader = function () {
                var authHeader = null;
                if (cdata.api.auth.type == 'basic') {
                    var username = cdata.api.auth.basic.username;
                    var password = cdata.api.auth.basic.password;
                    var enc = btoa(username + ':' + password);
                    authHeader = 'Basic ' + enc;
                }
                else if (cdata.api.auth.type == 'bearerToken') {
                    if (cdata.api.auth.bearerToken && cdata.api.auth.bearerToken.token) {
                        var token = cdata.api.auth.bearerToken.token;
                        authHeader = 'Bearer ' + token;
                    }
                    else {
                        console.log('** Auth type was ' + cdata.api.auth.type + ' but no bearer-token was found! **');
                    }
                }
                else if (cdata.api.auth.type == 'authToken') {
                    var token = cdata.api.auth.bearerToken.token;
                    authHeader = 'AUTH-TOKEN ' + token;
                }
                return authHeader;
            };
            if (!cdata.ui) {
                cdata.ui = {
                    header: false,
                    metrics: true
                };
            }
            if (cdata.ui.metrics == undefined || cdata.ui.metrics == null) {
                cdata.ui.metrics = true;
            }
            if (cdata.ui.platform == undefined || cdata.ui.platform == null) {
                cdata.ui.platform = "community";
            }
            if (cdata.ui.adminOnlyOrgCreation == undefined || cdata.ui.adminOnlyOrgCreation == null) {
                cdata.ui.adminOnlyOrgCreation = false;
            }
            return cdata;
        }]);
})(ApimanConfiguration || (ApimanConfiguration = {}));

/// <reference path='../../includes.ts'/>
var ApimanCurrentUser;
(function (ApimanCurrentUser) {
    ApimanCurrentUser._module = angular.module('ApimanCurrentUser', ['ApimanRPC']);
    ApimanCurrentUser.CurrentUser = ApimanCurrentUser._module.factory('CurrentUser', ['$q', '$rootScope', 'CurrentUserSvcs', 'Logger',
            ($q, $rootScope, CurrentUserSvcs, Logger) => {
            return {
                getCurrentUser: function () {
                    return $q(function (resolve, reject) {
                        return CurrentUserSvcs.get({ what: 'info' }, function (currentUser) {
                            resolve(currentUser);
                        }, reject);
                    });
                },
                getCurrentUserOrgs: function () {
                    var orgs = {};
                    var perms = $rootScope.currentUser.permissions;
                    for (var i = 0; i < perms.length; i++) {
                        var perm = perms[i];
                        orgs[perm.organizationId] = true;
                    }
                    var rval = [];
                    angular.forEach(orgs, function (value, key) {
                        this.push(key);
                    }, rval);
                    return rval;
                },
                hasPermission: function (organizationId, permission) {
                    //Logger.debug('Checking for permission {0}||{1} in {2}', organizationId, permission, $rootScope.permissions);
                    if ($rootScope.currentUser && $rootScope.currentUser.admin) {
                        return true;
                    }
                    if (organizationId && $rootScope.permissions) {
                        var permid = organizationId + '||' + permission;
                        return $rootScope.permissions[permid];
                    }
                    else {
                        return false;
                    }
                },
                isMember: function (organizationId) {
                    if (organizationId && $rootScope.memberships) {
                        return $rootScope.memberships[organizationId];
                    }
                    else {
                        return false;
                    }
                },
                clear: function () {
                    $rootScope.currentUser = undefined;
                }
            };
        }]);
})(ApimanCurrentUser || (ApimanCurrentUser = {}));

/// <reference path="apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.DashController = Apiman._module.controller("Apiman.DashController", ['$scope', 'PageLifecycle', 'CurrentUser', 'Configuration',
            ($scope, PageLifecycle, CurrentUser, Configuration) => {
            PageLifecycle.loadPage('Dash', undefined, undefined, $scope, function () {
                $scope.noCreateOrg = Configuration.ui.platform == 'f8' || Configuration.ui.platform == 'ose' ||
                    (Configuration.ui.adminOnlyOrgCreation == true && !$scope.isAdmin);
                PageLifecycle.setPageTitle('dashboard');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../../includes.ts"/>
var Apiman;
(function (Apiman) {
    Apiman._module.directive('apimanActionBtn', ['Logger', function (Logger) {
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    var actionVar = attrs.field;
                    var actionText = attrs.placeholder;
                    var icon = attrs.icon;
                    var disabledExpr = attrs.ngDisabled;
                    scope[actionVar] = {
                        state: 'ready',
                        html: $(element).html(),
                        actionHtml: '<i class="fa fa-spin ' + icon + '"></i> ' + actionText
                    };
                    scope.$watch(actionVar + '.state', function () {
                        var newVal = scope[actionVar];
                        if (newVal.state == 'in-progress') {
                            $(element).prop('disabled', true);
                            $(element).html(newVal.actionHtml);
                        }
                        else {
                            var isDisabled = false;
                            if (disabledExpr) {
                                var exprVal = scope.$eval(disabledExpr);
                                isDisabled = new Boolean(exprVal).valueOf();
                            }
                            $(element).prop('disabled', isDisabled);
                            $(element).html(newVal.html);
                        }
                    });
                }
            };
        }]);
    Apiman._module.directive('apimanApiModal', ['Logger', function (Logger) {
            return {
                templateUrl: 'plugins/api-manager/html/client/apiModal.html',
                replace: true,
                restrict: 'E',
                link: function (scope, element, attrs) {
                    $(element).on('hidden.bs.modal', function () {
                        $(element).remove();
                    });
                    // Called if copy-to-clipboard functionality was successful
                    scope.copySuccess = function () {
                        //console.log('Copied!');
                    };
                    // Called if copy-to-clipboard functionality was unsuccessful
                    scope.copyFail = function (err) {
                        //console.error('Error!', err);
                    };
                }
            };
        }]);
    Apiman._module.directive('apimanSelectPicker', ['Logger', '$timeout', '$parse', 'TranslationSvc',
        function (Logger, $timeout, $parse, TranslationSvc) {
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    function refresh(newVal) {
                        scope.$applyAsync(function () {
                            $(element)['selectpicker']('refresh');
                        });
                    }
                    $timeout(function () {
                        $(element)['selectpicker']();
                        $(element)['selectpicker']('refresh');
                    });
                    if (attrs.ngOptions && / in /.test(attrs.ngOptions)) {
                        var refreshModel = attrs.ngOptions.split(' in ')[1].split(' ')[0];
                        Logger.debug('Watching model {0} for {1}.', refreshModel, attrs.ngModel);
                        scope.$watch(refreshModel, function () {
                            scope.$applyAsync(function () {
                                Logger.debug('Refreshing {0} due to watch model update.', attrs.ngModel);
                                $(element)['selectpicker']('refresh');
                            });
                        }, true);
                    }
                    if (attrs.apimanSelectPicker) {
                        Logger.debug('Watching {0}.', attrs.apimanSelectPicker);
                        scope.$watch(attrs.apimanSelectPicker + '.length', refresh, true);
                    }
                    if (attrs.ngModel) {
                        scope.$watch(attrs.ngModel, refresh, true);
                    }
                    if (attrs.ngDisabled) {
                        scope.$watch(attrs.ngDisabled, refresh, true);
                    }
                    scope.$on('$destroy', function () {
                        $timeout(function () {
                            $(element)['selectpicker']('destroy');
                        });
                    });
                }
            };
        }]);
    Apiman._module.directive('apimanPermission', ['Logger', 'CurrentUser',
            (Logger, CurrentUser) => {
            return {
                restrict: 'A',
                link: function ($scope, element, attrs) {
                    var refresh = function (newValue) {
                        var orgId = $scope.organizationId;
                        if (orgId) {
                            var permission = attrs.apimanPermission;
                            $(element).removeClass('apiman-not-permitted');
                            if (!CurrentUser.hasPermission(orgId, permission)) {
                                $(element).addClass('apiman-not-permitted');
                            }
                        }
                        else {
                            Logger.error('Missing organizationId from $scope - authorization disabled.');
                        }
                    };
                    $scope.$watch('organizationId', refresh);
                    $scope.$watch('permissions', refresh);
                }
            };
        }]);
    Apiman._module.directive('apimanStatus', ['Logger', 'EntityStatusSvc',
        function (Logger, EntityStatusSvc) {
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    scope.$watch(function ($scope) {
                        return EntityStatusSvc.getEntityStatus();
                    }, function (newValue, oldValue) {
                        var entityStatus = newValue;
                        var elem = element;
                        if (entityStatus) {
                            var validStatuses = attrs.apimanStatus.split(',');
                            var statusIsValid = false;
                            //                            Logger.debug('Checking status {0} against valid statuses {1}:  {2}', entityStatus, '' + validStatuses,
                            //                                    element[0].outerHTML);
                            for (var i = 0; i < validStatuses.length; i++) {
                                if (validStatuses[i] == entityStatus) {
                                    statusIsValid = true;
                                    break;
                                }
                            }
                            $(element).removeClass('apiman-wrong-status');
                            if (!statusIsValid) {
                                $(element).addClass('apiman-wrong-status');
                            }
                        }
                        else {
                            Logger.error('Missing entityStatus from $scope - hide/show based on entity status feature is disabled.');
                        }
                    });
                }
            };
        }]);
    Apiman._module.factory('EntityStatusSvc', ['$rootScope', 'Logger',
        function ($rootScope, Logger) {
            var entity = null;
            var entityType = null;
            return {
                setEntity: function (theEntity, type) {
                    Logger.debug('Setting the entity: {0} type={1}', theEntity, type);
                    entity = theEntity;
                    entityType = type;
                },
                getEntity: function () {
                    return entity;
                },
                getEntityStatus: function () {
                    if (entity) {
                        return entity.status;
                    }
                },
                getEntityType: function () {
                    if (!entity) {
                        Logger.debug('Entity is null!');
                        return 'n/a';
                    }
                    return entityType;
                },
                setEntityStatus: function (status) {
                    if (entity) {
                        entity.status = status;
                    }
                },
                isEntityDisabled: function () {
                    if (entity) {
                        if (entityType == 'client' || entityType == 'clients') {
                            return entity.status == 'Retired';
                        }
                        else if (entityType == 'api' || entityType == 'apis') {
                            if (entity.publicAPI) {
                                return entity.status == 'Retired';
                            }
                            else {
                                return (entity.status !== 'Created' && entity.status !== 'Ready');
                            }
                        }
                        else {
                            return (entity.status !== 'Created' && entity.status !== 'Ready');
                        }
                    }
                }
            };
        }]);
    Apiman._module.directive('apimanEntityStatus', ['Logger', 'EntityStatusSvc',
        function (Logger, EntityStatusSvc) {
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    scope.$watch(function ($scope) {
                        return EntityStatusSvc.getEntityStatus();
                    }, function (newValue, oldValue) {
                        var entityStatus = newValue;
                        if (entityStatus) {
                            $(element).html(entityStatus);
                            $(element).removeClass();
                            $(element).addClass('apiman-label');
                            if (entityStatus == 'Created' || entityStatus == 'Ready') {
                                $(element).addClass('apiman-label-warning');
                            }
                            else if (entityStatus == 'Retired') {
                                $(element).addClass('apiman-label-default');
                            }
                            else {
                                $(element).addClass('apiman-label-success');
                            }
                        }
                    });
                }
            };
        }]);
    Apiman.sb_counter = 0;
    Apiman._module.directive('apimanSearchBox', ['Logger', 'TranslationSvc',
        function (Logger, TranslationSvc) {
            return {
                restrict: 'E',
                replace: true,
                templateUrl: 'plugins/api-manager/html/directives/searchBox.html',
                scope: {
                    searchFunction: '=function'
                },
                link: function (scope, element, attrs) {
                    scope.placeholder = attrs.placeholder;
                    if (attrs['id']) {
                        scope.filterId = attrs['id'] + '-f';
                        scope.buttonId = attrs['id'] + '-b';
                    }
                    else {
                        var cid = 'search-box-' + Apiman.sb_counter;
                        Apiman.sb_counter = Apiman.sb_counter + 1;
                        scope.filterId = cid + '-filter';
                        scope.buttonId = cid + '-button';
                    }
                    if (attrs.apimanI18nKey) {
                        var translationKey = attrs.apimanI18nKey + ".placeholder";
                        var defaultValue = scope.placeholder;
                        var translatedValue = TranslationSvc.translate(translationKey, defaultValue);
                        scope.placeholder = translatedValue;
                    }
                    scope.doSearch = function () {
                        $(element).find('button i').removeClass('fa-search');
                        $(element).find('button i').removeClass('fa-close');
                        if (scope.value) {
                            $(element).find('button i').addClass('fa-close');
                        }
                        else {
                            $(element).find('button i').addClass('fa-search');
                        }
                        scope.searchFunction(scope.value);
                    };
                    scope.onClick = function () {
                        if (scope.value) {
                            scope.value = '';
                            $(element).find('button i').removeClass('fa-search');
                            $(element).find('button i').removeClass('fa-close');
                            $(element).find('button i').addClass('fa-search');
                        }
                        scope.searchFunction(scope.value);
                    };
                }
            };
        }]);
    var entryTypeClasses = {
        Organization: 'fa-shield',
        Client: 'fa-gears',
        Plan: 'fa-bar-chart-o',
        Api: 'fa-puzzle-piece'
    };
    Apiman._module.directive('apimanActivity', ['Logger', '$rootScope', 'PageLifecycle',
            (Logger, $rootScope, PageLifecycle) => {
            return {
                templateUrl: 'plugins/api-manager/html/directives/activity.html',
                restrict: 'E',
                replace: true,
                scope: {
                    auditEntries: '=model',
                    next: '=next'
                },
                link: function (scope, element, attrs) {
                    scope.pluginName = $rootScope.pluginName;
                    scope.hasMore = true;
                    scope.getEntryIcon = function (entry) {
                        return entryTypeClasses[entry.entityType];
                    };
                    scope.getMore = function () {
                        scope.getMoreButton.state = 'in-progress';
                        scope.next(function (newEntries) {
                            scope.auditEntries = scope.auditEntries.concat(newEntries);
                            scope.hasMore = newEntries.length >= 20;
                            scope.getMoreButton.state = 'complete';
                        }, PageLifecycle.handleError);
                    };
                }
            };
        }]);
    Apiman._module.directive('apimanAuditEntry', ['Logger', '$rootScope',
        function (Logger, $rootScope) {
            return {
                restrict: 'E',
                scope: {
                    entry: '=model'
                },
                link: function (scope, element, attrs) {
                    scope.pluginName = $rootScope.pluginName;
                    scope.template = 'plugins/api-manager/html/directives/audit/' + scope.entry.entityType + '/audit' + scope.entry.what + '.html';
                    if (scope.entry.data) {
                        scope.data = JSON.parse(scope.entry.data);
                    }
                },
                template: '<div ng-include="template"></div>'
            };
        }]);
    Apiman._module.directive('apimanDropText', ['Logger',
            (Logger) => {
            return {
                restrict: 'A',
                require: 'ngModel',
                scope: {
                    ngModel: '='
                },
                link: function ($scope, $elem, $attrs, ngModel) {
                    $elem.on('dragover', function (e) {
                        e.preventDefault();
                        if (e.dataTransfer) {
                            e.dataTransfer.effectAllowed = 'copy';
                        }
                        if (!$elem.hasClass('dropping')) {
                            $elem.addClass('dropping');
                        }
                        return false;
                    });
                    $elem.on('dragenter', function (e) {
                        e.preventDefault();
                        if (e.dataTransfer) {
                            e.dataTransfer.effectAllowed = 'copy';
                        }
                        $elem.addClass('dropping');
                        return false;
                    });
                    $elem.on('dragleave', function (e) {
                        e.preventDefault();
                        $elem.removeClass('dropping');
                        return false;
                    });
                    $elem.on('drop', function (e) {
                        e.preventDefault();
                        $elem.removeClass('dropping');
                        if (e.originalEvent.dataTransfer && e.originalEvent.dataTransfer.files.length) {
                            if (e.preventDefault)
                                e.preventDefault();
                            if (e.stopPropagation)
                                e.stopPropagation();
                            var firstFile = e.originalEvent.dataTransfer.files[0];
                            var reader = new FileReader();
                            reader.onload = (function (theFile) {
                                return function (result) {
                                    $elem.val(result.target.result);
                                    ngModel.$setViewValue(result.target.result);
                                    $scope.$emit('afterdrop', { element: $elem, value: result.target.result });
                                };
                            })(firstFile);
                            reader.readAsText(firstFile);
                        }
                    });
                }
            };
        }]);
    Apiman._module.directive('apimanPolicyList', ['Logger',
        function (Logger) {
            return {
                restrict: 'E',
                scope: {
                    policies: "=ngModel",
                    remove: "=removeFunction",
                    reorder: "=reorderFunction",
                    type: "@",
                    org: "@orgId",
                    id: "@pageId",
                    version: "@"
                },
                controller: ['$scope', ($scope) => {
                        $scope.policyListOptions = {
                            containerPositioning: 'relative',
                            orderChanged: function (event) {
                                Logger.debug("Reordered as: {0}", $scope.ctrl.policies);
                                $scope.ctrl.reorder($scope.ctrl.policies);
                            }
                        };
                        $scope.pluginName = $scope.$parent.pluginName;
                    }],
                controllerAs: 'ctrl',
                bindToController: true,
                templateUrl: 'plugins/api-manager/html/directives/policyList.html'
            };
        }
    ]);
    Apiman._module.directive('apimanEditableDescription', ['Logger',
        function (Logger) {
            return {
                restrict: 'E',
                scope: {
                    descr: '=description',
                    callback: '='
                },
                controller: ['$scope', ($scope) => {
                    }],
                link: function ($scope, $elem, $attrs) {
                    $scope.defaultValue = $attrs.defaultValue;
                    var elem = null;
                    var previousRows = 1;
                    //$scope.topPosition = 0;
                    //$scope.leftPosition = 0;
                    //$scope.height = 60;
                    //$scope.height = 'auto';
                    /*
                    // If description is updated, call updateFunction.
                    $scope.$watch(function() {
                        return $scope.descr;
                    },
                    function(new_value, old_value) {
                        if (old_value !== new_value && typeof new_value !== 'undefined') {
                            console.log('old_value' + old_value);
                            console.log('new_value: ' + new_value);
                            console.log('callback()');
                             $scope.callback(new_value || '');
                         }
                    });*/
                    $scope.saveDescription = function () {
                        $scope.callback($scope.descr);
                    };
                    $scope.focusOnDescription = function (event) {
                        elem = event.target;
                        elem.value = $scope.descr || '';
                        $(elem).css('height', 'auto');
                        $(elem).height(elem.scrollHeight);
                    };
                    $scope.changeOnDescription = function () {
                        $(elem).css('height', 'auto');
                        $(elem).height(elem.scrollHeight);
                    };
                    $scope.descriptionMouseOver = function (event) {
                        $scope.showPencil = true;
                        var elem = event.target;
                        var position = elem.getBoundingClientRect();
                        // Calculate position of pen
                        // console.log("elem.top " + position.top);
                        // console.log("elem.bottom " + position.bottom);
                        // console.log("elem.left " + position.left);
                        // console.log("elem.right " + position.right);
                        /*
                        if (position.right != 0) {
                            $scope.leftPosition = (position.right - position.left) - 15;
                            $scope.height = (position.bottom - position.top);
                        }
                        */
                    };
                    $scope.descriptionMouseOut = function (event) {
                        $scope.showPencil = false;
                    };
                },
                templateUrl: 'plugins/api-manager/html/directives/editDescription.html'
            };
        }]);
    Apiman._module.run(['editableOptions', 'editableThemes', function (editableOptions, editableThemes) {
            editableOptions.theme = 'default';
            // overwrite templates
            editableThemes['default'].submitTpl = '<button class="btn btn-default inline-save-btn" type="submit"><i class="fa fa-check fa-fw"></i></button>';
            editableThemes['default'].cancelTpl = '<button class="btn btn-default" type="button" ng-click="$form.$cancel()"><i class="fa fa-times fa-fw"></i></button>';
            editableThemes['default'].buttonsTpl = '<div class="editable-options"></div>';
            editableThemes['default'].formTpl = '<form class="editable-wrap apiman-inline-edit"></form>';
        }]);
    Apiman._module.directive('apimanI18nKey', ['Logger', 'TranslationSvc',
        function (Logger, TranslationSvc) {
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    if (!attrs.apimanI18nKey) {
                        return;
                    }
                    var translationKey, defaultValue, translatedValue;
                    // Process the text of the element only if it has no child elements
                    if ($(element).children().length == 0) {
                        translationKey = attrs.apimanI18nKey;
                        defaultValue = $(element).text();
                        translatedValue = TranslationSvc.translate(translationKey, defaultValue);
                        $(element).text(translatedValue);
                    }
                    // Now process the placeholder attribute.
                    if ($(element).attr('placeholder')) {
                        translationKey = attrs.apimanI18nKey + '.placeholder';
                        defaultValue = $(element).attr('placeholder');
                        translatedValue = TranslationSvc.translate(translationKey, defaultValue);
                        Logger.debug('Translating placeholder attr.  Key: {2}  default value: {0}  translated: {1}', defaultValue, translatedValue, translationKey);
                        $(element).prop('placeholder', translatedValue);
                        $(element).attr('placeholder', translatedValue);
                    }
                    // Now process the title attribute.
                    if ($(element).attr('title')) {
                        translationKey = attrs.apimanI18nKey + '.title';
                        defaultValue = $(element).attr('title');
                        translatedValue = TranslationSvc.translate(translationKey, defaultValue);
                        Logger.debug('Translating title attr.  Key: {2}  default value: {0}  translated: {1}', defaultValue, translatedValue, translationKey);
                        $(element).prop('title', translatedValue);
                        $(element).attr('title', translatedValue);
                    }
                }
            };
        }]);
    Apiman._module.directive('clickOutside', function ($parse, $timeout) {
        return {
            link: function (scope, element, attrs) {
                function handler(event) {
                    if (!$(event.target).closest(element).length) {
                        scope.$apply(function () {
                            $parse(attrs.clickOutside)(scope);
                        });
                    }
                }
                $timeout(function () {
                    // Timeout is to prevent the click handler from immediately
                    // firing upon opening the popover.
                    $(document).on('click', handler);
                });
                scope.$on('$destroy', function () {
                    $(document).off('click', handler);
                });
            }
        };
    });
    Apiman._module.directive('httpVerbsSelect', ['Logger', function (Logger) {
            return {
                templateUrl: 'plugins/api-manager/html/directives/requestMethod.html',
                replace: true,
                restrict: 'E',
                link: function (scope, elem, attrs) {
                    // init model
                    scope.resetVerbsSelector = function () {
                        scope.verb = '*';
                    };
                    scope.resetVerbsSelector();
                }
            };
        }]);
    Apiman._module.directive('httpMethodCachingSelect', ['Logger', function (Logger) {
            return {
                templateUrl: 'plugins/api-manager/html/directives/requestMethodCachingResourcesOptions.html',
                replace: true,
                restrict: 'E',
                link: function (scope, elem, attrs) {
                    // init model
                    scope.resetVerbsSelector = function () {
                        scope.verb = '*';
                    };
                    scope.resetVerbsSelector();
                }
            };
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman._module.controller('Apiman.Error400Controller', ['$scope', '$rootScope', 'PageLifecycle',
            ($scope, $rootScope, PageLifecycle) => {
            PageLifecycle.loadErrorPage('Error', $scope, function () {
                PageLifecycle.setPageTitle('error', 400);
            });
        }]);
    Apiman._module.controller('Apiman.Error403Controller', ['$scope', '$rootScope', 'PageLifecycle',
            ($scope, $rootScope, PageLifecycle) => {
            PageLifecycle.loadErrorPage('Error', $scope, function () {
                PageLifecycle.setPageTitle('error', 403);
            });
        }]);
    Apiman._module.controller('Apiman.Error404Controller', ['$scope', '$rootScope', 'PageLifecycle',
            ($scope, $rootScope, PageLifecycle) => {
            PageLifecycle.loadErrorPage('Error', $scope, function () {
                PageLifecycle.setPageTitle('error', 404);
            });
        }]);
    Apiman._module.controller('Apiman.Error409Controller', ['$scope', '$rootScope', 'PageLifecycle',
            ($scope, $rootScope, PageLifecycle) => {
            PageLifecycle.loadErrorPage('Error', $scope, function () {
                PageLifecycle.setPageTitle('error', 409);
            });
        }]);
    Apiman._module.controller('Apiman.Error500Controller', ['$scope', '$rootScope', 'PageLifecycle', 'Logger',
            ($scope, $rootScope, PageLifecycle, Logger) => {
            $scope.error = $rootScope.pageError;
            PageLifecycle.loadErrorPage('Error', $scope, function () {
                PageLifecycle.setPageTitle('error', 500);
            });
        }]);
    Apiman._module.controller('Apiman.ErrorInvalidServerController', ['$scope', '$rootScope', 'PageLifecycle', 'Logger', 'Configuration',
            ($scope, $rootScope, PageLifecycle, Logger, Configuration) => {
            $scope.error = $rootScope.pageError;
            PageLifecycle.loadErrorPage('Error', $scope, function () {
                $scope.installGuide = 'http://www.apiman.io/latest/installation-guide.html';
                $scope.version = Configuration.apiman.version;
                $scope.builtOn = Configuration.apiman.builtOn;
                $scope.apiEndpoint = Configuration.api.endpoint;
                $scope.cors = 'https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS';
                PageLifecycle.setPageTitle('error', 'Invalid Server');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../../includes.ts"/>
var ApimanFilters;
(function (ApimanFilters) {
    ApimanFilters._module = angular.module('ApimanFilters', ['ApimanConfiguration']);
    ApimanFilters.checklist = ApimanFilters._module.filter('urlEncode', function () {
        return encodeURIComponent;
    });
    // Checklist Filter:
    // This filter processes and formats data returned by the /status endpoint.
    ApimanFilters.checklist = ApimanFilters._module.filter('checklist', function () {
        // Map the IDs to the Tab Names
        // This is used when checking if the user is on the same tab
        // defined on the checklist.
        var tabMapping = {
            'endpoint': 'impl',
            'gateways': 'impl',
            'plans': 'plans',
            'policies': 'policies'
        };
        return function (input) {
            var filtered = [];
            angular.forEach(input, function (item) {
                if (item && item.id) {
                    // Add path for tabs with more than one path (ie: endpoint and gateways)
                    item.path = tabMapping[item.id];
                    // Check if item is completed (no need to check for this)
                    var status = (item.done === true) ? 'complete' : 'incomplete';
                    // Determine status icon class
                    item.iconClass = (item.done === true) ? 'fa fa-check-circle-o' : 'fa fa-circle-o';
                    // Determine table row class (ie: active complete, inactive incomplete)
                    item.rowClass = status;
                    filtered.push(item);
                }
            });
            return filtered;
        };
    });
    ApimanFilters.propsFilter = ApimanFilters._module.filter('propsFilter', function () {
        return function (items, props) {
            var out = [];
            if (angular.isArray(items)) {
                items.forEach(function (item) {
                    var itemMatches = false;
                    var keys = Object.keys(props);
                    for (var i = 0; i < keys.length; i++) {
                        var prop = keys[i];
                        var text = props[prop].toLowerCase();
                        if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                            itemMatches = true;
                            break;
                        }
                    }
                    if (itemMatches) {
                        out.push(item);
                    }
                });
            }
            else {
                // Let the output be the input untouched
                out = items;
            }
            return out;
        };
    });
    ApimanFilters.selectedTags = ApimanFilters._module.filter('selectedTags', ['Logger', function (Logger) {
            return function (array, selectedTags) {
                if (array && selectedTags.length >= 1) {
                    return array.filter(function (item) {
                        var itemTags = [];
                        _.map(selectedTags, function (tag) {
                            if (_.includes(item.tags, tag)) {
                                itemTags.push(tag);
                            }
                        });
                        return _.difference(selectedTags, itemTags).length === 0;
                    });
                }
                else {
                    return array;
                }
            };
        }]);
})(ApimanFilters || (ApimanFilters = {}));

/// <reference path="../../includes.ts"/>
var ApimanPageLifecycle;
(function (ApimanPageLifecycle) {
    ApimanPageLifecycle.pageTitles = {
        "page.title.admin-gateways": "apiman - Admin - Gateways",
        "page.title.admin-plugins": "apiman - Admin - Plugins",
        "page.title.admin-roles": "apiman - Admin - Roles",
        "page.title.admin-policyDefs": "apiman - Admin - Policy Definitions",
        "page.title.admin-export": "apiman - Admin - Export/Import",
        "page.title.api-catalog": "apiman - API Catalog",
        "page.title.api-catalog-def": "apiman - API Definition",
        "page.title.client-activity": "apiman - {0} (Change Log)",
        "page.title.client-apis": "apiman - {0} (APIs)",
        "page.title.client-contracts": "apiman - {0} (Contracts)",
        "page.title.client-metrics": "apiman - {0} (Metrics)",
        "page.title.client-overview": "apiman - {0} (Overview)",
        "page.title.client-policies": "apiman - {0} (Policies)",
        "page.title.consumer-org": "apiman - Organization {0}",
        "page.title.consumer-orgs": "apiman - Organizations",
        "page.title.consumer-api": "apiman - API {0}",
        "page.title.consumer-api-def": "apiman - API {0} - Definition",
        "page.title.consumer-apis": "apiman - APIs",
        "page.title.dashboard": "apiman - Home",
        "page.title.about": "apiman - About",
        "page.title.edit-gateway": "apiman - Edit Gateway",
        "page.title.edit-policy": "apiman - Edit Policy",
        "page.title.edit-policyDef": "apiman - Edit Policy Definition",
        "page.title.edit-role": "apiman - Edit Role",
        "page.title.import-policyDefs": "apiman - Import Policy Definition(s)",
        "page.title.import-apis": "apiman - Import API(s)",
        "page.title.new-client": "apiman - New Client App",
        "page.title.new-client-version": "apiman - New Client App Version",
        "page.title.new-contract": "apiman - New Contract",
        "page.title.new-gateway": "apiman - New Gateway",
        "page.title.new-member": "apiman - Add Member",
        "page.title.new-org": "apiman - New Organization",
        "page.title.new-plan": "apiman - New Plan",
        "page.title.new-plan-version": "apiman - New Plan Version",
        "page.title.new-plugin": "apiman - Add Plugin",
        "page.title.new-policy": "apiman - Add Policy",
        "page.title.new-role": "apiman - New Role",
        "page.title.new-api": "apiman - New API",
        "page.title.new-api-version": "apiman - New API Version",
        "page.title.manager-rest-def": "apiman - REST API",
        "page.title.org-activity": "apiman - {0} (Change Log)",
        "page.title.org-clients": "apiman - {0} (Client Apps)",
        "page.title.org-manage-members": "apiman - {0} (Manage Members)",
        "page.title.org-members": "apiman - {0} (Members)",
        "page.title.org-plans": "apiman - {0} (Plans)",
        "page.title.org-apis": "apiman - {0} (APIs)",
        "page.title.plan-activity": "apiman - {0} (Change Log)",
        "page.title.plan-overview": "apiman - {0} (Overview)",
        "page.title.plan-policies": "apiman - {0} (Policies)",
        "page.title.plugin-details": "apiman - Plugin Details",
        "page.title.policy-defs": "apiman - Admin - Policy Definitions",
        "page.title.api-activity": "apiman - {0} (Change Log)",
        "page.title.api-contracts": "apiman - {0} (Contracts)",
        "page.title.api-endpoint": "apiman - {0} (Endpoint)",
        "page.title.api-metrics": "apiman - {0} (Metrics)",
        "page.title.api-impl": "apiman - {0} (Implementation)",
        "page.title.api-def": "apiman - {0} (Definition)",
        "page.title.api-overview": "apiman - {0} (Overview)",
        "page.title.api-plans": "apiman - {0} (Plans)",
        "page.title.api-policies": "apiman - {0} (Policies)",
        "page.title.user-activity": "apiman - {0} (Change Log)",
        "page.title.user-clients": "apiman - {0} (Client Apps)",
        "page.title.user-orgs": "apiman - {0} (Organizations)",
        "page.title.user-profile": "apiman - User Profile",
        "page.title.user-apis": "apiman - {0} (APIs)",
        "page.title.error": "apiman - {0} Error",
    };
    var formatMessage = function (theArgs) {
        var now = new Date();
        var msg = theArgs[0];
        if (theArgs.length > 1) {
            for (var i = 1; i < theArgs.length; i++) {
                msg = msg.replace('{' + (i - 1) + '}', theArgs[i]);
            }
        }
        return msg;
    };
    ApimanPageLifecycle._module = angular.module("ApimanPageLifecycle", []);
    ApimanPageLifecycle.PageLifecycle = ApimanPageLifecycle._module.factory('PageLifecycle', ['$q', '$timeout', 'Logger', '$rootScope', '$location', 'CurrentUserSvcs', 'Configuration', 'TranslationSvc', '$window', 'CurrentUser',
            ($q, $timeout, Logger, $rootScope, $location, CurrentUserSvcs, Configuration, TranslationSvc, $window, CurrentUser) => {
            var header = 'community';
            if (Configuration.ui && Configuration.ui.header) {
                header = Configuration.ui.header;
            }
            if (header == 'apiman') {
                header = 'community';
            }
            $rootScope.headerInclude = 'plugins/api-manager/html/headers/' + header + '.include';
            console.log('Using header: ' + $rootScope.headerInclude);
            let redirectWrongPermission = function () {
                Logger.info('Detected a 404 error.');
                $location.url(Apiman.pluginName + '/errors/404').replace();
                return;
            };
            var processCurrentUser = function (currentUser) {
                $rootScope.currentUser = currentUser;
                var permissions = {};
                var memberships = {};
                if (currentUser.permissions) {
                    for (var i = 0; i < currentUser.permissions.length; i++) {
                        var perm = currentUser.permissions[i];
                        var permid = perm.organizationId + '||' + perm.name;
                        permissions[permid] = true;
                        memberships[perm.organizationId] = true;
                    }
                }
                Logger.info('Updating permissions now {0}', permissions);
                $rootScope.permissions = permissions;
                $rootScope.memberships = memberships;
                $rootScope.isAdmin = currentUser.admin;
            };
            var handleError = function (error) {
                $rootScope.pageState = 'error';
                $rootScope.pageError = error;
                if (error.status == 400) {
                    Logger.info('Detected an error {0}, redirecting to 400.', error.status);
                    $location.url(Apiman.pluginName + '/errors/400').replace();
                }
                else if (error.status == 401) {
                    Logger.info('Detected an error 401, reloading the page.');
                    $window.location.reload();
                }
                else if (error.status == 403) {
                    Logger.info('Detected an error {0}, redirecting to 403.', error.status);
                    $location.url(Apiman.pluginName + '/errors/403').replace();
                }
                else if (error.status == 404) {
                    Logger.info('Detected an error {0}, redirecting to 404.', error.status);
                    $location.url(Apiman.pluginName + '/errors/404').replace();
                }
                else if (error.status == 409) {
                    Logger.info('Detected an error {0}, redirecting to 409.', error.status);
                    var errorUri = '409';
                    Logger.info('=====> {0}', error);
                    Logger.info('=====> error code: {0}', error.data.errorCode);
                    if (error.data.errorCode && error.data.errorCode == 8002) {
                        errorUri = '409-8002';
                    }
                    $location.url(Apiman.pluginName + '/errors/' + errorUri).replace();
                }
                else if (error.status == 0) {
                    Logger.info('Detected an error {0}, redirecting to CORS error page.', error.status);
                    $location.url(Apiman.pluginName + '/errors/invalid_server').replace();
                }
                else {
                    // TODO: if the error data starts with <html> then redirect to a more generic html-into-div based error page
                    Logger.info('Detected an error {0}, redirecting to 500.', error.status);
                    $location.url(Apiman.pluginName + '/errors/500').replace();
                }
            };
            return {
                setPageTitle: function (titleKey, params) {
                    var key = 'page.title.' + titleKey;
                    var pattern = ApimanPageLifecycle.pageTitles[key];
                    pattern = TranslationSvc.translate(key, pattern);
                    if (pattern) {
                        var args = [];
                        args.push(pattern);
                        args = args.concat(params);
                        var title = formatMessage(args);
                        document.title = title;
                    }
                    else {
                        document.title = pattern;
                    }
                },
                handleError: handleError,
                forwardTo: function () {
                    var path = '/' + Apiman.pluginName + formatMessage(arguments);
                    Logger.info('Forwarding to page {0}', path);
                    $location.url(path).replace();
                },
                redirectTo: function () {
                    var path = '/' + Apiman.pluginName + formatMessage(arguments);
                    Logger.info('Redirecting to page {0}', path);
                    $location.url(path);
                },
                loadPage: function (pageName, requiredPermission, pageData, $scope, handler) {
                    Logger.log("|{0}| >> Loading page.", pageName);
                    $rootScope.pageState = 'loading';
                    $rootScope.isDirty = false;
                    var currentUser = $q(function (resolve, reject) {
                        if ($rootScope.currentUser) {
                            Logger.log("|{0}| >> Using cached current user from $rootScope.", pageName);
                            resolve($rootScope.currentUser);
                        }
                        else {
                            return CurrentUserSvcs.get({ what: 'info' }, function (currentUser) {
                                processCurrentUser(currentUser);
                                resolve(currentUser);
                            }, reject);
                        }
                    });
                    // Now resolve the data as a promise (wait for all data packets to be fetched)
                    return currentUser.then(function () {
                        return $q.all(pageData);
                    }).then(function (data) {
                        // Make sure the user has permission to view this page.
                        if ((requiredPermission && requiredPermission == 'orgView' && !CurrentUser.isMember($scope.organizationId)) ||
                            (requiredPermission && requiredPermission != 'orgView' && !CurrentUser.hasPermission($scope.organizationId, requiredPermission))) {
                            redirectWrongPermission();
                        }
                        // Now process all the data packets and bind them to the $scope.
                        var count = 0;
                        angular.forEach(data, function (value, key) {
                            Logger.debug("|{0}| >> Binding {1} to $scope.", pageName, key);
                            this[key] = value;
                            count++;
                        }, $scope);
                        $timeout(function () {
                            $rootScope.pageState = 'loaded';
                            Logger.log("|{0}| >> Page successfully loaded: {1} data packets loaded", pageName, count);
                            if (handler) {
                                $timeout(function () {
                                    Logger.log("|{0}| >> Calling Page onLoaded handler", pageName);
                                    handler();
                                }, 20);
                            }
                        }, 50);
                    }, function (reason) {
                        Logger.error("|{0}| >> Page load failed: {1}", pageName, reason);
                        handleError(reason);
                    });
                },
                loadErrorPage: function (pageName, $scope, handler) {
                    Logger.log("|{0}| >> Loading error page.", pageName);
                    $rootScope.pageState = 'loading';
                    // Nothing to do asynchronously for the error pages!
                    $rootScope.pageState = 'loaded';
                    if (handler) {
                        handler();
                    }
                    Logger.log("|{0}| >> Error page successfully loaded", pageName);
                }
            };
        }]);
})(ApimanPageLifecycle || (ApimanPageLifecycle = {}));

/// <reference path="../../includes.ts"/>
var ApimanLogger;
(function (ApimanLogger) {
    ApimanLogger._module = angular.module("ApimanLogger", []);
    var stringifyIfObject = function (candidate) {
        return (typeof candidate === 'object') ? angular.toJson(candidate, true) : candidate;
    };
    var _formatMessage = function (theArgs) {
        var now = new Date();
        var msg = theArgs[0];
        if (theArgs.length > 1) {
            for (var i = 1; i < theArgs.length; i++) {
                msg = msg.replace('{' + (i - 1) + '}', stringifyIfObject(theArgs[i]));
            }
        }
        else {
            msg = stringifyIfObject(msg);
        }
        return 'apiman [' + now.toLocaleTimeString() + ']>>  ' + msg;
    };
    ApimanLogger.Logger = ApimanLogger._module.factory('Logger', [
        function () {
            return {
                debug: function () {
                    console.debug(_formatMessage(arguments));
                },
                info: function () {
                    console.info(_formatMessage(arguments));
                },
                log: function () {
                    console.info(_formatMessage(arguments));
                },
                warn: function () {
                    console.warn(_formatMessage(arguments));
                },
                error: function () {
                    console.error(_formatMessage(arguments));
                }
            };
        }]);
})(ApimanLogger || (ApimanLogger = {}));

/// <reference path="../../includes.ts"/>
var ApimanModals;
(function (ApimanModals) {
    ApimanModals._module = angular.module('ApimanModals', ['ApimanLogger', 'ApimanRPC']);
    ApimanModals.Modals = ApimanModals._module.factory('Modals', ['Logger', '$uibModal',
            (Logger, $uibModal) => {
            return {
                // Simple data entry dialog
                ///////////////////////////
                getValue: function (title, message, label, initialValue, okCallback, cancelCallback) {
                    var options = {
                        initialValue: initialValue,
                        label: label,
                        message: message,
                        title: title
                    };
                    var modalInstance = $uibModal.open({
                        animation: true,
                        templateUrl: 'getValueModal.html',
                        controller: 'ModalGetValueCtrl',
                        resolve: {
                            options: function () {
                                return options;
                            }
                        }
                    });
                    modalInstance.result.then(okCallback, cancelCallback);
                },
                // A standard confirmation dialog
                /////////////////////////////////
                confirm: function (title, message, yesCallback, noCallback) {
                    var options = {
                        title: title,
                        message: message
                    };
                    var modalInstance = $uibModal.open({
                        animation: true,
                        templateUrl: 'confirmModal.html',
                        controller: 'ModalConfirmCtrl',
                        resolve: {
                            options: function () {
                                return options;
                            }
                        }
                    });
                    modalInstance.result.then(yesCallback, noCallback);
                }
            };
        }]);
    ApimanModals.ClientAppDeleteModalCtrl = ApimanModals._module.controller('ModalClientAppDeleteCtrl', function ($location, $rootScope, $scope, $uibModalInstance, OrgSvcs, Configuration, PageLifecycle, client, params) {
        $scope.confirmClientName = '';
        $scope.client = client;
        // Used for enabling/disabling the submit button
        $scope.okayToDelete = false;
        $scope.typed = function () {
            // For user convenience, compare lower case values so that check is not case-sensitive
            $scope.okayToDelete = ($scope.confirmClientName.toLowerCase() === client.name.toLowerCase());
        };
        // Yes, delete the API
        $scope.yes = function () {
            var deleteAction = {
                entityId: client.id,
                entityType: 'clients',
                organizationId: params.org
            };
            OrgSvcs.remove(deleteAction).$promise.then(function (res) {
                $scope.okayToDelete = false;
                setTimeout(function () {
                    $uibModalInstance.close();
                    // Redirect users to their list of APIs
                    $location.path($rootScope.pluginName + '/users/' + Configuration.user.username + '/clients');
                }, 800);
                // We should display some type of Toastr/Growl notification to the user here
            }, function (err) {
                $scope.okayToDelete = false;
                $uibModalInstance.close();
                PageLifecycle.handleError(err);
            });
        };
        // No, do NOT delete the API
        $scope.no = function () {
            $uibModalInstance.dismiss('cancel');
        };
    });
    ApimanModals.ModalSelectApiCtrl = ApimanModals._module.controller('ModalSelectApiCtrl', ['$scope', '$uibModalInstance', 'ApimanSvcs', 'Logger', 'OrgSvcs', 'options',
            ($scope, $uibModalInstance, ApimanSvcs, Logger, OrgSvcs, options) => {
            $scope.options = options;
            $scope.selectedApi = undefined;
            $scope.selectedApiVersion = undefined;
            $scope.title = options.title;
            $scope.search = function () {
                $scope.selectedApi = undefined;
                if (!$scope.searchText) {
                    $scope.criteria = undefined;
                    $scope.apis = undefined;
                }
                else {
                    $scope.searchButton.state = 'in-progress';
                    var body = {};
                    body.filters = [];
                    body.filters.push({
                        'name': 'name',
                        'value': '%' + $scope.searchText + '%',
                        'operator': 'like'
                    });
                    var searchStr = angular.toJson(body);
                    Logger.log('Searching for apis: {0}', $scope.searchText);
                    ApimanSvcs.save({
                        entityType: 'search',
                        secondaryType: 'apis'
                    }, searchStr, function (reply) {
                        if (reply.beans.length > 0) {
                            $scope.apis = reply.beans;
                        }
                        else {
                            $scope.apis = undefined;
                        }
                        $scope.criteria = $scope.searchText;
                        Logger.log('Found {0} apis.', reply.beans.length);
                        $scope.searchButton.state = 'complete';
                    }, function (error) {
                        Logger.error(error);
                        // TODO do something interesting with the error
                        $scope.apis = undefined;
                        $scope.criteria = $scope.searchText;
                        $scope.searchButton.state = 'error';
                    });
                }
            };
            $scope.$watch('selectedApiVersion', function (newValue) {
                Logger.info("===========> Api Version: {0}", newValue);
            }, false);
            $scope.onApiSelected = function (api) {
                if ($scope.selectedApi) {
                    $scope.selectedApi.selected = false;
                }
                $scope.selectedApi = api;
                api.selected = true;
                $scope.selectedApiVersion = undefined;
                OrgSvcs.query({
                    organizationId: api.organizationId,
                    entityType: 'apis',
                    entityId: api.id,
                    versionsOrActivity: 'versions'
                }, function (versions) {
                    if ($scope.options.publishedOnly === true) {
                        var validVersions = [];
                        angular.forEach(versions, function (version) {
                            if (version.status == 'Published') {
                                validVersions.push(version);
                            }
                        });
                        $scope.apiVersions = validVersions;
                    }
                    else {
                        $scope.apiVersions = versions;
                    }
                    if ($scope.apiVersions.length > 0) {
                        $scope.selectedApiVersion = $scope.apiVersions[0];
                    }
                }, function (error) {
                    $scope.apiVersions = [];
                    $scope.selectedApiVersion = undefined;
                });
            };
            $scope.onApiVersionSelected = function (apiVersion) {
                Logger.info("===========> Called onApiVersionSelected: {0}", apiVersion);
                $scope.selectedApiVersion = apiVersion;
            };
            $scope.ok = function () {
                $uibModalInstance.close($scope.selectedApiVersion);
            };
            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };
        }]);
    ApimanModals.ModalGetValueCtrl = ApimanModals._module.controller('ModalGetValueCtrl', ['$scope', '$uibModalInstance', 'Logger', 'options',
            ($scope, $uibModalInstance, Logger, options) => {
            $scope.options = options;
            $scope.title = $scope.options.title;
            $scope.message = $scope.options.message;
            $scope.label = $scope.options.label;
            $scope.value = $scope.options.initialValue;
            $scope.ok = function () {
                $uibModalInstance.close($scope.value);
            };
            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };
        }
    ]);
    ApimanModals.ModalConfirmCtrl = ApimanModals._module.controller('ModalConfirmCtrl', ['$scope', '$uibModalInstance', 'Logger', 'options',
            ($scope, $uibModalInstance, Logger, options) => {
            $scope.options = options;
            $scope.title = $scope.options.title;
            $scope.message = $scope.options.message;
            $scope.ok = function () {
                $uibModalInstance.close();
            };
            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };
        }
    ]);
})(ApimanModals || (ApimanModals = {}));

/// <reference path="apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NavbarController = Apiman._module.controller("Apiman.NavbarController", ['$scope', 'Logger', 'Configuration', ($scope, Logger, Configuration) => {
            Logger.log("Current user is {0}.", Configuration.user.username);
            $scope.username = Configuration.user.username;
            $scope.logoutUrl = Configuration.apiman.logoutUrl;
            $scope.goBack = function () {
                Logger.info('Returning to parent UI: {0}', Configuration.ui.backToConsole);
                window.location.href = Configuration.ui.backToConsole;
            };
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../../includes.ts"/>
var ApimanRPC;
(function (ApimanRPC) {
    ApimanRPC._module = angular.module("ApimanRPC", ['ngResource', 'ApimanConfiguration']);
    var formatEndpoint = function (endpoint, params) {
        return endpoint.replace(/:(\w+)/g, function (match, key) {
            return params[key] ? params[key] : (':' + key);
        });
    };
    ApimanRPC.ApimanSvcs = ApimanRPC._module.factory('ApimanSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            var endpoint = Configuration.api.endpoint + '/:entityType/:secondaryType';
            /*
            // Intercept Errors
            function resourceErrorResponseHandler(response) {
                var charRegExp = /([\\]*)?"(pass|password)([\\]*)?":([\\]*)?"(.+?)([\\]*)?"/g;
                var regTest = charRegExp.test(JSON.stringify(response));

                if (regTest === true) {
                    var newResponse = JSON.stringify(response).replace(charRegExp, '\\"password\\":\\"*****\\"');
                    console.log('Formatted response: ' + newResponse);

                    return newResponse;
                }

                return response;
            }
            */
            return $resource(endpoint, { entityType: '@entityType', secondaryType: '@secondaryType' }, {
                update: {
                    method: 'PUT' //, // this method issues a PUT request
                } });
        }]);
    ApimanRPC.UserSvcs = ApimanRPC._module.factory('UserSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            var endpoint = Configuration.api.endpoint + '/users/:user/:entityType';
            return $resource(endpoint, { user: '@user', entityType: '@entityType' }, {
                update: {
                    method: 'PUT' // this method issues a PUT request
                }
            });
        }]);
    ApimanRPC.OrganizationSvcs = ApimanRPC._module.factory('OrgSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            var endpoint = Configuration.api.endpoint + '/organizations/:organizationId/:entityType/:entityId/:versionsOrActivity/:version/:policiesOrActivity/:policyId/:policyChain';
            return $resource(endpoint, {
                organizationId: '@organizationId',
                entityType: '@entityType',
                entityId: '@entityId',
                versionsOrActivity: '@versionsOrActivity',
                version: '@version',
                policiesOrActivity: '@policiesOrActivity',
                policyId: '@policyId',
                chain: '@policyChain',
                page: '@page',
                count: '@count'
            }, {
                update: {
                    method: 'PUT' // update issues a PUT request
                } });
        }]);
    ApimanRPC.CurrentUserSvcs = ApimanRPC._module.factory('CurrentUserSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            var endpoint = Configuration.api.endpoint + '/users/currentuser/:what';
            return $resource(endpoint, { entityType: '@what' });
        }]);
    ApimanRPC.ActionSvcs = ApimanRPC._module.factory('ActionSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            var endpoint = Configuration.api.endpoint + '/actions';
            return $resource(endpoint);
        }]);
    ApimanRPC.AuditSvcs = ApimanRPC._module.factory('AuditSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            var endpoint = Configuration.api.endpoint + '/organizations/:organizationId/:entityType/:entityId/activity';
            return $resource(endpoint, {
                organizationId: '@organizationId',
                entityType: '@entityType',
                entityId: '@entityId',
                page: '@page',
                count: '@count'
            });
        }]);
    ApimanRPC.UserAuditSvcs = ApimanRPC._module.factory('UserAuditSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            var endpoint = Configuration.api.endpoint + '/users/:user/activity';
            return $resource(endpoint, {
                user: '@user',
                page: '@page',
                count: '@count'
            });
        }]);
    ApimanRPC.PluginSvcs = ApimanRPC._module.factory('PluginSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            return {
                getPolicyForm: function (pluginId, policyDefId, handler, errorHandler) {
                    var endpoint = Configuration.api.endpoint + '/plugins/:pluginId/policyDefs/:policyDefId/form';
                    $resource(endpoint, { pluginId: '@pluginId', policyDefId: '@policyDefId' }).get({ pluginId: pluginId, policyDefId: policyDefId }, handler, errorHandler);
                }
            };
        }]);
    ApimanRPC.ApiSvcs = ApimanRPC._module.factory('ApiSvcs', [
        '$resource',
        '$http',
        'Configuration', function ($resource, $http, Configuration) {
            return {
                deleteApi: function (data) {
                    var endpoint = Configuration.api.endpoint + '/organizations/' + data.orgId + '/apis/' + data.apiId;
                    return $http({
                        method: 'DELETE',
                        url: endpoint,
                        data: {
                            organizationId: data.orgId,
                            apiId: data.apiId
                        }
                    });
                }
            };
        }]);
    ApimanRPC.ApiDefinitionSvcs = ApimanRPC._module.factory('ApiDefinitionSvcs', ['$resource', '$http', 'Configuration',
        function ($resource, $http, Configuration) {
            return {
                getApimanDefinitionUrl: function (orgId, apiId, version) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/definition', { organizationId: orgId, apiId: apiId, version: version });
                    return endpoint;
                },
                getApiDefinition: function (orgId, apiId, version, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/definition', { organizationId: orgId, apiId: apiId, version: version });
                    $http({
                        method: 'GET',
                        url: endpoint,
                        transformResponse: function (value) { return value; }
                    }).success(handler).error(errorHandler);
                },
                updateApiDefinition: function (orgId, apiId, version, definition, definitionType, handler, errorHandler) {
                    let ct = 'application/json';
                    if (definitionType == 'SwaggerYAML') {
                        ct = 'application/x-yaml';
                    }
                    else if (definitionType == 'WSDL') {
                        ct = 'application/wsdl+xml';
                    }
                    let endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/definition', { organizationId: orgId, apiId: apiId, version: version });
                    $http({
                        method: 'PUT',
                        url: endpoint,
                        headers: { 'Content-Type': ct },
                        data: definition
                    }).success(handler).error(errorHandler);
                },
                updateApiDefinitionFromUrl(orgId, apiId, version, definitionUrl, definitionType, handler, errorHandler) {
                    let ct = 'application/json';
                    let endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/definition', { organizationId: orgId, apiId: apiId, version: version });
                    let data = JSON.stringify({ definitionUrl: definitionUrl, definitionType: definitionType });
                    $http({
                        method: 'POST',
                        url: endpoint,
                        headers: { 'Content-Type': ct },
                        data: data
                    }).success(handler).error(errorHandler);
                }
            };
        }]);
    ApimanRPC.MetricsSvcs = ApimanRPC._module.factory('MetricsSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            return {
                getUsage: function (orgId, apiId, version, interval, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/metrics/usage', { organizationId: orgId, apiId: apiId, version: version });
                    $resource(endpoint, { interval: interval, from: from, to: to }).get({}, handler, errorHandler);
                },
                getUsagePerClient: function (orgId, apiId, version, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/metrics/clientUsage', { organizationId: orgId, apiId: apiId, version: version });
                    $resource(endpoint, { from: from, to: to }).get({}, handler, errorHandler);
                },
                getUsagePerPlan: function (orgId, apiId, version, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/metrics/planUsage', { organizationId: orgId, apiId: apiId, version: version });
                    $resource(endpoint, { from: from, to: to }).get({}, handler, errorHandler);
                },
                getResponseStats: function (orgId, apiId, version, interval, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/metrics/responseStats', { organizationId: orgId, apiId: apiId, version: version });
                    $resource(endpoint, { interval: interval, from: from, to: to }).get({}, handler, errorHandler);
                },
                getResponseStatsSummary: function (orgId, apiId, version, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/metrics/summaryResponseStats', { organizationId: orgId, apiId: apiId, version: version });
                    $resource(endpoint, { from: from, to: to }).get({}, handler, errorHandler);
                },
                getResponseStatsPerClient: function (orgId, apiId, version, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/metrics/clientResponseStats', { organizationId: orgId, apiId: apiId, version: version });
                    $resource(endpoint, { from: from, to: to }).get({}, handler, errorHandler);
                },
                getResponseStatsPerPlan: function (orgId, apiId, version, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/apis/:apiId/versions/:version/metrics/planResponseStats', { organizationId: orgId, apiId: apiId, version: version });
                    $resource(endpoint, { from: from, to: to }).get({}, handler, errorHandler);
                },
                getClientUsagePerApi: function (orgId, clientId, version, from, to, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/clients/:clientId/versions/:version/metrics/apiUsage', { organizationId: orgId, clientId: clientId, version: version });
                    $resource(endpoint, { from: from, to: to }).get({}, handler, errorHandler);
                },
            };
        }]);
    ApimanRPC.SystemSvcs = ApimanRPC._module.factory('SystemSvcs', ['$resource', 'Configuration', 'Logger', 'Upload',
        function ($resource, Configuration, Logger, Upload) {
            return {
                getStatus: function (handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/system/status', {});
                    $resource(endpoint).get({}, handler, errorHandler);
                },
                exportAsJson: function (handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/system/export?download=true', {});
                    $resource(endpoint).get({}, handler, errorHandler);
                },
                importJson: function (file, progressHandler, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/system/import', {});
                    file.upload = Upload.http({
                        url: endpoint,
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        data: file
                    });
                    file.upload.then(handler, errorHandler);
                    file.upload.progress(progressHandler);
                }
            };
        }]);
    ApimanRPC.DownloadSvcs = ApimanRPC._module.factory('DownloadSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            return {
                getDownloadLink: function (downloadId) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/downloads/:downloadId', {
                        "downloadId": downloadId
                    });
                    return endpoint;
                }
            };
        }]);
    ApimanRPC.ApiRegistrySvcs = ApimanRPC._module.factory('ApiRegistrySvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            return {
                exportApiRegistryAsJson: function (orgId, clientId, version, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/clients/:clientId/versions/:version/apiregistry/json?download=true', {
                        "organizationId": orgId,
                        "clientId": clientId,
                        "version": version
                    });
                    $resource(endpoint).get({}, handler, errorHandler);
                },
                exportApiRegistryAsXml: function (orgId, clientId, version, handler, errorHandler) {
                    var endpoint = formatEndpoint(Configuration.api.endpoint + '/organizations/:organizationId/clients/:clientId/versions/:version/apiregistry/xml?download=true', {
                        "organizationId": orgId,
                        "clientId": clientId,
                        "version": version
                    });
                    $resource(endpoint).get({}, handler, errorHandler);
                }
            };
        }]);
    ApimanRPC.ApiCatalogSvcs = ApimanRPC._module.factory('ApiCatalogSvcs', ['$resource', 'Configuration',
        function ($resource, Configuration) {
            return {
                getNamespaces: function (handler, errorHandler) {
                    var endpoint = Configuration.api.endpoint + '/search/apiCatalog/namespaces';
                    $resource(endpoint, {}, {
                        "get": { "action": "GET", "isArray": true }
                    }).get({}, handler, errorHandler);
                },
                search: function (criteria, handler, errorHandler) {
                    var endpoint = Configuration.api.endpoint + '/search/apiCatalog/entries';
                    $resource(endpoint).save({}, criteria, handler, errorHandler);
                }
            };
        }]);
})(ApimanRPC || (ApimanRPC = {}));

/// <reference path="apimanPlugin.ts"/>
/// <reference path="rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.isRegexpValid = function (v) {
        var valid = true;
        try {
            new RegExp(v, '');
        }
        catch (e) {
            valid = false;
        }
        return valid;
    };
    Apiman._module.controller('Apiman.DefaultPolicyConfigFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validateRaw = function (config) {
                var valid = true;
                try {
                    var parsed = JSON.parse(config);
                    $scope.setConfig(parsed);
                }
                catch (e) {
                    valid = false;
                }
                $scope.setValid(valid);
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            if ($scope.getConfig()) {
                $scope.rawConfig = JSON.stringify($scope.getConfig(), null, 2);
            }
            $scope.$watch('rawConfig', validateRaw);
        }]);
    Apiman._module.controller('Apiman.JsonSchemaPolicyConfigFormController', ['$scope', 'Logger', 'PluginSvcs', 'EntityStatusSvc',
            ($scope, Logger, PluginSvcs, EntityStatusSvc) => {
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            var initEditor = function (schema) {
                var holder = document.getElementById('json-editor-holder');
                var editor = new window['JSONEditor'](holder, {
                    // Disable fetching schemas via ajax
                    ajax: false,
                    // The schema for the editor
                    schema: schema,
                    // Disable additional properties
                    no_additional_properties: true,
                    // Require all properties by default
                    required_by_default: true,
                    disable_edit_json: true,
                    disable_properties: true,
                    iconlib: 'fontawesome4',
                    theme: 'bootstrap3'
                });
                editor.on('change', function () {
                    $scope.$apply(function () {
                        // Get an array of errors from the validator
                        var errors = editor.validate();
                        // Not valid
                        if (errors.length) {
                            $scope.setValid(false);
                        }
                        else {
                            $scope.setValid(true);
                            $scope.setConfig($scope.editor.getValue());
                        }
                    });
                });
                if ($scope.isEntityDisabled() === true) {
                    editor.disable();
                }
                $scope.editor = editor;
            };
            var destroyEditor = function () {
                if ($scope.editor) {
                    $scope.editor.destroy();
                    $scope.editor = null;
                }
            };
            var loadSchema = function () {
                $scope.schemaState = 'loading';
                var pluginId = $scope.selectedDef.pluginId;
                var policyDefId = $scope.selectedDef.id;
                PluginSvcs.getPolicyForm(pluginId, policyDefId, function (schema) {
                    destroyEditor();
                    initEditor(schema);
                    $scope.editor.setValue($scope.config);
                    $scope.schemaState = 'loaded';
                }, function (error) {
                    // TODO handle the error better here!
                    Logger.error(error);
                    $scope.schemaState = 'loaded';
                });
            };
            // Watch for changes to selectedDef - if the user changes from one schema-based policy
            // to another schema-based policy, then the controller won't change.  The result is that
            // we need to refresh the schema when the selectedDef changes.
            $scope.$watch('selectedDef', function (newValue) {
                if (newValue && newValue.formType == 'JsonSchema') {
                    destroyEditor();
                    loadSchema();
                }
            });
            $scope.$on('$destroy', function () {
                destroyEditor();
            });
            // On first load of this controller, load the schema.
            loadSchema();
        }]);
    Apiman._module.controller('Apiman.RateLimitingFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                var valid = true;
                if (config.limit) {
                    config.limit = Number(config.limit);
                }
                if (!config.limit || config.limit < 1) {
                    valid = false;
                }
                if (valid && !Number.isSafeInteger(config.limit)) {
                    config.limit = Number.MAX_SAFE_INTEGER;
                }
                if (!config.granularity) {
                    valid = false;
                }
                if (!config.period) {
                    valid = false;
                }
                if (config.granularity == 'User' && !config.userHeader) {
                    valid = false;
                }
                $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
                $scope.setValid(valid);
            };
            $scope.$watch('config', validate, true);
        }]);
    Apiman._module.controller('Apiman.QuotaFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                var valid = true;
                if (config.limit) {
                    config.limit = Number(config.limit);
                }
                if (!config.limit || config.limit < 1) {
                    valid = false;
                }
                if (!config.granularity) {
                    valid = false;
                }
                if (!config.period) {
                    valid = false;
                }
                if (config.granularity == 'User' && !config.userHeader) {
                    valid = false;
                }
                $scope.setValid(valid);
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            $scope.$watch('config', validate, true);
        }]);
    Apiman.KB = 1024;
    Apiman.MB = 1024 * 1024;
    Apiman.GB = 1024 * 1024 * 1024;
    Apiman._module.controller('Apiman.TransferQuotaFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            $scope.limitDenomination = 'B';
            if ($scope.config && $scope.config.limit) {
                var limit = Number($scope.config.limit);
                if (limit > Apiman.GB && ((limit % Apiman.GB) == 0)) {
                    $scope.limitAmount = limit / Apiman.GB;
                    $scope.limitDenomination = 'GB';
                }
                else if (limit > Apiman.MB && ((limit % Apiman.MB) == 0)) {
                    $scope.limitAmount = limit / Apiman.MB;
                    $scope.limitDenomination = 'MB';
                }
                else if (limit > Apiman.KB && ((limit % Apiman.KB) == 0)) {
                    $scope.limitAmount = limit / Apiman.KB;
                    $scope.limitDenomination = 'KB';
                }
                else {
                    $scope.limitAmount = limit;
                }
            }
            var validate = function (config) {
                var valid = true;
                if (!config.limit || config.limit < 1) {
                    valid = false;
                }
                if (!config.granularity) {
                    valid = false;
                }
                if (!config.period) {
                    valid = false;
                }
                if (config.granularity == 'User' && !config.userHeader) {
                    valid = false;
                }
                if (!config.direction) {
                    valid = false;
                }
                $scope.setValid(valid);
            };
            var onLimitChange = function () {
                var amt = $scope.limitAmount;
                if (amt) {
                    var den = $scope.limitDenomination;
                    var denFact = 1;
                    if (den == 'KB') {
                        denFact = 1024;
                    }
                    if (den == 'MB') {
                        denFact = 1024 * 1024;
                    }
                    if (den == 'GB') {
                        denFact = 1024 * 1024 * 1024;
                    }
                    try {
                        $scope.config.limit = Number(amt) * denFact;
                    }
                    catch (e) {
                        $scope.config.limit = null;
                    }
                }
                else {
                    $scope.config.limit = null;
                }
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            $scope.$watch('config', validate, true);
            $scope.$watch('limitDenomination', onLimitChange, false);
            $scope.$watch('limitAmount', onLimitChange, false);
        }]);
    Apiman._module.controller('Apiman.IPListFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                var valid = true;
                $scope.setValid(valid);
            };
            $scope.$watch('config', validate, true);
            if (!$scope.config.ipList) {
                $scope.config.ipList = [];
            }
            if (!$scope.config.responseCode) {
                $scope.config.responseCode = '500';
            }
            $scope.add = function (ip) {
                $scope.remove(ip);
                $scope.config.ipList.push(ip);
                $scope.selectedIP = [ip];
                $scope.ipAddress = undefined;
                $('#ip-address').focus();
            };
            $scope.remove = function (ips) {
                angular.forEach(ips, function (ip) {
                    var idx = -1;
                    angular.forEach($scope.config.ipList, function (item, index) {
                        if (item == ip) {
                            idx = index;
                        }
                    });
                    if (idx != -1) {
                        $scope.config.ipList.splice(idx, 1);
                    }
                });
                $scope.selectedIP = undefined;
            };
            $scope.clear = function () {
                $scope.config.ipList = [];
                $scope.selectedIP = undefined;
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
        }]);
    Apiman._module.controller('Apiman.IgnoredResourcesFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                var valid = config.rules && config.rules.length > 0;
                $scope.setValid(valid);
            };
            $scope.currentItemInvalid = function () { return !$scope.pathPattern || !$scope.verb || !Apiman.isRegexpValid($scope.path); };
            $scope.$watch('config', validate, true);
            $scope.add = function (path, verb) {
                if (!$scope.config.rules) {
                    $scope.config.rules = [];
                }
                var rule = {
                    'verb': verb,
                    'pathPattern': path
                };
                $scope.config.rules.push(rule);
                $scope.pathPattern = undefined;
                $scope.resetVerbsSelector();
                $('#path').focus();
            };
            $scope.remove = function (selectedRule) {
                var idx = -1;
                angular.forEach($scope.config.rules, function (item, index) {
                    if (item == selectedRule) {
                        idx = index;
                    }
                });
                if (idx != -1) {
                    $scope.config.rules.splice(idx, 1);
                }
                $scope.selectedPath = undefined;
            };
            $scope.clear = function () {
                $scope.config.rules = [];
                $scope.selectedPath = undefined;
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
        }]);
    Apiman._module.controller('Apiman.BasicAuthFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                if (!config) {
                    return;
                }
                var valid = true;
                if (!config.realm) {
                    valid = false;
                }
                if (!config.staticIdentity && !config.ldapIdentity && !config.jdbcIdentity) {
                    valid = false;
                }
                if (config.staticIdentity) {
                    if (!config.staticIdentity.identities) {
                        valid = false;
                    }
                }
                if (config.ldapIdentity) {
                    if (!config.ldapIdentity.url) {
                        valid = false;
                    }
                    if (!config.ldapIdentity.dnPattern) {
                        valid = false;
                    }
                    if (config.ldapIdentity.bindAs == 'ServiceAccount') {
                        if (!config.ldapIdentity.credentials || !config.ldapIdentity.credentials.username || !config.ldapIdentity.credentials.password) {
                            valid = false;
                        }
                        if (config.ldapIdentity.credentials) {
                            if (config.ldapIdentity.credentials.password != $scope.repeatPassword) {
                                valid = false;
                            }
                        }
                        if (!config.ldapIdentity.userSearch || !config.ldapIdentity.userSearch.baseDn || !config.ldapIdentity.userSearch.expression) {
                            valid = false;
                        }
                    }
                    if (config.ldapIdentity.extractRoles) {
                        if (!config.ldapIdentity.membershipAttribute) {
                            valid = false;
                        }
                        if (!config.ldapIdentity.rolenameAttribute) {
                            valid = false;
                        }
                    }
                }
                if (config.jdbcIdentity) {
                    if (config.jdbcIdentity.type == 'datasource' || !config.jdbcIdentity.type) {
                        if (!config.jdbcIdentity.datasourcePath) {
                            valid = false;
                        }
                    }
                    if (config.jdbcIdentity.type == 'url') {
                        if (!config.jdbcIdentity.jdbcUrl) {
                            valid = false;
                        }
                        if (!config.jdbcIdentity.username) {
                            valid = false;
                        }
                        if (config.jdbcIdentity.password) {
                            if (config.jdbcIdentity.password != $scope.jdbcPasswordVerify) {
                                valid = false;
                            }
                        }
                    }
                    if (!config.jdbcIdentity.query) {
                        valid = false;
                    }
                    if (config.jdbcIdentity.extractRoles && !config.jdbcIdentity.roleQuery) {
                        valid = false;
                    }
                }
                $scope.setValid(valid);
            };
            if ($scope.config && $scope.config.jdbcIdentity && !$scope.config.jdbcIdentity.type) {
                $scope.config.jdbcIdentity.type = 'datasource';
            }
            $scope.$watch('config', validate, true);
            $scope.$watch('jdbcPasswordVerify', function () {
                validate($scope.config);
            });
            $scope.$watch('repeatPassword', function () {
                validate($scope.config);
            });
            if ($scope.config) {
                if ($scope.config.staticIdentity) {
                    $scope.identitySourceType = 'static';
                }
                else if ($scope.config.ldapIdentity && $scope.config.ldapIdentity.url) {
                    $scope.identitySourceType = 'ldap';
                    if ($scope.config.ldapIdentity.credentials) {
                        $scope.repeatPassword = $scope.config.ldapIdentity.credentials.password;
                    }
                }
                else if ($scope.config.jdbcIdentity) {
                    $scope.identitySourceType = 'jdbc';
                    $scope.jdbcPasswordVerify = $scope.config.jdbcIdentity.password;
                }
            }
            $scope.$watch('identitySourceType', function (newValue) {
                if (newValue) {
                    if (newValue == 'static' && !$scope.config.staticIdentity) {
                        $scope.config.staticIdentity = new Object();
                        delete $scope.config.ldapIdentity;
                        delete $scope.config.jdbcIdentity;
                    }
                    else if (newValue == 'jdbc' && !$scope.config.jdbcIdentity) {
                        $scope.config.jdbcIdentity = new Object();
                        $scope.config.jdbcIdentity.type = 'datasource';
                        $scope.config.jdbcIdentity.hashAlgorithm = 'SHA1';
                        delete $scope.config.staticIdentity;
                        delete $scope.config.ldapIdentity;
                    }
                    else if (newValue == 'ldap' && !$scope.config.ldapIdentity) {
                        $scope.config.ldapIdentity = new Object();
                        $scope.config.ldapIdentity.bindAs = 'UserAccount';
                        delete $scope.config.staticIdentity;
                        delete $scope.config.jdbcIdentity;
                    }
                }
            });
            $scope.add = function (username, password) {
                var item = {
                    username: username,
                    password: password
                };
                if (!$scope.config.staticIdentity.identities) {
                    $scope.config.staticIdentity.identities = [];
                }
                $scope.remove([item]);
                $scope.config.staticIdentity.identities.push(item);
                $scope.selectedIdentity = [item];
                $scope.username = undefined;
                $scope.password = undefined;
                $('#username').focus();
            };
            $scope.remove = function (selectedIdentities) {
                angular.forEach(selectedIdentities, function (identity) {
                    var idx = -1;
                    angular.forEach($scope.config.staticIdentity.identities, function (item, index) {
                        if (item.username == identity.username) {
                            idx = index;
                        }
                    });
                    if (idx != -1) {
                        $scope.config.staticIdentity.identities.splice(idx, 1);
                    }
                });
                $scope.selectedIdentity = undefined;
            };
            $scope.clear = function () {
                $scope.config.staticIdentity.identities = [];
                $scope.selectedIdentity = undefined;
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
        }]);
    Apiman._module.controller('Apiman.AuthorizationFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                var valid = config.rules && config.rules.length > 0;
                if (!config.requestUnmatched) {
                    config.requestUnmatched = 'fail';
                }
                if (!config.multiMatch) {
                    config.multiMatch = 'all';
                }
                $scope.setValid(valid);
            };
            $scope.$watch('config', validate, true);
            $scope.currentItemInvalid = function () {
                return !$scope.path || !$scope.verb || !$scope.role || !Apiman.isRegexpValid($scope.path);
            };
            $scope.add = function (path, verb, role) {
                if (!$scope.config.rules) {
                    $scope.config.rules = [];
                }
                var rule = {
                    'verb': verb,
                    'pathPattern': path,
                    'role': role
                };
                $scope.config.rules.push(rule);
                $scope.path = undefined;
                $scope.role = undefined;
                $scope.resetVerbsSelector();
                $('#path').focus();
            };
            $scope.remove = function (selectedRule) {
                var idx = -1;
                angular.forEach($scope.config.rules, function (item, index) {
                    if (item == selectedRule) {
                        idx = index;
                    }
                });
                if (idx != -1) {
                    $scope.config.rules.splice(idx, 1);
                }
            };
            $scope.clear = function () {
                $scope.config.rules = [];
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
        }]);
    Apiman._module.controller('Apiman.CachingFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                var valid = false;
                if (config.ttl) {
                    config.ttl = Number(config.ttl);
                    // Check that TTL & Policy Definition ID are set
                    valid = ((config.ttl && config.ttl > 0) && ($scope.selectedDef && $scope.selectedDef.id != null));
                }
                $scope.setValid(valid);
            };
            $scope.$watch('config', validate, true);
            if (!$scope.config.statusCodes) {
                $scope.config.statusCodes = [];
            }
            $scope.add = function (statusCode) {
                $scope.remove(statusCode);
                $scope.config.statusCodes.push(statusCode);
                $scope.selectedStatusCode = [statusCode];
                $scope.statusCode = undefined;
                $('#status-code').focus();
            };
            $scope.remove = function (statusCodes) {
                angular.forEach(statusCodes, function (statusCode) {
                    var idx = -1;
                    angular.forEach($scope.config.statusCodes, function (item, index) {
                        if (item == statusCode) {
                            idx = index;
                        }
                    });
                    if (idx != -1) {
                        $scope.config.statusCodes.splice(idx, 1);
                    }
                });
                $scope.selectedStatusCode = undefined;
            };
            $scope.clear = function () {
                $scope.config.statusCodes = [];
                $scope.selectedStatusCode = undefined;
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
        }]);
    Apiman._module.controller('Apiman.CachingResourcesFormController', ['$scope', 'EntityStatusSvc',
            ($scope, EntityStatusSvc) => {
            let validate = function (config) {
                let valid = false;
                if (config.ttl) {
                    config.ttl = Number(config.ttl);
                    // Check that TTL & Policy Definition ID are set
                    valid = ((config.ttl && config.ttl > 0) && ($scope.selectedDef && $scope.selectedDef.id != null));
                    valid = valid && config.cachingResourcesSettingsEntries && config.cachingResourcesSettingsEntries.length > 0;
                }
                $scope.setValid(valid);
            };
            $scope.currentItemInvalid = function () { return !$scope.pathPattern || !$scope.httpMethod || !$scope.statusCodeCaching || !Apiman.isRegexpValid($scope.path); };
            $scope.$watch('config', validate, true);
            if (!$scope.config.statusCodes) {
                $scope.config.statusCodes = [];
            }
            $scope.add = function (statusCode, pathPattern, httpMethod) {
                if (!$scope.config.cachingResourcesSettingsEntries) {
                    $scope.config.cachingResourcesSettingsEntries = [];
                }
                let cachingResourcesSetting = {
                    "statusCode": statusCode,
                    "pathPattern": pathPattern,
                    "httpMethod": httpMethod
                };
                $scope.config.cachingResourcesSettingsEntries.push(cachingResourcesSetting);
                $scope.pathPattern = undefined;
                $scope.httpMethod = undefined;
                $scope.statusCodeCaching = undefined;
            };
            $scope.remove = function (cachingResourceSetting) {
                $scope.config.cachingResourcesSettingsEntries.remove(cachingResourceSetting);
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            $scope.isPostRequestCached = function () {
                if ($scope.config.cachingResourcesSettingsEntries != null) {
                    return $scope.config.cachingResourcesSettingsEntries.some((e) => {
                        return e.httpMethod === "POST" || e.httpMethod === "*";
                    });
                }
                return false;
            };
        }]);
    Apiman._module.controller('Apiman.URLRewritingFormController', ['$scope', 'Logger', 'EntityStatusSvc',
            ($scope, Logger, EntityStatusSvc) => {
            var validate = function (config) {
                var valid = true;
                if (!config.fromRegex) {
                    valid = false;
                }
                else {
                    if (!Apiman.isRegexpValid(config.fromRegex)) {
                        valid = false;
                    }
                }
                if (!config.toReplacement) {
                    valid = false;
                }
                if (!config.processResponseBody &&
                    !config.processResponseHeaders &&
                    !config.processRequestHeaders &&
                    !config.processRequestUrl) {
                    valid = false;
                }
                $scope.setValid(valid);
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            $scope.$watch('config', validate, true);
        }]);
    Apiman._module.controller('Apiman.TimeRestrictedAccessFormController', ['$window', '$scope', 'Logger', 'EntityStatusSvc',
            ($window, $scope, Logger, EntityStatusSvc) => {
            var moment = $window.moment;
            var isoTimeFormat = "HH:mm:ss";
            var validate = function (config) {
                var valid = config.rules && config.rules.length > 0;
                $scope.setValid(valid);
            };
            $scope.weekdays = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];
            $scope.currentItemInvalid = function () {
                return !$scope.pathPattern || !$scope.timeStart ||
                    !$scope.timeEnd || !$scope.dayStart ||
                    !$scope.dayEnd || !Apiman.isRegexpValid($scope.path);
            };
            $scope.$watch('config', validate, true);
            $scope.add = function () {
                if (!$scope.config.rules) {
                    $scope.config.rules = [];
                }
                var timeStart = moment($scope.timeStart).utc().format(isoTimeFormat);
                var timeEnd = moment($scope.timeEnd).utc().format(isoTimeFormat);
                var rule = {
                    'timeStart': timeStart,
                    'timeEnd': timeEnd,
                    'dayStart': $scope.getDayIndex($scope.dayStart),
                    'dayEnd': $scope.getDayIndex($scope.dayEnd),
                    'pathPattern': $scope.pathPattern
                };
                $scope.config.rules.push(rule);
                $scope.resetModel();
                $('#path').focus();
            };
            $scope.remove = function (selectedRule) {
                var idx = -1;
                angular.forEach($scope.config.rules, function (item, index) {
                    if (item == selectedRule) {
                        idx = index;
                    }
                });
                if (idx != -1) {
                    $scope.config.rules.splice(idx, 1);
                }
            };
            $scope.resetModel = function () {
                $scope.timeStart = $window.moment("8:00", "hh:mm").toDate();
                $scope.timeEnd = $window.moment("16:00", "hh:mm").toDate();
                $scope.dayStart = $scope.weekdays[0];
                $scope.dayEnd = $scope.weekdays[4];
                $scope.selectedPath = undefined;
            };
            $scope.resetModel();
            $scope.formatToTime = function (time) {
                return moment.utc(time, isoTimeFormat).local().format("HH:mm");
            };
            $scope.getDayIndex = function (day) {
                return $scope.weekdays.indexOf(day) + 1;
            };
            $scope.getDayForIndex = function (index) {
                return $scope.weekdays[index - 1];
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
        }]);
})(Apiman || (Apiman = {}));

var Apiman;
(function (Apiman) {
    Apiman.ManagerRestApiDefController = Apiman._module.controller("Apiman.ManagerRestApiDefController", ['$q', '$rootScope', '$scope', 'PageLifecycle', 'Configuration',
            ($q, $rootScope, $scope, PageLifecycle, Configuration) => {
            PageLifecycle.loadPage('MangerRestApiDef', undefined, undefined, $scope, function () {
                PageLifecycle.setPageTitle('manager-rest-def');
                $scope.definitionUrl = Configuration.api.endpoint + '/swagger.yaml';
                if (SwaggerUIBundle) {
                    $scope.definitionStatus = 'loading';
                    let ui;
                    let swaggerOptions = {
                        url: $scope.definitionUrl,
                        dom_id: "#swagger-ui-container",
                        validatorUrl: "https://online.swagger.io/validator",
                        presets: [
                            SwaggerUIBundle.presets.apis
                        ],
                        layout: "BaseLayout",
                        sorter: "alpha",
                        requestInterceptor: function (request) {
                            // Send keycloak token
                            request.headers.Authorization = Configuration.getAuthorizationHeader();
                            return request;
                        },
                        onComplete: function () {
                            $scope.$apply(function () {
                                $scope.definitionStatus = 'complete';
                            });
                        },
                        // do error handling in the responseInterceptor
                        responseInterceptor: function (response) {
                            if (response.status == 500 && response.ok === false) {
                                $scope.$apply(function () {
                                    $scope.definitionStatus = 'error';
                                    $scope.hasError = true;
                                });
                            }
                            return response;
                        }
                    };
                    ui = SwaggerUIBundle(swaggerOptions);
                    $scope.hasDefinition = true;
                }
                else {
                    $scope.hasDefinition = false;
                }
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.SidebarController = Apiman._module.controller("Apiman.SidebarController", ['$scope', 'Logger', 'Configuration', ($scope, Logger, Configuration) => {
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../../includes.ts"/>
var ApimanTranslation;
(function (ApimanTranslation) {
    ApimanTranslation._module = angular.module("ApimanTranslation", []);
    ApimanTranslation.Translation = ApimanTranslation._module.factory('TranslationSvc', ['$window',
        function ($window) {
            return {
                translate: function (key, defaultValue) {
                    var translation = undefined;
                    if ($window.APIMAN_TRANSLATION_DATA && $window.APIMAN_TRANSLATION_DATA[key]) {
                        translation = $window.APIMAN_TRANSLATION_DATA[key];
                    }
                    else {
                        translation = defaultValue;
                    }
                    return translation;
                }
            };
        }]);
})(ApimanTranslation || (ApimanTranslation = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.AdminRolesController = Apiman._module.controller("Apiman.AdminExportImportController", ['$q', '$scope', 'SystemSvcs', 'DownloadSvcs', 'PageLifecycle', 'Logger', '$window',
            ($q, $scope, SystemSvcs, DownloadSvcs, PageLifecycle, Logger, $window) => {
            $scope.tab = 'export';
            var pageData = {};
            $scope.importStatus = 'none';
            $scope.exportStatus = 'none';
            $scope.doExport = function () {
                $scope.exportButton.state = 'in-progress';
                Logger.info('Starting download of export data.');
                SystemSvcs.exportAsJson(function (download) {
                    Logger.info('Download: {0}', download);
                    var downloadLink = DownloadSvcs.getDownloadLink(download.id);
                    Logger.info('Downloading export data from: {0}', downloadLink);
                    $scope.exportStatus = 'downloading';
                    $window.open(downloadLink, "_self");
                }, PageLifecycle.handleError);
            };
            $scope.doImport = function (file) {
                Logger.info('Uploading file for import.');
                $scope.importStatus = 'uploading';
                $scope.uploadPercentage = 0;
                SystemSvcs.importJson(file, function (progress) {
                    var perc = (100.0 * Number(progress.loaded)) / Number(progress.total);
                    perc = (~~perc) + 1;
                    if (perc >= 100) {
                        perc = 100;
                        $scope.importStatus = 'importing';
                    }
                    $scope.uploadPercentage = perc;
                    Logger.info('Upload perc: {0}', perc);
                }, function (response) {
                    Logger.info('Import file successfully uploaded (and imported?).');
                    $scope.importResult = response.data;
                    $scope.importStatus = 'imported';
                }, function (error) {
                    $scope.importError = error;
                    $scope.importStatus = 'error';
                });
            };
            $scope.selectFile = function (files) {
                if (files && files.length) {
                    $scope.importFile = files[0];
                }
            };
            PageLifecycle.loadPage('AdminExport', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('admin-export');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.AdminGatewaysController = Apiman._module.controller("Apiman.AdminGatewaysController", ['$q', '$scope', 'ApimanSvcs', 'PageLifecycle', ($q, $scope, ApimanSvcs, PageLifecycle) => {
            $scope.tab = 'gateways';
            var pageData = {
                gateways: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'gateways' }, function (adminGateways) {
                        resolve(adminGateways);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('AdminGateways', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('admin-gateways');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.AdminPluginsController = Apiman._module.controller("Apiman.AdminPluginsController", ['$q', '$scope', 'Modals', 'ApimanSvcs', 'PageLifecycle', 'Logger',
            ($q, $scope, Modals, ApimanSvcs, PageLifecycle, Logger) => {
            $scope.tab = 'plugins';
            $scope.filterAvailablePlugins = function (value) {
                if (!value) {
                    $scope.filteredAvailablePlugins = $scope.availablePlugins;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.availablePlugins, function (plugin) {
                        if (plugin.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(plugin);
                        }
                    });
                    $scope.filteredAvailablePlugins = filtered;
                }
            };
            var pageData = {
                plugins: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'plugins' }, function (plugins) {
                        angular.forEach(plugins, function (p) {
                            p.isSnapshot = p.version.indexOf("-SNAPSHOT", this.length - "-SNAPSHOT".length) !== -1;
                        });
                        resolve(plugins);
                    }, reject);
                }),
                availablePlugins: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'plugins', secondaryType: 'availablePlugins' }, function (plugins) {
                        $scope.filteredAvailablePlugins = plugins;
                        resolve(plugins);
                    }, reject);
                })
            };
            var getInstalledPlugin = function (plugin) {
                var rval = null;
                angular.forEach($scope.plugins, function (p) {
                    if (plugin.groupId == p.groupId && plugin.artifactId == p.artifactId) {
                        rval = p;
                    }
                });
                return rval;
            };
            var removePlugin = function (plugin) {
                var index = -1;
                var i = 0;
                angular.forEach($scope.plugins, function (p, i) {
                    if (p === plugin) {
                        index = i;
                    }
                });
                if (index >= 0) {
                    $scope.plugins.splice(index, 1);
                }
            };
            $scope.uninstallPlugin = function (plugin) {
                plugin.deleting = true;
                Modals.confirm('Confirm Uninstall Plugin', 'Do you really want to uninstall this plugin?  Any policies it provided will no longer be available.', function () {
                    ApimanSvcs.delete({ entityType: 'plugins', secondaryType: plugin.id }, function (reply) {
                        removePlugin(plugin);
                        refreshPlugins();
                    }, PageLifecycle.handleError);
                }, function () {
                    plugin.deleting = false;
                });
            };
            $scope.upgradePlugin = function (plugin) {
                Modals.getValue('Confirm Upgrade Plugin', 'Do you really want to upgrade this plugin?  Any published APIs already using the plugin will continue to use the old version.  All new policies will use the newly upgraded version.', 'New Plugin Version', plugin.latestVersion, function (value) {
                    var uplugin = {
                        groupId: plugin.groupId,
                        artifactId: plugin.artifactId,
                        classifier: plugin.classifier,
                        type: plugin.type,
                        version: value,
                        upgrade: true
                    };
                    plugin.upgrading = true;
                    ApimanSvcs.save({ entityType: 'plugins' }, uplugin, function (reply) {
                        delete plugin.upgrading;
                        plugin.version = value;
                        refreshPlugins();
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                });
            };
            var refreshPlugins = function () {
                angular.forEach($scope.plugins, function (ip) {
                    delete ip.latestVersion;
                    ip.hasAvailableVersion = false;
                    ip.canUpgrade = true;
                });
                angular.forEach($scope.availablePlugins, function (plugin) {
                    var ip = getInstalledPlugin(plugin);
                    if (ip) {
                        plugin.isInstalled = true;
                        plugin.installedVersion = ip.version;
                        ip.latestVersion = plugin.version;
                        ip.canUpgrade = plugin.version != ip.version;
                        ip.hasAvailableVersion = true;
                    }
                    else {
                        plugin.isInstalled = false;
                        delete plugin.installedVersion;
                    }
                });
            };
            PageLifecycle.loadPage('AdminPlugins', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('admin-plugins');
                refreshPlugins();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.AdminPolicyDefsController = Apiman._module.controller("Apiman.AdminPolicyDefsController", ['$q', '$scope', 'ApimanSvcs', 'PageLifecycle', ($q, $scope, ApimanSvcs, PageLifecycle) => {
            $scope.tab = 'policyDefs';
            $scope.filterPolicies = function (value) {
                if (!value) {
                    $scope.filteredPolicyDefs = $scope.policyDefs;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.policyDefs, function (policyDef) {
                        if (policyDef.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(policyDef);
                        }
                    });
                    $scope.filteredPolicyDefs = filtered;
                }
            };
            var pageData = {
                policyDefs: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'policyDefs' }, function (policyDefs) {
                        $scope.filteredPolicyDefs = policyDefs;
                        resolve(policyDefs);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('AdminPolicyDefs', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('admin-policyDefs');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.AdminRolesController = Apiman._module.controller("Apiman.AdminRolesController", ['$q', '$scope', 'ApimanSvcs', 'PageLifecycle',
            ($q, $scope, ApimanSvcs, PageLifecycle) => {
            $scope.tab = 'roles';
            $scope.filterRoles = function (value) {
                if (!value) {
                    $scope.filteredRoles = $scope.roles;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.roles, function (role) {
                        if (role.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(role);
                        }
                    });
                    $scope.filteredRoles = filtered;
                }
            };
            var pageData = {
                roles: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'roles' }, function (adminRoles) {
                        $scope.filteredRoles = adminRoles;
                        resolve(adminRoles);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('AdminRoles', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('admin-roles');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiActivityController = Apiman._module.controller("Apiman.ApiActivityController", ['$q', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', 'AuditSvcs', '$routeParams', 'Configuration',
            ($q, $scope, $location, PageLifecycle, ApiEntityLoader, AuditSvcs, $routeParams, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'activity';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var getNextPage = function (successHandler, errorHandler) {
                $scope.currentPage = $scope.currentPage + 1;
                AuditSvcs.get({ organizationId: params.org, entityType: 'apis', entityId: params.api, page: $scope.currentPage, count: 20 }, function (results) {
                    var entries = results.beans;
                    successHandler(entries);
                }, errorHandler);
            };
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                auditEntries: $q(function (resolve, reject) {
                    $scope.currentPage = 0;
                    getNextPage(resolve, reject);
                })
            });
            $scope.getNextPage = getNextPage;
            PageLifecycle.loadPage('ApiActivity', 'apiView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('api-activity', [$scope.api.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiContractsController = Apiman._module.controller("Apiman.ApiContractsController", ['$q', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', 'OrgSvcs', 'Logger', '$routeParams', 'Configuration',
            ($q, $scope, $location, PageLifecycle, ApiEntityLoader, OrgSvcs, Logger, $routeParams, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'contracts';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var getNextPage = function (successHandler, errorHandler) {
                var maxCount = 10;
                $scope.currentPage = $scope.currentPage + 1;
                OrgSvcs.query({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'contracts', page: $scope.currentPage, count: maxCount }, function (contracts) {
                    if (contracts.length == maxCount) {
                        $scope.hasMore = true;
                    }
                    else {
                        $scope.hasMore = false;
                    }
                    successHandler(contracts);
                }, errorHandler);
            };
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                contracts: $q(function (resolve, reject) {
                    $scope.currentPage = 0;
                    getNextPage(resolve, reject);
                })
            });
            $scope.getNextPage = getNextPage;
            PageLifecycle.loadPage('ApiContracts', 'apiView', pageData, $scope, function () {
                Logger.debug("::: is public: {0}", $scope.version.publicAPI);
                if ($scope.version.publicAPI) {
                    Logger.debug("::: num plans: {0}", $scope.version.plans.length);
                    if ($scope.version.plans.length == 0) {
                        $scope.isPublicOnly = true;
                    }
                }
                PageLifecycle.setPageTitle('api-contracts', [$scope.api.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiDefController = Apiman._module.controller('Apiman.ApiDefController', ['$q', '$rootScope', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', 'OrgSvcs', 'Logger', '$routeParams', 'ApiDefinitionSvcs', 'Configuration', 'EntityStatusSvc', 'CurrentUser',
            ($q, $rootScope, $scope, $location, PageLifecycle, ApiEntityLoader, OrgSvcs, Logger, $routeParams, ApiDefinitionSvcs, Configuration, EntityStatusSvc, CurrentUser) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'def';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            $scope.textAreaHeight = '100';
            $scope.typeOptions = [
                { "label": "No API Definition", "value": "None" },
                { "label": "Swagger (JSON)", "value": "SwaggerJSON" },
                { "label": "Swagger (YAML)", "value": "SwaggerYAML" },
                { "label": "WSDL", "value": "WSDL" }
            ];
            var selectType = function (newType) {
                angular.forEach($scope.typeOptions, function (option) {
                    if (option.value == newType) {
                        $scope.selectedDefinitionType = option;
                    }
                });
            };
            selectType('None');
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            $scope.saveApi = function () {
                console.log('$scope.selectedDefinitionType.value: ' + $scope.selectedDefinitionType.value);
                $scope.saveButton.state = 'in-progress';
                ApiDefinitionSvcs.updateApiDefinition(params.org, params.api, params.version, $scope.updatedApiDefinition, $scope.selectedDefinitionType.value, function (definition) {
                    Logger.debug("Updated the api definition!");
                    $scope.apiDefinition = $scope.updatedApiDefinition;
                    $rootScope.isDirty = false;
                    $scope.saveButton.state = 'complete';
                }, function (error) {
                    Logger.error("Error updating definition: {0}", error);
                    $scope.saveButton.state = 'error';
                });
            };
            $scope.$on('afterdrop', function (event, data) {
                let newValue = data.value;
                if (newValue) {
                    if (newValue.lastIndexOf('{', 0) === 0) {
                        $scope.$apply(function () {
                            selectType('SwaggerJSON');
                        });
                    }
                    else if (newValue.lastIndexOf('<', 0) === 0) {
                        $scope.$apply(function () {
                            selectType('WSDL');
                        });
                    }
                    else {
                        $scope.$apply(function () {
                            selectType('SwaggerYAML');
                        });
                    }
                }
            });
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            var loadDefinition = function () {
                ApiDefinitionSvcs.getApiDefinition(params.org, params.api, params.version, function (definition) {
                    $scope.apiDefinition = definition;
                    $scope.updatedApiDefinition = definition;
                }, function (error) {
                    Logger.error("Error loading definition: {0}", error);
                });
            };
            let loadDefinitionUrl = function () {
                $scope.apimanDefinitionUrl = ApiDefinitionSvcs.getApimanDefinitionUrl(params.org, params.api, params.version);
            };
            var checkDirty = function () {
                if ($scope.version) {
                    var dirty = false;
                    Logger.debug("Model def type: {1}   UI Def type: {0}", $scope.definitionType, $scope.selectedDefinitionType.value);
                    if ($scope.apiDefinition != $scope.updatedApiDefinition) {
                        Logger.debug("**** dirty because of api def");
                        dirty = true;
                    }
                    if ($scope.selectedDefinitionType.value != $scope.definitionType) {
                        Logger.debug("**** dirty because of def type: {0} != {1}", $scope.selectedDefinitionType.value, $scope.definitionType);
                        dirty = true;
                    }
                    $rootScope.isDirty = dirty;
                }
            };
            $scope.$watch('updatedApi', checkDirty, true);
            $scope.$watch('updatedApiDefinition', function (newValue, oldValue) {
                if (!newValue && !oldValue) {
                    return;
                }
                checkDirty();
            });
            $scope.$watch('selectedDefinitionType', checkDirty, true);
            $scope.reset = function () {
                selectType($scope.definitionType);
                $scope.updatedApiDefinition = $scope.apiDefinition;
                $scope.updatedApiDefinitionUrl = $scope.version.definitionUrl;
                $rootScope.isDirty = false;
            };
            $scope.downloadDefinition = function () {
                let element = document.createElement('a');
                element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent($scope.apiDefinition));
                let fileName = $scope.api.id + '-' + $scope.version.version + '-' + $scope.definitionType;
                let fileExtension = '.json';
                if ($scope.definitionType == 'SwaggerYAML') {
                    fileExtension = '.yaml';
                }
                else if ($scope.definitionType == 'WSDL') {
                    fileExtension = '.xml';
                }
                element.setAttribute('download', fileName + fileExtension);
                element.style.display = 'none';
                document.body.appendChild(element);
                element.click();
                document.body.removeChild(element);
            };
            $scope.updateDefinitionFromUrl = function () {
                let definitionUrl = $scope.updatedApiDefinitionUrl;
                let definitionType = $scope.selectedDefinitionType.value;
                ApiDefinitionSvcs.updateApiDefinitionFromUrl(params.org, params.api, params.version, definitionUrl, definitionType, function () {
                    Logger.debug("Updated the api definition!");
                    loadDefinition();
                    $rootScope.isDirty = false;
                    $scope.saveButton.state = 'complete';
                }, function (error) {
                    Logger.error("Error updating definition: {0}", error);
                    $scope.saveButton.state = 'error';
                });
            };
            PageLifecycle.loadPage('ApiDef', 'apiView', pageData, $scope, function () {
                $scope.definitionType = $scope.version.definitionType;
                $scope.updatedApiDefinitionUrl = $scope.version.definitionUrl;
                if (!$scope.definitionType) {
                    $scope.definitionType = 'None';
                }
                if ($scope.version.definitionType && $scope.version.definitionType != 'None' && $scope.version.definitionType != 'External') {
                    loadDefinition();
                    loadDefinitionUrl();
                }
                else {
                    Logger.debug("Skipped loading api definition - None defined.");
                }
                $scope.reset();
                PageLifecycle.setPageTitle('api-def', [$scope.api.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiEndpointController = Apiman._module.controller("Apiman.ApiEndpointController", ['$q', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', 'OrgSvcs', 'ApimanSvcs', '$routeParams', 'Configuration', 'EntityStatusSvc',
            ($q, $scope, $location, PageLifecycle, ApiEntityLoader, OrgSvcs, ApimanSvcs, $routeParams, Configuration, EntityStatusSvc) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'endpoint';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                managedEndpoint: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'endpoint' }, resolve, reject);
                })
            });
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            // Tooltip
            // Initiates the tooltip (this is required for performance reasons)
            $(function () {
                $('[data-toggle="tooltip"]').tooltip();
            });
            // Called if copy-to-clipboard functionality was successful
            $scope.copySuccess = function () {
                //console.log('Copied!');
            };
            // Called if copy-to-clipboard functionality was unsuccessful
            $scope.copyFail = function (err) {
                //console.error('Error!', err);
            };
            // Called on clicking the button the tooltip is attached to
            $scope.tooltipChange = function () {
                $('[data-toggle="tooltip"]').attr('data-original-title', 'Copied!');
                // This is a workaround for jQuery + TS not playing well together
                $('[data-toggle="tooltip"]').tooltip('show');
            };
            // Call when the mouse leaves the button the tooltip is attached to
            $scope.tooltipReset = function () {
                $('[data-toggle="tooltip"]').attr('data-original-title', 'Copy to clipboard');
            };
            PageLifecycle.loadPage('ApiEndpoint', 'apiView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('api-endpoint', [$scope.api.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiImplController = Apiman._module.controller("Apiman.ApiImplController", ['$q', '$rootScope', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', 'OrgSvcs', 'ApimanSvcs', '$routeParams', 'EntityStatusSvc', 'Logger', 'Configuration',
            ($q, $rootScope, $scope, $location, PageLifecycle, ApiEntityLoader, OrgSvcs, ApimanSvcs, $routeParams, EntityStatusSvc, Logger, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'impl';
            $scope.version = params.version;
            $scope.typeOptions = ["rest", "soap"];
            $scope.contentTypeOptions = ["json", "xml"];
            $scope.updatedApi = new Object();
            $scope.apiSecurity = new Object();
            $scope.showMetrics = Configuration.ui.metrics;
            $scope.saved = false;
            $scope.saving = false;
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            if (params.version != null) {
                pageData = angular.extend(pageData, {
                    gateways: $q(function (resolve, reject) {
                        ApimanSvcs.query({ entityType: 'gateways' }, resolve, reject);
                    })
                });
            }
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            // API Security Type Options
            $scope.apiSecurityTypeOptions = [
                {
                    label: 'None',
                    i18nKey: 'none',
                    type: 'none'
                },
                {
                    label: 'MTLS/Two-Way-SSL',
                    i18nKey: 'mtls',
                    type: 'mtls'
                },
                {
                    label: 'BASIC Authentication',
                    i18nKey: 'basic-auth',
                    type: 'basic'
                }
            ];
            var epValue = function (endpointProperties, key) {
                if (endpointProperties && endpointProperties[key]) {
                    return endpointProperties[key];
                }
                else {
                    return null;
                }
            };
            var toApiSecurity = function (version) {
                var rval = {};
                rval.type = version.endpointProperties['authorization.type'];
                if (!rval.type) {
                    rval.type = 'none';
                }
                if (rval.type == 'mssl') {
                    rval.type = 'mtls';
                }
                if (rval.type == 'basic') {
                    rval.basic = {
                        username: epValue(version.endpointProperties, 'basic-auth.username'),
                        password: epValue(version.endpointProperties, 'basic-auth.password'),
                        confirmPassword: epValue(version.endpointProperties, 'basic-auth.password'),
                        requireSSL: 'true' === epValue(version.endpointProperties, 'basic-auth.requireSSL')
                    };
                }
                return rval;
            };
            var toEndpointProperties = function (apiSecurity) {
                var rval = {};
                if (apiSecurity.type == 'none') {
                    return rval;
                }
                rval['authorization.type'] = apiSecurity.type;
                if (apiSecurity.type == 'basic' && apiSecurity.basic) {
                    rval['basic-auth.username'] = apiSecurity.basic.username;
                    rval['basic-auth.password'] = apiSecurity.basic.password;
                    if (apiSecurity.basic.requireSSL) {
                        rval['basic-auth.requireSSL'] = 'true';
                    }
                    else {
                        rval['basic-auth.requireSSL'] = 'false';
                    }
                }
                return rval;
            };
            // Validates depending on the endpoint type selected
            $scope.checkValid = function () {
                var valid = true;
                if (!$scope.updatedApi.endpoint) {
                    valid = false;
                }
                if (!$scope.updatedApi.endpointType) {
                    valid = false;
                }
                if ($scope.apiSecurity.type == 'basic' && $scope.apiSecurity.basic) {
                    if (!$scope.apiSecurity.basic.password) {
                        valid = false;
                    }
                    if ($scope.apiSecurity.basic.password != $scope.apiSecurity.basic.confirmPassword) {
                        valid = false;
                    }
                }
                else if ($scope.apiSecurity.type == 'basic' && !$scope.apiSecurity.basic) {
                    valid = false;
                }
                $scope.isValid = valid;
                return valid;
            };
            // This function checks for changes to the updateApi model
            // and compares the new value to the original value. If they are all the same,
            // the Save button will remain disabled.
            $scope.$watch('updatedApi', function (newValue) {
                if ($scope.version) {
                    var dirty = false;
                    if (newValue.endpoint != $scope.version.endpoint) {
                        dirty = true;
                    }
                    if (newValue.endpointType != $scope.version.endpointType) {
                        dirty = true;
                    }
                    if (newValue.endpointContentType != $scope.version.endpointContentType) {
                        dirty = true;
                    }
                    if (newValue.parsePayload != $scope.version.parsePayload) {
                        dirty = true;
                    }
                    if (newValue.disableKeysStrip != $scope.version.disableKeysStrip) {
                        dirty = true;
                    }
                    if (newValue.gateways && newValue.gateways.length > 0) {
                        dirty = true;
                    }
                    if ($scope.version.endpointProperties && newValue.endpointProperties) {
                        if (!angular.equals($scope.version.endpointProperties, newValue.endpointProperties)) {
                            Logger.debug('Dirty due to EP:');
                            Logger.debug('    $scope.version:    {0}', $scope.version);
                            Logger.debug('    $scope.version.EP: {0}', $scope.version.endpointProperties);
                            Logger.debug('    newValue.EP:       {0}', newValue.endpointProperties);
                            dirty = true;
                        }
                    }
                    $scope.checkValid();
                    $rootScope.isDirty = dirty;
                }
            }, true);
            $scope.$watch('apiSecurity', function (newValue) {
                if (newValue) {
                    $scope.updatedApi.endpointProperties = toEndpointProperties(newValue);
                    $scope.checkValid();
                }
            }, true);
            // Used, as you'd guess, to compare originally selected values to new values
            function arraysAreEqual(one, two) {
                return (one.join('') == two.join(''));
            }
            $scope.$watch('selectedGateways', function (newValue) {
                if (newValue) {
                    var alreadySet = false;
                    var newSelectedArray = [];
                    // Iterate over each selected value, push into an empty array with proper formatting
                    for (var i = 0; i < newValue.length; i++) {
                        newSelectedArray.push({ gatewayId: newValue[i].id });
                    }
                    // Will need to compare newly selected gateways to available gateways again
                    // by plucking gatewayId values, inserting into an array, and comparing them
                    var pluckedAfter = _.map(newSelectedArray, 'gatewayId');
                    var pluckedBefore = _.map($scope.version.gateways, 'gatewayId');
                    var compare = arraysAreEqual(pluckedAfter, pluckedBefore);
                    if (compare === true) {
                        alreadySet = true;
                    }
                    if (!alreadySet) {
                        $scope.updatedApi.gateways = newSelectedArray;
                    }
                    else {
                        delete $scope.updatedApi.gateways;
                    }
                }
            });
            $scope.setEndpointProperties = function (newValue) {
                if (newValue) {
                    $scope.updatedApi.endpointProperties = toEndpointProperties(newValue);
                    $scope.checkValid();
                }
            };
            $scope.reset = function () {
                if (!$scope.version.endpointType) {
                    $scope.version.endpointType = 'rest';
                }
                if (!$scope.version.endpointContentType) {
                    $scope.version.endpointContentType = 'json';
                }
                $scope.apiSecurity = toApiSecurity($scope.version);
                $scope.updatedApi.endpoint = $scope.version.endpoint;
                $scope.updatedApi.endpointType = $scope.version.endpointType;
                $scope.updatedApi.endpointContentType = $scope.version.endpointContentType;
                $scope.updatedApi.endpointProperties = angular.copy($scope.version.endpointProperties);
                $scope.updatedApi.parsePayload = $scope.version.parsePayload;
                $scope.updatedApi.disableKeysStrip = $scope.version.disableKeysStrip;
                // Gateway Handling
                delete $scope.updatedApi.gateways;
                $scope.selectedGateways = [];
                // Match up currently associated gateways for this API with available gateways
                // to provide additional information, other than just the ID, about each gateway
                if ($scope.version.gateways && $scope.version.gateways.length > 0) {
                    for (var i = 0; i < $scope.gateways.length; i++) {
                        for (var j = 0; j < $scope.version.gateways.length; j++) {
                            // Check if IDs match
                            if ($scope.gateways[i].id === $scope.version.gateways[j].gatewayId) {
                                // Add gateway to selected gateway array
                                $scope.selectedGateways.push($scope.gateways[i]);
                            }
                        }
                    }
                }
                $rootScope.isDirty = false;
                // Automatically set the selected gateway if there's only one and the
                // gateway is not already set.
                if ((!$scope.version.gateways || $scope.version.gateways.length == 0)
                    && ($scope.gateways && $scope.gateways.length === 1)) {
                    $scope.autoGateway = true;
                    $scope.selectedGateways[0] = $scope.gateways[0];
                }
            };
            $scope.saveApi = function () {
                $scope.invalidEndpoint = false;
                $scope.saving = true;
                OrgSvcs.update({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: params.version }, $scope.updatedApi, function (reply) {
                    $rootScope.isDirty = false;
                    $scope.autoGateway = false;
                    $scope.saved = true;
                    $scope.saving = false;
                    $scope.version = reply;
                    EntityStatusSvc.setEntityStatus(reply.status);
                }, PageLifecycle.handleError);
            };
            // Endpoint Validation
            $scope.invalidEndpoint = false;
            $scope.validateEndpoint = function () {
                var first7 = $scope.updatedApi.endpoint.substring(0, 7);
                var first8 = $scope.updatedApi.endpoint.substring(0, 8);
                var re = new RegExp('^(http|https):\/\/', 'i');
                // Test first 7 letters for http:// first
                if (re.test(first7) === true) {
                    $scope.saveApi();
                }
                else {
                    // If it fails, test first 8 letters for https:// next
                    if (re.test(first8) === true) {
                        $scope.saveApi();
                    }
                    else {
                        console.log('Invalid input.');
                        $scope.invalidEndpoint = true;
                    }
                }
            };
            PageLifecycle.loadPage('ApiImpl', 'apiView', pageData, $scope, function () {
                $scope.reset();
                PageLifecycle.setPageTitle('api-impl', [$scope.api.name]);
                // $scope.gateways - list of available gateways
                // $scope.version.gateways - list of gateways for this specific version
                // $scope.selectedGateway - list of currently selected gateways (with `name`, `ID`, etc.)
                // $scope.updatedApi.gateways - what we submit to the API, with only the `gatewayId`
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NINETY_DAYS = 90 * 24 * 60 * 60 * 1000;
    Apiman.THIRTY_DAYS = 30 * 24 * 60 * 60 * 1000;
    Apiman.SEVEN_DAYS = 7 * 24 * 60 * 60 * 1000;
    Apiman.ONE_DAY = 1 * 24 * 60 * 60 * 1000;
    Apiman.ONE_HOUR = 1 * 60 * 60 * 1000;
    Apiman.ApiMetricsController = Apiman._module.controller("Apiman.ApiMetricsController", ['$q', 'Logger', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', 'OrgSvcs', 'MetricsSvcs', '$routeParams', '$timeout', 'Configuration',
            ($q, Logger, $scope, $location, PageLifecycle, ApiEntityLoader, OrgSvcs, MetricsSvcs, $routeParams, $timeout, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'metrics';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            $scope.metricsRange = '7days';
            $scope.metricsType = 'usage';
            var usageChart, usageByClientChart, usageByPlanChart;
            var responseTypeChart, responseTypeSuccessChart, responseTypeFailuresChart, responseTypeErrorsChart;
            var getTimeSeriesFormat = function () {
                var format = '%Y-%m-%d';
                if ($scope.metricsRange == '7days' || $scope.metricsRange == '24hours' || $scope.metricsRange == 'hour') {
                    format = '%H:%M';
                }
                return format;
            };
            var renderUsageChart = function (data) {
                var xcol = [];
                xcol.push('x');
                var reqCol = ['# Requests'];
                angular.forEach(data.data, function (dataPoint) {
                    xcol.push(Date.parse(dataPoint.label));
                    reqCol.push(dataPoint.count);
                });
                if (xcol.length == 1) {
                    $scope.usageChartNoData = true;
                }
                else {
                    Logger.log("======= xcol: " + JSON.stringify(xcol));
                    Logger.log("======= reqs: " + JSON.stringify(reqCol));
                    usageChart = c3.generate({
                        size: {
                            height: 200
                        },
                        data: {
                            x: 'x',
                            columns: [
                                xcol,
                                reqCol
                            ],
                            types: {
                                '# Requests': 'bar'
                            }
                        },
                        bindto: '#usage-chart',
                        legend: {
                            hide: true
                        },
                        axis: {
                            x: {
                                type: 'timeseries',
                                tick: {
                                    format: getTimeSeriesFormat()
                                }
                            },
                            y: {
                                label: 'Total Requests'
                            }
                        }
                    });
                }
            };
            var renderClientUsageChart = function (data) {
                var columns = [];
                angular.forEach(data.data, function (numRequests, clientName) {
                    columns.push([clientName, numRequests]);
                });
                if (columns.length == 0) {
                    $scope.clientUsageChartNoData = true;
                }
                else {
                    usageByClientChart = c3.generate({
                        size: {
                            height: 250
                        },
                        data: {
                            columns: columns,
                            type: 'pie'
                        },
                        bindto: '#client-usage-chart'
                    });
                }
            };
            var renderPlanUsageChart = function (data) {
                var columns = [];
                angular.forEach(data.data, function (numRequests, planName) {
                    columns.push([planName, numRequests]);
                });
                if (columns.length == 0) {
                    $scope.planUsageChartNoData = true;
                }
                else {
                    usageByPlanChart = c3.generate({
                        size: {
                            height: 250
                        },
                        data: {
                            columns: columns,
                            type: 'pie'
                        },
                        bindto: '#plan-usage-chart'
                    });
                }
            };
            var renderResponseTypeHistogramChart = function (data) {
                var xcol = [];
                xcol.push('x');
                var successCol = ['Success'];
                var failureCol = ['Fail'];
                var errorCol = ['Error'];
                angular.forEach(data.data, function (dataPoint) {
                    xcol.push(Date.parse(dataPoint.label));
                    successCol.push((dataPoint.total - dataPoint.failures - dataPoint.errors).toString());
                    failureCol.push(dataPoint.failures);
                    errorCol.push(dataPoint.errors);
                });
                if (xcol.length == 1) {
                    $scope.responseTypeChartNoData = true;
                }
                else {
                    Logger.log("======= xcol: " + JSON.stringify(xcol));
                    Logger.log("======= successCol: " + JSON.stringify(successCol));
                    Logger.log("======= failureCol: " + JSON.stringify(failureCol));
                    Logger.log("======= errorCol: " + JSON.stringify(errorCol));
                    responseTypeChart = c3.generate({
                        size: {
                            height: 200
                        },
                        data: {
                            x: 'x',
                            columns: [
                                xcol, successCol, failureCol, errorCol
                            ],
                            colors: {
                                'Success': '#71B56E',
                                'Fail': '#E37B4F',
                                'Error': '#E34F4F',
                            },
                            types: {
                                'Success': 'bar',
                                'Fail': 'bar',
                                'Error': 'bar',
                            },
                            groups: [
                                ['Success', 'Fail', 'Error']
                            ]
                        },
                        bindto: '#responseType-chart',
                        axis: {
                            x: {
                                type: 'timeseries',
                                tick: {
                                    format: getTimeSeriesFormat()
                                }
                            },
                            y: {
                                label: 'Responses'
                            }
                        }
                    });
                }
            };
            var renderResponseTypeSummaryCharts = function (data) {
                var total = data.total;
                var success = data.total - data.failures - data.errors;
                var failures = data.failures;
                var errors = data.errors;
                responseTypeSuccessChart = c3.generate({
                    size: {
                        height: 150
                    },
                    data: {
                        columns: [
                            ['data', success]
                        ],
                        colors: {
                            data: '#71B56E'
                        },
                        type: 'gauge'
                    },
                    gauge: {
                        max: total
                    },
                    bindto: '#responseType-chart-success'
                });
                responseTypeFailuresChart = c3.generate({
                    size: {
                        height: 150
                    },
                    data: {
                        columns: [
                            ['data', failures]
                        ],
                        colors: {
                            data: '#E37B4F'
                        },
                        type: 'gauge'
                    },
                    gauge: {
                        max: total
                    },
                    bindto: '#responseType-chart-failed'
                });
                responseTypeErrorsChart = c3.generate({
                    size: {
                        height: 150
                    },
                    data: {
                        columns: [
                            ['data', errors]
                        ],
                        colors: {
                            data: '#E34F4F'
                        },
                        type: 'gauge'
                    },
                    gauge: {
                        max: total
                    },
                    bindto: '#responseType-chart-error'
                });
            };
            var truncateToDay = function (date) {
                truncateToHour(date);
                date.setHours(0);
                return date;
            };
            var truncateToHour = function (date) {
                date.setMinutes(0);
                date.setSeconds(0);
                date.setMilliseconds(0);
                return date;
            };
            var getChartDateRange = function () {
                var from = new Date();
                var to = new Date();
                if ($scope.metricsRange == '90days') {
                    from = new Date(from.getTime() - Apiman.NINETY_DAYS);
                    truncateToDay(from);
                }
                else if ($scope.metricsRange == '30days') {
                    from = new Date(from.getTime() - Apiman.THIRTY_DAYS);
                    truncateToDay(from);
                }
                else if ($scope.metricsRange == '7days') {
                    from = new Date(from.getTime() - Apiman.SEVEN_DAYS);
                    truncateToDay(from);
                }
                else if ($scope.metricsRange == '24hours') {
                    from = new Date(from.getTime() - Apiman.ONE_DAY);
                    truncateToHour(from);
                }
                else if ($scope.metricsRange == 'hour') {
                    from = new Date(from.getTime() - Apiman.ONE_HOUR);
                }
                return {
                    from: from,
                    to: to
                };
            };
            // *******************************************************
            // Refresh the usage charts
            // *******************************************************
            var refreshUsageCharts = function () {
                $scope.usageChartLoading = true;
                $scope.clientUsageChartLoading = true;
                $scope.planUsageChartLoading = true;
                var range = getChartDateRange();
                var from = range.from;
                var to = range.to;
                var interval = 'day';
                if ($scope.metricsRange == '7days' || $scope.metricsRange == '24hours') {
                    interval = 'hour';
                }
                if ($scope.metricsRange == 'hour') {
                    interval = 'minute';
                }
                // Refresh the usage chart
                if (usageChart) {
                    usageChart.destroy();
                    usageChart = null;
                }
                MetricsSvcs.getUsage(params.org, params.api, params.version, interval, from, to, function (data) {
                    $scope.usageChartLoading = false;
                    renderUsageChart(data);
                }, function (error) {
                    Logger.error('Error loading usage chart data: {0}', JSON.stringify(error));
                    $scope.usageChartLoading = false;
                    $scope.usageChartNoData = true;
                });
                // Refresh the client usage chart
                if (usageByClientChart) {
                    usageByClientChart.destroy();
                    usageByClientChart = null;
                }
                MetricsSvcs.getUsagePerClient(params.org, params.api, params.version, from, to, function (data) {
                    $scope.clientUsageChartLoading = false;
                    renderClientUsageChart(data);
                }, function (error) {
                    Logger.error('Error loading client usage chart data: {0}', JSON.stringify(error));
                    $scope.clientUsageChartLoading = false;
                    $scope.clientUsageChartNoData = true;
                });
                // Refresh the plan usage chart
                if (usageByPlanChart) {
                    usageByPlanChart.destroy();
                    usageByPlanChart = null;
                }
                MetricsSvcs.getUsagePerPlan(params.org, params.api, params.version, from, to, function (data) {
                    $scope.planUsageChartLoading = false;
                    renderPlanUsageChart(data);
                }, function (error) {
                    Logger.error('Error loading plan usage chart data: {0}', JSON.stringify(error));
                    $scope.planUsageChartLoading = false;
                    $scope.planUsageChartNoData = true;
                });
            };
            // *******************************************************
            // Refresh the response type charts
            // *******************************************************
            var refreshResponseTypeCharts = function () {
                $scope.responseTypeChartLoading = true;
                $scope.responseTypeSuccessChartLoading = true;
                $scope.responseTypeFailedChartLoading = true;
                $scope.responseTypeErrorChartLoading = true;
                var range = getChartDateRange();
                var from = range.from;
                var to = range.to;
                var interval = 'day';
                if ($scope.metricsRange == '7days' || $scope.metricsRange == '24hours') {
                    interval = 'hour';
                }
                if ($scope.metricsRange == 'hour') {
                    interval = 'minute';
                }
                // Refresh the response type chart
                if (responseTypeChart) {
                    responseTypeChart.destroy();
                    responseTypeChart = null;
                }
                MetricsSvcs.getResponseStats(params.org, params.api, params.version, interval, from, to, function (data) {
                    $scope.responseTypeChartLoading = false;
                    renderResponseTypeHistogramChart(data);
                }, function (error) {
                    Logger.error('Error loading response type stats histogram data: {0}', JSON.stringify(error));
                    $scope.responseTypeChartLoading = false;
                    $scope.responseTypeChartNoData = true;
                });
                // Refresh the success, failure, and error charts
                if (responseTypeSuccessChart) {
                    responseTypeSuccessChart.destroy();
                    responseTypeSuccessChart = null;
                }
                if (responseTypeFailuresChart) {
                    responseTypeFailuresChart.destroy();
                    responseTypeFailuresChart = null;
                }
                if (responseTypeErrorsChart) {
                    responseTypeErrorsChart.destroy();
                    responseTypeErrorsChart = null;
                }
                MetricsSvcs.getResponseStatsSummary(params.org, params.api, params.version, from, to, function (data) {
                    $scope.responseTypeSuccessChartLoading = false;
                    $scope.responseTypeFailedChartLoading = false;
                    $scope.responseTypeErrorChartLoading = false;
                    renderResponseTypeSummaryCharts(data);
                }, function (error) {
                    Logger.error('Error loading response type summary stats chart data: {0}', JSON.stringify(error));
                    $scope.responseTypeSuccessChartLoading = false;
                    $scope.responseTypeFailedChartLoading = false;
                    $scope.responseTypeErrorChartLoading = false;
                    $scope.responseTypeSuccessChartNoData = true;
                    $scope.responseTypeFailedChartNoData = true;
                    $scope.responseTypeErrorChartNoData = true;
                });
            };
            var refreshCharts = function () {
                Logger.debug("Refreshing charts!");
                if ($scope.metricsType == 'usage') {
                    refreshUsageCharts();
                }
                if ($scope.metricsType == 'responseType') {
                    refreshResponseTypeCharts();
                }
            };
            $scope.refreshCharts = refreshCharts;
            $scope.$watch('metricsRange', function (newValue, oldValue) {
                if (newValue && newValue != oldValue) {
                    refreshCharts();
                }
            });
            $scope.$watch('metricsType', function (newValue, oldValue) {
                if (newValue && newValue != oldValue) {
                    refreshCharts();
                }
            });
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            PageLifecycle.loadPage('ApiMetrics', 'apiView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('api-metrics', [$scope.api.name]);
                refreshCharts();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiOverviewController = Apiman._module.controller("Apiman.ApiOverviewController", ['$q', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', '$routeParams', 'Configuration',
            ($q, $scope, $location, PageLifecycle, ApiEntityLoader, $routeParams, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'overview';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            PageLifecycle.loadPage('ApiOverview', 'apiView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('api-overview', [$scope.api.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiPlansController = Apiman._module.controller('Apiman.ApiPlansController', ['$q', '$rootScope', '$scope', '$location', 'PageLifecycle', 'ApiEntityLoader', 'OrgSvcs', 'ApimanSvcs', '$routeParams', 'EntityStatusSvc', 'Configuration',
            ($q, $rootScope, $scope, $location, PageLifecycle, ApiEntityLoader, OrgSvcs, ApimanSvcs, $routeParams, EntityStatusSvc, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'plans';
            $scope.version = params.version;
            $scope.updatedApi = new Object();
            $scope.showMetrics = Configuration.ui.metrics;
            var lockedPlans = [];
            var getSelectedPlans = function () {
                var selectedPlans = [];
                for (var i = 0; i < lockedPlans.length; i++) {
                    var plan = lockedPlans[i];
                    if (plan.checked) {
                        var selectedPlan = {};
                        selectedPlan.planId = plan.id;
                        selectedPlan.version = plan.selectedVersion;
                        selectedPlans.push(selectedPlan);
                    }
                }
                return selectedPlans;
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            if (params.version != null) {
                pageData = angular.extend(pageData, {
                    plans: $q(function (resolve, reject) {
                        OrgSvcs.query({ organizationId: params.org, entityType: 'plans' }, function (plans) {
                            //for each plan find the versions that are locked
                            var promises = [];
                            angular.forEach(plans, function (plan) {
                                promises.push($q(function (resolve, reject) {
                                    OrgSvcs.query({ organizationId: params.org, entityType: 'plans', entityId: plan.id, versionsOrActivity: 'versions' }, function (planVersions) {
                                        //for each plan find the versions that are locked
                                        var lockedVersions = [];
                                        for (var j = 0; j < planVersions.length; j++) {
                                            var planVersion = planVersions[j];
                                            if (planVersion.status == 'Locked') {
                                                lockedVersions.push(planVersion.version);
                                            }
                                        }
                                        // if we found locked plan versions then add them
                                        if (lockedVersions.length > 0) {
                                            plan.lockedVersions = lockedVersions;
                                            lockedPlans.push(plan);
                                        }
                                        resolve(planVersions);
                                    }, reject);
                                }));
                            });
                            $q.all(promises).then(function () {
                                lockedPlans.sort(function (a, b) {
                                    if (a.id.toLowerCase() < b.id.toLowerCase()) {
                                        return -1;
                                    }
                                    else if (b.id < a.id) {
                                        return 1;
                                    }
                                    else {
                                        return 0;
                                    }
                                });
                                resolve(lockedPlans);
                            });
                        }, reject);
                    })
                });
            }
            $scope.$watch('updatedApi', function (newValue) {
                $rootScope.isDirty = false;
                if (newValue.publicAPI != $scope.version.publicAPI) {
                    $rootScope.isDirty = true;
                }
                if (newValue.plans && $scope.version.plans && newValue.plans.length != $scope.version.plans.length) {
                    $rootScope.isDirty = true;
                }
                else if (newValue.plans && $scope.version.plans) {
                    newValue.plans = _.sortBy(newValue.plans, 'planId');
                    $scope.version.plans = _.sortBy($scope.version.plans, 'planId');
                    for (var i = 0; i < newValue.plans.length; i++) {
                        var p1 = newValue.plans[i];
                        var p2 = $scope.version.plans[i];
                        if (p1.planId != p2.planId || p1.version != p2.version) {
                            $rootScope.isDirty = true;
                        }
                    }
                }
            }, true);
            $scope.$watch('plans', function (newValue) {
                $scope.updatedApi.plans = getSelectedPlans();
            }, true);
            $scope.changedVersion = function (item) {
                //console.log('changedVersion: ' + JSON.stringify(item));
            };
            $scope.reset = function () {
                $scope.updatedApi.publicAPI = $scope.version.publicAPI;
                for (var i = 0; i < lockedPlans.length; i++) {
                    lockedPlans[i].selectedVersion = lockedPlans[i].lockedVersions[0];
                    for (var j = 0; j < $scope.version.plans.length; j++) {
                        if (lockedPlans[i].id == $scope.version.plans[j].planId) {
                            lockedPlans[i].checked = true;
                            lockedPlans[i].selectedVersion = $scope.version.plans[j].version;
                            break;
                        }
                    }
                }
                $scope.updatedApi.plans = getSelectedPlans();
                $rootScope.isDirty = false;
            };
            $scope.saveApi = function () {
                $scope.saveButton.state = 'in-progress';
                OrgSvcs.update({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: params.version }, $scope.updatedApi, function (reply) {
                    $scope.version.publicAPI = $scope.updatedApi.publicAPI;
                    $scope.saveButton.state = 'complete';
                    $scope.version = reply;
                    EntityStatusSvc.setEntityStatus(reply.status);
                    $rootScope.isDirty = false;
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('ApiPlans', 'apiView', pageData, $scope, function () {
                $scope.reset();
                PageLifecycle.setPageTitle('api-plans', [$scope.api.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiPoliciesController = Apiman._module.controller('Apiman.ApiPoliciesController', [
        '$q',
        '$scope',
        '$location',
        '$uibModal',
        'PageLifecycle',
        'ActionSvcs',
        'ApiEntityLoader',
        'OrgSvcs',
        '$routeParams',
        'Configuration',
        'EntityStatusSvc',
        'CurrentUser',
            ($q, $scope, $location, $uibModal, PageLifecycle, ActionSvcs, ApiEntityLoader, OrgSvcs, $routeParams, Configuration, EntityStatusSvc, CurrentUser) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'policies';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var removePolicy = function (policy) {
                angular.forEach($scope.policies, function (p, index) {
                    if (policy === p) {
                        $scope.policies.splice(index, 1);
                    }
                });
            };
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            $scope.removePolicy = function (policy, size) {
                var options = {
                    message: 'Do you really want to remove this policy from the API?',
                    title: 'Confirm Remove Policy'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    OrgSvcs.delete({
                        organizationId: params.org,
                        entityType: 'apis',
                        entityId: params.api,
                        versionsOrActivity: 'versions',
                        version: params.version,
                        policiesOrActivity: 'policies',
                        policyId: policy.id
                    }, function (reply) {
                        removePolicy(policy);
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                    $scope.unregisterButton.state = 'complete';
                });
            };
            $scope.reorderPolicies = function (reorderedPolicies) {
                var policyChainBean = {
                    policies: reorderedPolicies
                };
                OrgSvcs.save({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'reorderPolicies' }, policyChainBean, function () {
                    Logger.debug("Reordering POSTed successfully");
                }, function () {
                    Logger.debug("Reordering POST failed.");
                });
            };
            var pageData = ApiEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                policies: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'policies' }, resolve, reject);
                })
            });
            PageLifecycle.loadPage('ApiPolicies', 'apiView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('api-policies', [$scope.api.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiRedirectController = Apiman._module.controller("Apiman.ApiRedirectController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', 'CurrentUser', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, CurrentUser, $routeParams) => {
            var orgId = $routeParams.org;
            var apiId = $routeParams.api;
            var pageData = {
                versions: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: orgId, entityType: 'apis', entityId: apiId, versionsOrActivity: 'versions' }, resolve, reject);
                })
            };
            $scope.organizationId = orgId;
            PageLifecycle.loadPage('ApiRedirect', 'apiView', pageData, $scope, function () {
                var version = $scope.versions[0].version;
                if (!version) {
                    PageLifecycle.handleError({ status: 404 });
                }
                else {
                    PageLifecycle.forwardTo('/orgs/{0}/apis/{1}/{2}', orgId, apiId, version);
                }
            });
        }]);
    Apiman.ApiEntityLoader = Apiman._module.factory('ApiEntityLoader', ['$q', 'OrgSvcs', 'Logger', '$rootScope', '$routeParams', 'EntityStatusSvc',
            ($q, OrgSvcs, Logger, $rootScope, $routeParams, EntityStatusSvc) => {
            return {
                getCommonData: function ($scope, $location) {
                    var params = $routeParams;
                    return {
                        version: $q(function (resolve, reject) {
                            OrgSvcs.get({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: params.version }, function (version) {
                                $scope.org = version.api.organization;
                                $scope.api = version.api;
                                $rootScope.mruApi = version;
                                EntityStatusSvc.setEntity(version, 'api');
                                resolve(version);
                            }, reject);
                        }),
                        versions: $q(function (resolve, reject) {
                            OrgSvcs.query({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions' }, resolve, reject);
                        })
                    };
                }
            };
        }]);
    Apiman.ApiEntityController = Apiman._module.controller("Apiman.ApiEntityController", [
        '$rootScope',
        '$q',
        '$location',
        '$scope',
        '$uibModal',
        'ActionSvcs',
        'Logger',
        'PageLifecycle',
        '$routeParams',
        'OrgSvcs',
        'EntityStatusSvc',
        'Configuration',
            ($rootScope, $q, $location, $scope, $uibModal, ActionSvcs, Logger, PageLifecycle, $routeParams, OrgSvcs, EntityStatusSvc, Configuration) => {
            var params = $routeParams;
            $scope.params = params;
            $scope.setEntityStatus = EntityStatusSvc.setEntityStatus;
            $scope.getEntityStatus = EntityStatusSvc.getEntityStatus;
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            // ----- Status Checklist Popover --------------------->>>>
            $scope.checklist = [];
            // Initiates the tooltip (this is required for performance reasons)
            $(function () {
                $('[data-toggle="popover"]').popover();
            });
            // Set initial popover value to be closed
            $scope.isOpen = false;
            // Set initial collapse (for context information in checklist) to be closed
            $scope.isCollapsed = true;
            // Popover options
            $scope.checklistPopover = {
                templateUrl: 'checklistTemplate.html',
                title: 'Publish Checklist'
            };
            // Programmatically close popover
            $scope.closePopover = function () {
                $scope.isOpen = false;
            };
            // ----- Delete --------------------->>>>
            $scope.showCtxMenu = true;
            if (Configuration.ui.platform == 'f8' || Configuration.ui.platform == 'ose') {
                $scope.showCtxMenu = false;
            }
            // Add check for ability to delete, show/hide Delete option
            $scope.canDelete = function () { };
            // Call delete, open modal
            $scope.callDelete = function (size) {
                var modalInstance = $uibModal.open({
                    templateUrl: 'deleteModal.html',
                    controller: 'ApiDeleteModalCtrl',
                    size: size,
                    resolve: {
                        api: function () {
                            return $scope.api;
                        },
                        params: function () {
                            return $scope.params;
                        }
                    }
                });
                modalInstance.result.then(function (selectedItem) {
                    $scope.selected = selectedItem;
                }, function () {
                    Logger.info('Modal dismissed at: ' + new Date());
                });
            };
            // ----- Why Can't I Publish? --------------------->>>>
            // Called when user clicks 'Why can't I publish?' & opens modal
            $scope.getStatusDetails = function () {
                if ($scope.isOpen === false) {
                    return OrgSvcs.get({
                        organizationId: params.org,
                        entityType: 'apis',
                        entityId: params.api,
                        versionsOrActivity: 'versions',
                        version: params.version,
                        policiesOrActivity: 'status'
                    }, function (response) {
                        $scope.checklist = response.items;
                        $scope.isOpen = true;
                    });
                }
                else if ($scope.isOpen === true) {
                    $scope.isOpen = false;
                }
            };
            $scope.oneAtATime = true;
            $scope.goTo = function (idx, item, e) {
                if (e) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                $location.path($rootScope.pluginName + '/orgs/' + params.org + '/apis/' + params.api + '/' + params.version + '/' + item.path);
            };
            // ----- Api Update Methods --------------------->>>>
            $scope.setVersion = function (api) {
                PageLifecycle.redirectTo('/orgs/{0}/apis/{1}/{2}', params.org, params.api, api.version);
            };
            $scope.isModified = function () {
                if (!$scope.version.publishedOn) {
                    return false;
                }
                var pub = new Date($scope.version.publishedOn);
                var mod = new Date($scope.version.modifiedOn);
                return mod > pub;
            };
            $scope.publishApi = function () {
                $scope.publishButton.state = 'in-progress';
                $scope.republishButton.state = 'in-progress';
                var publishAction = {
                    type: 'publishAPI',
                    entityId: params.api,
                    organizationId: params.org,
                    entityVersion: params.version
                };
                ActionSvcs.save(publishAction, function (reply) {
                    $scope.version.publishedOn = Date.now();
                    $scope.publishButton.state = 'complete';
                    $scope.republishButton.state = 'complete';
                    $scope.setEntityStatus('Published');
                }, PageLifecycle.handleError);
            };
            $scope.retireApi = function (size) {
                $scope.retireButton.state = 'in-progress';
                var options = {
                    message: 'Do you really want to retire this API?  This action cannot be undone.',
                    title: 'Confirm Retire API'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    var retireAction = {
                        type: 'retireAPI',
                        entityId: params.api,
                        organizationId: params.org,
                        entityVersion: params.version
                    };
                    ActionSvcs.save(retireAction, function (reply) {
                        $scope.version.status = 'Retired';
                        $scope.version.retiredOn = Date.now();
                        $scope.retireButton.state = 'complete';
                        $scope.setEntityStatus($scope.version.status);
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                    $scope.retireButton.state = 'complete';
                });
            };
            $scope.updateApiDescription = function (updatedDescription) {
                var updateApiBean = {
                    description: updatedDescription
                };
                OrgSvcs.update({
                    organizationId: $scope.organizationId,
                    entityType: 'apis',
                    entityId: $scope.api.id,
                }, updateApiBean, function (success) {
                    Logger.info("Updated sucessfully");
                }, function (error) {
                    Logger.error("Unable to update API description:  {0}", error);
                });
            };
        }]);
    Apiman.ApiDeleteModalCtrl = Apiman._module.controller('ApiDeleteModalCtrl', function ($location, $rootScope, $scope, $uibModalInstance, ApiSvcs, Configuration, PageLifecycle, api, params) {
        $scope.api = api;
        $scope.params = params;
        $scope.confirmApiName = '';
        // Used for enabling/disabling the submit button
        $scope.okayToDelete = false;
        $scope.typed = function () {
            // For user convenience, compare lower case values so that check is not case-sensitive
            $scope.okayToDelete = ($scope.confirmApiName.toLowerCase() === api.name.toLowerCase());
        };
        // Yes, delete the API
        $scope.yes = function () {
            var deleteAction = {
                apiId: params.api,
                orgId: params.org
            };
            ApiSvcs.deleteApi(deleteAction).then(function (res) {
                $scope.okayToDelete = false;
                setTimeout(function () {
                    $uibModalInstance.close();
                    // Redirect users to their list of APIs
                    $location.path($rootScope.pluginName + '/users/' + Configuration.user.username + '/apis');
                }, 800);
                // We should display some type of Toastr/Growl notification to the user here
            }, function (err) {
                $scope.okayToDelete = false;
                $uibModalInstance.close();
                PageLifecycle.handleError(err);
            });
        };
        // No, do NOT delete the API
        $scope.no = function () {
            $uibModalInstance.dismiss('cancel');
        };
    });
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    var pages = [
        'overview', 'find-apis', 'choose-plans', 'import-apis'
    ];
    Apiman.ApiRedirectController = Apiman._module.controller("Apiman.ImportApisController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', 'CurrentUser', '$routeParams', 'Logger', 'ApiCatalogSvcs',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, CurrentUser, $routeParams, Logger, ApiCatalogSvcs) => {
            var params = $routeParams;
            $scope.params = params;
            $scope.organizationId = params.org;
            $scope.importInfo = {
                apis: [],
                isPublic: false,
                plans: []
            };
            var lockedPlans = [];
            var getSelectedPlans = function () {
                var selectedPlans = [];
                for (var i = 0; i < lockedPlans.length; i++) {
                    var plan = lockedPlans[i];
                    if (plan.checked) {
                        var selectedPlan = {};
                        selectedPlan.planId = plan.id;
                        selectedPlan.version = plan.selectedVersion;
                        selectedPlans.push(selectedPlan);
                    }
                }
                return selectedPlans;
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, resolve, reject);
                }),
                plans: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'plans' }, function (plans) {
                        //for each plan find the versions that are locked
                        var promises = [];
                        angular.forEach(plans, function (plan) {
                            promises.push($q(function (resolve, reject) {
                                OrgSvcs.query({ organizationId: params.org, entityType: 'plans', entityId: plan.id, versionsOrActivity: 'versions' }, function (planVersions) {
                                    //for each plan find the versions that are locked
                                    var lockedVersions = [];
                                    for (var j = 0; j < planVersions.length; j++) {
                                        var planVersion = planVersions[j];
                                        if (planVersion.status == "Locked") {
                                            lockedVersions.push(planVersion.version);
                                        }
                                    }
                                    // if we found locked plan versions then add them
                                    if (lockedVersions.length > 0) {
                                        plan.lockedVersions = lockedVersions;
                                        lockedPlans.push(plan);
                                    }
                                    resolve(planVersions);
                                }, reject);
                            }));
                        });
                        $q.all(promises).then(function () {
                            lockedPlans.sort(function (a, b) {
                                if (a.id.toLowerCase() < b.id.toLowerCase()) {
                                    return -1;
                                }
                                else if (b.id < a.id) {
                                    return 1;
                                }
                                else {
                                    return 0;
                                }
                            });
                            for (var i = 0; i < lockedPlans.length; i++) {
                                lockedPlans[i].selectedVersion = lockedPlans[i].lockedVersions[0];
                            }
                            resolve(lockedPlans);
                        });
                    }, reject);
                })
            };
            $scope.$watch('plans', function (newValue) {
                $scope.importInfo.plans = getSelectedPlans();
            }, true);
            var validatePage = function () {
                var valid = true;
                if ($scope.currentPage == 'find-apis') {
                    Logger.log("Validating find-apis page.");
                    valid = $scope.importInfo.apis.length > 0;
                }
                if ($scope.currentPage == 'choose-plans') {
                    Logger.log("Validating choose-plans page.");
                    valid = $scope.importInfo.isPublic || $scope.importInfo.plans.length > 0;
                }
                $scope.currentPageValid = valid;
                Logger.log("Current Page Valid: " + valid);
            };
            $scope.$watch('importInfo', validatePage, true);
            $scope.$watch('currentPage', validatePage);
            $scope.currentPage = 'overview';
            $scope.currentPageIdx = 0;
            $scope.currentPageValid = true;
            $scope.apis = [];
            $scope.importSources = [
                {
                    id: 'api-catalog',
                    icon: 'search-plus',
                    name: "API Catalog",
                    disabled: false
                },
                {
                    id: 'wadl',
                    icon: 'file-text-o',
                    name: "WADL File",
                    disabled: true
                },
                {
                    id: 'swagger',
                    icon: 'ellipsis-h',
                    name: "Swagger File",
                    disabled: true
                }
            ];
            $scope.importFrom = 'api-catalog';
            $scope.searchApiCatalog = function (searchText) {
                $scope.searchButton.state = 'in-progress';
                $scope.searchDisabled = true;
                var body = {};
                body.filters = [];
                body.filters.push({ "name": "name", "value": searchText, "operator": "like" });
                var criteria = angular.toJson(body);
                Logger.log("Searching API catalogs: {0}", criteria);
                ApiCatalogSvcs.search(criteria, function (reply) {
                    $scope.apis = reply.beans;
                    Logger.log("Found {0} apis.", reply.beans.length);
                    $scope.searchButton.state = 'complete';
                    $scope.searchDisabled = false;
                }, function (error) {
                    Logger.error(error);
                    // TODO do something interesting with the error
                    $scope.searchButton.state = 'complete';
                    $scope.searchDisabled = false;
                });
            };
            var importApis = function (apis) {
                if (apis.length == 0) {
                    // We're done - show the "Finish" button. :)
                    $scope.hideImportButton = true;
                    $scope.showFinishButton = true;
                    return;
                }
                var api = apis[0];
                apis.splice(0, 1);
                Logger.debug("Importing api {0}", api.name);
                Logger.debug("   # Remaining: {0}", apis.length);
                api.status = 'importing';
                var newApi = {
                    name: api.name,
                    description: api.description,
                    initialVersion: '1.0',
                    endpoint: api.endpoint,
                    endpointType: api.endpointType,
                    publicAPI: $scope.importInfo.isPublic,
                    plans: $scope.importInfo.plans,
                    definitionUrl: api.definitionUrl,
                    definitionType: api.definitionType
                };
                OrgSvcs.save({ organizationId: params.org, entityType: 'apis' }, newApi, function (reply) {
                    api.status = 'imported';
                    importApis(apis);
                }, function (error) {
                    api.status = 'error';
                    api.error = error;
                    importApis(apis);
                });
            };
            $scope.prevPage = function () {
                $scope.currentPageIdx = $scope.currentPageIdx - 1;
                $scope.currentPage = pages[$scope.currentPageIdx];
            };
            $scope.nextPage = function () {
                $scope.currentPageIdx = $scope.currentPageIdx + 1;
                $scope.currentPage = pages[$scope.currentPageIdx];
            };
            $scope.doImport = function () {
                $scope.disableBackButton = true;
                $scope.disableCancelButton = true;
                $scope.importButton.state = 'in-progress';
                var apisToImport = $scope.importInfo.apis.slice(0);
                apisToImport.sort(function (s1, s2) {
                    if (s1.name.toLowerCase() < s2.name.toLowerCase()) {
                        return -1;
                    }
                    if (s1.name.toLowerCase() > s2.name.toLowerCase()) {
                        return 1;
                    }
                    return 0;
                });
                importApis(apisToImport);
            };
            $scope.isApiSelected = function (api) {
                var rval = false;
                angular.forEach($scope.importInfo.apis, function (selectedApi) {
                    if (api.name == selectedApi.name && api.endpoint == selectedApi.endpoint) {
                        rval = true;
                    }
                });
                return rval;
            };
            $scope.addApi = function (api) {
                if (!$scope.isApiSelected(api)) {
                    $scope.importInfo.apis.push(api);
                }
            };
            $scope.removeApi = function (api) {
                angular.forEach($scope.importInfo.apis, function (s, idx) {
                    if (api == s) {
                        $scope.importInfo.apis.splice(idx, 1);
                    }
                });
            };
            PageLifecycle.loadPage('ImportApis', 'apiEdit', pageData, $scope, function () {
                PageLifecycle.setPageTitle('import-apis');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ApiCatalogController = Apiman._module.controller("Apiman.ApiCatalogController", ['$q', 'Logger', '$scope', '$rootScope', '$filter', '$timeout', 'ApiCatalogSvcs', 'PageLifecycle', '$uibModal', 'CurrentUser', 'UserSvcs', '$location',
            ($q, Logger, $scope, $rootScope, $filter, $timeout, ApiCatalogSvcs, PageLifecycle, $uibModal, CurrentUser, UserSvcs, $location) => {
            // set a "rest" as default value for the dropdown
            $scope.epType = "rest";
            var body = {};
            body.filters = [];
            body.filters.push({ "name": "name", "value": "*", "operator": "like" });
            var namespace = $location.hash();
            if (namespace) {
                body.filters.push({ "name": "namespace", "value": namespace, "operator": "eq" });
            }
            var searchStr = angular.toJson(body);
            $scope.reverse = false;
            $scope.tags = [];
            $scope.selected = {};
            $scope.selected.tags = [];
            $scope.filterApis = function (searchText) {
                $scope.criteria = {
                    name: searchText
                };
            };
            $scope.clear = function () {
                $scope.selected.tags = [];
            };
            $scope.addTag = function (tag) {
                if (_.find($scope.selected.tags, tag)) {
                    console.log('This tag already existed on here, not adding again...');
                    return;
                }
                else {
                    $scope.selected.tags.push(tag);
                }
            };
            $scope.removeTag = function (tag) {
                if (_.find($scope.selected.tags, tag)) {
                    _.pull($scope.selected.tags, tag);
                }
                else {
                    return console.log('This tag doesn\'t exist on here.');
                }
            };
            $scope.hideInternal = true;
            $scope.isInternal = function (actual, expected) {
                if (!expected) {
                    return true;
                }
                if (!actual) {
                    return false;
                }
                if (!actual.id && !actual.name) {
                    return false;
                }
                if (actual.internal == true) {
                    return false;
                }
                return true;
            };
            $scope.apiEndpoint = function (api) {
                if (api.routeEndpoint) {
                    return api.routeEndpoint;
                }
                return api.endpoint;
            };
            $scope.selectNamespace = function (ns) {
                $location.hash(ns.name);
            };
            $scope.importApi = function (api) {
                var modalInstance = $uibModal.open({
                    animation: true,
                    templateUrl: 'importApiModal.html',
                    controller: 'Apiman.ImportApiController',
                    resolve: {
                        api: function () {
                            var copyOf = angular.copy(api);
                            copyOf.initialVersion = '1.0';
                            return copyOf;
                        },
                        orgs: function () {
                            return $scope.orgs;
                        }
                    }
                });
            };
            $scope.tagLabel = function (tag) {
                var idx = tag.indexOf("=");
                if (idx == -1) {
                    return tag;
                }
                else {
                    return tag.slice(idx + 1);
                }
            };
            $scope.tagTitle = function (tag) {
                return "Filter by tag: " + tag;
            };
            var pageData = {
                namespaces: $q(function (resolve, reject) {
                    ApiCatalogSvcs.getNamespaces(function (reply) {
                        angular.forEach(reply, function (ns) {
                            if ((namespace && ns.name == namespace) || (!namespace && ns.current)) {
                                $scope.namespace = ns;
                            }
                        });
                        resolve(reply);
                    }, reject);
                }),
                apis: $q(function (resolve, reject) {
                    $scope.hasInternalApis = false;
                    ApiCatalogSvcs.search(searchStr, function (reply) {
                        angular.forEach(reply.beans, function (entry) {
                            if (entry.internal) {
                                $scope.hasInternalApis = true;
                            }
                        });
                        resolve(reply.beans);
                    }, reject);
                }),
                orgs: $q(function (resolve, reject) {
                    return CurrentUser.getCurrentUser().then(function (currentUser) {
                        return UserSvcs.query({ user: currentUser.username, entityType: 'apiorgs' }, resolve, reject);
                    });
                })
            };
            let apiAdjustments = function (api) {
                api.iconIsUrl = false;
                if (!api.icon) {
                    api.icon = 'puzzle-piece';
                }
                if (api.icon.indexOf('http') == 0) {
                    api.iconIsUrl = true;
                }
                api.ticon = 'fa-file-text-o';
                if (api.endpointType == 'soap' || api.endpointType == 'ui') {
                    api.ticon = 'fa-file-code-o';
                }
                if (api.routeDefinitionUrl != null) {
                    api.definitionUrl = api.routeDefinitionUrl;
                }
            };
            PageLifecycle.loadPage('ApiCatalog', undefined, pageData, $scope, function () {
                angular.forEach($scope.apis, function (api) {
                    apiAdjustments(api);
                });
                $scope.tags = _.uniq(_.flatten(_.map($scope.apis, 'tags')));
                PageLifecycle.setPageTitle('api-catalog');
            });
        }
    ]);
    Apiman.ImportApiController = Apiman._module.controller("Apiman.ImportApiController", ['$q', '$rootScope', 'Logger', '$scope', 'OrgSvcs', 'PageLifecycle', '$uibModalInstance', 'api', 'orgs',
            ($q, $rootScope, Logger, $scope, OrgSvcs, PageLifecycle, $uibModalInstance, api, orgs) => {
            var recentOrg = $rootScope.mruOrg;
            $scope.api = api;
            $scope.orgs = orgs;
            if (recentOrg) {
                $scope.selectedOrg = recentOrg;
            }
            else if (orgs.length > 0) {
                $scope.selectedOrg = orgs[0];
            }
            $scope.setOrg = function (org) {
                $scope.selectedOrg = org;
            };
            $scope.import = function () {
                $scope.importButton.state = 'in-progress';
                var newApi = {
                    'name': $scope.api.name,
                    'description': $scope.api.description,
                    'initialVersion': $scope.api.initialVersion,
                    'endpoint': $scope.api.endpoint,
                    'endpointType': $scope.api.endpointType,
                    'definitionUrl': $scope.api.definitionUrl,
                    'definitionType': $scope.api.definitionType
                };
                OrgSvcs.save({ organizationId: $scope.selectedOrg.id, entityType: 'apis' }, newApi, function (reply) {
                    $uibModalInstance.dismiss('cancel');
                    PageLifecycle.redirectTo('/orgs/{0}/apis/{1}/{2}', reply.organization.id, reply.id, $scope.api.initialVersion);
                }, function (error) {
                    $uibModalInstance.dismiss('cancel');
                    PageLifecycle.handleError(error);
                });
            };
            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };
        }
    ]);
    Apiman.ApiCatalogDefController = Apiman._module.controller("Apiman.ApiCatalogDefController", ['$q', '$scope', 'ApiCatalogSvcs', 'PageLifecycle', '$routeParams', '$window', 'Logger', 'ApiDefinitionSvcs', 'Configuration',
            ($q, $scope, ApiCatalogSvcs, PageLifecycle, $routeParams, $window, Logger, ApiDefinitionSvcs, Configuration) => {
            $scope.params = $routeParams;
            $scope.chains = {};
            var name = $scope.params.name;
            var body = {};
            body.filters = [];
            body.filters.push({ "name": "name", "value": $scope.params.name, "operator": "like" });
            var searchStr = angular.toJson(body);
            var pageData = {
                apis: $q(function (resolve, reject) {
                    ApiCatalogSvcs.search(searchStr, function (reply) {
                        resolve(reply.beans);
                        $scope.api = reply.beans[0];
                        if ($scope.api.routeDefinitionUrl != null) {
                            $scope.api.definitionUrl = $scope.api.routeDefinitionUrl;
                        }
                    }, reject);
                })
            };
            const DisableTryItOutPlugin = function () {
                return {
                    statePlugins: {
                        spec: {
                            wrapSelectors: {
                                allowTryItOutFor: () => () => false
                            }
                        }
                    }
                };
            };
            // SwaggerUI Plugins
            const DisableAuthorizePlugin = function () {
                return {
                    wrapComponents: {
                        authorizeBtn: () => () => null
                    }
                };
            };
            PageLifecycle.loadPage('ApiCatalogDef', undefined, pageData, $scope, function () {
                $scope.hasError = false;
                PageLifecycle.setPageTitle('api-catalog-def', [$scope.params.name]);
                var definitionUrl = $scope.api.definitionUrl;
                if ($scope.api.routeDefinitionUrl != null)
                    definitionUrl = $scope.api.routeDefinitionUrl;
                var definitionType = $scope.api.definitionType;
                if ((definitionType == 'SwaggerJSON' || definitionType == 'SwaggerYAML') && SwaggerUIBundle) {
                    $scope.definitionStatus = 'loading';
                    let ui;
                    let swaggerOptions = {
                        url: definitionUrl,
                        dom_id: "#swagger-ui-container",
                        validatorUrl: "https://online.swagger.io/validator",
                        presets: [
                            SwaggerUIBundle.presets.apis
                        ],
                        layout: "BaseLayout",
                        sorter: "alpha",
                        onComplete: function () {
                            $scope.$apply(function () {
                                $scope.definitionStatus = 'complete';
                            });
                        },
                        // do error handling in the responseInterceptor
                        responseInterceptor: function (response) {
                            if (response.status == 500 && response.ok === false) {
                                $scope.$apply(function () {
                                    $scope.definitionStatus = 'error';
                                    $scope.hasError = true;
                                });
                            }
                            return response;
                        }
                    };
                    swaggerOptions.plugins = [];
                    swaggerOptions.plugins.push(DisableTryItOutPlugin, DisableAuthorizePlugin);
                    ui = SwaggerUIBundle(swaggerOptions);
                    $scope.hasDefinition = true;
                }
                else {
                    $scope.hasDefinition = false;
                }
            });
        }
    ]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ClientActivityController = Apiman._module.controller("Apiman.ClientActivityController", ['$q', '$scope', '$location', 'Logger', 'PageLifecycle', 'ClientEntityLoader', 'AuditSvcs', '$routeParams', 'Configuration',
            ($q, $scope, $location, Logger, PageLifecycle, ClientEntityLoader, AuditSvcs, $routeParams, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'activity';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var getNextPage = function (successHandler, errorHandler) {
                $scope.currentPage = $scope.currentPage + 1;
                AuditSvcs.get({ organizationId: params.org, entityType: 'clients', entityId: params.client, page: $scope.currentPage, count: 20 }, function (results) {
                    var entries = results.beans;
                    successHandler(entries);
                }, errorHandler);
            };
            var pageData = ClientEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                auditEntries: $q(function (resolve, reject) {
                    $scope.currentPage = 0;
                    getNextPage(resolve, reject);
                })
            });
            $scope.getNextPage = getNextPage;
            PageLifecycle.loadPage('ClientActivity', 'clientView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('client-activity', [$scope.client.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ClientApisController = Apiman._module.controller('Apiman.ClientApisController', ['$q', '$scope', '$location', 'PageLifecycle', 'ClientEntityLoader', 'Logger', 'OrgSvcs', '$rootScope', '$compile', '$timeout', '$routeParams', 'Configuration', 'ApiRegistrySvcs', 'DownloadSvcs', '$window', '$uibModal', '$log',
            ($q, $scope, $location, PageLifecycle, ClientEntityLoader, Logger, OrgSvcs, $rootScope, $compile, $timeout, $routeParams, Configuration, ApiRegistrySvcs, DownloadSvcs, $window, $uibModal, $log) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'apis';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            $scope.toggle = function (api) {
                api.expanded = !api.expanded;
            };
            $scope.animationsEnabled = true;
            $scope.howToInvoke = function (apiKey, api) {
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'invokeModal.html',
                    controller: 'ClientApisModalCtrl',
                    size: null,
                    resolve: {
                        api: function () {
                            return api;
                        },
                        apiKey: function () {
                            return apiKey;
                        }
                    }
                });
                modalInstance.result.then(function (selectedItem) {
                    $scope.selected = selectedItem;
                }, function () {
                    $log.info('Modal dismissed at: ' + new Date());
                });
            };
            $scope.toggleAnimation = function () {
                $scope.animationsEnabled = !$scope.animationsEnabled;
            };
            $scope.doExportAsJson = function () {
                $scope.exportAsJsonButton.state = 'in-progress';
                Logger.info('Starting download of api registry (json).');
                ApiRegistrySvcs.exportApiRegistryAsJson(params.org, params.client, params.version, function (download) {
                    Logger.info('Download: {0}', download);
                    var downloadLink = DownloadSvcs.getDownloadLink(download.id);
                    Logger.info('Downloading api registry from: {0}', downloadLink);
                    $window.open(downloadLink, "_self");
                    $scope.exportAsJsonButton.state = 'complete';
                }, PageLifecycle.handleError);
            };
            $scope.doExportAsXml = function () {
                $scope.exportAsXmlButton.state = 'in-progress';
                Logger.info('Starting download of api registry (xml).');
                ApiRegistrySvcs.exportApiRegistryAsXml(params.org, params.client, params.version, function (download) {
                    Logger.info('Download: {0}', download);
                    var downloadLink = DownloadSvcs.getDownloadLink(download.id);
                    Logger.info('Downloading api registry from: {0}', downloadLink);
                    $window.open(downloadLink, "_self");
                    $scope.exportAsXmlButton.state = 'complete';
                }, PageLifecycle.handleError);
            };
            var pageData = ClientEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                apiRegistry: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'apiregistry', policyId: 'json' }, resolve, reject);
                })
            });
            // Copy-to-Clipboard
            // Called if copy-to-clipboard functionality was successful
            $scope.copySuccess = function () {
                //console.log('Copied!');
            };
            // Called if copy-to-clipboard functionality was unsuccessful
            $scope.copyFail = function (err) {
                //console.error('Error!', err);
            };
            // Tooltip
            $scope.tooltipTxt = 'Copy to clipboard';
            // Called on clicking the button the tooltip is attached to
            $scope.tooltipChange = function () {
                $scope.tooltipTxt = 'Copied!';
            };
            // Call when the mouse leaves the button the tooltip is attached to
            $scope.tooltipReset = function () {
                setTimeout(function () {
                    $scope.tooltipTxt = 'Copy to clipboard';
                }, 100);
            };
            PageLifecycle.loadPage('ClientApis', 'clientView', pageData, $scope, function () {
                Logger.info("API Registry: {0}", $scope.apiRegistry);
                PageLifecycle.setPageTitle('client-apis', [$scope.client.name]);
            });
        }]);
    Apiman.ClientApisModalCtrl = Apiman._module.controller('ClientApisModalCtrl', function ($scope, $uibModalInstance, api, apiKey) {
        $scope.api = api;
        $scope.asQueryParam = api.httpEndpoint + '?apikey=' + apiKey;
        if (api.httpEndpoint.indexOf('?') > -1) {
            $scope.asQueryParam = api.httpEndpoint + '&apikey=' + apiKey;
        }
        $scope.asRequestHeader = 'X-API-Key: ' + apiKey;
        $scope.ok = function () {
            $uibModalInstance.close();
        };
        // Tooltip
        $scope.tooltipTxt = 'Copy to clipboard';
        // Called on clicking the button the tooltip is attached to
        $scope.tooltipChange = function () {
            $scope.tooltipTxt = 'Copied!';
        };
        // Call when the mouse leaves the button the tooltip is attached to
        $scope.tooltipReset = function () {
            setTimeout(function () {
                $scope.tooltipTxt = 'Copy to clipboard';
            }, 100);
        };
        // Copy-to-Clipboard
        // Called if copy-to-clipboard functionality was successful
        $scope.copySuccess = function () {
            //console.log('Copied!');
        };
        // Called if copy-to-clipboard functionality was unsuccessful
        $scope.copyFail = function (err) {
            //console.error('Error!', err);
        };
    });
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ClientContractsController = Apiman._module.controller('Apiman.ClientContractsController', [
        '$q',
        '$scope',
        '$location',
        '$uibModal',
        'PageLifecycle',
        'ClientEntityLoader',
        'OrgSvcs',
        'Logger',
        '$routeParams',
        'Configuration',
            ($q, $scope, $location, $uibModal, PageLifecycle, ClientEntityLoader, OrgSvcs, Logger, $routeParams, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'contracts';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var pageData = ClientEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                contracts: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'contracts' }, function (contracts) {
                        $scope.filteredContracts = contracts;
                        resolve(contracts);
                    }, reject);
                })
            });
            function removeContractFromArray(contract, carray) {
                var idx = -1;
                for (var i = 0; i < carray.length; i++) {
                    if (carray[i].contractId == contract.contractId) {
                        idx = i;
                        break;
                    }
                }
                if (idx > -1) {
                    carray.splice(idx, 1);
                }
            }
            ;
            $scope.filterContracts = function (value) {
                Logger.debug('Called filterContracts!');
                if (!value) {
                    $scope.filteredContracts = $scope.contracts;
                }
                else {
                    var fc = [];
                    angular.forEach($scope.contracts, function (contract) {
                        if (contract.apiOrganizationName.toLowerCase().indexOf(value.toLowerCase()) > -1 || contract.apiName.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            fc.push(contract);
                        }
                    });
                    $scope.filteredContracts = fc;
                }
            };
            $scope.breakAll = function (size) {
                var options = {
                    title: 'Break All Contracts?',
                    message: 'Do you really want to break all contracts with all APIs?'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    OrgSvcs.delete({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'contracts' }, function () {
                        $scope.contracts = [];
                        $scope.filteredContracts = [];
                        $scope.version.modifiedOn = Date.now();
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                });
            };
            $scope.break = function (contract, size) {
                Logger.debug('Called break() with {0}.', contract);
                var options = {
                    title: 'Break Contract',
                    message: 'Do you really want to break this contract?'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    OrgSvcs.delete({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'contracts', policyId: contract.contractId }, function () {
                        removeContractFromArray(contract, $scope.contracts);
                        removeContractFromArray(contract, $scope.filteredContracts);
                        $scope.version.modifiedOn = Date.now();
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                });
            };
            PageLifecycle.loadPage('ClientContracts', 'clientView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('client-contracts', [$scope.client.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ClientMetricsController = Apiman._module.controller("Apiman.ClientMetricsController", ['$q', '$scope', '$location', 'PageLifecycle', 'ClientEntityLoader', '$routeParams', 'MetricsSvcs', 'Configuration',
            ($q, $scope, $location, PageLifecycle, ClientEntityLoader, $routeParams, MetricsSvcs, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'metrics';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            $scope.metricsRange = '7days';
            $scope.metricsType = 'usage';
            var usageByApiChart;
            var renderApiUsageChart = function (data) {
                var columns = [];
                var x = ['x'];
                var dataPoints = ['data'];
                angular.forEach(data.data, function (numRequests, apiName) {
                    x.push(apiName);
                    dataPoints.push(numRequests);
                });
                if (data.data.length == 0) {
                    $scope.apiUsageChartNoData = true;
                }
                else {
                    columns.push(x);
                    columns.push(dataPoints);
                    usageByApiChart = c3.generate({
                        size: {
                            height: 250
                        },
                        data: {
                            x: 'x',
                            columns: columns,
                            type: 'bar'
                        },
                        axis: {
                            x: {
                                type: 'category'
                            }
                        },
                        bar: {
                            width: {
                                ratio: 0.9
                            }
                        },
                        legend: {
                            hide: true
                        },
                        bindto: '#api-usage-chart'
                    });
                }
            };
            var truncateToDay = function (date) {
                truncateToHour(date);
                date.setHours(0);
                return date;
            };
            var truncateToHour = function (date) {
                date.setMinutes(0);
                date.setSeconds(0);
                date.setMilliseconds(0);
                return date;
            };
            var getChartDateRange = function () {
                var from = new Date();
                var to = new Date();
                if ($scope.metricsRange == '90days') {
                    from = new Date(from.getTime() - Apiman.NINETY_DAYS);
                    truncateToDay(from);
                }
                else if ($scope.metricsRange == '30days') {
                    from = new Date(from.getTime() - Apiman.THIRTY_DAYS);
                    truncateToDay(from);
                }
                else if ($scope.metricsRange == '7days') {
                    from = new Date(from.getTime() - Apiman.SEVEN_DAYS);
                    truncateToDay(from);
                }
                else if ($scope.metricsRange == '24hours') {
                    from = new Date(from.getTime() - Apiman.ONE_DAY);
                    truncateToHour(from);
                }
                else if ($scope.metricsRange == 'hour') {
                    from = new Date(from.getTime() - Apiman.ONE_HOUR);
                }
                return {
                    from: from,
                    to: to
                };
            };
            // *******************************************************
            // Refresh the usage charts
            // *******************************************************
            var refreshUsageCharts = function () {
                $scope.apiUsageChartLoading = true;
                var range = getChartDateRange();
                var from = range.from;
                var to = range.to;
                var interval = 'day';
                if ($scope.metricsRange == '7days' || $scope.metricsRange == '24hours') {
                    interval = 'hour';
                }
                if ($scope.metricsRange == 'hour') {
                    interval = 'minute';
                }
                // Refresh the usage chart
                if (usageByApiChart) {
                    usageByApiChart.destroy();
                    usageByApiChart = null;
                }
                MetricsSvcs.getClientUsagePerApi(params.org, params.client, params.version, from, to, function (data) {
                    $scope.apiUsageChartLoading = false;
                    renderApiUsageChart(data);
                }, function (error) {
                    Logger.error('Error loading usage chart data: {0}', JSON.stringify(error));
                    $scope.usageChartLoading = false;
                    $scope.usageChartNoData = true;
                });
            };
            var refreshCharts = function () {
                if ($scope.metricsType == 'usage') {
                    refreshUsageCharts();
                }
            };
            $scope.refreshCharts = refreshCharts;
            $scope.$watch('metricsRange', function (newValue, oldValue) {
                if (newValue && newValue != oldValue) {
                    refreshCharts();
                }
            });
            $scope.$watch('metricsType', function (newValue, oldValue) {
                if (newValue && newValue != oldValue) {
                    refreshCharts();
                }
            });
            var pageData = ClientEntityLoader.getCommonData($scope, $location);
            PageLifecycle.loadPage('ClientMetrics', 'clientView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('client-metrics', [$scope.client.name]);
                refreshCharts();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ClientOverviewController = Apiman._module.controller("Apiman.ClientOverviewController", ['$q', '$scope', '$location', 'PageLifecycle', 'ClientEntityLoader', '$routeParams', 'Configuration',
            ($q, $scope, $location, PageLifecycle, ClientEntityLoader, $routeParams, Configuration) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'overview';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var pageData = ClientEntityLoader.getCommonData($scope, $location);
            PageLifecycle.loadPage('ClientOverview', 'clientView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('client-overview', [$scope.client.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ClientPoliciesController = Apiman._module.controller("Apiman.ClientPoliciesController", [
        '$q',
        '$scope',
        '$location',
        '$uibModal',
        'PageLifecycle',
        'ClientEntityLoader',
        'OrgSvcs',
        '$routeParams',
        'Configuration',
        'EntityStatusSvc',
        'CurrentUser',
            ($q, $scope, $location, $uibModal, PageLifecycle, ClientEntityLoader, OrgSvcs, $routeParams, Configuration, EntityStatusSvc, CurrentUser) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'policies';
            $scope.version = params.version;
            $scope.showMetrics = Configuration.ui.metrics;
            var removePolicy = function (policy) {
                angular.forEach($scope.policies, function (p, index) {
                    if (policy === p) {
                        $scope.policies.splice(index, 1);
                    }
                });
            };
            $scope.removePolicy = function (policy, size) {
                var options = {
                    title: 'Confirm Remove Policy',
                    message: 'Do you really want to remove this policy from the client app?'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    OrgSvcs.delete({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'policies', policyId: policy.id }, function (reply) {
                        removePolicy(policy);
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                });
            };
            $scope.reorderPolicies = function (reorderedPolicies) {
                var policyChainBean = {
                    policies: reorderedPolicies
                };
                OrgSvcs.save({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'reorderPolicies' }, policyChainBean, function () {
                    Logger.debug("Reordering POSTed successfully");
                }, function () {
                    Logger.debug("Reordering POST failed.");
                });
            };
            var pageData = ClientEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                policies: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'policies' }, function (policies) {
                        resolve(policies);
                    }, reject);
                })
            });
            PageLifecycle.loadPage('ClientPolicies', 'clientView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('client-policies', [$scope.client.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ClientRedirectController = Apiman._module.controller('Apiman.ClientRedirectController', ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, $routeParams) => {
            var orgId = $routeParams.org;
            var clientId = $routeParams.client;
            var pageData = {
                versions: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: orgId, entityType: 'clients', entityId: clientId, versionsOrActivity: 'versions' }, resolve, reject);
                })
            };
            $scope.organizationId = orgId;
            PageLifecycle.loadPage('ClientRedirect', 'clientView', pageData, $scope, function () {
                var version = $scope.versions[0].version;
                if (!version) {
                    PageLifecycle.handleError({ status: 404 });
                }
                else {
                    PageLifecycle.forwardTo('/orgs/{0}/clients/{1}/{2}', orgId, clientId, version);
                }
            });
        }]);
    Apiman.ClientEntityLoader = Apiman._module.factory('ClientEntityLoader', ['$q', 'OrgSvcs', 'Logger', '$rootScope', '$routeParams', 'EntityStatusSvc',
            ($q, OrgSvcs, Logger, $rootScope, $routeParams, EntityStatusSvc) => {
            return {
                getCommonData: function ($scope, $location) {
                    var params = $routeParams;
                    //console.log('params provided to ClientEntityLoader: ' + JSON.stringify(params));
                    return {
                        version: $q(function (resolve, reject) {
                            OrgSvcs.get({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: params.version }, function (version) {
                                $scope.org = version.client.organization;
                                $scope.client = version.client;
                                $rootScope.mruClient = version;
                                EntityStatusSvc.setEntity(version, 'client');
                                Logger.debug('client version: {0}', version);
                                resolve(version);
                            }, reject);
                        }),
                        versions: $q(function (resolve, reject) {
                            OrgSvcs.query({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions' }, resolve, reject);
                        })
                    };
                }
            };
        }]);
    Apiman.ClientEntityController = Apiman._module.controller('Apiman.ClientEntityController', [
        '$q',
        '$uibModal',
        '$scope',
        '$rootScope',
        '$location',
        'ActionSvcs',
        'Logger',
        'PageLifecycle',
        '$routeParams',
        'OrgSvcs',
        'EntityStatusSvc',
        'Configuration',
            ($q, $uibModal, $scope, $rootScope, $location, ActionSvcs, Logger, PageLifecycle, $routeParams, OrgSvcs, EntityStatusSvc, Configuration) => {
            var params = $routeParams;
            $scope.setEntityStatus = EntityStatusSvc.setEntityStatus;
            $scope.getEntityStatus = EntityStatusSvc.getEntityStatus;
            $scope.showMetrics = Configuration.ui.metrics;
            $scope.setVersion = function (client) {
                PageLifecycle.redirectTo('/orgs/{0}/clients/{1}/{2}', params.org, params.client, client.version);
            };
            $scope.isModified = function () {
                if (!$scope.version.publishedOn) {
                    return false;
                }
                var pub = new Date($scope.version.publishedOn);
                var mod = new Date($scope.version.modifiedOn);
                return mod > pub;
            };
            $scope.isReregisterable = function () {
                var rval = false;
                if ($scope.getEntityStatus() == 'Retired') {
                    Logger.info('Entity is retired, so it **CAN** be re-registered.');
                    rval = true;
                }
                if ($scope.getEntityStatus() == 'Registered') {
                    var mod = $scope.isModified();
                    rval = mod;
                }
                return rval;
            };
            $scope.registerClient = function () {
                $scope.registerButton.state = 'in-progress';
                $scope.reregisterButton.state = 'in-progress';
                var registerAction = {
                    type: 'registerClient',
                    entityId: params.client,
                    organizationId: params.org,
                    entityVersion: params.version
                };
                ActionSvcs.save(registerAction, function (reply) {
                    $scope.version.publishedOn = Date.now();
                    $scope.registerButton.state = 'complete';
                    $scope.reregisterButton.state = 'complete';
                    $scope.setEntityStatus('Registered');
                    Logger.info('---');
                }, PageLifecycle.handleError);
            };
            $scope.unregisterClient = function (size) {
                $scope.unregisterButton.state = 'in-progress';
                var options = {
                    publishedOnly: true,
                    title: 'Confirm Unregister App'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    //templateUrl: 'modal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    var unregisterAction = {
                        type: 'unregisterClient',
                        entityId: params.client,
                        organizationId: params.org,
                        entityVersion: params.version
                    };
                    ActionSvcs.save(unregisterAction, function (reply) {
                        $scope.version.status = 'Retired';
                        $scope.unregisterButton.state = 'complete';
                        $scope.setEntityStatus($scope.version.status);
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                    $scope.unregisterButton.state = 'complete';
                });
            };
            $scope.updateClientDescription = function (updatedDescription) {
                var updateClientBean = {
                    description: updatedDescription
                };
                OrgSvcs.update({
                    organizationId: $scope.organizationId,
                    entityType: 'clients',
                    entityId: $scope.client.id
                }, updateClientBean, function (success) { }, function (error) {
                    Logger.error('Unable to update client description: {0}', error);
                });
            };
            // ----- Delete --------------------->>>>
            // Add check for ability to delete, show/hide Delete option
            $scope.canDelete = function () { };
            // Call delete, open modal
            $scope.callDelete = function (size) {
                var modalInstance = $uibModal.open({
                    templateUrl: 'deleteModal.html',
                    controller: 'ModalClientAppDeleteCtrl',
                    size: size,
                    resolve: {
                        client: function () {
                            return $scope.client;
                        },
                        params: function () {
                            return params;
                        }
                    }
                });
                modalInstance.result.then(function (selectedItem) {
                    $scope.selected = selectedItem;
                }, function () {
                    Logger.info('Modal dismissed at: ' + new Date());
                });
            };
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ConsumerApiRedirectController = Apiman._module.controller("Apiman.ConsumerApiRedirectController", ['$q', '$scope', 'OrgSvcs', 'PageLifecycle', '$routeParams',
            ($q, $scope, OrgSvcs, PageLifecycle, $routeParams) => {
            var orgId = $routeParams.org;
            var apiId = $routeParams.api;
            var pageData = {
                versions: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: orgId, entityType: 'apis', entityId: apiId, versionsOrActivity: 'versions' }, resolve, reject);
                })
            };
            PageLifecycle.loadPage('ConsumerApiRedirect', undefined, pageData, $scope, function () {
                var version = $scope.versions[0].version;
                for (var i = 0; i < $scope.versions.length; i++) {
                    var v = $scope.versions[i];
                    if (v.status == 'Published') {
                        version = v.version;
                        break;
                    }
                }
                PageLifecycle.forwardTo('/browse/orgs/{0}/{1}/{2}', orgId, apiId, version);
            });
        }]);
    Apiman.ConsumerApiController = Apiman._module.controller("Apiman.ConsumerApiController", ['$q', '$scope', 'OrgSvcs', 'PageLifecycle', '$routeParams',
            ($q, $scope, OrgSvcs, PageLifecycle, $routeParams) => {
            $scope.params = $routeParams;
            $scope.chains = {};
            $scope.getPolicyChain = function (plan) {
                var planId = plan.planId;
                if (!$scope.chains[planId]) {
                    OrgSvcs.get({ organizationId: $routeParams.org, entityType: 'apis', entityId: $routeParams.api, versionsOrActivity: 'versions', version: $routeParams.version, policiesOrActivity: 'plans', policyId: plan.planId, policyChain: 'policyChain' }, function (policyReply) {
                        $scope.chains[planId] = policyReply.policies;
                    }, function (error) {
                        $scope.chains[planId] = [];
                    });
                }
            };
            var pageData = {
                version: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: $routeParams.org, entityType: 'apis', entityId: $routeParams.api, versionsOrActivity: 'versions', version: $routeParams.version }, resolve, reject);
                }),
                versions: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: $routeParams.org, entityType: 'apis', entityId: $routeParams.api, versionsOrActivity: 'versions' }, function (versions) {
                        var publishedVersions = [];
                        angular.forEach(versions, function (version) {
                            if (version.version == $routeParams.version) {
                                $scope.selectedApiVersion = version;
                            }
                            if (version.status == 'Published') {
                                publishedVersions.push(version);
                            }
                        });
                        resolve(publishedVersions);
                    }, reject);
                }),
                publicEndpoint: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: $routeParams.org, entityType: 'apis', entityId: $routeParams.api, versionsOrActivity: 'versions', version: $routeParams.version, policiesOrActivity: 'endpoint' }, resolve, function (error) {
                        resolve({
                            managedEndpoint: 'Not available.'
                        });
                    });
                }),
                plans: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: $routeParams.org, entityType: 'apis', entityId: $routeParams.api, versionsOrActivity: 'versions', version: $routeParams.version, policiesOrActivity: 'plans' }, resolve, reject);
                })
            };
            $scope.setVersion = function (apiVersion) {
                PageLifecycle.redirectTo('/browse/orgs/{0}/{1}/{2}', $routeParams.org, $routeParams.api, apiVersion.version);
            };
            PageLifecycle.loadPage('ConsumerApi', undefined, pageData, $scope, function () {
                $scope.api = $scope.version.api;
                $scope.org = $scope.api.organization;
                PageLifecycle.setPageTitle('consumer-api', [$scope.api.name]);
            });
            // Tooltip
            $scope.tooltipTxt = 'Copy to clipboard';
            // Called on clicking the button the tooltip is attached to
            $scope.tooltipChange = function () {
                $scope.tooltipTxt = 'Copied!';
            };
            // Call when the mouse leaves the button the tooltip is attached to
            $scope.tooltipReset = function () {
                setTimeout(function () {
                    $scope.tooltipTxt = 'Copy to clipboard';
                }, 100);
            };
            // Copy-to-Clipboard
            // Called if copy-to-clipboard functionality was successful
            $scope.copySuccess = function () {
                //console.log('Copied!');
            };
            // Called if copy-to-clipboard functionality was unsuccessful
            $scope.copyFail = function (err) {
                //console.error('Error!', err);
            };
        }]);
    Apiman.ConsumerApiDefController = Apiman._module.controller("Apiman.ConsumerApiDefController", ['$q', '$scope', 'OrgSvcs', 'PageLifecycle', '$routeParams', '$window', 'Logger', 'ApiDefinitionSvcs', 'Configuration',
            ($q, $scope, OrgSvcs, PageLifecycle, $routeParams, $window, Logger, ApiDefinitionSvcs, Configuration) => {
            $scope.params = $routeParams;
            $scope.chains = {};
            var pageData = {
                version: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: $routeParams.org, entityType: 'apis', entityId: $routeParams.api, versionsOrActivity: 'versions', version: $routeParams.version }, resolve, reject);
                })
            };
            const DisableTryItOutPlugin = function () {
                return {
                    statePlugins: {
                        spec: {
                            wrapSelectors: {
                                allowTryItOutFor: () => () => false
                            }
                        }
                    }
                };
            };
            // SwaggerUI Plugins
            const DisableAuthorizePlugin = function () {
                return {
                    wrapComponents: {
                        authorizeBtn: () => () => null
                    }
                };
            };
            PageLifecycle.loadPage('ConsumerApiDef', undefined, pageData, $scope, function () {
                $scope.api = $scope.version.api;
                $scope.org = $scope.api.organization;
                $scope.hasError = false;
                PageLifecycle.setPageTitle('consumer-api-def', [$scope.api.name]);
                if (($scope.version.definitionType == 'SwaggerJSON' || $scope.version.definitionType == 'SwaggerYAML') && SwaggerUIBundle) {
                    var url = ApiDefinitionSvcs.getApimanDefinitionUrl($scope.params.org, $scope.params.api, $scope.params.version);
                    Logger.debug("!!!!! Using definition URL: {0}", url);
                    $scope.definitionStatus = 'loading';
                    let ui;
                    let swaggerOptions = {
                        url: url,
                        dom_id: "#swagger-ui-container",
                        validatorUrl: "https://online.swagger.io/validator",
                        presets: [
                            SwaggerUIBundle.presets.apis
                        ],
                        layout: "BaseLayout",
                        sorter: "alpha",
                        requestInterceptor: function (request) {
                            // Only add auth header to requests where the URL matches the one specified above.
                            if (request.url === url) {
                                request.headers.Authorization = Configuration.getAuthorizationHeader();
                            }
                            return request;
                        },
                        onComplete: function () {
                            $scope.$apply(function () {
                                $scope.definitionStatus = 'complete';
                            });
                        },
                        // do error handling in the responseInterceptor
                        responseInterceptor: function (response) {
                            if (response.status == 500 && response.ok === false) {
                                $scope.$apply(function () {
                                    $scope.definitionStatus = 'error';
                                    $scope.hasError = true;
                                });
                            }
                            return response;
                        }
                    };
                    swaggerOptions.plugins = [];
                    swaggerOptions.plugins.push(DisableTryItOutPlugin, DisableAuthorizePlugin);
                    ui = SwaggerUIBundle(swaggerOptions);
                    $scope.hasDefinition = true;
                }
                else {
                    $scope.hasDefinition = false;
                }
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ConsumerApisController = Apiman._module.controller("Apiman.ConsumerApisController", ['$q', '$location', '$scope', 'ApimanSvcs', 'PageLifecycle', 'Logger',
            ($q, $location, $scope, ApimanSvcs, PageLifecycle, Logger) => {
            var params = $location.search();
            if (params.q) {
                $scope.apiName = params.q;
            }
            $scope.searchSvcs = function (value, currentPage, pageSize) {
                $location.search({
                    'q': value,
                    'cp': currentPage,
                    'ps': pageSize
                });
            };
            var pageData = {
                apis: $q(function (resolve, reject) {
                    if (params.q && params.cp && params.ps) {
                        var body = {};
                        body.filters = [];
                        body.page = params.cp;
                        body.pageSize = params.ps;
                        body.filters.push({ "name": "name", "value": "*" + params.q + "*", "operator": "like" });
                        var searchStr = angular.toJson(body);
                        ApimanSvcs.save({ entityType: 'search', secondaryType: 'apis' }, searchStr, function (result) {
                            $scope.resultCount = result.totalSize;
                            $scope.currentPage = params.cp;
                            $scope.pageSize = params.ps;
                            resolve(result.beans);
                        }, reject);
                    }
                    else {
                        resolve([]);
                    }
                })
            };
            function loadFirstPage() {
                if ($scope.apis.length == 0) {
                    $scope.searchSvcs('*', 1, 10);
                }
            }
            PageLifecycle.loadPage('ConsumerApis', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('consumer-apis');
                loadFirstPage();
                $scope.$applyAsync(function () {
                    $('#apiman-search').val('').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ConsumerOrgController = Apiman._module.controller("Apiman.ConsumerOrgController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', 'CurrentUser', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, CurrentUser, $routeParams) => {
            $scope.filterApis = function (value) {
                if (!value) {
                    $scope.filteredApis = $scope.apis;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.apis, function (api) {
                        if (api.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(api);
                        }
                    });
                    $scope.filteredApis = filtered;
                }
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: $routeParams.org, entityType: '' }, resolve, reject);
                }),
                members: $q(function (resolve, reject) {
                    // If we are not a member we don't send this request because it would throw an exception
                    if (CurrentUser.isMember($routeParams.org)) {
                        OrgSvcs.query({ organizationId: $routeParams.org, entityType: 'members' }, resolve, reject);
                    }
                    else {
                        resolve();
                    }
                }),
                apis: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: $routeParams.org, entityType: 'apis' }, resolve, reject);
                })
            };
            PageLifecycle.loadPage('ConsumerOrg', undefined, pageData, $scope, function () {
                $scope.org.isMember = CurrentUser.isMember($scope.org.id);
                $scope.filteredApis = $scope.apis;
                PageLifecycle.setPageTitle('consumer-org', [$scope.org.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ConsumerOrgsController = Apiman._module.controller("Apiman.ConsumerOrgsController", ['$q', '$location', '$scope', 'ApimanSvcs', 'PageLifecycle', 'Logger', 'CurrentUser',
            ($q, $location, $scope, ApimanSvcs, PageLifecycle, Logger, CurrentUser) => {
            var params = $location.search();
            if (params.q) {
                $scope.orgName = params.q;
            }
            $scope.searchOrg = function (value, currentPage, pageSize) {
                $location.search({
                    'q': value,
                    'cp': currentPage,
                    'ps': pageSize
                });
            };
            var pageData = {
                orgs: $q(function (resolve, reject) {
                    if (params.q && params.cp && params.ps) {
                        var body = {};
                        body.filters = [];
                        body.page = params.cp;
                        body.pageSize = params.ps;
                        body.filters.push({ "name": "name", "value": "*" + params.q + "*", "operator": "like" });
                        var searchStr = angular.toJson(body);
                        ApimanSvcs.save({ entityType: 'search', secondaryType: 'organizations' }, searchStr, function (result) {
                            $scope.resultCount = result.totalSize;
                            $scope.currentPage = params.cp;
                            $scope.pageSize = params.ps;
                            resolve(result.beans);
                        }, reject);
                    }
                    else {
                        resolve([]);
                    }
                })
            };
            function loadFirstPage() {
                if ($scope.orgs.length == 0) {
                    $scope.searchOrg('*', 1, 10);
                }
            }
            PageLifecycle.loadPage('ConsumerOrgs', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('consumer-orgs');
                loadFirstPage();
                $scope.$applyAsync(function () {
                    angular.forEach($scope.orgs, function (org) {
                        org.isMember = CurrentUser.isMember(org.id);
                    });
                    $('#apiman-search').val('').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.EditGatewayController = Apiman._module.controller("Apiman.EditGatewayController", ['$location', '$q', '$rootScope', '$routeParams', '$scope', '$uibModal', 'ApimanSvcs', 'PageLifecycle',
            ($location, $q, $rootScope, $routeParams, $scope, $uibModal, ApimanSvcs, PageLifecycle) => {
            $scope.isValid = false;
            var params = $routeParams;
            var validate = function () {
                $scope.testResult = 'none';
                // First validation
                var valid = true;
                if (!$scope.configuration.endpoint) {
                    valid = false;
                }
                if (!$scope.configuration.username) {
                    valid = false;
                }
                if (!$scope.configuration.password) {
                    valid = false;
                }
                if ($scope.configuration.password != $scope.passwordConfirm) {
                    valid = false;
                }
                $scope.isValid = valid;
                // Now dirty
                var dirty = false;
                if ($scope.gateway.description != $scope.originalGateway.description) {
                    dirty = true;
                }
                if ($scope.configuration.endpoint != $scope.originalConfig.endpoint) {
                    dirty = true;
                }
                if ($scope.configuration.username != $scope.originalConfig.username) {
                    dirty = true;
                }
                if ($scope.configuration.password != $scope.originalConfig.password) {
                    dirty = true;
                }
                $rootScope.isDirty = dirty;
            };
            var Gateway = function () {
                return {
                    description: $scope.gateway.description,
                    type: $scope.gateway.type,
                    configuration: angular.toJson($scope.configuration)
                };
            };
            var pageData = {
                gateway: $q(function (resolve, reject) {
                    ApimanSvcs.get({ entityType: 'gateways', secondaryType: params.gateway }, function (gateway) {
                        $scope.gateway = gateway;
                        $scope.configuration = JSON.parse(gateway.configuration);
                        $scope.passwordConfirm = $scope.configuration.password;
                        $scope.originalGateway = angular.copy(gateway);
                        $scope.originalConfig = angular.copy($scope.configuration);
                        $rootScope.isDirty = false;
                        resolve(gateway);
                    }, reject);
                })
            };
            var testGateway = function () {
                $scope.testButton.state = 'in-progress';
                var gateway = Gateway();
                ApimanSvcs.update({ entityType: 'gateways' }, gateway, function (reply) {
                    $scope.testButton.state = 'complete';
                    if (reply.success == true) {
                        Logger.info('Connected successfully to Gateway: {0}', reply.detail);
                        $scope.testResult = 'success';
                    }
                    else {
                        Logger.info('Failed to connect to Gateway: {0}', reply.detail);
                        $scope.testResult = 'error';
                        $scope.testErrorMessage = reply.detail;
                    }
                }, function (error) {
                    var charRegExp = /([\\]*)?"(pass|password)([\\]*)?":([\\]*)?"(.+?)([\\]*)?"/g;
                    var regTest = charRegExp.test(JSON.stringify(error));
                    if (regTest === true) {
                        error = JSON.stringify(error).replace(charRegExp, '\\"password\\":\\"*****\\"');
                    }
                    $scope.testButton.state = 'error';
                    $scope.testResult = 'error';
                    $scope.testErrorMessage = error;
                });
            };
            $scope.cancel = function () {
                $rootScope.isDirty = false;
                $location.path($rootScope.pluginName + '/admin/gateways');
            };
            $scope.updateGateway = function () {
                $scope.updateButton.state = 'in-progress';
                var gateway = Gateway();
                ApimanSvcs.update({ entityType: 'gateways', secondaryType: $scope.gateway.id }, gateway, function () {
                    $rootScope.isDirty = false;
                    PageLifecycle.redirectTo('/admin/gateways');
                }, PageLifecycle.handleError);
            };
            $scope.deleteGateway = function (size) {
                $scope.deleteButton.state = 'in-progress';
                var options = {
                    message: 'Do you really want to permanently delete this gateway?  This can be very destructive to any API published to it.',
                    title: 'Confirm Delete Gateway'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    ApimanSvcs.delete({ entityType: 'gateways', secondaryType: $scope.gateway.id }, function (reply) {
                        PageLifecycle.redirectTo('/admin/gateways');
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                    $scope.deleteButton.state = 'complete';
                });
            };
            $scope.testGateway = testGateway;
            PageLifecycle.loadPage('EditGateway', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('edit-gateway');
                $scope.$watch('gateway', validate, true);
                $scope.$watch('configuration', validate, true);
                $scope.$watch('passwordConfirm', validate);
                $('#apiman-gateway-description').focus();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.EditPluginController = Apiman._module.controller("Apiman.EditPluginController", [
        '$q',
        '$scope',
        '$location',
        'ApimanSvcs',
        'PageLifecycle',
        '$routeParams',
        'Logger',
            ($q, $scope, $location, ApimanSvcs, PageLifecycle, $routeParams, Logger) => {
            var params = $routeParams;
            var pageData = {
                plugin: $q(function (resolve, reject) {
                    ApimanSvcs.get({ entityType: 'plugins', secondaryType: params.plugin }, function (plugin) {
                        plugin.isSnapshot = plugin.version.indexOf("-SNAPSHOT", plugin.version.length - "-SNAPSHOT".length) !== -1;
                        resolve(plugin);
                    }, reject);
                })
            };
            $scope.reload = function () {
                Logger.debug("Now reloading the plugin!");
                $scope.reloadButton.state = 'in-progress';
                var body = {
                    groupId: $scope.plugin.groupId,
                    artifactId: $scope.plugin.artifactId,
                    version: $scope.plugin.version,
                    classifier: $scope.plugin.classifier,
                    type: $scope.plugin.type
                };
                ApimanSvcs.save({ entityType: 'plugins' }, body, function (reply) {
                    PageLifecycle.redirectTo('/admin/plugins');
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('EditPlugin', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('plugin-details');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.EditPolicyController = Apiman._module.controller("Apiman.EditPolicyController", ['$q', '$location', '$scope', 'OrgSvcs', 'ApimanSvcs', 'PageLifecycle', 'Logger', '$routeParams', 'EntityStatusSvc', 'CurrentUser',
            ($q, $location, $scope, OrgSvcs, ApimanSvcs, PageLifecycle, Logger, $routeParams, EntityStatusSvc, CurrentUser) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            var requiredPermissionMap = {
                clients: 'clientEdit',
                apis: 'apiEdit',
                plans: 'planEdit'
            };
            var etype = params.type;
            $scope.isEntityDisabled = EntityStatusSvc.isEntityDisabled;
            var pageData = {
                version: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: etype, entityId: params.id, versionsOrActivity: 'versions', version: params.ver }, resolve, reject);
                }),
                policy: $q(function (resolve, reject) {
                    OrgSvcs.get({
                        organizationId: params.org,
                        entityType: etype,
                        entityId: params.id,
                        versionsOrActivity: 'versions',
                        version: params.ver,
                        policiesOrActivity: 'policies',
                        policyId: params.policy
                    }, function (policy) {
                        var config = new Object();
                        try {
                            config = JSON.parse(policy.configuration);
                        }
                        catch (e) {
                        }
                        $scope.config = config;
                        if (policy.definition.formType == 'JsonSchema') {
                            $scope.include = 'plugins/api-manager/html/policyForms/JsonSchema.include';
                        }
                        else {
                            var inc = Apiman.ConfigForms[policy.definition.id];
                            if (!inc) {
                                inc = 'Default.include';
                            }
                            $scope.include = 'plugins/api-manager/html/policyForms/' + inc;
                        }
                        $scope.selectedDef = policy.definition;
                        resolve(policy);
                    }, reject);
                })
            };
            $scope.setValid = function (valid) {
                $scope.isValid = valid;
            };
            $scope.setConfig = function (config) {
                $scope.config = config;
            };
            $scope.getConfig = function () {
                return $scope.config;
            };
            $scope.updatePolicy = function () {
                $scope.updateButton.state = 'in-progress';
                var updatedPolicy = {
                    configuration: angular.toJson($scope.config)
                };
                var etype = params.type;
                OrgSvcs.update({
                    organizationId: params.org,
                    entityType: etype,
                    entityId: params.id,
                    versionsOrActivity: 'versions',
                    version: params.ver,
                    policiesOrActivity: 'policies',
                    policyId: params.policy
                }, updatedPolicy, function () {
                    PageLifecycle.redirectTo('/orgs/{0}/{1}/{2}/{3}/policies', params.org, params.type, params.id, params.ver);
                }, PageLifecycle.handleError);
            };
            var requiredPermission = requiredPermissionMap[etype];
            PageLifecycle.loadPage('EditPolicy', requiredPermission, pageData, $scope, function () {
                EntityStatusSvc.setEntity($scope.version, etype);
                // Note: not using the apiman-permission directive in the template for this page because
                // we cannot hard-code the required permission.  The required permission changes depending
                // on the entity type of the parent of the policy.  Instead we figure it out and set it here.
                $scope.hasPermission = CurrentUser.hasPermission(params.org, requiredPermission);
                PageLifecycle.setPageTitle('edit-policy');
                $('#apiman-description').focus();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.EditPolicyDefController = Apiman._module.controller("Apiman.EditPolicyDefController", ['$q', '$scope', '$location', 'ApimanSvcs', 'PageLifecycle', '$routeParams',
            ($q, $scope, $location, ApimanSvcs, PageLifecycle, $routeParams) => {
            var params = $routeParams;
            var pageData = {
                policyDef: $q(function (resolve, reject) {
                    ApimanSvcs.get({ entityType: 'policyDefs', secondaryType: params.policyDef }, function (policyDef) {
                        resolve(policyDef);
                        $scope.policyDefJSON = angular.toJson(policyDef, true);
                    }, reject);
                })
            };
            $scope.updatePolicyDef = function () {
                var policyDefUpdate = {};
                var policyDef = JSON.parse($scope.policyDefJSON);
                policyDefUpdate.name = policyDef.name;
                policyDefUpdate.description = policyDef.description;
                policyDefUpdate.icon = policyDef.icon;
                ApimanSvcs.update({ entityType: 'policyDefs', secondaryType: $scope.policyDef.id }, policyDefUpdate, function (reply) {
                    PageLifecycle.redirectTo('/admin/policyDefs');
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('EditPolicyDef', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('edit-policyDef');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.EditRoleController = Apiman._module.controller("Apiman.EditRoleController", [
        '$q',
        '$scope',
        '$location',
        '$uibModal',
        'ApimanSvcs',
        'PageLifecycle',
        'Logger',
        '$routeParams',
            ($q, $scope, $location, $uibModal, ApimanSvcs, PageLifecycle, Logger, $routeParams) => {
            var params = $routeParams;
            var allPermissions = ['orgView', 'orgEdit', 'orgAdmin',
                'planView', 'planEdit', 'planAdmin',
                'apiView', 'apiEdit', 'apiAdmin',
                'clientView', 'clientEdit', 'clientAdmin'];
            $scope.isValid = true;
            $scope.rolePermissions = {};
            angular.forEach(allPermissions, function (value) {
                $scope.rolePermissions[value] = false;
            });
            var validate = function () {
                var atLeastOne = false;
                angular.forEach($scope.rolePermissions, function (value, key) {
                    if (value == true) {
                        atLeastOne = true;
                    }
                });
                return atLeastOne;
            };
            $scope.$watch('rolePermissions', function (newValue) {
                $scope.isValid = validate();
            }, true);
            var pageData = {
                role: $q(function (resolve, reject) {
                    ApimanSvcs.get({ entityType: 'roles', secondaryType: params.role }, function (role) {
                        angular.forEach(role.permissions, function (name) {
                            $scope.rolePermissions[name] = true;
                        });
                        resolve(role);
                    }, reject);
                })
            };
            $scope.updateRole = function () {
                $scope.updateButton.state = 'in-progress';
                var permissions = [];
                angular.forEach($scope.rolePermissions, function (value, key) {
                    if (value == true) {
                        permissions.push(key);
                    }
                });
                var role = {};
                role.name = $scope.role.name;
                role.description = $scope.role.description;
                role.permissions = permissions;
                role.autoGrant = $scope.role.autoGrant;
                ApimanSvcs.update({ entityType: 'roles', secondaryType: $scope.role.id }, role, function (reply) {
                    PageLifecycle.redirectTo('/admin/roles');
                }, PageLifecycle.handleError);
            };
            $scope.deleteRole = function (size) {
                $scope.deleteButton.state = 'in-progress';
                var options = {
                    message: 'Do you really want to delete this role?',
                    title: 'Confirm Delete Role'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    ApimanSvcs.delete({ entityType: 'roles', secondaryType: $scope.role.id }, function (reply) {
                        PageLifecycle.redirectTo('/admin/roles');
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                    $scope.deleteButton.state = 'complete';
                });
            };
            PageLifecycle.loadPage('EditRole', 'admin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('edit-role');
                $('#apiman-description').focus();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ImportPolicyDefsController = Apiman._module.controller("Apiman.ImportPolicyDefsController", ['$q', '$scope', '$location', 'ApimanSvcs', 'PageLifecycle',
            ($q, $scope, $location, ApimanSvcs, PageLifecycle) => {
            $scope.isData = true;
            $scope.isConfirm = false;
            $scope.isValid = false;
            $scope.parseJSON = function () {
                var policiesImport = JSON.parse($scope.policyDefsJSON);
                var policyDefs = [];
                if (policiesImport.constructor === Array) {
                    policyDefs = policiesImport;
                }
                else {
                    policyDefs.push(policiesImport);
                }
                $scope.policyDefs = policyDefs;
                $scope.isData = false;
                $scope.isConfirm = true;
            };
            $scope.$watch('policyDefsJSON', function (newValue) {
                try {
                    JSON.parse($scope.policyDefsJSON);
                    $scope.isValid = true;
                }
                catch (e) {
                    $scope.isValid = false;
                }
            });
            $scope.importPolicyDefs = function () {
                $scope.yesButton.state = 'in-progress';
                var promises = [];
                angular.forEach($scope.policyDefs, function (def) {
                    promises.push($q(function (resolve, reject) {
                        ApimanSvcs.save({ entityType: 'policyDefs' }, def, resolve, reject);
                    }));
                });
                $q.all(promises).then(function () {
                    PageLifecycle.redirectTo('/admin/policyDefs');
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('ImportPolicyDefs', 'admin', undefined, $scope, function () {
                PageLifecycle.setPageTitle('import-policyDefs');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewApiController = Apiman._module.controller("Apiman.NewApiController", ['$q', '$location', '$scope', 'CurrentUser', 'UserSvcs', 'OrgSvcs', 'PageLifecycle', '$rootScope',
            ($q, $location, $scope, CurrentUser, UserSvcs, OrgSvcs, PageLifecycle, $rootScope) => {
            var recentOrg = $rootScope.mruOrg;
            var pageData = {
                organizations: $q(function (resolve, reject) {
                    return CurrentUser.getCurrentUser().then(function (currentUser) {
                        return UserSvcs.query({ user: currentUser.username, entityType: 'apiorgs' }, function (orgs) {
                            if (recentOrg) {
                                $scope.selectedOrg = recentOrg;
                            }
                            else if (orgs.length > 0) {
                                $scope.selectedOrg = orgs[0];
                            }
                            resolve(orgs);
                        }, reject);
                    });
                })
            };
            $scope.setOrg = function (org) {
                $scope.selectedOrg = org;
            };
            $scope.saveNewApi = function () {
                $scope.createButton.state = 'in-progress';
                OrgSvcs.save({ organizationId: $scope.selectedOrg.id, entityType: 'apis' }, $scope.api, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/apis/{1}/{2}', reply.organization.id, reply.id, $scope.api.initialVersion);
                }, PageLifecycle.handleError);
            };
            $scope.api = {
                initialVersion: '1.0'
            };
            PageLifecycle.loadPage('NewApi', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('new-api');
                $scope.$applyAsync(function () {
                    $('#apiman-entityname').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewApiVersionController = Apiman._module.controller("Apiman.NewApiVersionController", ['$q', '$location', '$scope', 'OrgSvcs', 'PageLifecycle', 'Logger', '$routeParams',
            ($q, $location, $scope, OrgSvcs, PageLifecycle, Logger, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.apiversion = {
                clone: true,
                cloneVersion: params.version
            };
            $scope.saveNewApiVersion = function () {
                $scope.createButton.state = 'in-progress';
                Logger.info('Creating new version {0} of api {1} / {2}', $scope.apiversion.version, params.api, params.org);
                OrgSvcs.save({ organizationId: params.org, entityType: 'apis', entityId: params.api, versionsOrActivity: 'versions', version: '' }, $scope.apiversion, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/apis/{1}/{2}', params.org, params.api, reply.version);
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewApiVersion', 'apiEdit', undefined, $scope, function () {
                PageLifecycle.setPageTitle('new-api-version');
                $scope.$applyAsync(function () {
                    $('#apiman-version').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewClientController = Apiman._module.controller("Apiman.NewClientController", ['$q', '$location', '$scope', 'CurrentUser', 'UserSvcs', 'OrgSvcs', 'PageLifecycle', '$rootScope',
            ($q, $location, $scope, CurrentUser, UserSvcs, OrgSvcs, PageLifecycle, $rootScope) => {
            var recentOrg = $rootScope.mruOrg;
            var pageData = {
                organizations: $q(function (resolve, reject) {
                    return CurrentUser.getCurrentUser().then(function (currentUser) {
                        return UserSvcs.query({ user: currentUser.username, entityType: 'clientorgs' }, function (orgs) {
                            if (recentOrg) {
                                $scope.selectedOrg = recentOrg;
                            }
                            else if (orgs.length > 0) {
                                $scope.selectedOrg = orgs[0];
                            }
                            resolve(orgs);
                        }, reject);
                    });
                }),
            };
            $scope.setOrg = function (org) {
                $scope.selectedOrg = org;
            };
            $scope.saveNewClient = function () {
                $scope.createButton.state = 'in-progress';
                OrgSvcs.save({ organizationId: $scope.selectedOrg.id, entityType: 'clients' }, $scope.client, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/clients/{1}/{2}', reply.organization.id, reply.id, $scope.client.initialVersion);
                }, PageLifecycle.handleError);
            };
            $scope.client = {
                initialVersion: '1.0'
            };
            PageLifecycle.loadPage('NewClient', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('new-client');
                $scope.$applyAsync(function () {
                    $('#apiman-entityname').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewClientVersionController = Apiman._module.controller("Apiman.NewClientVersionController", ['$q', '$location', '$scope', 'OrgSvcs', 'PageLifecycle', '$routeParams',
            ($q, $location, $scope, OrgSvcs, PageLifecycle, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.clientversion = {
                clone: true,
                cloneVersion: params.version
            };
            $scope.saveNewClientVersion = function () {
                $scope.createButton.state = 'in-progress';
                OrgSvcs.save({ organizationId: params.org, entityType: 'clients', entityId: params.client, versionsOrActivity: 'versions', version: '' }, $scope.clientversion, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/clients/{1}/{2}', params.org, params.client, reply.version);
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewClientVersion', 'clientEdit', undefined, $scope, function () {
                PageLifecycle.setPageTitle('new-client-version');
                $scope.$applyAsync(function () {
                    $('#apiman-version').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path='../apimanPlugin.ts'/>
var Apiman;
(function (Apiman) {
    Apiman.NewContractController = Apiman._module.controller('Apiman.NewContractController', ['$location', '$q', '$rootScope', '$scope', '$uibModal', 'UserSvcs', 'CurrentUser', 'Logger', 'OrgSvcs', 'PageLifecycle',
            ($location, $q, $rootScope, $scope, $uibModal, UserSvcs, CurrentUser, Logger, OrgSvcs, PageLifecycle) => {
            var params = $location.search();
            var apiId = params.api;
            var apiOrgId = params.apiorg;
            var apiVer = params.apiv;
            var planId = params.planid;
            $scope.saving = false;
            $scope.selectedClientVersion = null;
            $scope.refreshClientVersions = function (organizationId, clientId, onSuccess, onError) {
                OrgSvcs.query({
                    organizationId: organizationId,
                    entityType: 'clients',
                    entityId: clientId,
                    versionsOrActivity: 'versions'
                }, function (versions) {
                    var plainVersions = [];
                    angular.forEach(versions, function (version) {
                        if (version.status == 'Created' || version.status == 'Ready' || version.status == 'Registered') {
                            plainVersions.push(version.version);
                        }
                    });
                    $scope.clientVersions = plainVersions;
                    if (onSuccess) {
                        onSuccess(plainVersions);
                    }
                }, PageLifecycle.handleError);
            };
            var pageData = {
                clients: $q(function (resolve, reject) {
                    return CurrentUser.getCurrentUser().then(function (currentUser) {
                        UserSvcs.query({ user: currentUser.username, entityType: 'editable-clients' }, function (clients) {
                            Logger.info('clients: {0}', clients);
                            if ($rootScope.mruClient) {
                                for (var i = 0; i < clients.length; i++) {
                                    var client = clients[i];
                                    if (client.organizationId == $rootScope.mruClient.client.organization.id && client.id == $rootScope.mruClient.client.id) {
                                        $scope.selectedClient = client;
                                    }
                                }
                            }
                            else if (clients) {
                                $scope.selectedClient = clients[0];
                            }
                            else {
                                $scope.selectedClient = undefined;
                            }
                            $scope.changedClient($scope.selectedClient);
                            resolve(clients);
                        }, reject);
                    });
                }),
                selectedApi: $q(function (resolve, reject) {
                    if (apiId && apiOrgId && apiVer) {
                        Logger.debug('Loading api {0}/{1} version {2}.', apiOrgId, apiId, apiVer);
                        OrgSvcs.get({
                            organizationId: apiOrgId,
                            entityType: 'apis',
                            entityId: apiId,
                            versionsOrActivity: 'versions',
                            version: apiVer
                        }, function (apiVersion) {
                            apiVersion.organizationName = apiVersion.api.organization.name;
                            apiVersion.organizationId = apiVersion.api.organization.id;
                            apiVersion.name = apiVersion.api.name;
                            apiVersion.id = apiVersion.api.id;
                            resolve(apiVersion);
                        }, reject);
                    }
                    else {
                        resolve(undefined);
                    }
                })
            };
            $scope.changedClient = function (newValue) {
                Logger.debug('Client App selected: {0}', newValue);
                $scope.clientVersions = [];
                $scope.selectedClient = newValue;
                if (newValue) {
                    $scope.refreshClientVersions(newValue.organizationId, newValue.id, function (versions) {
                        Logger.debug('Versions: {0}', versions);
                        if ($rootScope.mruClient) {
                            if ($rootScope.mruClient.client.organization.id == newValue.organizationId && $rootScope.mruClient.client.id == newValue.id) {
                                $scope.selectedClientVersion = $rootScope.mruClient.version;
                            }
                        }
                        else {
                            if (versions.length > 0) {
                                $scope.selectedClientVersion = versions[0];
                            }
                        }
                    });
                }
            };
            $scope.selectApi = function () {
                var options = {
                    publishedOnly: true
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'selectApiModal.html',
                    controller: 'ModalSelectApiCtrl',
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function (apiVersion) {
                    $scope.selectedApi = apiVersion;
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                });
            };
            $scope.toggleAnimation = function () {
                $scope.animationsEnabled = !$scope.animationsEnabled;
            };
            $scope.changedPlan = function (newValue) {
                $scope.selectedPlan = newValue;
            };
            $scope.$watch('selectedApi', function (newValue) {
                if (!newValue) {
                    $scope.plans = undefined;
                    $scope.selectedPlan = undefined;
                    return;
                }
                Logger.debug('Api selection made, fetching plans.');
                OrgSvcs.query({
                    organizationId: newValue.organizationId,
                    entityType: 'apis',
                    entityId: newValue.id,
                    versionsOrActivity: 'versions',
                    version: newValue.version,
                    policiesOrActivity: 'plans'
                }, function (plans) {
                    $scope.plans = plans;
                    Logger.debug('Found {0} plans: {1}.', plans.length, plans);
                    if (plans.length > 0) {
                        if (planId) {
                            for (var i = 0; i < plans.length; i++) {
                                if (plans[i].planId == planId) {
                                    $scope.selectedPlan = plans[i];
                                }
                            }
                        }
                        else {
                            $scope.selectedPlan = undefined;
                            if (plans.length > 0) {
                                $scope.selectedPlan = plans[0];
                            }
                        }
                    }
                    else {
                        $scope.plans = undefined;
                    }
                }, PageLifecycle.handleError);
            });
            $scope.isDisabled = function () {
                return (!$scope.selectedClient || !$scope.selectedClientVersion || !$scope.selectedPlan || !$scope.selectedApi);
            };
            $scope.createContract = function () {
                Logger.log('Creating new contract from {0}/{1} ({2}) to {3}/{4} ({5}) through the {6} plan!', $scope.selectedClient.organizationName, $scope.selectedClient.name, $scope.selectedClientVersion, $scope.selectedApi.organizationName, $scope.selectedApi.name, $scope.selectedApi.version, $scope.selectedPlan.planName);
                $scope.createButton.state = 'in-progress';
                var newContract = {
                    apiOrgId: $scope.selectedApi.organizationId,
                    apiId: $scope.selectedApi.id,
                    apiVersion: $scope.selectedApi.version,
                    planId: $scope.selectedPlan.planId
                };
                OrgSvcs.save({
                    organizationId: $scope.selectedClient.organizationId,
                    entityType: 'clients',
                    entityId: $scope.selectedClient.id,
                    versionsOrActivity: 'versions',
                    version: $scope.selectedClientVersion,
                    policiesOrActivity: 'contracts'
                }, newContract, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/clients/{1}/{2}/contracts', $scope.selectedClient.organizationId, $scope.selectedClient.id, $scope.selectedClientVersion);
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewContract', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('new-contract');
            });
        }
    ]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewGatewayController = Apiman._module.controller("Apiman.NewGatewayController", ['$q', '$location', '$scope', 'ApimanSvcs', 'PageLifecycle', 'CurrentUser', 'Logger',
            ($q, $location, $scope, ApimanSvcs, PageLifecycle, CurrentUser, Logger) => {
            $scope.isValid = false;
            $scope.gateway = {};
            $scope.configuration = {
                endpoint: 'http://localhost:8080/apiman-gateway-api/'
            };
            var validate = function () {
                $scope.testResult = 'none';
                var valid = true;
                if (!$scope.gateway.name) {
                    valid = false;
                }
                if (!$scope.configuration.endpoint) {
                    valid = false;
                }
                if (!$scope.configuration.username) {
                    valid = false;
                }
                if (!$scope.configuration.password) {
                    valid = false;
                }
                if ($scope.configuration.password != $scope.passwordConfirm) {
                    valid = false;
                }
                $scope.isValid = valid;
            };
            $scope.$watch('gateway', validate, true);
            $scope.$watch('configuration', validate, true);
            $scope.$watch('passwordConfirm', validate);
            var Gateway = function () {
                var gateway = $scope.gateway;
                gateway.configuration = angular.toJson($scope.configuration);
                gateway.type = 'REST';
                return gateway;
            };
            var testGateway = function () {
                $scope.testButton.state = 'in-progress';
                var gateway = Gateway();
                ApimanSvcs.update({ entityType: 'gateways' }, gateway, function (reply) {
                    $scope.testButton.state = 'complete';
                    if (reply.success == true) {
                        Logger.info('Connected successfully to Gateway: {0}', reply.detail);
                        $scope.testResult = 'success';
                    }
                    else {
                        Logger.info('Failed to connect to Gateway: {0}', reply.detail);
                        $scope.testResult = 'error';
                        $scope.testErrorMessage = reply.detail;
                    }
                }, function (error) {
                    var charRegExp = /([\\]*)?"(pass|password)([\\]*)?":([\\]*)?"(.+?)([\\]*)?"/g;
                    var regTest = charRegExp.test(JSON.stringify(error));
                    if (regTest === true) {
                        error = JSON.stringify(error).replace(charRegExp, '\\"password\\":\\"*****\\"');
                    }
                    $scope.testButton.state = 'error';
                    $scope.testResult = 'error';
                    $scope.testErrorMessage = error;
                });
            };
            $scope.createGateway = function () {
                $scope.createButton.state = 'in-progress';
                var gateway = Gateway();
                ApimanSvcs.save({ entityType: 'gateways' }, gateway, function (reply) {
                    PageLifecycle.redirectTo('/admin/gateways');
                }, PageLifecycle.handleError);
            };
            $scope.testGateway = testGateway;
            PageLifecycle.loadPage('NewGateway', 'admin', undefined, $scope, function () {
                PageLifecycle.setPageTitle('new-gateway');
                $('#apiman-gateway-name').focus();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewOrgController = Apiman._module.controller("Apiman.NewOrgController", ['$q', '$location', '$scope', 'OrgSvcs', 'PageLifecycle', 'CurrentUser',
            ($q, $location, $scope, OrgSvcs, PageLifecycle, CurrentUser) => {
            $scope.saveNewOrg = function () {
                $scope.createButton.state = 'in-progress';
                OrgSvcs.save($scope.org, function (reply) {
                    CurrentUser.clear();
                    PageLifecycle.redirectTo('/orgs/{0}/plans', reply.id);
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewOrg', undefined, undefined, $scope, function () {
                PageLifecycle.setPageTitle('new-org');
                $scope.$applyAsync(function () {
                    $('#apiman-entityname').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewPlanController = Apiman._module.controller("Apiman.NewPlanController", ['$q', '$location', '$scope', 'CurrentUser', 'UserSvcs', 'OrgSvcs', 'PageLifecycle', '$rootScope',
            ($q, $location, $scope, CurrentUser, UserSvcs, OrgSvcs, PageLifecycle, $rootScope) => {
            var recentOrg = $rootScope.mruOrg;
            var pageData = {
                organizations: $q(function (resolve, reject) {
                    return CurrentUser.getCurrentUser().then(function (currentUser) {
                        return UserSvcs.query({ user: currentUser.username, entityType: 'planorgs' }, function (orgs) {
                            if (recentOrg) {
                                $scope.selectedOrg = recentOrg;
                            }
                            else if (orgs.length > 0) {
                                $scope.selectedOrg = orgs[0];
                            }
                            resolve(orgs);
                        }, reject);
                    });
                })
            };
            $scope.setOrg = function (org) {
                $scope.selectedOrg = org;
            };
            $scope.saveNewPlan = function () {
                $scope.createButton.state = 'in-progress';
                OrgSvcs.save({ organizationId: $scope.selectedOrg.id, entityType: 'plans' }, $scope.plan, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/plans/{1}/{2}', reply.organization.id, reply.id, $scope.plan.initialVersion);
                }, PageLifecycle.handleError);
            };
            // Initialize the model - the default initial version for a new plan is always 1.0
            $scope.plan = {
                initialVersion: '1.0'
            };
            PageLifecycle.loadPage('NewPlan', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('new-plan');
                $scope.$applyAsync(function () {
                    $('#apiman-entityname').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewPlanVersionController = Apiman._module.controller("Apiman.NewPlanVersionController", ['$q', '$location', '$scope', 'OrgSvcs', 'PageLifecycle', '$routeParams',
            ($q, $location, $scope, OrgSvcs, PageLifecycle, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.planversion = {
                clone: true,
                cloneVersion: params.version
            };
            $scope.saveNewPlanVersion = function () {
                $scope.createButton.state = 'in-progress';
                OrgSvcs.save({ organizationId: params.org, entityType: 'plans', entityId: params.plan, versionsOrActivity: 'versions', version: '' }, $scope.planversion, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/plans/{1}/{2}', params.org, params.plan, reply.version);
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewPlanVersion', 'planEdit', undefined, $scope, function () {
                PageLifecycle.setPageTitle('new-plan-version');
                $scope.$applyAsync(function () {
                    $('#apiman-version').focus();
                });
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewPluginController = Apiman._module.controller("Apiman.NewPluginController", ['$q', '$scope', '$location', 'ApimanSvcs', 'PageLifecycle', '$routeParams',
            ($q, $scope, $location, ApimanSvcs, PageLifecycle, $routeParams) => {
            $scope.plugin = {};
            var params = $routeParams;
            if (params && params.groupId) {
                $scope.plugin = {
                    groupId: params.groupId,
                    artifactId: params.artifactId,
                    version: params.version
                };
                if (params.classifier) {
                    $scope.plugin.classifier = params.classifier;
                }
                if (params.type) {
                    $scope.plugin.type = params.type;
                }
            }
            var validate = function () {
                var valid = true;
                if (!$scope.plugin.groupId) {
                    valid = false;
                }
                if (!$scope.plugin.artifactId) {
                    valid = false;
                }
                if (!$scope.plugin.version) {
                    valid = false;
                }
                $scope.isValid = valid;
            };
            $scope.$watch('plugin', function (newValue) {
                validate();
            }, true);
            $scope.addPlugin = function () {
                $scope.addButton.state = 'in-progress';
                ApimanSvcs.save({ entityType: 'plugins' }, $scope.plugin, function (reply) {
                    PageLifecycle.redirectTo('/admin/plugins');
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewPlugin', 'admin', undefined, $scope, function () {
                PageLifecycle.setPageTitle('new-plugin');
                $('#apiman-group-id').focus();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.ConfigForms = {
        BASICAuthenticationPolicy: 'basic-auth.include',
        IgnoredResourcesPolicy: 'ignored-resources.include',
        IPBlacklistPolicy: 'ip-list.include',
        IPWhitelistPolicy: 'ip-list.include',
        RateLimitingPolicy: 'rate-limiting.include',
        QuotaPolicy: 'quota.include',
        TransferQuotaPolicy: 'transfer-quota.include',
        AuthorizationPolicy: 'authorization.include',
        URLRewritingPolicy: 'url-rewriting.include',
        CachingPolicy: 'caching.include',
        CachingResourcesPolicy: 'caching-resources.include',
        TimeRestrictedAccessPolicy: 'time-restricted-access.include'
    };
    Apiman.NewPolicyController = Apiman._module.controller("Apiman.NewPolicyController", ['$q', '$location', '$scope', 'OrgSvcs', 'ApimanSvcs', 'PageLifecycle', 'Logger', '$routeParams',
            ($q, $location, $scope, OrgSvcs, ApimanSvcs, PageLifecycle, Logger, $routeParams) => {
            var params = $routeParams;
            var etype = params.type;
            var pageData = {
                version: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: etype, entityId: params.id, versionsOrActivity: 'versions', version: params.ver }, resolve, reject);
                }),
                policyDefs: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'policyDefs' }, function (policyDefs) {
                        $scope.selectedDefId = null;
                        resolve(policyDefs);
                    }, reject);
                })
            };
            function loadTemplate(newValue) {
                if (!newValue) {
                    $scope.include = undefined;
                }
                else {
                    $scope.config = new Object();
                    if ($scope.selectedDef.formType == 'JsonSchema') {
                        $scope.include = 'plugins/api-manager/html/policyForms/JsonSchema.include';
                    }
                    else {
                        var inc = Apiman.ConfigForms[$scope.selectedDef.id];
                        if (!inc) {
                            inc = 'Default.include';
                        }
                        $scope.include = 'plugins/api-manager/html/policyForms/' + inc;
                    }
                }
            }
            $scope.changeSelectedDefId = function (newValue) {
                if (newValue.id) {
                    var newDef = undefined;
                    angular.forEach($scope.policyDefs, function (def) {
                        if (def.id == newValue.id) {
                            newDef = def;
                        }
                    });
                    $scope.selectedDef = newDef;
                    loadTemplate(newValue);
                }
            };
            $scope.$watch('selectedDef', function (newValue) {
                if (!newValue) {
                    $scope.include = undefined;
                }
                else {
                    $scope.config = new Object();
                    if ($scope.selectedDef.formType == 'JsonSchema') {
                        $scope.include = 'plugins/api-manager/html/policyForms/JsonSchema.include';
                    }
                    else {
                        var inc = Apiman.ConfigForms[$scope.selectedDef.id];
                        if (!inc) {
                            inc = 'Default.include';
                        }
                        $scope.include = 'plugins/api-manager/html/policyForms/' + inc;
                    }
                }
            });
            $scope.setValid = function (valid) {
                $scope.isValid = valid;
            };
            $scope.setConfig = function (config) {
                $scope.config = config;
            };
            $scope.getConfig = function () {
                return $scope.config;
            };
            $scope.addPolicy = function () {
                $scope.createButton.state = 'in-progress';
                var newPolicy = {
                    definitionId: $scope.selectedDef.id,
                    configuration: angular.toJson($scope.config)
                };
                var etype = params.type;
                OrgSvcs.save({ organizationId: params.org, entityType: etype, entityId: params.id, versionsOrActivity: 'versions', version: params.ver, policiesOrActivity: 'policies' }, newPolicy, function (reply) {
                    PageLifecycle.redirectTo('/orgs/{0}/{1}/{2}/{3}/policies', params.org, params.type, params.id, params.ver);
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewPolicy', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('new-policy');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.NewRoleController = Apiman._module.controller("Apiman.NewRoleController", ['$q', '$location', '$scope', 'OrgSvcs', 'PageLifecycle', 'CurrentUser', 'Logger', 'ApimanSvcs',
            ($q, $location, $scope, OrgSvcs, PageLifecycle, CurrentUser, Logger, ApimanSvcs) => {
            $scope.role = {};
            $scope.rolePermissions = {};
            $scope.isValid = false;
            var validate = function () {
                var valid = true;
                if (!$scope.role.name) {
                    valid = false;
                }
                var atLeastOne = false;
                angular.forEach($scope.rolePermissions, function (value, key) {
                    if (value == true) {
                        atLeastOne = true;
                    }
                });
                if (!atLeastOne) {
                    valid = false;
                }
                $scope.isValid = valid;
            };
            $scope.$watch('role', function (newValue) {
                validate();
            }, true);
            $scope.$watch('rolePermissions', function (newValue) {
                validate();
            }, true);
            $scope.addRole = function () {
                $scope.createButton.state = 'in-progress';
                var permissions = [];
                angular.forEach($scope.rolePermissions, function (value, key) {
                    if (value == true) {
                        permissions.push(key);
                    }
                });
                var role = {};
                role.name = $scope.role.name;
                role.description = $scope.role.description;
                role.permissions = permissions;
                role.autoGrant = $scope.role.autoGrant;
                ApimanSvcs.save({ entityType: 'roles' }, role, function (reply) {
                    PageLifecycle.redirectTo('/admin/roles');
                }, PageLifecycle.handleError);
            };
            PageLifecycle.loadPage('NewRole', 'admin', undefined, $scope, function () {
                PageLifecycle.setPageTitle('new-role');
                $('#apiman-entityname').focus();
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgActivityController = Apiman._module.controller("Apiman.OrgActivityController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', 'AuditSvcs', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, AuditSvcs, $routeParams) => {
            $scope.tab = 'activity';
            var params = $routeParams;
            $scope.organizationId = params.org;
            var getNextPage = function (successHandler, errorHandler) {
                $scope.currentPage = $scope.currentPage + 1;
                AuditSvcs.get({ organizationId: params.org, page: $scope.currentPage, count: 20 }, function (results) {
                    var entries = results.beans;
                    successHandler(entries);
                }, errorHandler);
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, function (org) {
                        $rootScope.mruOrg = org;
                        resolve(org);
                    }, reject);
                }),
                members: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'members' }, function (members) {
                        resolve(members);
                    }, reject);
                }),
                auditEntries: $q(function (resolve, reject) {
                    $scope.currentPage = 0;
                    getNextPage(resolve, reject);
                })
            };
            $scope.getNextPage = getNextPage;
            PageLifecycle.loadPage('OrgActivity', 'orgView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('org-activity', [$scope.org.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgApisController = Apiman._module.controller("Apiman.OrgApisController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', '$routeParams', 'CurrentUser',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, $routeParams, CurrentUser) => {
            $scope.tab = 'apis';
            var params = $routeParams;
            $scope.organizationId = params.org;
            if (!CurrentUser.hasPermission(params.org, 'apiView')) {
                delete $rootScope['currentUser'];
            }
            $scope.filterApis = function (value) {
                if (!value) {
                    $scope.filteredApis = $scope.apis;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.apis, function (api) {
                        if (api.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(api);
                        }
                    });
                    $scope.filteredApis = filtered;
                }
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, function (org) {
                        $rootScope.mruOrg = org;
                        resolve(org);
                    }, reject);
                }),
                members: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'members' }, function (members) {
                        resolve(members);
                    }, reject);
                }),
                apis: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'apis' }, function (apis) {
                        $scope.filteredApis = apis;
                        resolve(apis);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('OrgSvcs', 'apiView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('org-apis', [$scope.org.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgClientsController = Apiman._module.controller("Apiman.OrgClientsController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', '$routeParams', 'CurrentUser',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, $routeParams, CurrentUser) => {
            $scope.tab = 'clients';
            var params = $routeParams;
            $scope.organizationId = params.org;
            if (!CurrentUser.hasPermission(params.org, 'clientView')) {
                delete $rootScope['currentUser'];
            }
            $scope.filterClients = function (value) {
                if (!value) {
                    $scope.filteredClients = $scope.clients;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.clients, function (client) {
                        if (client.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(client);
                        }
                    });
                    $scope.filteredClients = filtered;
                }
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, function (org) {
                        $rootScope.mruOrg = org;
                        resolve(org);
                    }, reject);
                }),
                members: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'members' }, function (members) {
                        resolve(members);
                    }, reject);
                }),
                clients: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'clients' }, function (clients) {
                        $scope.filteredClients = clients;
                        resolve(clients);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('OrgClients', 'clientView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('org-clients', [$scope.org.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.getRoleIds = function (member) {
        return member.roles.map(function (role) {
            return role.roleId;
        });
    };
    Apiman.OrgManageMembersController = Apiman._module.controller("Apiman.OrgManageMembersController", ['$q', '$scope', '$location', 'ApimanSvcs', 'OrgSvcs', 'PageLifecycle', '$rootScope', 'Logger', '$routeParams',
            ($q, $scope, $location, ApimanSvcs, OrgSvcs, PageLifecycle, $rootScope, $log, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.filteredMembers = [];
            $scope.filterValue = "";
            $scope.selectedRoles = "";
            var containsAnyRoles = function (containsArray) {
                if ($scope.selectedRoles.length === 0) {
                    return true;
                }
                var returnVal = false;
                jQuery.each($scope.selectedRoles, function (index, value) {
                    if (jQuery.inArray(value, containsArray) > -1) {
                        return returnVal = true;
                    }
                });
                return returnVal;
            };
            $scope.filterMembers = function (value) {
                $scope.filterValue = value;
                if (!value) {
                    // Case 1: no filter value and no selected roles
                    // Case 2: no filter value but at least one selected role
                    // Case 3: 
                    if ($scope.selectedRoles.length === 0) {
                        $scope.filteredMembers = $scope.members;
                    }
                    else {
                        $scope.filteredMembers = jQuery.grep($scope.members, function (member, _) {
                            return containsAnyRoles(Apiman.getRoleIds(member));
                        });
                    }
                }
                else {
                    $scope.filteredMembers = jQuery.grep($scope.members, function (m, _) {
                        return ((m.userName.toLowerCase().indexOf(value.toLowerCase()) > -1 || m.userId.toLowerCase().indexOf(value.toLowerCase()) > -1)
                            && containsAnyRoles(Apiman.getRoleIds(m)));
                    });
                }
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, function (org) {
                        $rootScope.mruOrg = org;
                        resolve(org);
                    }, reject);
                }),
                members: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'members' }, function (members) {
                        $scope.filteredMembers = members;
                        resolve(members);
                    }, reject);
                }),
                roles: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'roles' }, function (adminRoles) {
                        $scope.filteredRoles = adminRoles;
                        resolve(adminRoles);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('OrgManageMembers', 'orgAdmin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('org-manage-members', [$scope.org.name]);
            });
        }]);
    Apiman.OrgManageMembersController.directive('apimanUserCard', [
        '$uibModal',
        'OrgSvcs',
        'Logger',
        'PageLifecycle',
            ($uibModal, OrgSvcs, $log, PageLifecycle) => {
            return {
                restrict: 'E',
                scope: {
                    member: '=',
                    roles: '=',
                    orgId: '@'
                },
                template: '<div ng-include="currentTemplate()" ng-show="isCardVisible"></div>',
                link: function ($scope, element, attrs) {
                    // updatedRoles comes from card-back.
                    $scope.updatedRoles = Apiman.getRoleIds($scope.member);
                    $scope.front = 'apiman-user-card-front';
                    $scope.back = 'apiman-user-card-back';
                    $scope.cardFace = $scope.front;
                    $scope.isCardVisible = true;
                    $scope.flipCard = function (face) {
                        $scope.cardFace = face;
                    };
                    $scope.currentTemplate = function () {
                        return 'plugins/api-manager/html/org/' + $scope.cardFace + '.html';
                    };
                    $scope.joinRoles = function (roles) {
                        return roles.map(function (role) {
                            return role.roleName;
                        }).join(', ');
                    };
                    // Update is revoke + grant
                    $scope.updateRoles = function (selectedRoles) {
                        if (!selectedRoles)
                            return $scope.flipCard($scope.front);
                        var grantRolesBean = {
                            userId: $scope.member.userId,
                            roleIds: selectedRoles
                        };
                        _revokeAll($scope.orgId, $scope.member.userId);
                        OrgSvcs.save({ organizationId: $scope.orgId, entityType: 'roles' }, grantRolesBean, function () {
                            $log.info('Successfully Saved: ' + angular.toJson(grantRolesBean));
                            $scope.flipCard($scope.front);
                        }, PageLifecycle.handleError);
                        _reassignRoles(selectedRoles);
                    };
                    // Revoke all permissions with warning
                    $scope.revokeAll = function (size) {
                        var options = {
                            message: 'This will remove ' + $scope.member.userName + ' from all roles in the Organization. Really do this?',
                            title: 'Confirm Revoke All'
                        };
                        $scope.animationsEnabled = true;
                        $scope.toggleAnimation = function () {
                            $scope.animationsEnabled = !$scope.animationsEnabled;
                        };
                        var modalInstance = $uibModal.open({
                            animation: $scope.animationsEnabled,
                            templateUrl: 'confirmModal.html',
                            controller: 'ModalConfirmCtrl',
                            size: size,
                            resolve: {
                                options: function () {
                                    return options;
                                }
                            }
                        });
                        modalInstance.result.then(function () {
                            _revokeAll($scope.orgId, $scope.member.userId);
                            $scope.isCardVisible = false;
                        }, function () {
                            //console.log('Modal dismissed at: ' + new Date());
                        });
                    };
                    // Actual revoke function.
                    var _revokeAll = function (orgId, userId) {
                        OrgSvcs.delete({ organizationId: orgId, entityType: 'members', entityId: userId }, function () {
                            $log.debug('Successfully revoked all roles for ' + userId);
                        }, PageLifecycle.handleError);
                    };
                    // Now we've modified the roles, we can update to reflect.
                    var _reassignRoles = function (newRoles) {
                        var matchingRoles = jQuery.grep($scope.roles, function (role, _) {
                            return jQuery.inArray(role.id, newRoles) >= 0;
                        });
                        var assignedRoles = matchingRoles.map(function (elem) {
                            return {
                                roleId: elem.id,
                                roleName: elem.name
                            };
                        });
                        $scope.member.roles = assignedRoles;
                        $scope.updatedRoles = Apiman.getRoleIds($scope.member);
                    };
                }
            };
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgMembersController = Apiman._module.controller("Apiman.OrgMembersController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, $routeParams) => {
            $scope.tab = 'members';
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.filterMembers = function (value) {
                if (!value) {
                    $scope.filteredMembers = $scope.members;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.members, function (member) {
                        if (member.userName.toLowerCase().indexOf(value.toLowerCase()) > -1 || member.userId.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(member);
                        }
                    });
                    $scope.filteredMembers = filtered;
                }
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, function (org) {
                        $rootScope.mruOrg = org;
                        resolve(org);
                    }, reject);
                }),
                members: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'members' }, function (members) {
                        $scope.filteredMembers = members;
                        resolve(members);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('OrgMembers', 'orgView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('org-members', [$scope.org.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgNewMemberController = Apiman._module.controller("Apiman.OrgNewMemberController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', 'ApimanSvcs', 'Logger', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, ApimanSvcs, $log, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.selectedUsers = {};
            $scope.selectedRoles = [];
            $scope.queriedUsers = [];
            $scope.searchBoxValue = '';
            $scope.addMembers = function () {
                if ($scope.selectedRoles) {
                    $scope.addMembersButton.state = 'in-progress';
                    // Iterate over object like map (k:v)
                    jQuery.each($scope.selectedUsers, function (k, user) {
                        $log.debug('Adding user: {0}', user);
                        var grantRolesBean = {
                            userId: user.username,
                            roleIds: $scope.selectedRoles
                        };
                        OrgSvcs.save({ organizationId: $scope.organizationId, entityType: 'roles' }, grantRolesBean, function () {
                            $log.debug('Successfully Saved: {0}', grantRolesBean);
                            $scope.addMembersButton.state = 'complete';
                            PageLifecycle.redirectTo('/orgs/{0}/manage-members', params.org);
                        }, PageLifecycle.handleError);
                    });
                }
            };
            $scope.findUsers = (searchBoxValue) => {
                $scope.searchButton.state = 'in-progress';
                $scope.searchBoxValue = searchBoxValue;
                if (!searchBoxValue || searchBoxValue.length == 0) {
                    $scope.queriedUsers = [];
                    $scope.searchButton.state = 'complete';
                    return;
                }
                var queryBean = {
                    filters: [{
                            name: 'username',
                            value: '*' + searchBoxValue + '*',
                            operator: 'like'
                        }],
                    orderBy: {
                        name: 'fullName',
                        ascending: true
                    },
                    paging: {
                        page: 1,
                        pageSize: 50
                    }
                };
                $log.debug('Query: {0}', queryBean);
                ApimanSvcs.save({ entityType: 'search', secondaryType: 'users' }, queryBean, function (reply) {
                    $scope.searchButton.state = 'complete';
                    $log.debug('Reply: {0}', reply);
                    $scope.queriedUsers = reply.beans;
                }, function () {
                    $scope.searchButton.state = 'error';
                });
            };
            $scope.countObjectKeys = (object) => {
                return Object.keys(object).length;
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, function (org) {
                        $rootScope.mruOrg = org;
                        resolve(org);
                    }, reject);
                }),
                members: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'members' }, function (members) {
                        $scope.filteredMembers = members;
                        resolve(members);
                    }, reject);
                }),
                roles: $q(function (resolve, reject) {
                    ApimanSvcs.query({ entityType: 'roles' }, function (adminRoles) {
                        $scope.filteredRoles = adminRoles;
                        resolve(adminRoles);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('OrgNewMember', 'orgAdmin', pageData, $scope, function () {
                PageLifecycle.setPageTitle('new-member');
            });
        }]);
    Apiman.OrgNewMemberController.directive('apimanUserEntry', ['Logger', function ($log) {
            return {
                scope: {
                    user: '=',
                    selectedUsers: '='
                },
                replace: true,
                templateUrl: 'plugins/api-manager/html/org/apiman-user-entry.html',
                link: function ($scope) {
                    $scope.isSelectedUser = false;
                    $scope.selectThisUser = function () {
                        $scope.isSelectedUser = !$scope.isSelectedUser;
                        // If selected user then add to map; if deselected remove it.
                        if ($scope.isSelectedUser) {
                            $scope.selectedUsers[$scope.user.username] = $scope.user;
                        }
                        else {
                            delete $scope.selectedUsers[$scope.user.username];
                        }
                        $log.debug("Selected {0}", $scope.user.username);
                        $log.debug("Global $scope.selectedUsers {0}", $scope.selectedUsers);
                    };
                }
            };
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgPlansController = Apiman._module.controller("Apiman.OrgPlansController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', '$routeParams', 'CurrentUser', 'Logger',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, $routeParams, CurrentUser, Logger) => {
            $scope.tab = 'plans';
            var params = $routeParams;
            $scope.organizationId = params.org;
            if (!CurrentUser.hasPermission(params.org, 'planView')) {
                Logger.info('planView permission not found - forcing user reload');
                delete $rootScope['currentUser'];
            }
            $scope.filterPlans = function (value) {
                if (!value) {
                    $scope.filteredPlans = $scope.plans;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.plans, function (plan) {
                        if (plan.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(plan);
                        }
                    });
                    $scope.filteredPlans = filtered;
                }
            };
            var pageData = {
                org: $q(function (resolve, reject) {
                    OrgSvcs.get({ organizationId: params.org, entityType: '' }, function (org) {
                        $rootScope.mruOrg = org;
                        resolve(org);
                    }, reject);
                }),
                members: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'members' }, function (members) {
                        resolve(members);
                    }, reject);
                }),
                plans: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'plans' }, function (plans) {
                        $scope.filteredPlans = plans;
                        resolve(plans);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('OrgPlans', 'planView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('org-plans', [$scope.org.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgSidebarController = Apiman._module.controller("Apiman.OrgSidebarController", ['Logger', '$uibModal', '$scope', 'OrgSvcs', 'Configuration', (Logger, $uibModal, $scope, OrgSvcs, Configuration) => {
            $scope.updateOrgDescription = function (updatedDescription) {
                var updateOrganizationBean = {
                    description: updatedDescription
                };
                OrgSvcs.update({ organizationId: $scope.organizationId }, updateOrganizationBean, function (success) {
                }, function (error) {
                    Logger.error("Unable to update org description: {0}", error);
                });
            };
            // ----- Delete --------------------->>>>
            $scope.showCtxMenu = true;
            if (Configuration.ui.platform == 'f8' || Configuration.ui.platform == 'ose') {
                $scope.showCtxMenu = false;
            }
            // Add check for ability to delete, show/hide Delete option
            $scope.canDelete = function () { };
            // Call delete, open modal
            $scope.callDelete = function (size) {
                var modalInstance = $uibModal.open({
                    templateUrl: 'deleteModal.html',
                    controller: 'OrgDeleteModalCtrl',
                    size: size,
                    resolve: {
                        org: function () {
                            return $scope.org;
                        }
                    }
                });
                modalInstance.result.then(function (selectedItem) {
                    $scope.selected = selectedItem;
                }, function () {
                    Logger.info('Modal dismissed at: ' + new Date());
                });
            };
        }]);
    Apiman.OrgDeleteModalCtrl = Apiman._module.controller('OrgDeleteModalCtrl', function ($location, $rootScope, $scope, $uibModalInstance, OrgSvcs, Configuration, PageLifecycle, org) {
        $scope.confirmOrgName = '';
        $scope.org = org;
        // Used for enabling/disabling the submit button
        $scope.okayToDelete = false;
        $scope.typed = function () {
            // For user convenience, compare lower case values so that check is not case-sensitive
            $scope.okayToDelete = ($scope.confirmOrgName.toLowerCase() === org.name.toLowerCase());
        };
        // Yes, delete the organization
        $scope.yes = function () {
            var deleteAction = {
                organizationId: org.id
            };
            OrgSvcs.remove(deleteAction).$promise.then(function (res) {
                $scope.okayToDelete = false;
                setTimeout(function () {
                    $uibModalInstance.close();
                    // Redirect users to their list of organizations
                    $location.path($rootScope.pluginName + '/users/' + Configuration.user.username + '/orgs');
                }, 800);
                // We should display some type of Toastr/Growl notification to the user here
            }, function (err) {
                $scope.okayToDelete = false;
                $uibModalInstance.close();
                PageLifecycle.handleError(err);
            });
        };
        // No, do NOT delete the API
        $scope.no = function () {
            $uibModalInstance.dismiss('cancel');
        };
    });
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.OrgRedirectController = Apiman._module.controller("Apiman.OrgRedirectController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', 'CurrentUser', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, CurrentUser, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            if (!CurrentUser.isMember(params.org)) {
                delete $rootScope['currentUser'];
            }
            PageLifecycle.loadPage('OrgRedirect', 'orgView', undefined, $scope, function () {
                var orgId = $routeParams.org;
                var tab = 'members';
                if (CurrentUser.hasPermission(orgId, 'planEdit')) {
                    tab = 'plans';
                }
                else if (CurrentUser.hasPermission(orgId, 'apiEdit')) {
                    tab = 'apis';
                }
                else if (CurrentUser.hasPermission(orgId, 'clientEdit')) {
                    tab = 'clients';
                }
                PageLifecycle.forwardTo('/orgs/{0}/{1}', orgId, tab);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.PlanActivityController = Apiman._module.controller("Apiman.PlanActivityController", ['$q', '$scope', '$location', 'OrgSvcs', 'AuditSvcs', 'Logger', 'PageLifecycle', 'PlanEntityLoader', '$routeParams',
            ($q, $scope, $location, OrgSvcs, AuditSvcs, Logger, PageLifecycle, PlanEntityLoader, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'activity';
            $scope.version = params.version;
            var getNextPage = function (successHandler, errorHandler) {
                $scope.currentPage = $scope.currentPage + 1;
                AuditSvcs.get({ organizationId: params.org, entityType: 'plans', entityId: params.plan, page: $scope.currentPage, count: 20 }, function (results) {
                    var entries = results.beans;
                    successHandler(entries);
                }, errorHandler);
            };
            var pageData = PlanEntityLoader.getCommonData($scope, $location);
            pageData = angular.extend(pageData, {
                auditEntries: $q(function (resolve, reject) {
                    $scope.currentPage = 0;
                    getNextPage(resolve, reject);
                })
            });
            $scope.getNextPage = getNextPage;
            PageLifecycle.loadPage('PlanActivity', 'planView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('plan-activity', [$scope.plan.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.PlanOverviewController = Apiman._module.controller("Apiman.PlanOverviewController", ['$q', '$scope', '$location', 'PageLifecycle', 'PlanEntityLoader', '$routeParams',
            ($q, $scope, $location, PageLifecycle, PlanEntityLoader, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'overview';
            var pageData = PlanEntityLoader.getCommonData($scope, $location);
            PageLifecycle.loadPage('PlanOverview', 'planView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('plan-overview', [$scope.plan.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.PlanPoliciesController = Apiman._module.controller("Apiman.PlanPoliciesController", ['$q', '$scope', '$location', '$uibModal', 'OrgSvcs', 'ApimanSvcs', 'Logger', 'PageLifecycle', 'PlanEntityLoader', '$routeParams',
            ($q, $scope, $location, $uibModal, OrgSvcs, ApimanSvcs, Logger, PageLifecycle, PlanEntityLoader, $routeParams) => {
            var params = $routeParams;
            $scope.organizationId = params.org;
            $scope.tab = 'policies';
            $scope.version = params.version;
            var removePolicy = function (policy) {
                angular.forEach($scope.policies, function (p, index) {
                    if (policy === p) {
                        $scope.policies.splice(index, 1);
                    }
                });
            };
            $scope.removePolicy = function (policy, size) {
                Logger.info('Removing policy: {0}', policy);
                var options = {
                    message: 'Do you really want to remove this policy from the plan?',
                    title: 'Confirm Remove Policy'
                };
                $scope.animationsEnabled = true;
                $scope.toggleAnimation = function () {
                    $scope.animationsEnabled = !$scope.animationsEnabled;
                };
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    templateUrl: 'confirmModal.html',
                    controller: 'ModalConfirmCtrl',
                    size: size,
                    resolve: {
                        options: function () {
                            return options;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    OrgSvcs.delete({ organizationId: params.org, entityType: 'plans', entityId: params.plan, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'policies', policyId: policy.id }, function (reply) {
                        removePolicy(policy);
                    }, PageLifecycle.handleError);
                }, function () {
                    //console.log('Modal dismissed at: ' + new Date());
                });
            };
            $scope.reorderPolicies = function (reorderedPolicies) {
                var policyChainBean = {
                    policies: reorderedPolicies
                };
                OrgSvcs.save({ organizationId: params.org, entityType: 'plans', entityId: params.plan, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'reorderPolicies' }, policyChainBean, function () {
                    Logger.debug("Reordering POSTed successfully");
                }, function () {
                    Logger.debug("Reordering POST failed.");
                });
            };
            var pageData = PlanEntityLoader.getCommonData($scope, $location);
            angular.extend(pageData, {
                policies: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: params.org, entityType: 'plans', entityId: params.plan, versionsOrActivity: 'versions', version: params.version, policiesOrActivity: 'policies' }, function (policies) {
                        resolve(policies);
                    }, reject);
                })
            });
            PageLifecycle.loadPage('PlanPolicies', 'planView', pageData, $scope, function () {
                PageLifecycle.setPageTitle('plan-policies', [$scope.plan.name]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.PlanRedirectController = Apiman._module.controller("Apiman.PlanRedirectController", ['$q', '$scope', '$location', 'OrgSvcs', 'PageLifecycle', '$rootScope', 'CurrentUser', '$routeParams',
            ($q, $scope, $location, OrgSvcs, PageLifecycle, $rootScope, CurrentUser, $routeParams) => {
            var orgId = $routeParams.org;
            var planId = $routeParams.plan;
            var pageData = {
                versions: $q(function (resolve, reject) {
                    OrgSvcs.query({ organizationId: orgId, entityType: 'plans', entityId: planId, versionsOrActivity: 'versions' }, resolve, reject);
                })
            };
            $scope.organizationId = orgId;
            PageLifecycle.loadPage('PlanRedirect', 'planView', pageData, $scope, function () {
                var version = $scope.versions[0].version;
                if (!version) {
                    PageLifecycle.handleError({ status: 404 });
                }
                else {
                    PageLifecycle.forwardTo('/orgs/{0}/plans/{1}/{2}', orgId, planId, version);
                }
            });
        }]);
    Apiman.PlanEntityLoader = Apiman._module.factory('PlanEntityLoader', ['$q', 'OrgSvcs', 'Logger', '$rootScope', '$routeParams', 'EntityStatusSvc',
            ($q, OrgSvcs, Logger, $rootScope, $routeParams, EntityStatusSvc) => {
            return {
                getCommonData: function ($scope, $location) {
                    var params = $routeParams;
                    return {
                        version: $q(function (resolve, reject) {
                            OrgSvcs.get({ organizationId: params.org, entityType: 'plans', entityId: params.plan, versionsOrActivity: 'versions', version: params.version }, function (version) {
                                $scope.org = version.plan.organization;
                                $scope.plan = version.plan;
                                EntityStatusSvc.setEntity(version, 'plan');
                                resolve(version);
                            }, reject);
                        }),
                        versions: $q(function (resolve, reject) {
                            OrgSvcs.query({ organizationId: params.org, entityType: 'plans', entityId: params.plan, versionsOrActivity: 'versions' }, resolve, reject);
                        })
                    };
                }
            };
        }]);
    Apiman.PlanEntityController = Apiman._module.controller("Apiman.PlanEntityController", ['$q', '$uibModal', '$scope', '$location', 'ActionSvcs', 'Logger', 'PageLifecycle', '$routeParams', 'OrgSvcs', 'EntityStatusSvc',
            ($q, $uibModal, $scope, $location, ActionSvcs, Logger, PageLifecycle, $routeParams, OrgSvcs, EntityStatusSvc) => {
            var params = $routeParams;
            $scope.setEntityStatus = EntityStatusSvc.setEntityStatus;
            $scope.getEntityStatus = EntityStatusSvc.getEntityStatus;
            $scope.setVersion = function (plan) {
                PageLifecycle.redirectTo('/orgs/{0}/plans/{1}/{2}', params.org, params.plan, plan.version);
            };
            $scope.lockPlan = function () {
                $scope.lockButton.state = 'in-progress';
                var lockAction = {
                    type: 'lockPlan',
                    entityId: params.plan,
                    organizationId: params.org,
                    entityVersion: params.version
                };
                ActionSvcs.save(lockAction, function (reply) {
                    $scope.version.status = 'Locked';
                    $scope.lockButton.state = 'complete';
                    $scope.setEntityStatus($scope.version.status);
                }, PageLifecycle.handleError);
            };
            $scope.updatePlanDescription = function (updatedDescription) {
                var updatePlanBean = {
                    description: updatedDescription
                };
                OrgSvcs.update({
                    organizationId: $scope.organizationId,
                    entityType: 'plans',
                    entityId: $scope.plan.id
                }, updatePlanBean, function (success) {
                }, function (error) {
                    Logger.error("Unable to update plan description:  {0}", error);
                });
            };
            // ----- Delete --------------------->>>>
            // Add check for ability to delete, show/hide Delete option
            $scope.canNotDelete = function () {
                return ($scope.version && $scope.version.status === 'Locked') || ($scope.versions && $scope.versions.some(function (planItem) {
                    return planItem.status === 'Locked';
                }));
            };
            // Call delete, open modal
            $scope.callDelete = function (size) {
                var modalInstance = $uibModal.open({
                    templateUrl: 'deleteModal.html',
                    controller: 'PlanDeleteModalCtrl',
                    size: size,
                    resolve: {
                        organizationId: function () {
                            return $scope.organizationId;
                        },
                        plan: function () {
                            return $scope.plan;
                        }
                    }
                });
                modalInstance.result.then(function (selectedItem) {
                    $scope.selected = selectedItem;
                }, function () {
                    Logger.info('Modal dismissed at: ' + new Date());
                });
            };
        }]);
    Apiman.PlanDeleteModalCtrl = Apiman._module.controller('PlanDeleteModalCtrl', function ($location, $rootScope, $scope, $uibModalInstance, OrgSvcs, Configuration, PageLifecycle, organizationId, plan) {
        $scope.confirmPlanName = '';
        $scope.plan = plan;
        // Used for enabling/disabling the submit button
        $scope.okayToDelete = false;
        $scope.typed = function () {
            // For user convenience, compare lower case values so that check is not case-sensitive
            $scope.okayToDelete = ($scope.confirmPlanName.toLowerCase() === plan.name.toLowerCase());
        };
        // Yes, delete the plan
        $scope.yes = function () {
            var deleteAction = {
                organizationId: organizationId,
                entityType: 'plans',
                entityId: plan.id
            };
            OrgSvcs.remove(deleteAction).$promise.then(function (res) {
                $scope.okayToDelete = false;
                // Redirect users to their list of plans
                setTimeout(function () {
                    $uibModalInstance.close();
                    $location.path($rootScope.pluginName + '/orgs/' + organizationId + '/plans');
                }, 900);
                // We should display some type of Toastr/Growl notification to the user here
            }, function (err) {
                $scope.okayToDelete = false;
                $uibModalInstance.close();
                PageLifecycle.handleError(err);
            });
        };
        // No, do NOT delete the API
        $scope.no = function () {
            $uibModalInstance.dismiss('cancel');
        };
    });
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.UserActivityController = Apiman._module.controller("Apiman.UserActivityController", ['$q', '$scope', '$location', 'UserSvcs', 'UserAuditSvcs', 'PageLifecycle', '$routeParams',
            ($q, $scope, $location, UserSvcs, UserAuditSvcs, PageLifecycle, $routeParams) => {
            $scope.tab = 'activity';
            var getNextPage = function (successHandler, errorHandler) {
                $scope.currentPage = $scope.currentPage + 1;
                UserAuditSvcs.get({ user: $routeParams.user, page: $scope.currentPage, count: 20 }, function (results) {
                    var entries = results.beans;
                    successHandler(entries);
                }, errorHandler);
            };
            var pageData = {
                user: $q(function (resolve, reject) {
                    UserSvcs.get({ user: $routeParams.user }, function (user) {
                        if (!user.fullName) {
                            user.fullName = user.username;
                        }
                        resolve(user);
                    }, reject);
                }),
                auditEntries: $q(function (resolve, reject) {
                    $scope.currentPage = 0;
                    getNextPage(resolve, reject);
                })
            };
            $scope.getNextPage = getNextPage;
            PageLifecycle.loadPage('UserActivity', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('user-activity', [$scope.user.fullName]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.UserApisController = Apiman._module.controller("Apiman.UserApisController", ['$q', '$scope', '$location', 'UserSvcs', 'PageLifecycle', '$routeParams',
            ($q, $scope, $location, UserSvcs, PageLifecycle, $routeParams) => {
            $scope.tab = 'apis';
            $scope.filterApis = function (value) {
                if (!value) {
                    $scope.filteredApis = $scope.apis;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.apis, function (api) {
                        if (api.name.toLowerCase().indexOf(value.toLowerCase()) > -1 || api.organizationName.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(api);
                        }
                    });
                    $scope.filteredApis = filtered;
                }
            };
            var pageData = {
                user: $q(function (resolve, reject) {
                    UserSvcs.get({ user: $routeParams.user }, function (user) {
                        if (!user.fullName) {
                            user.fullName = user.username;
                        }
                        resolve(user);
                    }, reject);
                }),
                apis: $q(function (resolve, reject) {
                    UserSvcs.query({ user: $routeParams.user, entityType: 'apis' }, function (userApis) {
                        $scope.filteredApis = userApis;
                        resolve(userApis);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('UserApis', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('user-apis', [$scope.user.fullName]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.UserClientsController = Apiman._module.controller("Apiman.UserClientsController", ['$q', '$scope', '$location', 'UserSvcs', 'PageLifecycle', 'Logger', '$routeParams',
            ($q, $scope, $location, UserSvcs, PageLifecycle, Logger, $routeParams) => {
            $scope.tab = 'clients';
            $scope.filterClients = function (value) {
                if (!value) {
                    $scope.filteredClients = $scope.clients;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.clients, function (client) {
                        if (client.name.toLowerCase().indexOf(value.toLowerCase()) > -1 || client.organizationName.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(client);
                        }
                    });
                    $scope.filteredClients = filtered;
                }
            };
            var pageData = {
                user: $q(function (resolve, reject) {
                    UserSvcs.get({ user: $routeParams.user }, function (user) {
                        if (!user.fullName) {
                            user.fullName = user.username;
                        }
                        resolve(user);
                    }, reject);
                }),
                clients: $q(function (resolve, reject) {
                    UserSvcs.query({ user: $routeParams.user, entityType: 'viewable-clients' }, function (userClients) {
                        $scope.filteredClients = userClients;
                        resolve(userClients);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('UserClients', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('user-clients', [$scope.user.fullName]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.UserOrgsController = Apiman._module.controller("Apiman.UserOrgsController", ['$q', '$scope', '$location', 'UserSvcs', 'PageLifecycle', '$routeParams', 'Configuration',
            ($q, $scope, $location, UserSvcs, PageLifecycle, $routeParams, Configuration) => {
            $scope.tab = 'organizations';
            $scope.noCreateOrg = Configuration.ui.platform == 'f8' || Configuration.ui.platform == 'ose' ||
                (Configuration.ui.adminOnlyOrgCreation == true && !$scope.isAdmin);
            $scope.filterOrgs = function (value) {
                if (!value) {
                    $scope.filteredOrgs = $scope.organizations;
                }
                else {
                    var filtered = [];
                    angular.forEach($scope.organizations, function (org) {
                        if (org.name.toLowerCase().indexOf(value.toLowerCase()) > -1) {
                            filtered.push(org);
                        }
                    });
                    $scope.filteredOrgs = filtered;
                }
            };
            var pageData = {
                user: $q(function (resolve, reject) {
                    UserSvcs.get({ user: $routeParams.user }, function (user) {
                        if (!user.fullName) {
                            user.fullName = user.username;
                        }
                        resolve(user);
                    }, reject);
                }),
                organizations: $q(function (resolve, reject) {
                    UserSvcs.query({ user: $routeParams.user, entityType: 'organizations' }, function (userOrgs) {
                        $scope.filteredOrgs = userOrgs;
                        resolve(userOrgs);
                    }, reject);
                })
            };
            PageLifecycle.loadPage('UserOrgs', undefined, pageData, $scope, function () {
                PageLifecycle.setPageTitle('user-orgs', [$scope.user.fullName]);
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.UserProfileController = Apiman._module.controller("Apiman.UserProfileController", ['$q', '$rootScope', '$scope', '$location', 'UserSvcs', 'CurrentUserSvcs', 'CurrentUser', 'PageLifecycle',
            ($q, $rootScope, $scope, $location, UserSvcs, CurrentUserSvcs, CurrentUser, PageLifecycle) => {
            var pageData = {
                user: $q(function (resolve, reject) {
                    CurrentUserSvcs.get({ what: 'info' }, resolve, reject);
                })
            };
            $rootScope.isDirty = false;
            $scope.isValid = true;
            $scope.updatedUser = {
                fullName: undefined,
                email: undefined
            };
            $scope.$watch('updatedUser', function (newValue) {
                var dirty = false;
                var valid = true;
                if (!newValue.fullName) {
                    valid = false;
                }
                if (!newValue.email) {
                    valid = false;
                }
                if ($scope.user
                    && $scope.user.fullName
                    && newValue.fullName != $scope.user.fullName) {
                    dirty = true;
                }
                if ($scope.user
                    && $scope.user.email
                    && newValue.email != $scope.user.email) {
                    dirty = true;
                }
                $rootScope.isDirty = dirty;
                $scope.isValid = valid;
            }, true);
            $scope.cancel = function () {
                $rootScope.isDirty = false;
                $location.path($rootScope.pluginName);
            };
            $scope.save = function () {
                $scope.updateButton.state = 'in-progress';
                CurrentUser.getCurrentUser().then(function (currentUser) {
                    UserSvcs.update({ user: currentUser.username }, $scope.updatedUser, function () {
                        $scope.updateButton.state = 'complete';
                        $scope.user.fullName = $scope.updatedUser.fullName;
                        $scope.user.email = $scope.updatedUser.email;
                        $scope.isValid = true;
                        $rootScope.isDirty = false;
                    }, PageLifecycle.handleError);
                });
            };
            PageLifecycle.loadPage('UserProfile', undefined, pageData, $scope, function () {
                $scope.updatedUser.fullName = $scope.user.fullName;
                $scope.updatedUser.email = $scope.user.email;
                PageLifecycle.setPageTitle('user-profile');
            });
        }]);
})(Apiman || (Apiman = {}));

/// <reference path="../apimanPlugin.ts"/>
/// <reference path="../rpc.ts"/>
var Apiman;
(function (Apiman) {
    Apiman.UserRedirectController = Apiman._module.controller("Apiman.UserRedirectController", ['$q', '$scope', '$location', 'PageLifecycle', '$routeParams',
            ($q, $scope, $location, PageLifecycle, $routeParams) => {
            PageLifecycle.loadPage('UserRedirect', undefined, undefined, $scope, function () {
                PageLifecycle.forwardTo('/users/{0}/orgs', $routeParams.user);
            });
        }]);
})(Apiman || (Apiman = {}));

angular.module("apiman-manager-ui-templates", []).run(["$templateCache", function($templateCache) {$templateCache.put("plugins/api-manager/html/about.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.AboutController\" class=\"page container apiman-about-page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <div class=\"col-md-12\">\n          <h2 apiman-i18n-key=\"about.page-heading\">About apiman</h2>\n          <hr />\n        </div>\n        <div class=\"col-md-3\">\n          <div class=\"about-logo\"></div>\n        </div>\n        <div class=\"col-md-9\">\n          <h1 class=\"about-title\" apiman-i18n-key=\"about.page-title\">Open Source API Management</h1>\n          <span class=\"about-description\" apiman-i18n-key=\"about.page-description\">\n            The apiman project brings an open source development methodology to API Management, \n            coupling a rich API design & configuration layer with a blazingly fast runtime.\n          </span>\n          <hr />\n          <table class=\"table table-bordered\">\n            <tbody>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"about.version\">Version:</span></td>\n                <td>{{ version }}</td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"about.built-on\">Built On:</span></td>\n                <td>{{ builtOn }}</td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"about.api-endpoint\">API Endpoint:</span></td>\n                <td><a href=\"{{ apiEndpoint }}\">{{ apiEndpoint }}</a></td>\n              </tr>\n            </tbody>\n          </table>\n          <table class=\"table table-bordered\">\n            <tbody>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"about.project-site\">Project Site:</span></td>\n                <td><a href=\"{{ site }}\">{{ site }}</a></td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"about.source-code\">Source Code:</span></td>\n                <td><a href=\"{{ github }}\">{{ github }}</a></td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"about.user-guide\">User Guide:</span></td>\n                <td><a href=\"{{ userGuide }}\">{{ userGuide }}</a></td>\n              </tr>\n<!--               <tr> -->\n<!--                 <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"about.tutorials\">Tutorials:</span></td> -->\n<!--                 <td><a href=\"{{ tutorials }}\">{{ tutorials }}</a></td> -->\n<!--               </tr> -->\n            </tbody>\n          </table>\n        </div>\n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/dash.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.DashController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <h1 apiman-i18n-key=\"dash.page-heading\">API Management</h1>\r\n          <hr />\r\n        </div>\r\n        <div class=\"col-md-12 no-phone\">\r\n          <span class=\"description\" apiman-i18n-key=\"dash.page-description\">\r\n            Welcome to apiman, open source API management.  Use this software to provide\r\n            various APIs (APIs) to your consumers (Client Apps) through a secure, scalable,\r\n            and governed Gateway layer.  API Management allows API Developers to centralize\r\n            control and analysis of their APIs.  It also provides a central location for\r\n            Client App Developers to find and consume available APIs.\r\n          </span>\r\n        \r\n        </div>\r\n      </div>\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n        \r\n          <div class=\"dash-group\">\r\n            <div class=\"title\">\r\n              <i class=\"fa fa-shield\"></i>\r\n              <span apiman-i18n-key=\"organizations\">Organizations</span>\r\n            </div>\r\n            <div class=\"description\" apiman-i18n-key=\"dash.orgs-description\">\r\n              All APIs and Client Apps must be managed within the context of an \r\n              Organization.  You can be a member of multiple Organizations at the same\r\n              time, with different roles in each:  you can be a Client App\r\n              Developer in one organization and an API Developer in another.\r\n            </div>\r\n            <div class=\"actions\">\r\n              <ul>\r\n                <li ng-hide=\"noCreateOrg\"><a id=\"org-new\" href=\"{{ pluginName }}/new-org\" apiman-i18n-key=\"actions.create-new-org\" data-field=\"createOrg\">Create a New Organization</a></li>\r\n                <li><a id=\"org-my-orgs\" href=\"{{ pluginName }}/users/{{ currentUser.username }}/orgs\" apiman-i18n-key=\"actions.my-orgs\" data-field=\"myOrgs\">Go to My Organizations</a></li>\r\n                <li><a id=\"org-browse\" href=\"{{ pluginName }}/browse/orgs\" apiman-i18n-key=\"actions.browse-orgs\" data-field=\"browseOrgs\">Browse/Find an Organization</a></li>\r\n              </ul>\r\n            </div>\r\n          </div>\r\n          \r\n          <div class=\"dash-group pull-right\">\r\n            <div class=\"title\">\r\n              <i class=\"fa fa-puzzle-piece\"></i>\r\n              <span apiman-i18n-key=\"apis\">APIs</span>\r\n            </div>\r\n            <div class=\"description\" apiman-i18n-key=\"dash.apis-description\">\r\n              Create, find, or manage APIs.  An API is also known as a \"Service\" - anything\r\n              that can be invoked remotely by some sort of client application.  This platform\r\n              simply provides a way to turn unmanaged (raw) back-end APIs into \"managed\" APIs\r\n              by attaching policies to them.\r\n            </div>\r\n            <div class=\"actions\">\r\n              <ul>\r\n                <li><a id=\"apis-manage\" href=\"{{ pluginName }}/users/{{ currentUser.username }}/apis\" apiman-i18n-key=\"actions.my-apis\">Manage My APIs</a></li>\r\n                <li><a id=\"api-new\" href=\"{{ pluginName }}/new-api\" apiman-i18n-key=\"actions.create-api\">Create a New API</a></li>\r\n                <li><a id=\"api-catalog\" href=\"{{ pluginName }}/catalog/api-catalog\" apiman-i18n-key=\"actions.browse-importable-apis\">Browse available/importable APIs</a></li>\r\n              </ul>\r\n            </div>\r\n          </div>\r\n\r\n          <div class=\"dash-group\">\r\n            <div class=\"title\">\r\n              <i class=\"fa fa-gears\"></i>\r\n              <span apiman-i18n-key=\"clients\">Client Apps</span>\r\n            </div>\r\n            <div class=\"description\" apiman-i18n-key=\"dash.clients-description\">\r\n              Create and manage your Client Apps.  A Client App is the thing that consumes\r\n              APIs.  These consumers must be defined in this platform so that \r\n              contracts can be created between them and the APIs they wish to consume.\r\n            </div>\r\n            <div class=\"actions\">\r\n              <ul>\r\n                <li><a id=\"clients-manage\" href=\"{{ pluginName }}/users/{{ currentUser.username }}/clients\" apiman-i18n-key=\"actions.my-clients\" data-field=\"myClients\">Manage My Client Apps</a></li>\r\n                <li><a id=\"clients-new\" href=\"{{ pluginName }}/new-client\" apiman-i18n-key=\"actions.new-client\" data-field=\"createClient\">Create a New Client App</a></li>\r\n                <li><a id=\"apis-consume\" href=\"{{ pluginName }}/browse/apis\" apiman-i18n-key=\"actions.find-api\">Find/Consume an API</a></li>\r\n              </ul>\r\n            </div>\r\n          </div>\r\n\r\n          <div class=\"dash-group dash-admin-group pull-right\" data-field=\"adminDashPanel\" ng-show=\"isAdmin\">\r\n            <div class=\"title\">\r\n              <i class=\"fa fa-gavel\"></i>\r\n              <span apiman-i18n-key=\"system-administration\">System Administration</span>\r\n            </div>\r\n            <div class=\"description\" apiman-i18n-key=\"dash.system-description\">\r\n              Hey it looks like you\'re an administrator!  Here are some things only you can do.\r\n              These are system-wide settings you\'re thinking about modifying, so please proceed\r\n              with caution.\r\n            </div>\r\n            <div class=\"actions\">\r\n              <ul>\r\n                <li><a id=\"admin-roles\" href=\"{{ pluginName }}/admin/roles\" apiman-i18n-key=\"actions.manage-roles\" data-field=\"manageRoles\">Manage Roles/Permissions</a></li>\r\n                <li><a id=\"admin-policyDefs\" href=\"{{ pluginName }}/admin/policyDefs\" apiman-i18n-key=\"actions.manage-policyDefs\" data-field=\"managePolicyDefs\">Manage Policy Definitions</a></li>\r\n                <li><a id=\"admin-gateways\" href=\"{{ pluginName }}/admin/gateways\" apiman-i18n-key=\"actions.manage-gateways\" data-field=\"manageGateways\">Manage Gateways</a></li>\r\n                <li><a id=\"admin-plugins\" href=\"{{ pluginName }}/admin/plugins\" apiman-i18n-key=\"actions.manage-plugins\" data-field=\"managePlugins\">Manage Plugins</a></li>\r\n                <li><a id=\"admin-export\" href=\"{{ pluginName }}/admin/export\" apiman-i18n-key=\"export-import-data\">Export/Import Data</a></li>\r\n              </ul>\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/rest-documentation.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n<head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n</head>\r\n\r\n<body>\r\n<div>\r\n\r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ManagerRestApiDefController\" class=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n\r\n        <div class=\"container-pf-nav-pf-vertical container-fluid container\">\r\n            <div class=\"row\">\r\n                <div class=\"col-md-12\">\r\n                    <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\r\n                        <li><a id=\"bc-home\" href=\"{{ pluginName }}/\"><i class=\"fa fa-home fa-fw\"></i><span apiman-i18n-key=\"home\">Home</span></a></li>\r\n                        <li class=\"active\"><i class=\"fa fa-sitemap fa-fw\"></i><span apiman-i18n-key=\"definition\">Definition</span></li>\r\n                    </ol>\r\n                </div>\r\n            </div>\r\n            <div class=\"row\">\r\n                <div class=\"col-md-12\">\r\n                    <h1 class=\"consumer-top-header\">\r\n                        <span apiman-i18n-key=\"api-definition\">API Definition</span>\r\n                        <a class=\"pull-right\" id=\"download\" href=\"{{ definitionUrl }}/\" download=\"API-Manager-REST-API.yaml\"><i class=\"fa fa-download fa-fw\"></i><span apiman-i18n-key=\"download\">Download</span></a>\r\n                    </h1>\r\n                    <hr />\r\n                </div>\r\n            </div>\r\n\r\n            <div class=\"row\" ng-show=\"hasError\">\r\n                <div class=\"col-md-12\">\r\n                    <div class=\"alert alert-danger\" style=\"margin-top: 15px\">\r\n                        <span class=\"pficon pficon-info\"></span>\r\n                        <span apiman-i18n-key=\"consumer-api-def.error-loading-definition\">An error occured while loading the API definition file.  Please try again later.</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class=\"row\" ng-hide=\"hasDefinition\">\r\n                <div class=\"col-md-12\">\r\n                    <div class=\"alert alert-warning\" style=\"margin-top: 15px\">\r\n                        <span class=\"pficon pficon-info\"></span>\r\n                        <span apiman-i18n-key=\"consumer-api-def.no-api-definition\">This API does not have an API definition file.  Contact the API provider and ask them to supply a valid API definition!</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class=\"row\" ng-show=\"definitionStatus == \'loading\'\">\r\n                <div class=\"col-md-12\">\r\n                    <div style=\"margin-top: 15px; padding: 20px\" class=\"alert alert-info\">\r\n                        <div style=\"float:left; margin-right: 6px\" class=\"spinner spinner-sm\"></div>\r\n                        <span apiman-i18n-key=\"loading-api-def\">Loading API Definition, please wait...</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div id=\"apiman-swagger\" class=\"row swagger-section\" ng-show=\"hasDefinition\">\r\n                <div class=\"col-md-12\">\r\n                    <div id=\"swagger-ui-container\"/>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div> <!-- /container-pf-nav-pf-vertical container-fluid -->\r\n</div>\r\n</body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/admin/admin-export.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <body>\n  <div>\n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.AdminExportImportController\" class=\"page container admin-page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <div class=\"col-md-12\">\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_bc.include\'\"></div>\n        </div>\n      </div>\n      <div class=\"row\">\n       <!-- Side Navigation -->\n       <!-- \n         <div class=\"col-md-3\">\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_tabs.include\'\"></div>\n        </div>\n        -->\n        <!-- Admin Content -->\n        <div class=\"col-md-9 admin-content\">\n          <div class=\"container-fluid\">\n            <div class=\"row\">\n              <h2 class=\"title\" data-field=\"heading\" apiman-i18n-key=\"export-import-data\">Export/Import Data</h2>\n            </div>\n            <!-- Helpful hint -->\n            <div class=\"row\">\n              <div class=\"col-md-12\">\n                <p class=\"apiman-label-faded\" apiman-i18n-key=\"export-import-data-help-text\" class=\"apiman-label-faded\">Export all data from the API Manager into an output file, or else use such a file to import data into this installation of the apiman API Manager.</p>\n              </div>\n              <div class=\"col-md-12\">\n                <div class=\"alert alert-info\">\n                  <span class=\"pficon pficon-info\"></span>\n                  <span apiman-i18n-key=\"admin-export.warning\">Note: when exporting or importing data, it is important that no other changes are made in the API Manager.  If possible, disable user access to the API Manager during this process.</span>\n                </div>\n              </div>\n            </div>\n            <!-- HR -->\n            <div class=\"row hr-row\">\n              <hr/>\n            </div>\n            \n            <div class=\"row\">\n              <div class=\"panel panel-default\">\n                <div class=\"panel-heading\">\n                  <h3 class=\"panel-title\" apiman-i18n-key=\"export-data\">Export Data</h3>\n                </div>\n                <div class=\"panel-body\">\n                  <button ng-show=\"exportStatus != \'downloading\'\" ng-click=\"doExport()\" apiman-action-btn=\"\" data-field=\"exportButton\" class=\"btn btn-primary\" apiman-i18n-key=\"export-all\" placeholder=\"Exporting...\" data-icon=\"fa-cog\">Export All</button>\n                  <div ng-show=\"exportButton.state == \'in-progress\'\" style=\"margin-top: 20px\" ng-show=\"exportStatus == \'downloading\'\">\n                    <div class=\"alert alert-info\">\n                      <span class=\"pficon pficon-info\"></span>\n                      <span apiman-i18n-key=\"admin-export.exporting-info\">Once the export has begun, your browser should prompt you to download the exported data file.  Once complete, you will need to refresh this page if you wish to export again.</span>\n                    </div>\n                  </div>\n                </div>\n              </div>\n            </div>\n\n            <div class=\"row\">\n              <div class=\"panel panel-default\">\n                <div class=\"panel-heading\">\n                  <h3 class=\"panel-title\" apiman-i18n-key=\"import-data\">Import Data</h3>\n                </div>\n                <div class=\"panel-body\">\n                  <form class=\"form-inline\">\n                    <div ng-show=\"importStatus == \'none\'\" class=\"form-group\" style=\"width: 75%;\">\n                      <input style=\"width: 100%; border: 1px solid #ccc;\" ng-model=\"importFile.name\" class=\"form-control\" name=\"file\" required>\n                    </div>\n                    <button ng-show=\"importStatus == \'none\'\" ngf-select accept=\"application/json\" class=\"btn btn-default\" ngf-change=\"selectFile($files)\" ngf-multiple=\"false\" apiman-i18n-key=\"select\">Select</button>\n                  </form>\n                  <button ng-show=\"importStatus == \'none\'\" ng-disabled=\"!importFile\" ng-click=\"doImport(importFile)\" class=\"btn btn-primary\" apiman-i18n-key=\"upload-file\" style=\"margin-top: 10px;\">Upload File</button>\n\n                  <div style=\"float: left; width: 100%;\" ng-show=\"importStatus == \'uploading\'\">\n                    <div class=\"progress-description\">\n                      <div class=\"spinner spinner-xs spinner-inline\"></div>\n                      <span apiman-i18n-key=\"uploading-file-msg\">Uploading file, please wait...</span>\n                    </div>\n                    <div class=\"progress progress-label-top-right\">\n                      <div class=\"progress-bar\" role=\"progressbar\" aria-valuenow=\"{{ uploadPercentage }}\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: {{ uploadPercentage }}%;\">\n                        <span>{{ uploadPercentage }}%</span>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div style=\"float: left; width: 100%;\" ng-show=\"importStatus == \'importing\'\">\n                    <div apiman-i18n-key=\"export.importing-data-msg\">Importing data, please wait - this may take some time...</div>\n                    <div class=\"progress\">\n                      <div class=\"progress-bar progress-bar-striped active\" role=\"progressbar\" aria-valuenow=\"100\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 100%\">\n                        <span class=\"sr-only\"></span>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div style=\"float: left; width: 100%;\" ng-show=\"importStatus == \'imported\'\">\n                    <span apiman-i18n-key=\"data-import-completed-msg\">Data import completed.  Please check the response below for details:</span>\n                    <pre style=\"width: 100%; max-height: 300px; margin-top: 15px; overflow: auto\">{{ importResult }}</pre>\n                  </div>\n\n                  <div style=\"float: left; width: 100%;\" ng-show=\"importStatus == \'error\'\">\n                  </div>\n                  \n                </div>\n              </div>\n            </div>\n            \n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/admin/admin-gateways.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.AdminGatewaysController\" class=\"page container admin-page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_bc.include\'\"></div>\r\n        </div>\r\n      </div>\r\n      <div class=\"row\">\r\n        <!-- Side Navigation -->\r\n        <!--\r\n        <div class=\"col-md-3\">\r\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_tabs.include\'\"></div>\r\n        </div>\r\n        -->\r\n        <!-- Admin Content -->\r\n        <div class=\"col-md-9 admin-content\">\r\n          <div class=\"container-fluid\">\r\n            <div class=\"row\">\r\n              <h2 class=\"title\" data-field=\"heading\" apiman-i18n-key=\"gateways\">Gateways</h2>\r\n            </div>\r\n            <!-- Helpful hint -->\r\n            <div class=\"row\">\r\n              <p class=\"col-md-10 apiman-label-faded\" apiman-i18n-key=\"gateways-help-text\" class=\"apiman-label-faded\">Configure the gateways on which the APIs may be published.  If no gateways are configured, then users will not be able to publish their APIs!</p>\r\n            </div>\r\n            <!-- HR -->\r\n            <div class=\"row hr-row\">\r\n              <hr/>\r\n            </div>\r\n            <!-- Filter and Actions -->\r\n            <div class=\"row\">\r\n              <div class=\"apiman-filters apiman-gateways-filters\">\r\n                <a apiman-i18n-key=\"new-gateway\" data-field=\"toNewGateway\" href=\"{{pluginName }}/new-gateway\" class=\"btn btn-primary pull-right\">New Gateway</a>\r\n              </div>\r\n            </div>\r\n            <!-- Table of Gateways -->\r\n            <div class=\"row\">\r\n              <div class=\"table-responsive\">\r\n                <table class=\"table table-striped table-bordered table-hover\" data-field=\"gateways\">\r\n                  <thead>\r\n                    <tr>\r\n                      <th apiman-i18n-key=\"name\">Name</th>\r\n                      <th apiman-i18n-key=\"config-type\">Configuration Type</th>\r\n                    </tr>\r\n                  </thead>\r\n                  <tbody>\r\n                    <tr ng-hide=\"gateways.length > 0\">\r\n                      <td colspan=\"2\">\r\n                        <div class=\"apiman-no-content\">\r\n                          <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-gateways-found\">No gateways have been added! Try adding a Gateway by clicking \'New Gateway\' above - you\'ll need at least one, otherwise users will not be able to publish their APIs.</p>\r\n                        </div>\r\n                      </td>\r\n                    </tr>\r\n                    <tr ng-repeat=\"gateway in gateways\">\r\n                      <td><a href=\"{{ pluginName}}/admin/gateways/{{ gateway.id }}\"><span>{{ gateway.name}}</span></a></td>\r\n                      <td>{{ gateway.type}}</td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n\r\n    </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/admin/admin-plugins.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.AdminPluginsController\" class=\"page container admin-page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <div class=\"col-md-12\">\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_bc.include\'\"></div>\n        </div>\n      </div>\n      <div class=\"row\">\n        <!-- Side Navigation -->\n        <!--\n        <div class=\"col-md-3\">\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_tabs.include\'\"></div>\n        </div>\n        -->\n        <!-- Admin Content -->\n        <div class=\"col-md-9 admin-content\">\n          <div class=\"container-fluid\">\n            <div class=\"row\">\n              <h2 class=\"title\" data-field=\"heading\" apiman-i18n-key=\"plugins\">Plugins</h2>\n            </div>\n            <!-- Helpful hint -->\n            <div class=\"row\">\n              <p class=\"col-md-10 apiman-label-faded\" apiman-i18n-key=\"plugins-help-text\" class=\"apiman-label-faded\">Manage the plugins known to this installation of apiman.  Plugins allow additional functionality to be included in the system after it has been installed and configured.</p>\n            </div>\n            <!-- HR -->\n            <div class=\"row hr-row\">\n              <hr/>\n            </div>\n\n            <div class=\"row\">\n              <ul class=\"nav nav-tabs\">\n                <li class=\"active\"><a href=\"#installed-plugins\" data-toggle=\"tab\" role=\"tab\" apiman-i18n-key=\"installed-plugins\">Installed Plugins</a></li>\n                <li><a href=\"#available-plugins\" data-toggle=\"tab\" role=\"tab\" apiman-i18n-key=\"available-plugins\">Available Plugins</a></li>\n              </ul>\n            </div>\n            \n            <div class=\"tab-content\">\n              <div id=\"installed-plugins\" role=\"tabpanel\" class=\"tab-pane fade active in\">\n                <!-- Table of Plugins -->\n                <div class=\"row\">\n                  <div class=\"table-responsive\">\n                    <table class=\"table table-striped table-bordered table-hover\">\n                      <thead>\n                        <tr>\n                          <th apiman-i18n-key=\"name\">Name</th>\n                          <th apiman-i18n-key=\"description\">Description</th>\n                          <th apiman-i18n-key=\"version\">Version</th>\n                          <th apiman-i18n-key=\"actions\">Actions</th>\n                        </tr>\n                      </thead>\n                      <tbody>\n                        <tr ng-hide=\"plugins.length > 0\">\n                          <td colspan=\"4\">\n                            <div class=\"apiman-no-content container-fluid\">\n                              <div class=\"row\">\n                                <div class=\"col-md-12\">\n                                  <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-plugins-found\">No plugins have been added! Try adding some plugins by clicking Add Plugin above.</p>\n                                </div>\n                              </div>\n                            </div>\n                          </td>\n                        </tr>\n                        <tr ng-repeat=\"plugin in plugins\" ng-class=\"{apiman_deleting: plugin.deleting}\">\n                          <td><a href=\"{{ pluginName }}/admin/plugins/{{ plugin.id }}\">{{ plugin.name }}</a></td>\n                          <td><span>{{plugin.description}}</span></td>\n                          <td nowrap=\"nowrap\"><span>{{plugin.version}}</span></td>\n                          <td nowrap=\"nowrap\" valign=\"middle\">\n                            <div ng-show=\"!plugin.upgrading\">\n                              <button class=\"btn btn-default\" ng-click=\"uninstallPlugin(plugin)\" apiman-i18n-key=\"uninstall\" title=\"Uninstall this plugin.\"><i class=\"fa fa-remove fa-fw\"></i></button>\n                              <button class=\"btn btn-default\" ng-click=\"upgradePlugin(plugin)\" ng-show=\"!plugin.hasAvailableVersion || plugin.canUpgrade\" apiman-i18n-key=\"upgrade\" title=\"Upgrade plugin to a newer version.\"><i class=\"fa fa-arrow-up fa-fw\"></i></button>\n                            </div>\n                            <div ng-show=\"plugin.upgrading\">\n                              <p><span class=\"spinner spinner-xs spinner-inline\"></span><span font-size=\"12px\" apiman-i18n-key=\"upgrading\">Upgrading...</span></p>\n                            </div>\n                          </td>\n                        </tr>\n                      </tbody>\n                    </table>\n                  </div>\n                </div>\n              </div>\n\n              <div id=\"available-plugins\" role=\"tabpanel\" class=\"tab-pane fade\">\n                <div class=\"row\">\n                  <div class=\"apiman-filters apiman-policyDefs-filters\">\n                    <div>\n                      <apiman-search-box id=\"plugin-name-filter\" apiman-i18n-key=\"filter-plugins\" function=\"filterAvailablePlugins\" placeholder=\"Filter by plugin name...\" />\n                    </div>\n                    <a apiman-i18n-key=\"add-custom-plugin\" href=\"{{ pluginName }}/new-plugin\" class=\"btn btn-primary pull-right\">Add Custom Plugin</a>\n                  </div>\n                </div>\n                <!-- Table of Available Plugins -->\n                <div class=\"row\">\n                  <div class=\"table-responsive\">\n                    <table class=\"table table-striped table-bordered table-hover\">\n                      <thead>\n                        <tr>\n                          <th apiman-i18n-key=\"name\">Name</th>\n                          <th apiman-i18n-key=\"description\">Description</th>\n                          <th apiman-i18n-key=\"actions\">Actions</th>\n                        </tr>\n                      </thead>\n                      <tbody>\n                        <tr ng-hide=\"availablePlugins.length > 0\">\n                          <td colspan=\"3\">\n                            <div class=\"apiman-no-content container-fluid\">\n                              <div class=\"row\">\n                                <div class=\"col-md-12\">\n                                  <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-available-plugins-found\">No plugins found! Perhaps the plugin registry is not properly configured?</p>\n                                </div>\n                              </div>\n                            </div>\n                          </td>\n                        </tr>\n                        <tr ng-hide=\"filteredAvailablePlugins.length > 0 || availablePlugins.length == 0\">\n                          <td colspan=\"3\">\n                            <div class=\"apiman-no-content container-fluid\">\n                              <div class=\"row\">\n                                <div class=\"col-md-12\">\n                                  <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-available-plugins-found-filtered\">No plugins match your filter criteria.</p>\n                                </div>\n                              </div>\n                            </div>\n                          </td>\n                        </tr>\n                        <tr ng-repeat=\"plugin in filteredAvailablePlugins\">\n                          <td>{{ plugin.name }}</td>\n                          <td><span>{{plugin.description}}</span></td>\n                          <td nowrap=\"nowrap\">\n                            <a ng-hide=\"plugin.isInstalled\" href=\"{{ pluginName }}/new-plugin?groupId={{ plugin.groupId }}&amp;artifactId={{ plugin.artifactId }}&amp;version={{ plugin.version }}&amp;classifier={{ plugin.classifier }}&amp;type={{ plugin.type }}\" apiman-i18n-key=\"install\">Install</a>\n                            <span class=\"apiman-label apiman-label-success\" ng-hide=\"!plugin.isInstalled\" apiman-i18n-key=\"installed\">Installed</span>\n                          </td>\n                        </tr>\n                      </tbody>\n                    </table>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n\n      <div ng-include=\"\'plugins/api-manager/html/modals/confirmModal.html\'\"></div>\n      <div ng-include=\"\'plugins/api-manager/html/modals/getValueModal.html\'\"></div>\n\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/admin/admin-policyDefs.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.AdminPolicyDefsController\" class=\"page container admin-page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_bc.include\'\"></div>\r\n        </div>\r\n      </div>\r\n      <div class=\"row\">\r\n        <!-- Side Navigation -->\r\n        <!--\r\n        <div class=\"col-md-3\">\r\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_tabs.include\'\"></div>\r\n        </div>\r\n      -->\r\n        <!-- Admin Content -->\r\n        <div class=\"col-md-9 admin-content\">\r\n          <div class=\"container-fluid\">\r\n            <div class=\"row\">\r\n              <h2 class=\"title\" data-field=\"heading\" apiman-i18n-key=\"policy-definitions\">Policy Definitions</h2>\r\n            </div>\r\n            <!-- Helpful hint -->\r\n            <div class=\"row\">\r\n              <p class=\"col-md-10 apiman-label-faded\" apiman-i18n-key=\"policy-definitions-help-text\" class=\"apiman-label-faded\">Configure the available policy definitions.  These will be the policies made available to users when configuring clients, APIs, and plans.</p>\r\n            </div>\r\n            <!-- HR -->\r\n            <div class=\"row hr-row\">\r\n              <hr/>\r\n            </div>\r\n            <!-- Filter and Actions -->\r\n            <div class=\"row\">\r\n              <div class=\"apiman-filters apiman-policyDefs-filters\">\r\n                <div>\r\n                  <apiman-search-box id=\"policy-name-filter\" apiman-i18n-key=\"filter-policies\" function=\"filterPolicies\" placeholder=\"Filter by policy name...\" />\r\n                </div>\r\n                <a apiman-i18n-key=\"import-policy\" href=\"{{ pluginName }}/import-policyDefs\" class=\"btn btn-primary pull-right\">Import Policy</a>\r\n              </div>\r\n            </div>\r\n            <!-- Table of Policy Definitions -->\r\n            <div class=\"row\">\r\n\r\n              <div ng-hide=\"policyDefs.length > 0\">\r\n                <div class=\"apiman-no-content container-fluid\">\r\n                  <div class=\"row\">\r\n                    <div class=\"col-md-12\">\r\n                      <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-policy-defs-found\">No policy definitions have been added!  Without at least one policy definition users will not be able to add policies to their APIs, Plans, and Clients.</p>\r\n                    </div>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n\r\n              <div ng-show=\"policyDefs.length > 0 && filteredPolicyDefs.length == 0\">\r\n                <div class=\"apiman-no-content container-fluid\">\r\n                  <div class=\"row\">\r\n                    <div class=\"col-md-12\">\r\n                      <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-policy-defs-for-filter\">No policy definitions matched your filter criteria.  Try something different!</p>\r\n                    </div>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n\r\n              <div class=\"apiman-summaryrow\" ng-repeat=\"policyDef in filteredPolicyDefs\">\r\n                <a href=\"{{ pluginName }}/admin/policyDefs/{{policyDef.id}}\"><i style=\"font-size: 18px; margin-top: 2px\" class=\"fa fa-{{ policyDef.icon}} fa-fw\"></i><span>{{ policyDef.name }}</span></a>\r\n                <div style=\"padding-left: 24px\">\r\n	                <div class=\"description apiman-label-faded\">{{ policyDef.description}}</div>\r\n	                <div>\r\n	                  <div class=\"emphasis\" apiman-i18n-key=\"implementation\">Implementation:</div>\r\n	                  <div>{{ policyDef.policyImpl}}</div>\r\n	                </div>\r\n                </div>\r\n                <hr/>\r\n              </div>\r\n              \r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/admin/admin-roles.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.AdminRolesController\" class=\"page container admin-page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <div class=\"col-md-12\">\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_bc.include\'\"></div>\n        </div>\n      </div>\n      <div class=\"row\">\n        <!-- Side Navigation -->\n        <!--\n        <div class=\"col-md-3\">\n          <div ng-include=\"\'plugins/api-manager/html/admin/admin_tabs.include\'\"></div>\n        </div>\n        -->\n        <!-- Admin Content -->\n        <div class=\"col-md-9 admin-content\">\n          <div class=\"container-fluid\">\n            <div class=\"row\">\n              <h2 class=\"title\" apiman-i18n-key=\"role-management\" apiman-i18n-key=\"role-management\">Role Management</h2>\n            </div>\n            <!-- Helpful hint -->\n            <div class=\"row\">\n              <p class=\"col-md-10 apiman-label-faded\" apiman-i18n-key=\"role-management-help-text\" class=\"apiman-label-faded\">Create and modify roles that users can be granted membership in for any organization.  Each role grants the user a set of permissions, allowing her to do specific things within the organization.</p>\n            </div>\n            <!-- HR -->\n            <div class=\"row hr-row\">\n              <hr/>\n            </div>\n            <!-- Filter and Actions -->\n            <div class=\"row\">\n              <div class=\"apiman-filters apiman-roles-filters\">\n                <div>\n                  <apiman-search-box id=\"role-name-filter\" apiman-i18n-key=\"filter-roles\" function=\"filterRoles\" placeholder=\"Filter by role name...\" />\n                </div>\n                <a apiman-i18n-key=\"new-role\" href=\"{{ pluginName }}/new-role\" class=\"btn btn-primary pull-right\">New Role</a>\n              </div>\n            </div>\n            <!-- The Roles -->\n            <div class=\"row\">\n              <div class=\"apiman-roles\">\n\n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"roles.length > 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-8\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-roles-found\">No roles have been created.  Until at least one \"auto-grant\" role is created, users will not be able to use apiman.</p>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"roles.length > 0 && filteredRoles.length == 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-12\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-roles-found-for-filter\">No roles found matching your filter criteria - please try searching for something different.</p>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"role in filteredRoles\">\n                    <div class=\"row\">\n                      <span class=\"title\"><a href=\"{{ pluginName }}/admin/roles/{{ role.id }}\">{{ role.name }}</a></span>\n                      \n                      <a ng-show=\"role.autoGrant\" class=\"apiman-summaryrow-icon\">\n                        <i class=\"fa fa-check fa-fw\"></i>\n                        <span class=\"title-summary-item\" apiman-i18n-key=\"auto-grant-to-creator\">Auto-granted to org creator</span>\n                      </a>\n                    </div>\n                    <div class=\"row\" style=\"margin-bottom: 8px;\">\n                      <span class=\"description apiman-label-faded\">\n                        {{ role.description }}\n                      </span>\n                    </div>\n                    <div class=\"row\">\n                      <div class=\"permissions\">\n                        <span class=\"emphasis\" apiman-i18n-key=\"grants-permissions\">Grants Permissions:</span>\n                        <span class=\"description\" ng-repeat=\"permission in role.permissions\">\n                        	{{ permission }}{{$last ? \'\' : \', \'}}\n                        </span>\n                      </div>\n                    </div>\n                    <hr/>\n                  </div>\n                </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/api/api-activity.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiActivityController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content\">\r\n          <!-- Title and help text -->\r\n          <div class=\"title\" apiman-i18n-key=\"api-activity\">API Change Log</div>\r\n          <div class=\"description\" apiman-i18n-key=\"api-activity-help\">The list below is all of the configuration changes (made by apiman users) associated with this API.</div>\r\n          <hr />\r\n          <apiman-activity model=\"auditEntries\" next=\"getNextPage\"/> \r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-contracts.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiContractsController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content\">\r\n          <div class=\"col-md-9\">\r\n            <div class=\"title\" apiman-i18n-key=\"api-contracts\">API Contracts</div>\r\n            <div class=\"description\" apiman-i18n-key=\"api-contracts-help\">Here is a list of all contracts between all Client Apps and this API.  This provides a list of all Client Apps that may potentially consume this API.</div>\r\n          </div>\r\n          <div class=\"col-md-12\" ng-show=\"isPublicOnly\">\r\n            <div aria-hidden=\"false\" style=\"background-color: rgb(255, 213, 185);\" apiman-i18n-key=\"warning-public-only\" data-field=\"onlyPublicWarning\" class=\"alert alert-warning no-icon\">Warning: this API is exclusively public, which means that it is impossible for Client Apps to create API Contracts with it.</div>\r\n          </div>\r\n          <div class=\"col-md-12\">\r\n            <div class=\"table-responsive\">\r\n              <table class=\"table table-striped table-bordered table-hover\" data-field=\"contracts\">\r\n                <thead>\r\n                  <tr>\r\n                    <th width=\"70%\" apiman-i18n-key=\"client-client\" nowrap=\"nowrap\">Client App</th>\r\n                    <th apiman-i18n-key=\"plan\" nowrap=\"nowrap\">Plan</th>\r\n                    <th apiman-i18n-key=\"created-on_capitalized\" nowrap=\"nowrap\">Created On</th>\r\n                  </tr>\r\n                </thead>\r\n                <tbody>\r\n\r\n                  <tr ng-hide=\"contracts.length > 0\">\r\n                    <td colspan=\"4\">\r\n                      <div class=\"apiman-no-content container-fluid\">\r\n                        <div class=\"row\">\r\n                          <div class=\"col-md-12\">\r\n                            <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-api-contracts\">This API doesn\'t appear to have any contracts. This means that there aren\'t any client apps consuming this API.  Note: if this is a public API, then no contracts are necessary to invoke the API!</p>\r\n                          </div>\r\n                        </div>\r\n                      </div>\r\n                    </td>\r\n                  </tr>\r\n\r\n                  <tr ng-repeat=\"contract in contracts\">\r\n                    <td>\r\n                      <span>\r\n                        <a href=\"{{ pluginName }}/browse/orgs/{{ contract.clientOrganizationId }}\"><span>{{ contract.clientOrganizationName }}</span></a>\r\n                        <span apiman-i18n-skip>/</span>\r\n                        <span class=\"emphasis\">{{ contract.clientName }}</span>\r\n                        <span apiman-i18n-skip>&#8680;</span>\r\n                        <span>{{ contract.clientVersion }}</span>\r\n                      </span>\r\n                    </td>\r\n                    <td><span>{{ contract.planName }}</span></td>\r\n                    <td><span>{{ contract.createdOn | date:\'yyyy-MM-dd\' }}</span></td>\r\n                  </tr>\r\n                </tbody>\r\n              </table>\r\n            </div>\r\n            <div style=\"text-align: center\" ng-hide=\"contracts.length == 0\">\r\n              <button ng-show=\"hasMore\" ng-click=\"getNextPage()\" class=\"btn btn-default\" data-field=\"moreButton\" apiman-i18n-key=\"show-more-contracts\" placeholder=\"Loading...\" data-icon=\"fa-cog\">Show More Contracts</button>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-def.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta content=\"width=device-width, initial-scale=1.0\" name=\"viewport\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n\r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiDefController\"\r\n         class=\"page container\"\r\n         data-field=\"page\"\r\n         ng-cloak=\"\"\r\n         ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content\">\r\n          <div class=\"col-md-10\">\r\n            <div class=\"title\"\r\n                 apiman-i18n-key=\"api-def\">API Definition</div>\r\n            <div class=\"apiman-label-faded\">\r\n              <p apiman-i18n-key=\"api-def-explanation\">\r\n                Here you can (optionally) provide definition information about your API.  This\r\n                information should take the form of a Swagger API definition file.  Adding a \r\n                definition file will allow consumers to better understand how to use your API.\r\n                Simply copy/paste (or drag and drop!) your Swagger API definition into the text\r\n                area below.\r\n              </p>\r\n            </div>\r\n            <div class=\"apiman-divider-20\" ng-show=\"definitionType\">\r\n              <div class=\"alert alert-warning\">\r\n                <span class=\"pficon pficon-info\"></span>\r\n                <p apiman-i18n-key=\"api-def.replaceInfo\">If the API is published, the endpoint in the definition\r\n                  will be automatically replaced by the endpoint of the gateway.</p>\r\n                <p apiman-i18n-key=\"api-def.downloadInfo\">You can retrieve the definition with the following link&#58;&#32;</p>\r\n                <p><a href=\"{{ apimanDefinitionUrl }}\">{{ apimanDefinitionUrl }}</a></p>\r\n              </div>\r\n            </div>\r\n            <form>\r\n              <div>\r\n                <span class=\"clearfix top-spacer bottom-spacer\"\r\n                      apiman-i18n-key=\"api-definition-label\">API Definition:</span>\r\n                <select apiman-i18n-key=\"api-def.choose-type\"\r\n                        title=\"Choose a type...\"\r\n                        apiman-select-picker=\"\"\r\n                        ng-model=\"selectedDefinitionType\"\r\n                        class=\"selectpicker\"\r\n                        ng-disabled=\"isEntityDisabled()\"\r\n                        ng-options=\"type.label for type in typeOptions track by type.value\">\r\n                </select>\r\n\r\n                <div class=\"top-spacer\">\r\n                  <span class=\"clearfix top-spacer bottom-spacer\"\r\n                        apiman-i18n-key=\"api-definition-url-label\">API Definition URL:\r\n                  </span>\r\n                  <div class=\"input-group\" style=\"width: 100%\">\r\n                    <input ng-model=\"updatedApiDefinitionUrl\"\r\n                           name=\"definitionUrl\"\r\n                           class=\"apiman-form-control form-control\"\r\n                           type=\"text\"\r\n                    >\r\n                    <span class=\"input-group-btn\">\r\n                      <div apiman-permission=\"apiEdit\"\r\n                           ng-show=\"!isEntityDisabled()\"\r\n                           class=\"actions definition\"\r\n                      >\r\n                        <button type=\"button\" class=\"btn btn-default\"\r\n                                ng-click=\"updateDefinitionFromUrl()\"\r\n                                style=\"margin-left: 5px\"\r\n                                ng-disabled=\"updatedApiDefinitionUrl == null\"\r\n                                apiman-i18n-key=\"load-definition\">Load Definition\r\n                        </button>\r\n                      </div>\r\n                    </span>\r\n                  </div>\r\n                </div>\r\n\r\n                <textarea style=\"width: 100%;\"\r\n                          apiman-i18n-key=\"enter-api-definition\"\r\n                          id=\"api-definition\"\r\n                          placeholder=\"Copy/paste or drag and drop your API Definition in here!\"\r\n                          apiman-drop-text\r\n                          ng-model=\"updatedApiDefinition\"\r\n                          ng-init=\"focus=false;blur=false;\"\r\n                          ng-class=\"{ myFocus: focus, myBlur: blur }\"\r\n                          ng-focus=\"focus=true;blur=false;\"\r\n                          ng-blur=\"blur=true;focus=false;\"\r\n                          data-field=\"data\"\r\n                          class=\"apiman-form-control form-control apiman-form-data top-spacer\"\r\n                          ng-disabled=\"isEntityDisabled()\">\r\n                </textarea>\r\n              </div>\r\n\r\n              <div apiman-permission=\"apiEdit\"\r\n                   ng-show=\"!isEntityDisabled()\"\r\n                   class=\"actions definition\"\r\n                   style=\"margin-top: 20px\"\r\n              >\r\n                <button type=\"button\" class=\"btn btn-default\" ng-mousedown=\"downloadDefinition()\"\r\n                        ng-disabled=\"isDirty || !apiDefinition\" apiman-i18n-key=\"download\">Download\r\n                </button>\r\n                <button ng-disabled=\"!isDirty  || updatedApiDefinition.length == 0\"\r\n                        ng-mousedown=\"saveApi()\"\r\n                        apiman-action-btn=\"\"\r\n                        class=\"btn btn-primary\"\r\n                        data-field=\"saveButton\"\r\n                        apiman-i18n-key=\"save\"\r\n                        placeholder=\"Saving...\"\r\n                        data-icon=\"fa-cog\" >Save\r\n                </button>\r\n                <button ng-disabled=\"!isDirty\"\r\n                        ng-mousedown=\"reset()\"\r\n                        class=\"btn btn-default\"\r\n                        data-field=\"cancelButton\"\r\n                        apiman-i18n-key=\"cancel\">Cancel\r\n                </button>\r\n              </div>\r\n            </form>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-endpoint.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiEndpointController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\">\r\n          <!-- Content Summary -->\r\n          <div class=\"col-md-12\">\r\n            <div class=\"title\" apiman-i18n-key=\"managed-endpoint-impl\">Managed Endpoint Information</div>\r\n            <p class=\"explanation\" apiman-i18n-key=\"managed-endpoint-explanation\">\r\n                To successfully invoke this managed API, a client must send the request \r\n                to the appropriate API Gateway endpoint.  When invoking the API through\r\n                an API Contract, a valid API Key must be included in each request.  If \r\n                the API is public, it can be invoked directly (without an API Key) through\r\n                the endpoint below.\r\n            </p>\r\n            <div ng-show=\"!version.publicAPI\">\r\n              <div class=\"apiman-divider-40\"></div>\r\n              <div apiman-i18n-key=\"warning-not-public\" class=\"alert alert-warning no-icon\">Warning: this API is not public - this endpoint will only work if a valid API Key is included in requests made to it.</div>\r\n            </div>\r\n            <hr />\r\n            <div class=\"apiman-form-label\">\r\n              <p apiman-i18n-key=\"managed-endpoint\">Managed Endpoint</p>\r\n            </div>\r\n              <div class=\"input-group\" style=\"width: 80%\">\r\n                  <input type=\"text\"\r\n                         style=\"background-color: white; color: black\"\r\n                         class=\"apiman-endpoint form-control\"\r\n                         readonly=\"readonly\"\r\n                         data-field=\"mangedEndpoint\"\r\n                         value=\"{{ managedEndpoint.managedEndpoint }}\">\r\n                  <span class=\"input-group-btn\">\r\n                      <button clipboard\r\n                              text=\"managedEndpoint.managedEndpoint\"\r\n                              class=\"btn btn-default\"\r\n                              type=\"button\"\r\n                              on-copied=\"copySuccess()\"\r\n                              on-error=\"copyFail(err)\"\r\n                              data-toggle=\"tooltip\"\r\n                              data-placement=\"bottom\"\r\n                              data-original-title=\"Copy to clipboard\"\r\n                              ng-mouseleave=\"tooltipReset()\"\r\n                              ng-click=\"tooltipChange()\">\r\n                        <span class=\"glyphicon glyphicon-copy\"></span>\r\n                      </button>\r\n                  </span>\r\n              </div>\r\n          </div>\r\n          <!-- /Content Summary -->\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-impl.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\"\r\n          content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n\r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiImplController\"\r\n         class=\"page container\"\r\n         data-field=\"page\"\r\n         ng-cloak=\"\"\r\n         ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content\">\r\n          <div class=\"col-md-8\">\r\n            <form name=\"apiImplForm\" novalidate>\r\n            <div class=\"title\"\r\n                 apiman-i18n-key=\"api-impl\">API Implementation</div>\r\n            <div class=\"apiman-label-faded\">\r\n              <p apiman-i18n-key=\"api-impl-explanation\">\r\n                Please provide us with details about the back-end API implementation\r\n                so that the API Gateway can successfully proxy API requests.  Please\r\n                include any security you wish to enable between the API Gateway and the\r\n                back-end API.\r\n              </p>\r\n            </div>\r\n            <div class=\"bottom-spacer\">\r\n              <span apiman-i18n-key=\"api-endpoint-label\">API Endpoint:</span>\r\n              <input ng-model=\"updatedApi.endpoint\"\r\n                     data-field=\"endpoint\"\r\n                     name=\"endpoint\"\r\n                     class=\"apiman-form-control form-control\"\r\n                     type=\"text\"\r\n                     ng-disabled=\"isEntityDisabled()\">\r\n            </div>\r\n            <div style=\"color: #ff0000\" ng-show=\"invalidEndpoint === true\">\r\n              <p apiman-i18n-key=\"invalid-endpiont-msg\">Please enter a valid endpoint that begins with http:// or https://.</p>\r\n            </div>\r\n            <div style=\"margin-top: 10px\">\r\n              <span class=\"clearfix\"\r\n                    apiman-i18n-key=\"api-type-label\">API Type:</span>\r\n              <ui-select ng-model=\"updatedApi.endpointType\"\r\n                         ng-disabled=\"isEntityDisabled()\"\r\n                         style=\"width: 30%; max-width: 300px;\">\r\n                <ui-select-match placeholder=\"Choose a type...\"\r\n                                 apiman-i18n-key=\"api-impl.choose-type\">\r\n                  <span ng-bind=\"$select.selected.toUpperCase()\"></span>\r\n                </ui-select-match>\r\n                <ui-select-choices repeat=\"type in (typeOptions | filter: $select.search) track by type\">\r\n                  <span ng-bind=\"type.toUpperCase()\"></span>\r\n                </ui-select-choices>\r\n              </ui-select>\r\n            </div>\r\n            <div style=\"margin-top: 10px\">\r\n              <span class=\"clearfix\"\r\n                    apiman-i18n-key=\"api-content-type-label\">API Content Type:</span>\r\n              <ui-select ng-model=\"updatedApi.endpointContentType\"\r\n                         ng-disabled=\"isEntityDisabled()\"\r\n                         name=\"endpointContentType\"\r\n                         style=\"width: 30%; max-width: 300px;\">\r\n                <ui-select-match placeholder=\"Choose a content type...\"\r\n                                 apiman-i18n-key=\"api-impl.choose-content-type\">\r\n                  <span ng-bind=\"$select.selected.toUpperCase()\"></span>\r\n                </ui-select-match>\r\n                <ui-select-choices repeat=\"ct in (contentTypeOptions | filter: $select.search) track by ct\">\r\n                  <span ng-bind=\"ct.toUpperCase()\"></span>\r\n                </ui-select-choices>\r\n              </ui-select>\r\n            </div>\r\n\r\n            <div style=\"margin-top: 10px\">\r\n              <input ng-model=\"updatedApi.parsePayload\"\r\n                     type=\"checkbox\"\r\n                     id=\"parse-payload\"\r\n                     ng-disabled=\"isEntityDisabled()\">\r\n              <label for=\"parse-payload\"\r\n                     apiman-i18n-key=\"parse-payload-msg\"\r\n                     style=\"padding-left: 3px\">Enable stateful request payload inspection</label>\r\n              <a apiman-i18n-key=\"parse-payload-tooltip\" type=\"button\" href=\"javascript:void(0)\" class=\"\" data-toggle=\"popover\" title=\"Stateful Payload Inspection\" data-close=\"true\" data-content=\"If this feature is enabled, the Gateway will parse the request body into an object prior to applying the policies.  This allows policies to make decisions based on the content of the request payload, but slows down the Gateway a bit.\">\r\n                <span class=\"pficon pficon-info\"></span>\r\n              </a>\r\n            </div>\r\n\r\n            <div class=\"\" style=\"margin-top:10px;\"\r\n                 ng-show=\"updatedApi.parsePayload\">\r\n              <div class=\"alert alert-info\">\r\n                 <span class=\"pficon pficon-info\"></span>\r\n                 <span apiman-i18n-key=\"api-impl.parse-payload-info\">Note that enabling this option may result in additional performance overhead.  However, this feature is sometimes required for certain policies to work (in particular many SOAP policies).</span>\r\n              </div>\r\n            </div>\r\n\r\n            <div style=\"margin-top: 10px\">\r\n              <input ng-model=\"updatedApi.disableKeysStrip\"\r\n                     type=\"checkbox\"\r\n                     id=\"disable-keys-strip\"\r\n                     ng-disabled=\"isEntityDisabled()\">\r\n              <label for=\"disable-keys-strip\"\r\n                     apiman-i18n-key=\"disable-keys-strip-msg\"\r\n                     style=\"padding-left: 3px\">Disable request keys stripping</label>\r\n              <a apiman-i18n-key=\"disable-keys-strip-tooltip\" type=\"button\" href=\"javascript:void(0)\" class=\"\" data-toggle=\"popover\" title=\"Request keys stripping\" data-close=\"true\" data-content=\"If this feature is enabled, the Gateway will not strip the X-API-KEY and apikey query param from the request. This allows the gateway to send the keys to the backend endpoint.\">\r\n                <span class=\"pficon pficon-info\"></span>\r\n              </a>\r\n            </div>\r\n\r\n            <div class=\"\" style=\"margin-top:10px;\">\r\n              <span class=\"clearfix\"\r\n                    apiman-i18n-key=\"api-security-label\">API Security:</span>\r\n              <ui-select ng-model=\"apiSecurity.type\"\r\n                         ng-disabled=\"isEntityDisabled()\"\r\n                         on-select=\"setEndpointProperties($item)\"\r\n                         style=\"width: 30%; max-width: 300px;\">\r\n                <ui-select-match>\r\n                  <span ng-bind=\"$select.selected.label\"></span>\r\n                </ui-select-match>\r\n                <ui-select-choices repeat=\"option.type as option in (apiSecurityTypeOptions | filter: $select.search) track by option.type\">\r\n                  <span ng-bind=\"option.label\"></span>\r\n                </ui-select-choices>\r\n              </ui-select>\r\n            </div>\r\n\r\n            <div class=\"\" style=\"margin-top:10px;\"\r\n                 ng-show=\"apiSecurity.type == \'mtls\'\">\r\n              <div class=\"alert alert-info\">\r\n                 <span class=\"pficon pficon-info\"></span>\r\n                 <span apiman-i18n-key=\"api-impl.mtsl-info\">When using MTLS/Two-Way-SSL you must configure the relevant settings globally in the apiman.properties file.  Please refer to the apiman Installation Guide for details.</span>\r\n              </div>\r\n            </div>\r\n\r\n            <div class=\"panel panel-default\" style=\"margin-top:10px;\"\r\n                 ng-show=\"apiSecurity.type == \'basic\'\">\r\n              <div class=\"panel-body\">\r\n                <table width=\"100%\"\r\n                       class=\"form-table\">\r\n                  <tr>\r\n                    <td width=\"1%\"\r\n                        nowrap=\"nowrap\"\r\n                        align=\"right\">\r\n                      <span apiman-i18n-key=\"username-label\"\r\n                            class=\"\">Username:</span>\r\n                    </td>\r\n                    <td>\r\n                      <input id=\"basic-auth.username\"\r\n                             ng-model=\"apiSecurity.basic.username\"\r\n                             class=\"apiman-form-control form-control\"\r\n                             width=\"100%\"\r\n                             type=\"text\"\r\n                             ng-disabled=\"isEntityDisabled()\">\r\n                    </td>\r\n                  </tr>\r\n                  <tr>\r\n                    <td width=\"1%\"\r\n                        nowrap=\"nowrap\"\r\n                        align=\"right\">\r\n                        <span apiman-i18n-key=\"password-label\"\r\n                              class=\"\">Password:</span>\r\n                    </td>\r\n                    <td>\r\n                        <input id=\"basic-auth.password\"\r\n                               ng-model=\"apiSecurity.basic.password\"\r\n                               class=\"apiman-form-control form-control\"\r\n                               width=\"100%\"\r\n                               type=\"password\"\r\n                               ng-disabled=\"isEntityDisabled()\">\r\n                    </td>\r\n                  </tr>\r\n                  <tr>\r\n                    <td width=\"1%\"\r\n                        nowrap=\"nowrap\"\r\n                        align=\"right\">\r\n                        <span apiman-i18n-key=\"confirm-password-label\"\r\n                              class=\"\">Confirm Password:</span>\r\n                    </td>\r\n                    <td>\r\n                        <input id=\"basic-auth.confirm-password\"\r\n                               ng-model=\"apiSecurity.basic.confirmPassword\"\r\n                               class=\"apiman-form-control form-control\"\r\n                               width=\"100%\"\r\n                               type=\"password\"\r\n                               ng-disabled=\"isEntityDisabled()\">\r\n                    </td>\r\n                  </tr>\r\n                  <tr>\r\n                    <td width=\"1%\"\r\n                        nowrap=\"nowrap\"\r\n                        align=\"right\"></td>\r\n                    <td>\r\n                      <input ng-model=\"apiSecurity.basic.requireSSL\"\r\n                             type=\"checkbox\"\r\n                             id=\"require-ssl\"\r\n                             ng-disabled=\"isEntityDisabled()\">\r\n                      <label for=\"require-ssl\"\r\n                             apiman-i18n-key=\"endpoint-security.require-ssl\"\r\n                             style=\"padding-left: 3px\">Require transport security (SSL)</label>\r\n                    </td>\r\n                  </tr>\r\n                </table>\r\n              </div>\r\n            </div>\r\n\r\n            <div id=\"gateway-info\"\r\n                 ng-show=\"gateways.length > 1\">\r\n              <hr />\r\n              <div class=\"title\"\r\n                   apiman-i18n-key=\"gateway\">Gateway</div>\r\n              <div class=\"apiman-label-faded\">\r\n                <p apiman-i18n-key=\"api-impl-gateway-explanation\">\r\n                  There are multiple API Gateways configured - you\'ll need to tell us which one you\r\n                  want to use for this API.\r\n                </p>\r\n              </div>\r\n              <div>\r\n                <span class=\"clearfix\"\r\n                      apiman-i18n-key=\"publish-to\">Publish To:</span>\r\n                <select ng-options=\"gateway.name for gateway in gateways | orderBy: name\"\r\n                        ng-model=\"selectedGateways\"\r\n                        ng-disabled=\"isEntityDisabled()\"\r\n                        class=\"selectpicker\"\r\n                        apiman-select-picker=\"\"\r\n                        multiple>\r\n                </select>\r\n              </div>\r\n            </div>\r\n\r\n            <div id=\"no-gateways-info\"\r\n                 ng-show=\"gateways.length == 0\">\r\n              <hr />\r\n              <div class=\"title\"\r\n                   apiman-i18n-key=\"gateway\">Gateway</div>\r\n              <div class=\"alert alert-warning\"\r\n                   apiman-i18n-key=\"api-impl-no-gateways-explanation\">\r\n                  There are no API Gateways configured in apiman.  For this reason you will not\r\n                  be able to complete the configuration of your API.  Please contact your\r\n                  apiman administrator - at least one API Gateway must be configured!\r\n              </div>\r\n            </div>\r\n\r\n            <div id=\"new-gateway-info\"\r\n                 ng-show=\"autoGateway\">\r\n              <hr />\r\n              <div class=\"title\"\r\n                   apiman-i18n-key=\"gateway\">Gateway</div>\r\n              <div class=\"alert alert-success\"\r\n                   apiman-i18n-key=\"api-impl-new-gateway-explanation\">\r\n                  An API Gateway has been added since this API was created.  The new\r\n                  Gateway has been selected for you - all you need to do is click Save below\r\n                  to make it stick.\r\n              </div>\r\n            </div>\r\n\r\n            <div apiman-permission=\"apiEdit\"\r\n                 ng-show=\"!isEntityDisabled()\"\r\n                 class=\"actions\"\r\n                 style=\"margin-top: 20px\">\r\n              <button ng-disabled=\"checkValid() === false || isDirty === false || saving === true\"\r\n                      ng-click=\"validateEndpoint()\"\r\n                      class=\"btn btn-primary\"\r\n                      type=\"submit\"\r\n                      data-icon=\"fa-cog\">\r\n                <span ng-show=\"saving\" apiman-i18n-key=\"saving\">Saving</span>\r\n                <span ng-hide=\"saving\" apiman-i18n-key=\"save\">Save</span>\r\n              </button>\r\n              <button ng-disabled=\"!isDirty\"\r\n                      ng-click=\"reset()\"\r\n                      class=\"btn btn-default\"\r\n                      data-field=\"cancelButton\"\r\n                      apiman-i18n-key=\"cancel\">Cancel</button>\r\n            </div>\r\n            </form>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-metrics.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div id=\"form-page\" ng-controller=\"Apiman.ApiMetricsController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\">\r\n          <!-- Content Summary -->\r\n          <div class=\"col-md-12\">\r\n            <div class=\"title\" apiman-i18n-key=\"api-metrics\">API Metrics</div>\r\n            <p class=\"explanation\" apiman-i18n-key=\"api-metrics-explanation\">\r\n                Now that this API is published to the gateway, it *may* be consumed by\r\n                API clients.  Use this tab to view basic metrics/analytics for the API.\r\n            </p>\r\n            <div id=\"apiman-api-metrics-selector\" style=\"margin-top: 15px; padding-top: 8px; border-top: 1px solid #ddd; border-bottom: 1px solid #ddd\">\r\n              <span style=\"margin-right: 5px\" apiman-i18n-key=\"api-metrics.show\">Show</span>\r\n                <select ng-model=\"metricsType\" apiman-select-picker=\"\" class=\"selectpicker apiman-inline-form-dropdown\" data-style=\"btn-default apiman-inline-form-dropdown\">\r\n                  <option value=\"usage\" apiman-i18n-key=\"metrics-usage\">usage</option>\r\n                  <option value=\"responseType\" apiman-i18n-key=\"metrics-responseType\">response type</option>\r\n                </select>\r\n              <span style=\"margin-right: 5px\" apiman-i18n-key=\"api-metrics.show-metrics-for\">metrics data for the</span>\r\n              <select ng-model=\"metricsRange\" apiman-select-picker=\"\" class=\"selectpicker apiman-inline-form-dropdown\" data-style=\"btn-default apiman-inline-form-dropdown\">\r\n                <option value=\"90days\" apiman-i18n-key=\"metrics-90days\">last 90 days</option>\r\n                <option value=\"30days\" apiman-i18n-key=\"metrics-30days\">last 30 days</option>\r\n                <option value=\"7days\" apiman-i18n-key=\"metrics-7days\">last 7 days</option>\r\n                <option value=\"24hours\" apiman-i18n-key=\"metrics-24hours\">last 24 hours</option>\r\n                <option value=\"hour\" apiman-i18n-key=\"metrics-hour\">last hour</option>\r\n              </select>\r\n              <button style=\"height:28px\" class=\"btn btn-default pull-right\" apiman-i18n-key=\"refresh\" ng-click=\"refreshCharts()\">Refresh</button>\r\n            </div>\r\n          </div>\r\n          <!-- /Content Summary -->\r\n\r\n          <!-- Usage Metrics -->\r\n          <div id=\"usage-metrics\" ng-show=\"metricsType == \'usage\'\">\r\n            <div class=\"col-md-12\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"overall-usage\">Overall Usage</h3>\r\n              <div id=\"usage-chart\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"usageChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"usageChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n            <div class=\"col-md-6\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"top-client-usage\">Top Client Usage</h3>\r\n              <div id=\"client-usage-chart\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"clientUsageChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"clientUsageChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n            <div class=\"col-md-6\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"usage-by-plan\">Usage by Plan</h3>\r\n              <div id=\"plan-usage-chart\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"planUsageChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"planUsageChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n          </div>\r\n\r\n          <!-- Response Type Metrics -->\r\n          <div id=\"response-type-metrics\" ng-show=\"metricsType == \'responseType\'\">\r\n            <div class=\"col-md-12\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"responses\">Responses</h3>\r\n              <div id=\"responseType-chart\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n            <div class=\"col-md-4\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"successful-responses\">Successful Responses</h3>\r\n              <div id=\"responseType-chart-success\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeSuccessChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeSuccessChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n            <div class=\"col-md-4\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"failed-responses\">Failed Responses</h3>\r\n              <div id=\"responseType-chart-failed\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeFailedChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeFailedChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n            <div class=\"col-md-4\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"error-responses\">Error Responses</h3>\r\n              <div id=\"responseType-chart-error\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeErrorChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"responseTypeErrorChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n          </div>\r\n\r\n          \r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-overview.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiOverviewController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\">\r\n          <!-- Content Summary -->\r\n          <div class=\"col-md-12\">\r\n            <h1 apiman-i18n-key=\"api-details\">API Details</h1>\r\n            <p apiman-i18n-key=\"api-overview.api-description\">\r\n              This is the API details page.  Use this page to modify the meta-data, plans, and \r\n              policies for the API.  There is no need to follow the tabs in order, but note that\r\n              you will need to fill out a minimum amount of data before the API can be published\r\n              to the Gateway.  In particular, the Implementation and Plans tabs are important (more\r\n              information below).\r\n            </p>\r\n            \r\n            <h2 apiman-i18n-key=\"impl\">Implementation</h2>\r\n            <p apiman-i18n-key=\"api-overview.impl-description\">\r\n              The \'Implementation\' tab is where you go to configure the details of the real API\r\n              being managed.  This is where you tell apiman where the API is, so that we can \r\n              actually invoke it at runtime.\r\n            </p>\r\n            \r\n            <h2 apiman-i18n-key=\"definition\">Definition</h2>\r\n            <p apiman-i18n-key=\"api-overview.definition-description\">\r\n              The \'Definition\' tab allows you to configure an optional API Definition document\r\n              for your API.  A API Definition is a detailed description of the capabilities\r\n              of your API (operation names, http verbs, data models).  For example, you might\r\n              add a Swagger spec document as your API Definition.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"plans\">Plans</h2>\r\n            <p apiman-i18n-key=\"api-overview.plans-description\">\r\n              The \'Plans\' tab is used to configure which Plans (already defined in the Organization)\r\n              are available when a Client App wishes to create an API Contract with this \r\n              API.  Optionally, an API can also be marked as \"Public\", which means that no\r\n              API Contract is required (the API can be invoked without sending an API Key).\r\n            </p>\r\n            \r\n            <h2 apiman-i18n-key=\"policies\">Policies</h2>\r\n            <p apiman-i18n-key=\"api-overview.policies-description\">\r\n              The \'Policies\' tab is where you go if you wish to configure any policies that should\r\n              be enforced for *all* requests to the API, regardless of which user, Client App,\r\n              or Plan is being used.  In other words, API-level policies.\r\n            </p>\r\n            \r\n            <h2 apiman-i18n-key=\"contracts\">Contracts</h2>\r\n            <p apiman-i18n-key=\"api-overview.contracts-description\">\r\n              The \'Contracts\' tab will show a table of all Client Apps that have created API\r\n              Contracts to this API.  In other words, it shows all of the registered \r\n              consumers of the API.  Note that if the API is marked as \"Public\", this tab\r\n              will likely be empty.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"endpoint\">Endpoint</h2>\r\n            <p apiman-i18n-key=\"api-overview.endpoint-description\">\r\n              The \'Endpoint\' tab will show you information about how to invoke the API once\r\n              it is published to the API Gateway.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"activity\">Change Log</h2>\r\n            <p apiman-i18n-key=\"api-overview.activity-description\">\r\n              The \'Change Log\' tab shows a history of all the changes made to the API.  Essentially\r\n              it is an audit log.\r\n            </p>\r\n            \r\n          </div>\r\n          <!-- /Content Summary -->\r\n          \r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-plans.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\"\r\n          content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiPlansController\"\r\n         id=\"page-content\"\r\n         class=\"page container\"\r\n         data-field=\"page\"\r\n         ng-cloak=\"\"\r\n         ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content\">\r\n          <div class=\"col-md-10\">\r\n            <div class=\"title\"\r\n                 apiman-i18n-key=\"public-api\">Public API</div>\r\n            <div>\r\n              <span apiman-i18n-key=\"public-api-help\">Select this option if you wish this API to be accessible directly, without an API Contract.  Typically (but not always) this option is used instead of selecting plan(s).</span>\r\n            </div>\r\n            <div style=\"padding: 8px; margin-bottom: 10px\">\r\n              <input ng-model=\"updatedApi.publicAPI\"\r\n                     type=\"checkbox\"\r\n                     id=\"public-api\"\r\n                     ng-disabled=\"isEntityDisabled()\">\r\n              <label for=\"public-api\"\r\n                     apiman-i18n-key=\"make-api-public\"\r\n                     style=\"padding-left: 3px\">Make this API public</label>\r\n            </div>\r\n            <div class=\"title\"\r\n                 apiman-i18n-key=\"available-plans\">Available Plans</div>\r\n            <div>\r\n              <span apiman-i18n-key=\"available-plans-help\">Choose which plans should be presented when Client Apps create a link (Contract) to this API. Note that only plans in a \'Locked\' state show up in this list.</span>\r\n            </div>\r\n            <div class=\"apiman-divider-40\"\r\n                 ng-show=\"plans.length == 0\">\r\n              <div class=\"alert alert-warning\">\r\n                <span class=\"pficon pficon-info\"></span>\r\n                <span apiman-i18n-key=\"api-plans.no-locked-plans-found\">No locked plans were found in the Organization.  Please create and lock at least one plan before attempting to configure them here.  Or simply make your APIs \"public\" using the checkbox above!</span>\r\n              </div>            \r\n            </div>\r\n            <!-- The plans to choose from -->\r\n            <div class=\"apiman-plan-selector apiman-divider-40\">\r\n              <div class=\"container-fluid apiman-summaryrow\"\r\n                   ng-repeat=\"plan in plans\">\r\n                <div class=\"row\">\r\n                  <div class=\"col-sm-6\"\r\n                       style=\"padding: 4px 0;\">\r\n                    <input ng-model=\"plan.checked\"\r\n                           data-field=\"checkbox\"\r\n                           type=\"checkbox\"\r\n                           ng-disabled=\"isEntityDisabled()\">\r\n                  <span class=\"title\">\r\n                    <a href=\"{{ pluginName }}/orgs/{{ plan.organizationId }}/plans/{{ plan.id }}\" data-field=\"name\" title=\"{{ plan.description }}\">{{ plan.name }}</a>\r\n                  </span>\r\n                  </div>\r\n                  <div class=\"col-sm-6\"\r\n                       style=\"padding-right: 0;\">\r\n                    <ui-select ng-model=\"plan.selectedVersion\"\r\n                               on-select=\"changedVersion($item)\"\r\n                               ng-disabled=\"isEntityDisabled()\"\r\n                               class=\"pull-right\"\r\n                               style=\"width: 25%; max-width: 250px;\">\r\n                      <ui-select-match>\r\n                        <span ng-bind=\"$select.selected\"></span>\r\n                      </ui-select-match>\r\n                      <ui-select-choices repeat=\"version in (plan.lockedVersions | filter: $select.search)\">\r\n                        <span ng-bind=\"version\"></span>\r\n                      </ui-select-choices>\r\n                    </ui-select>\r\n                  </div>\r\n                </div>\r\n                <hr>\r\n              </div>\r\n            </div>\r\n            \r\n            <div apiman-permission=\"apiEdit\"\r\n                 ng-show=\"!isEntityDisabled()\"\r\n                 class=\"actions\">\r\n              <button ng-disabled=\"!isDirty\"\r\n                      apiman-action-btn=\"\"\r\n                      ng-click=\"saveApi()\"\r\n                      class=\"btn btn-primary\"\r\n                      data-field=\"saveButton\"\r\n                      apiman-i18n-key=\"save\"\r\n                      placeholder=\"Saving...\"\r\n                      data-icon=\"fa-cog\">Save</button>\r\n              <button ng-disabled=\"!isDirty\"\r\n                      class=\"btn btn-default\"\r\n                      ng-click=\"reset()\"\r\n                      data-field=\"cancelButton\"\r\n                      apiman-i18n-key=\"cancel\">Cancel</button>\r\n            </div>\r\n            \r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api-policies.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\"\r\n          content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiPoliciesController\"\r\n         class=\"page container\"\r\n         data-field=\"page\"\r\n         ng-cloak=\"\"\r\n         ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/api/api_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/api/api_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content\">\r\n          <div class=\"col-md-9\">\r\n            <!-- Title and help text -->\r\n            <div class=\"title\"\r\n                 apiman-i18n-key=\"api-policies\">API Policies</div>\r\n            <div class=\"description\"\r\n                 apiman-i18n-key=\"api-policies-help\">Here is a list of all Policies defined for this API.  These Policies will be applied to all invocations of this API by any Client App, regardless of the Plan used in its Contract.</div>\r\n            <hr />\r\n            <!-- The list of policies -->\r\n            <div apiman-permission=\"apiEdit\"\r\n                 ng-show=\"!isEntityDisabled()\"\r\n                 class=\"apiman-filters apiman-policies-filters\">\r\n              <a apiman-i18n-key=\"add-policy\"\r\n                 href=\"{{ pluginName }}/orgs/{{ org.id }}/apis/{{ api.id }}/{{ version.version }}/new-policy\" class=\"btn btn-primary pull-right\">Add Policy</a>\r\n            </div>\r\n            <div class=\"clearfix\"></div>\r\n            <div class=\"apiman-policies\"\r\n                 data-field=\"policies\">\r\n\r\n              <div class=\"apiman-no-content container-fluid\"\r\n                   ng-hide=\"policies.length > 0\">\r\n                <div class=\"row\">\r\n                  <div class=\"col-md-9\" ng-show=\"!isEntityDisabled()\">\r\n                    <p class=\"apiman-no-entities-description\"\r\n                       apiman-i18n-key=\"no-policies-for-api-enabled\">It looks like there aren\'t any policies defined! That may be exactly what you want (of course) but if not, you may try defining one using the Add Policy button above...</p>\r\n                  </div>\r\n                  <div class=\"col-md-9\" ng-show=\"isEntityDisabled()\">\r\n                    <p class=\"apiman-no-entities-description\"\r\n                       apiman-i18n-key=\"no-policies-for-api-disabled\">It looks like there aren\'t any policies defined and the API is already published!  Hopefully that was your goal with this API...</p>\r\n                  </div>\r\n                  <div apiman-permission=\"apiEdit\"\r\n                       ng-show=\"!isEntityDisabled()\"\r\n                       class=\"col-md-3\">\r\n                    <div class=\"apiman-no-entities-arrow\"></div>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <div class=\"clearfix\"></div>\r\n              <apiman-policy-list ng-model=\"policies\"\r\n                                  remove-function=\"removePolicy\"\r\n                                  reorder-function=\"reorderPolicies\"\r\n                                  type=\"apis\"\r\n                                  org-id=\"{{ org.id }}\"\r\n                                  page-id=\"{{ api.id }}\"\r\n                                  version=\"{{ version.version }}\"></apiman-policy-list>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/api.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ApiRedirectController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/api/import-apis.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.ImportApisController\" id=\"form-page\" class=\"container apiman-import-apis-wizard apiman-wizard page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\r\n            <li><a id=\"bc-home\" href=\"{{ pluginName }}/\"><i class=\"fa fa-home fa-fw\"></i><span apiman-i18n-key=\"home\">Home</span></a></li>\r\n            <li><a id=\"bc-apis\" href=\"{{ pluginName }}/orgs/{{ org.id }}/apis\"><i class=\"fa fa-shield fa-fw\"></i><span>{{ org.name }}</span></a></li>\r\n            <li class=\"active\"><span apiman-i18n-key=\"import-apis_\">Import API(s)</span></li>\r\n          </ol>\r\n        </div>\r\n      </div>\r\n      <div class=\"row\">\r\n        <!-- Wizard Items (left hand side) -->\r\n        <div class=\"col-md-3 apiman-wizard-items\">\r\n          <div class=\"container-fluid\">\r\n            <div class=\"row\">\r\n              <div class=\"col-md-12 apiman-header ng-binding\" apiman-i18n-key=\"import-apis_\">Import API(s)</div>\r\n            </div>\r\n            <div class=\"row\">\r\n              <hr>\r\n            </div>\r\n            <div class=\"row\">\r\n              <div class=\"apiman-wizard-item\" ng-class=\"{done: currentPageIdx > 0, active: currentPageIdx == 0}\">\r\n                <div class=\"step\">\r\n                  <i class=\"fa fa-fw\" ng-class=\"{\'fa-check-circle-o\': currentPageIdx > 0, \'fa-circle-o\': currentPageIdx == 0}\"></i>\r\n                  <span apiman-i18n-key=\"step-1\" class=\"apiman-label-faded\">Step 1</span>\r\n                </div>\r\n                <div class=\"step-title\">\r\n                  <span apiman-i18n-key=\"overview\">Overview</span>\r\n                </div>\r\n              </div>\r\n            </div>\r\n            <div class=\"row\">\r\n              <div class=\"apiman-wizard-item\" ng-class=\"{done: currentPageIdx > 1, active: currentPageIdx == 1}\">\r\n                <div class=\"step\">\r\n                  <i class=\"fa fa-fw\" ng-class=\"{\'fa-check-circle-o\': currentPageIdx > 1, \'fa-circle-o\': currentPageIdx <= 1}\"></i>\r\n                  <span apiman-i18n-key=\"step-2\" class=\"apiman-label-faded\">Step 2</span>\r\n                </div>\r\n                <div class=\"step-title\">\r\n                  <span apiman-i18n-key=\"find-apis\">Find APIs</span>\r\n                </div>\r\n              </div>\r\n            </div>\r\n            <div class=\"row\">\r\n              <div class=\"apiman-wizard-item\" ng-class=\"{done: currentPageIdx > 2, active: currentPageIdx == 2}\">\r\n                <div class=\"step\">\r\n                  <i class=\"fa fa-fw\" ng-class=\"{\'fa-check-circle-o\': currentPageIdx > 2, \'fa-circle-o\': currentPageIdx <= 2}\"></i>\r\n                  <span apiman-i18n-key=\"step-3\" class=\"apiman-label-faded\">Step 3</span>\r\n                </div>\r\n                <div class=\"step-title\">\r\n                  <span apiman-i18n-key=\"choose-plans\">Choose Plans</span>\r\n                </div>\r\n              </div>\r\n            </div>\r\n            <div class=\"row\">\r\n              <div class=\"apiman-wizard-item\" ng-class=\"{done: currentPageIdx > 3, active: currentPageIdx == 3}\">\r\n                <div class=\"step\">\r\n                  <i class=\"fa fa-fw\" ng-class=\"{\'fa-check-circle-o\': currentPageIdx > 3, \'fa-circle-o\': currentPageIdx <= 3}\"></i>\r\n                  <span apiman-i18n-key=\"step-4\" class=\"apiman-label-faded\">Step 4</span>\r\n                </div>\r\n                <div class=\"step-title\">\r\n                  <span apiman-i18n-key=\"import-apis\">Import APIs</span>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        \r\n        <div class=\"col-md-9 apiman-wizard-pages\">\r\n          <!-- Overview Page -->\r\n          <div class=\"apiman-wizard-page\" ng-show=\"currentPage == \'overview\'\">\r\n            <div class=\"col-md-12\">\r\n              <p apiman-i18n-key=\"import-apis.overview.overview\">\r\n                Welcome to the Import API(s) wizard.  Use this wizard to import APIs from external\r\n                sources.  This is typically much faster than entering all of the API details by hand.\r\n                Depending on the configuration of apiman (and the source or sources used when searching for\r\n                APIs to import), more or less information may be included for each API during the \r\n                import process.\r\n              </p>\r\n\r\n              <h3 apiman-i18n-key=\"find-apis\">Find APIs</h3>\r\n              <p apiman-i18n-key=\"import-apis.overview.find-apis\">\r\n                The first step in the wizard is to search for and find the APIs you wish to \r\n                import.  The location of this data is dependent on how apiman is configured, but\r\n                in most cases you will be searching against some sort of registry of real, deployed\r\n                APIs.\r\n              </p>\r\n\r\n              <h3 apiman-i18n-key=\"choose-plans\">Choose Plans</h3>\r\n              <p apiman-i18n-key=\"import-apis.overview.choose-plans\">\r\n                Once you have searched for and located the API or APIs you wish to import, the\r\n                next step is to choose whether these APIs should be \"public\" or should be offered\r\n                through one or more of the Plans defined by the Organization.\r\n              </p>\r\n\r\n              <h3 apiman-i18n-key=\"import-apis\">Import APIs</h3>\r\n              <p apiman-i18n-key=\"import-apis.overview.import-apis\">\r\n                Finally, you will be shown a list of the choices you made so that you can confirm that\r\n                you really do want to import the APIs.  Once you click \"Import\" on this last step,\r\n                each of the APIs you chose will be added to the Organization.  Success or failure\r\n                of each API import will be shown as it happens.\r\n              </p>\r\n            </div>\r\n          </div>\r\n\r\n          <!-- Find APIs Page -->\r\n          <div class=\"apiman-wizard-page\" ng-show=\"currentPage == \'find-apis\'\">\r\n            <div class=\"col-md-12\">\r\n              <h1 apiman-i18n-key=\"find-apis\">Find APIs</h1>\r\n              <div>\r\n                <form class=\"form-horizontal\" style=\"margin-top: 10px\">\r\n                  <div class=\"form-group\">\r\n                    <label class=\"col-sm-2 control-label\" for=\"textInput-markup\" apiman-i18n-key=\"import-from_\">Import From:</label>\r\n                    <div class=\"col-sm-10\">\r\n                      <select id=\"import-from\" ng-model=\"importFrom\" apiman-select-picker=\"\" class=\"selectpicker\" data-live-search=\"false\">\r\n                        <option value=\"{{ importSource.id }}\" ng-disabled=\"importSource.disabled\" ng-repeat=\"importSource in importSources | orderBy : \'name.toLowerCase()\'\" data-content=\"<i class=\'fa fa-inline fa-fw fa-{{ importSource.icon }}\'></i> <span>{{ importSource.name }}</span>\">{{ importSource.name }}</option>\r\n                      </select>\r\n                    </div>\r\n                  </div>\r\n                </form>\r\n              </div>\r\n              <div ng-show=\"importFrom == \'api-catalog\'\">\r\n                <div class=\"apiman-wizard-search-box\">\r\n                  <form ng-submit=\"searchApiCatalog(searchText)\">\r\n                    <input ng-disabled=\"searchDisabled\" apiman-i18n-key=\"search-api-name\" ng-model=\"searchText\" type=\"text\" class=\"apiman-form-control form-control input-search\" placeholder=\"Search by API name...\">\r\n                    <button type=\"submit\" apiman-action-btn=\"\" class=\"btn btn-default btn-search\" data-field=\"searchButton\" apiman-i18n-key=\"search\" data-icon=\"fa-cog\" placeholder=\"Searching\">Search</button>\r\n                  </form>\r\n                </div>\r\n                <div class=\"apiman-wizard-search-results\">\r\n                  <div class=\"alert alert-info\" ng-show=\"apis.length == 0\">\r\n                    <span class=\"pficon pficon-info\"></span>\r\n                    <span apiman-i18n-key=\"import-apis.no-matching-apis-found\">No matching APIs found - use the search box above to search for APIs by name.</span>\r\n                  </div>\r\n                  <div class=\"apiman-wizard-table-wrapper\" ng-show=\"apis.length > 0\">\r\n                    <table class=\"table table-striped table-bordered\">\r\n                      <thead>\r\n                        <tr>\r\n                          <th apiman-i18n-key=\"api\">API</th>\r\n                          <th apiman-i18n-key=\"description\">Description</th>\r\n                          <th apiman-i18n-key=\"actions\">Actions</th>\r\n                        </tr>\r\n                      </thead>\r\n                      <tbody>\r\n                        <tr ng-repeat=\"api in apis | orderBy:\'name\'\">\r\n                          <td>{{ api.name }}</td>\r\n                          <td>{{ api.description }}</td>\r\n                          <td><a ng-hide=\"isApiSelected(api)\" href=\"#\" ng-click=\"addApi(api)\" apiman-i18n-key=\"add\">Add</a></td>\r\n                        </tr>\r\n                      </tbody>\r\n					</table>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <h1 apiman-i18n-key=\"selected-apis\" style=\"margin-top: 40px\">Selected APIs</h1>\r\n              <div ng-show=\"importInfo.apis.length == 0\">\r\n                <div class=\"alert alert-info\">\r\n                  <span class=\"pficon pficon-info\"></span>\r\n                  <span apiman-i18n-key=\"import-apis.no-apis-selected\">No APIs have been selected, please search for APIs above and then select at least one for import.</span>\r\n                </div>\r\n              </div>\r\n              <div ng-show=\"importInfo.apis.length > 0\">\r\n                <div class=\"apiman-wizard-table-wrapper\">\r\n                  <table class=\"table table-striped table-bordered\">\r\n                    <thead>\r\n                      <tr>\r\n                        <th apiman-i18n-key=\"api\">API</th>\r\n                        <th apiman-i18n-key=\"description\">Description</th>\r\n                        <th apiman-i18n-key=\"actions\">Actions</th>\r\n                      </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                      <tr ng-repeat=\"api in importInfo.apis | orderBy:\'name\'\">\r\n                        <td>{{ api.name }}</td>\r\n                        <td>{{ api.description }}</td>\r\n                        <td><a href=\"#\" ng-click=\"removeApi(api)\" apiman-i18n-key=\"remove\">Remove</a></td>\r\n                      </tr>\r\n                    </tbody>\r\n                  </table>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n\r\n          <!-- Choose Plans Page -->\r\n          <div class=\"apiman-wizard-page\" ng-show=\"currentPage == \'choose-plans\'\">\r\n            <div class=\"col-md-12\">\r\n              <h1 apiman-i18n-key=\"choose-plans\">Choose Plans</h1>\r\n              <h3 apiman-i18n-key=\"import-apis.public-apis\">Public API(s)</h3>\r\n              <div>\r\n                <span class=\"apiman-label-faded\" apiman-i18n-key=\"import-apis.public-api-help\">Select this option if you wish the imported APIs to be accessible directly, without using API Contracts.  Typically (but not always) this option is used instead of selecting Plan(s).</span>\r\n              </div>\r\n              <div style=\"padding: 8px; margin-bottom: 10px\">\r\n                <input ng-model=\"importInfo.isPublic\" type=\"checkbox\" id=\"public-apis\">\r\n                <label for=\"public-apis\" apiman-i18n-key=\"import-apis.make-apis-public\" style=\"padding-left: 3px\">Make imported API(s) public</label>\r\n              </div>\r\n              <h3 apiman-i18n-key=\"available-plans\">Available Plans</h3>\r\n              <div>\r\n                <span apiman-i18n-key=\"available-plans-help\">Choose which plans should be presented when Client Apps create a link (Contract) to this API. Note that only plans in a \'Locked\' state show up in this list.</span>\r\n              </div>\r\n              <div class=\"apiman-divider-40\" ng-show=\"plans.length == 0\">\r\n                <div class=\"alert alert-warning\">\r\n                  <span class=\"pficon pficon-info\"></span>\r\n                  <span apiman-i18n-key=\"import-apis.no-locked-plans-found\">No locked plans were found in the Organization.  Please create and lock at least one plan before attempting to configure them here.  Or simply make your APIs \"public\" using the checkbox above!</span>\r\n                </div>\r\n              </div>\r\n              <!-- The plans to choose from -->\r\n              <div class=\"apiman-plan-selector apiman-divider-40\">\r\n                <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"plan in plans\">\r\n                  <div class=\"row\">\r\n                    <input ng-model=\"plan.checked\" data-field=\"checkbox\" type=\"checkbox\">\r\n                    <span class=\"title\">{{ plan.name }}</span>\r\n                    <select apiman-select-picker=\"\" ng-model=\"plan.selectedVersion\" ng-options=\"version for version in plan.lockedVersions\" class=\"selectpicker pull-right\">\r\n                    </select>\r\n                  </div>\r\n                  <hr>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n\r\n          <!-- Import APIs Page -->\r\n          <div class=\"apiman-wizard-page\" ng-show=\"currentPage == \'import-apis\'\">\r\n            <div class=\"col-md-12\">\r\n              <h1 apiman-i18n-key=\"confirm-import\">Confirm Import</h1>\r\n              <div>\r\n                <p apiman-i18n-key=\"confirm-import.explanation\">Please verify that the APIs listed below really are the ones you would like to import.  Once you are satisfied, click Import!</p>\r\n              </div>\r\n              <h2 apiman-i18n-key=\"apis-to-import\">APIs To Import</h2>\r\n              <div class=\"apiman-wizard-table-wrapper apiman-import-wizard-apis\">\r\n                <table class=\"table table-striped table-bordered\">\r\n                  <thead>\r\n                    <tr>\r\n                      <th></th>\r\n                      <th apiman-i18n-key=\"api\">API</th>\r\n                      <th apiman-i18n-key=\"description\">Description</th>\r\n                    </tr>\r\n                  </thead>\r\n                  <tbody>\r\n                    <tr ng-repeat=\"api in importInfo.apis | orderBy:\'name\'\" ng-class=\"{\'complete\': api.status == \'imported\', \'pending\': !api.status, \'active\': api.status == \'importing\', \'error\': api.status == \'error\'}\">\r\n                      <td width=\"1%\"><i class=\"fa fa-fw\" ng-class=\"{\'fa-check-circle-o\': api.status == \'imported\', \'fa-circle-o\': !api.status, \'fa-dot-circle-o\': api.status == \'importing\', \'fa-warning\': api.status == \'error\'}\"></i></td>\r\n                      <td>{{ api.name }}</td>\r\n                      <td>{{ api.description }}</td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </div>\r\n            </div>\r\n          </div>\r\n\r\n          <!-- The Wizard Buttons -->\r\n          <div class=\"pull-right apiman-wizard-buttons\">\r\n            <hr />\r\n            <button ng-disabled=\"disableBackButton || currentPage == \'overview\'\" id=\"back\" class=\"btn btn-default\" ng-click=\"prevPage()\"><span class=\"i fa fa-angle-left\"></span><span apiman-i18n-key=\"back\">Back</span></button>\r\n            <button ng-disabled=\"currentPage == \'import-apis\' || !currentPageValid\" id=\"next\" class=\"btn btn-default\" ng-click=\"nextPage()\"><span apiman-i18n-key=\"next\">Next</span><span class=\"i fa fa-angle-right\"></span></button>\r\n            <button ng-hide=\"hideImportButton\" ng-disabled=\"currentPage != \'import-apis\' || !currentPageValid\" id=\"import\" class=\"btn btn-primary\" apiman-action-btn=\"\" data-field=\"importButton\" apiman-i18n-key=\"import\" ng-click=\"doImport()\" data-icon=\"fa-cog\" placeholder=\"Importing\">Import</button>\r\n            <a ng-show=\"showFinishButton\" id=\"finish\" href=\"{{ pluginName }}/orgs/{{ params.org }}/apis\" class=\"btn btn-primary\" apiman-i18n-key=\"finish\">Finish</a>\r\n            <a ng-disabled=\"disableCancelButton\" id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n          </div>\r\n\r\n        </div>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/catalog/api-catalog-def.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.ApiCatalogDefController\" class=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n    \r\n      <div class=\"container\">\r\n        <div class=\"row\">\r\n          <div class=\"col-md-12\">\r\n            <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\r\n              <li><a id=\"bc-home\" href=\"{{ pluginName }}/\"><i class=\"fa fa-home fa-fw\"></i><span apiman-i18n-key=\"home\">Home</span></a></li>\r\n              <li><a id=\"bc-catalog\" href=\"{{ pluginName }}/catalog/api-catalog\"><i class=\"fa fa-book fa-fw\"></i><span apiman-i18n-key=\"api-catalog\">API Catalog</span></a></li>\r\n              <li class=\"active\"><i class=\"fa fa-sitemap fa-fw\"></i><span apiman-i18n-key=\"definition\">Definition</span></li>\r\n            </ol>\r\n          </div>\r\n        </div>\r\n        <div class=\"row\">\r\n          <div class=\"col-md-12\">\r\n            <h1 class=\"consumer-top-header\">\r\n              <span apiman-i18n-key=\"api-definition\">API Definition</span>\r\n              <a target=\"_blank\" class=\"pull-right\" id=\"download\" href=\"{{ api.definitionUrl }}/\"><i class=\"fa fa-download fa-fw\"></i><span apiman-i18n-key=\"download\">Download</span></a>\r\n            </h1>\r\n            <hr />\r\n          </div>\r\n        </div>\r\n        \r\n        <div class=\"row\" ng-show=\"hasError\">\r\n          <div class=\"col-md-12\">\r\n            <div class=\"alert alert-danger\" style=\"margin-top: 15px\">\r\n               <span class=\"pficon pficon-info\"></span>\r\n               <span apiman-i18n-key=\"consumer-api-def.error-loading-definition\">An error occured while loading the API definition file.  Please try again later.</span>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        \r\n        <div class=\"row\" ng-hide=\"hasDefinition\">\r\n          <div class=\"col-md-12\">\r\n            <div class=\"alert alert-warning\" style=\"margin-top: 15px\">\r\n               <span class=\"pficon pficon-info\"></span>\r\n               <span apiman-i18n-key=\"consumer-api-def.no-api-definition\">This API does not have an API definition file.  Contact the API provider and ask them to supply a valid API definition!</span>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        \r\n        <div class=\"row\" ng-show=\"definitionStatus == \'loading\'\">\r\n          <div class=\"col-md-12\">\r\n            <div style=\"margin-top: 15px; padding: 20px\" class=\"alert alert-info\">\r\n              <div style=\"float:left; margin-right: 6px\" class=\"spinner spinner-sm\"></div>\r\n              <span apiman-i18n-key=\"loading-api-def\">Loading API Definition, please wait...</span>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        \r\n        <div id=\"apiman-swagger\" class=\"row swagger-section\" ng-show=\"hasDefinition\">\r\n          <div class=\"col-md-12\">\r\n            <div id=\"swagger-ui-container\" class=\"swagger-ui-wrap\" />\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/catalog/api-catalog.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.ApiCatalogController\" class=\"page container\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <div class=\"col-md-12\">\n          <ol class=\"breadcrumb\">\n            <li><a id=\"bc-home\" href=\"{{ pluginName }}/\"><i class=\"fa fa-home fa-fw\"></i><span apiman-i18n-key=\"home\">Home</span></a></li>\n            <li class=\"active\"><i class=\"fa fa-book fa-fw\"></i><span apiman-i18n-key=\"api-catalog\">API Catalog</span></li>\n          </ol>\n        </div>\n      </div>\n      <div class=\"row\">\n        \n        <!-- Catalog Content -->\n        <div class=\"col-md-12\">\n          <div class=\"container-fluid\">\n            <div class=\"row\">\n              <h2 class=\"title\" apiman-i18n-key=\"catalog\">API Catalog</h2>\n            </div>\n            <!-- Helpful hint -->\n            <div class=\"row\">\n              <p class=\"col-md-10 apiman-label-faded\" apiman-i18n-key=\"catalog-help-text\" class=\"apiman-label-faded\">List of APIs available to be imported.  These APIs were retrieved from the configured API Catalog.</p>\n            </div>\n            <!-- HR -->\n            <div class=\"row\">\n              <hr/>\n            </div>\n\n            <!-- Filter and Actions -->\n            <div class=\"row\"\n                 id=\"api-catalog-filters\">\n              <!-- Filter: Search -->\n              <span>\n                <apiman-search-box id=\"apis-filter\"\n                                   apiman-i18n-key=\"filter-catalog-apis\"\n                                   function=\"filterApis\"\n                                   style=\"height: 28px;\"\n                                   placeholder=\"Filter by API name...\" />\n              </span>\n\n              <!-- Filter: Tags -->\n              <ui-select multiple\n              			 id=\"apiman-tags-filter\"\n                         tagging\n                         tagging-label=\"(press enter)\"\n                         ng-model=\"selected.tags\"\n                         theme=\"bootstrap\"\n                         sortable=\"true\"\n                         class=\"selectpicker api-catalog-filters\"\n                         style=\"width: 250px; margin: 0 10px; box-shadow: none; font-size: small; border-color: #bababa; display: inline-table;\"\n                         apiman-i18n-key=\"choose-a-tag\"\n                         title=\"Choose a tag\">\n                <span apiman-i18n-key=\"filter-by-tags\"></span>\n                <ui-select-match placeholder=\"Filter by tags...\">{{$item}}</ui-select-match>\n                <ui-select-choices repeat=\"tag in tags | filter:$select.search | orderBy: tag\">\n                  {{tag}}\n                </ui-select-choices>\n              </ui-select>\n              <button ng-show=\"selected.tags.length > 0\" class=\"btn btn-default\"\n                      style=\"box-shadow: none; height: 29px; margin: -2px 10px 0 -14px; border-left: none;\"\n                      ng-click=\"clear()\"><i class=\"fa fa-fw fa-close\"></i></button>\n\n              <!-- Filter: API Type -->\n              <select ng-model=\"epType\"\n                      apiman-select-picker=\"\"\n                      class=\"selectpicker api-type\"\n                      data-style=\"btn-default\">\n                <option value=\"\" apiman-i18n-key=\"show-all-api-types\">Show All API Types</option>\n                <option value=\"rest\" apiman-i18n-key=\"show-only-rest\">Show REST only</option>\n                <option value=\"soap\" apiman-i18n-key=\"show-only-soap\">Show SOAP only</option>\n              </select>\n\n              <!-- Filter: Internal APIs -->\n              <span ng-show=\"hasInternalApis\"\n                    style=\"margin-left: 8px; height: 28px;\">\n                <input id=\"hide-internal\" type=\"checkbox\" ng-model=\"hideInternal\">\n                <label for=\"hide-internal\"\n                       apiman-i18n-key=\"hide-internal-apis\"\n                       style=\"padding-left: 3px\">Hide internal APIs</label>\n              </span>\n\n              <!-- Filter: Namespace -->\n              <span ng-show=\"namespaces.length > 0\">\n                <select\n                      class=\"selectpicker api-namespaces\"\n                      id=\"namespace\"\n                      apiman-select-picker=\"\"\n                      ng-model=\"namespace\"\n                      ng-change=\"selectNamespace( namespace )\"\n                      title=\"\"\n                      data-live-search=\"true\"\n                      apiman-i18n-skip\n                      data-ng-options=\"ns.name for ns in namespaces | orderBy: ns.name\">\n                </select>\n              </span>\n\n            </div>\n\n\n            <!-- Table of APIs -->\n            <div class=\"row apiman-card-table\">\n              <div class=\"container-fluid cards\">\n                <div ng-repeat=\"api in filteredApis=(apis | filter: criteria | filter: {endpointType: epType} | selectedTags: selected.tags  | filter:hideInternal:isInternal | orderBy: \'name\':reverse)\" class=\"card\">\n                  <a ng-show=\"api.description\" uib-tooltip=\"{{ api.description }}\" tooltip-trigger=\"mouseenter\" tooltip-placement=\"top\" href=\"#\" class=\"info\"><i class=\"fa fa-info-circle\"></i></a>\n                  <a ng-show=\"api.endpointType\" uib-tooltip=\"Endpoint&nbsp;Type:&nbsp;{{ api.endpointType }}\" tooltip-trigger=\"mouseenter\" tooltip-placement=\"top\" href=\"{{ api.definitionUrl }}\" class=\"endpointType\" target=\"_blank\"><i class=\"fa {{ api.ticon }}\"></i></a>\n                  <div class=\"icon\">\n                    <i ng-show=\"!api.iconIsUrl\" class=\"fa fa-{{ api.icon }}\"></i>\n                    <img ng-show=\"api.iconIsUrl\" src=\"{{ api.icon }}\"></img>\n                  </div>\n                  <div class=\"name\"><a href=\"{{ apiEndpoint(api) }}\"><span>{{ api.name}}</span></a></div>\n                  <div class=\"tags\" ng-show=\"api.tags\">\n                    <i class=\"fa fa-fw fa-tags\"></i>\n                    <ul>\n                      <li ng-repeat=\"tag in api.tags | orderBy:tag\"><a class=\"tagLink\" title=\"{{tagTitle(tag)}}\" ng-click=\"addTag(tag)\">{{ tagLabel(tag) }}</a></li>\n                    </ul>\n                  </div>\n                  <div><hr /></div>\n                  <div class=\"actions\"> \n                     <span class=\"apiman-action-divider\" apiman-i18n-skip=\"\">&nbsp;</span>\n                     <a href=\"#\" ng-click=\"importApi(api)\"><i class=\"fa fa-cart-arrow-down\"></i><span style=\"margin-left: 5px\" apiman-i18n-key=\"import\">Import</span></a>\n                     <span ng-show=\"api.definitionType == \'SwaggerJSON\' || api.definitionType == \'SwaggerYAML\' || api.definitionType == \'External\'\"\n                           class=\"apiman-action-divider\" apiman-i18n-skip=\"\">|</span>\n                     <a ng-show=\"api.definitionType == \'SwaggerJSON\'\" href=\"{{ pluginName }}/catalog/api-catalog/{{ api.name | urlEncode }}/def\" target=\"{{api.definitionType == \'External\' ? \'_blank\' : \'\'}}\"><i class=\"fa fa-sitemap\"></i><span style=\"margin-left: 5px\" apiman-i18n-key=\"definition\">Definition</span></a>\n                     <a ng-show=\"api.definitionType == \'SwaggerYAML\'\" href=\"{{ pluginName }}/catalog/api-catalog/{{ api.name | urlEncode }}/def\" target=\"{{api.definitionType == \'External\' ? \'_blank\' : \'\'}}\"><i class=\"fa fa-sitemap\"></i><span style=\"margin-left: 5px\" apiman-i18n-key=\"definition\">Definition</span></a>\n                     <a ng-show=\"api.definitionType == \'External\'\" href=\"{{ api.definitionUrl }}\" target=\"_blank\"><i class=\"fa fa-external-link\"></i><span style=\"margin-left: 5px\" apiman-i18n-key=\"definition\">Definition</span></a>\n                  </div>\n                </div>\n              </div>\n              <div class=\"alert alert-info\" ng-show=\"filteredApis.length == 0\">\n                <span class=\"pficon pficon-info\"></span>\n                <strong apiman-i18n-key=\"no-apis-warning.summary\">No APIs found.</strong>\n                <p apiman-i18n-key=\"no-apis-warning.detail\">\n                  No APIs matching the above filter criteria were found in the API catalog.  Perhaps try changing your filter(s)?\n                </p>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n      \n      <script type=\"text/ng-template\" id=\"importApiModal.html\">\n        <div class=\"modal-header\">\n            <h3 class=\"modal-title\">\n              <span apiman-i18n-key=\"import-api\">Import API</span>\n            </h3>\n        </div>\n        <div class=\"modal-body\">\n            <div class=\"apiman-entity-new\">\n\n\n      <!-- Choose org and api name -->\n      <div ng-show=\"orgs.length > 0\">\n        <div class=\"row\">\n          <dl class=\"org\">\n            <dt apiman-i18n-key=\"organization\">Organization</dt>\n            <dd>\n              <div class=\"btn-group\">\n                <button type=\"button\" id=\"selector-org\" class=\"btn btn-default dropdown-toggle\" data-toggle=\"dropdown\">\n                  <span id=\"selector-org-value\">{{selectedOrg.name}}</span> &nbsp;&nbsp;<span class=\"caret\"></span>\n                </button>\n                <ul class=\"dropdown-menu\">\n                   <li ng-repeat=\"org in orgs\"><a href=\"#\" ng-click=\"setOrg( org )\">{{ org.name }}</a></li>\n                </ul>\n              </div>\n            </dd>\n          </dl>\n          <dl class=\"slash\">\n            <dt apiman-i18n-skip>&nbsp;</dt>\n            <dd>\n              <span class=\"divider\" apiman-i18n-skip>/</span>\n            </dd>\n          </dl>\n          <dl class=\"name\">\n            <dt apiman-i18n-key=\"api-name\">API Name</dt>\n            <dd>\n              <input ng-model=\"api.name\" type=\"text\" class=\"apiman-form-control form-control entityname\" id=\"apiman-entityname\" apiman-i18n-key=\"enter-api-name\" placeholder=\"Enter API name...\"></input>\n            </dd>\n          </dl>\n        </div>\n        <!-- Initial API Version -->\n        <div class=\"row\">\n          <dl>\n            <dt apiman-i18n-key=\"initial-version\">Initial Version</dt>\n            <dd>\n              <input ng-model=\"api.initialVersion\" type=\"text\" class=\"apiman-form-control form-control version\" id=\"apiman-version\" value=\"1.0\"></input>\n            </dd>\n          </dl>\n        </div>\n        <!-- Description of api -->\n        <div class=\"row\">\n          <dl style=\"width: 100%\">\n            <dt apiman-i18n-key=\"description\">Description</dt>\n            <dd>\n              <textarea style=\"width: 90%\" ng-model=\"api.description\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-api-description\" placeholder=\"Enter API description (optional)...\"></textarea>\n            </dd>\n          </dl>\n        </div>\n      </div>\n      <div ng-hide=\"orgs.length > 0\" class=\"apiman-no-content container-fluid\">\n        <div class=\"row\">\n          <div class=\"col-md-12\">\n            <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"missing-create-api-permission\">You don\'t have permission to create an API in any of your Organizations (or you aren\'t in any organizations)!  Please become a member of an existing Organization or create a new one before trying to create an API.</p>\n          </div>\n        </div>\n      </div>\n\n\n\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"btn btn-primary\" ng-disabled=\"!api.name || !api.initialVersion || !selectedOrg\" data-field=\"importButton\" type=\"button\" apiman-action-btn=\"\" ng-click=\"import()\" apiman-i18n-key=\"import\" placeholder=\"Importing...\" data-icon=\"fa-cog\">Import</button>\n            <button class=\"btn btn-default btn-cancel\" type=\"button\" ng-click=\"cancel()\">Cancel</button>\n        </div>\n      </script>\n      \n    </div>\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/client/client-activity.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    \n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.ClientActivityController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/client/client_bc.include\'\"></div>\n      <!-- Entity Summary Row -->\n      <div ng-include=\"\'plugins/api-manager/html/client/client_entity.include\'\"></div>\n\n      <!-- Navigation + Content Row -->\n      <div class=\"row\">\n        <!-- Left hand nav -->\n        <div ng-include=\"\'plugins/api-manager/html/client/client_tabs.include\'\"></div>\n        <!-- /Left hand nav -->\n\n        <!-- Content -->\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\">\n          <!-- Title and help text -->\n          <div class=\"title\" apiman-i18n-key=\"client-activity\">Client App Change Log</div>\n          <div class=\"description\" apiman-i18n-key=\"client-activity-help\">The list below is all of the configuration changes (made by apiman users) associated with this Client App.</div>\n          <hr />\n          <apiman-activity model=\"auditEntries\" next=\"getNextPage\"/>\n        </div>\n        <!-- /Content -->\n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/client/client-apis.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ClientApisController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/client/client_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\">\r\n          <div class=\"col-md-11\">\r\n            <!-- Title and help text -->\r\n            <div class=\"title\" apiman-i18n-key=\"client-client-apis\">Client App APIs</div>\r\n            <div class=\"description\" apiman-i18n-key=\"apis-help\">Below is a list of all the APIs this Client App consumes.  This information is derived from the set of API Contracts the Client App has entered into.  Manage these Contracts by switching to the \"Contracts\" tab.</div>\r\n            <hr />\r\n            <!-- The list of apis (filterable) -->\r\n            <div>\r\n              <div class=\"clearfix\"></div>\r\n              <div class=\"actions\">\r\n                <button ng-click=\"doExportAsJson()\" apiman-action-btn=\"\" data-field=\"exportAsJsonButton\" class=\"btn btn-default\" apiman-i18n-key=\"download-as-json\" placeholder=\"Downloading...\" data-icon=\"fa-cog\">Download as JSON</button>\r\n                <button ng-click=\"doExportAsXml()\" apiman-action-btn=\"\" data-field=\"exportAsXmlButton\" class=\"btn btn-default\" apiman-i18n-key=\"download-as-xml\" placeholder=\"Downloading...\" data-icon=\"fa-cog\">Download as XML</button>\r\n              </div>\r\n              <div class=\"clearfix\"></div>\r\n              <!-- The list of apis -->\r\n              <div class=\"table-responsive\">\r\n                <table class=\"table table-striped table-bordered table-hover table-with-details\" data-field=\"apis\">\r\n                  <thead>\r\n                    <tr>\r\n                      <th apiman-i18n-key=\"api\" nowrap=\"nowrap\">API</th>\r\n                      <th apiman-i18n-key=\"version\" width=\"1%\" nowrap=\"nowrap\">Version</th>\r\n                      <th apiman-i18n-key=\"plan\" nowrap=\"nowrap\">Plan</th>\r\n                      <th nowrap=\"nowrap\" width=\"1%\"></th>\r\n                    </tr>\r\n                  </thead>\r\n                  <tbody>\r\n                    <tr ng-repeat-start=\"api in apiRegistry.apis\">\r\n                      <td>\r\n                        <span><a href=\"{{ pluginName }}/browse/orgs/{{ api.apiOrgId }}\">{{ api.apiOrgName }}</a>\r\n                        <span apiman-i18n-skip>/</span>\r\n                        <a href=\"{{ pluginName }}/browse/orgs/{{ api.apiOrgId }}/{{ api.apiId }}/{{ api.apiVersion }}\"><span class=\"emphasis\">{{ api.apiName }}</span></a></span>\r\n                      </td>\r\n                      <td><span>{{ api.apiVersion }}</span></td>\r\n                      <td>{{ api.planName }}</td>\r\n                      <td><a title=\"How do I invoke this API?\" apiman-i18n-key=\"client-apis.howtoinvoke\" ng-click=\"howToInvoke(apiRegistry.apiKey, api)\" href=\"javascript:;\"><span class=\"pficon pficon-info\"></span></a></td>\r\n                    </tr>\r\n                    <tr ng-repeat-end ng-show=\"api.expanded\">\r\n                      <td colspan=\"4\">\r\n                        <form role=\"form\">\r\n                          <div class=\"form-group\">\r\n                            <div>\r\n                              <script type=\"text/ng-template\"\r\n                                      id=\"invokeModal.html\">\r\n                                <div class=\"modal-header\">\r\n                                  <button class=\"close\"\r\n                                          type=\"button\"\r\n                                          ng-click=\"ok()\">\r\n                                    <span class=\"pficon pficon-close\"></span>\r\n                                  </button>\r\n                                  <h3 class=\"modal-title\"\r\n                                      id=\"apiCopyModalLabel\">\r\n                                    <span apiman-i18n-key=\"modal-title\">Copy API Endpoint</span>\r\n                                  </h3>\r\n                                </div>\r\n                                <div class=\"modal-body\">\r\n                                  <p class=\"explanation\"\r\n                                     apiman-i18n-key=\"api-dialog-explanation\">\r\n                                    To successfully invoke the managed API for this API contract, you must provide the appropriate API Key with each request. The API Key can be provided either by sending it as an HTTP Request Header named X-API-Key, or you can send it as a URL query parameter.\r\n                                  </p>\r\n                                  <hr style=\"margin-left: -25px; margin-right: -25px\">\r\n                                  <div class=\"apiman-form-label\"\r\n                                       apiman-i18n-key=\"as-query-param\">As Query Parameter</div>\r\n                                  <div class=\"input-group\"\r\n                                       style=\"width:100%\">\r\n                                    <input readonly\r\n                                           type=\"text\"\r\n                                           class=\"apiman-form-control form-control readonly apiman-readonly\"\r\n                                           style=\"background-color: white; color: black;\"\r\n                                           value=\"{{ asQueryParam }}\">\r\n                                    <span class=\"input-group-btn\">\r\n                                      <button clipboard\r\n                                              class=\"btn btn-default clipboard\"\r\n                                              type=\"button\"\r\n                                              text=\"asQueryParam\"\r\n                                              on-copied=\"copySuccess()\"\r\n                                              on-error=\"copyFail(err)\"\r\n                                              ng-mouseleave=\"tooltipReset()\"\r\n                                              ng-click=\"tooltipChange()\"\r\n                                              uib-tooltip=\"{{ tooltipTxt }}\">\r\n                                        <span apiman-i18n-key=\"copy\"\r\n                                              class=\"glyphicon glyphicon-copy\"></span>\r\n                                      </button>\r\n                                    </span>\r\n                                  </div>\r\n                                  <p apiman-i18n-skip>&nbsp;</p>\r\n                                  <div class=\"apiman-form-label\"\r\n                                       apiman-i18n-key=\"as-request-header\">As HTTP Request Header</div>\r\n                                  <div class=\"input-group\"\r\n                                       style=\"width:100%\">\r\n                                    <input readonly\r\n                                           type=\"text\"\r\n                                           class=\"apiman-form-control form-control readonly apiman-readonly\"\r\n                                           style=\"background-color: white; color: black;\"\r\n                                           value=\"{{ asRequestHeader }}\">\r\n                                      <span class=\"input-group-btn\">\r\n                                        <button clipboard\r\n                                                class=\"btn btn-default clipboard\"\r\n                                                type=\"button\"\r\n                                                text=\"asRequestHeader\"\r\n                                                on-copied=\"copySuccess()\"\r\n                                                on-error=\"copyFail(err)\"\r\n                                                ng-mouseleave=\"tooltipReset()\"\r\n                                                ng-click=\"tooltipChange()\"\r\n                                                uib-tooltip=\"{{ tooltipTxt }}\">\r\n                                          <span apiman-i18n-key=\"copy\"\r\n                                                class=\"glyphicon glyphicon-copy\"></span>\r\n                                        </button>\r\n                                      </span>\r\n                                  </div>\r\n                                </div>\r\n                                <div class=\"modal-footer\">\r\n                                  <button class=\"btn btn-default\"\r\n                                          type=\"button\"\r\n                                          apiman-i18n-key=\"done\"\r\n                                          ng-click=\"ok()\">Done</button>\r\n                                </div>\r\n                              </script>\r\n                            </div>\r\n                          </div>\r\n                        </form>\r\n                      </td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </div>\r\n            </div>\r\n            <!-- /Contract List -->\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/client/client-contracts.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ClientContractsController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/client/client_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\">\r\n          <div class=\"col-md-9\">\r\n            <!-- Title and help text -->\r\n            <div class=\"title\" apiman-i18n-key=\"api-contracts\">API Contracts</div>\r\n            <div class=\"description\" apiman-i18n-key=\"contracts-help\">Here is a list of all APIs that this Client App is currently contracted to utilize.  This provides a list of all APIs that Client App can potentially invoke.</div>\r\n            <hr />\r\n            <!-- The list of contracts (filterable) -->\r\n            <div>\r\n              <div class=\"apiman-filters apiman-contracts-filters\">\r\n                <div>\r\n                  <apiman-search-box id=\"contracts-filter\" apiman-i18n-key=\"filter-client-contracts\" function=\"filterContracts\" placeholder=\"Filter by org or API name...\" />\r\n                </div>\r\n                <a apiman-permission=\"clientEdit\" apiman-status=\"Created,Ready,Registered\" data-field=\"toNewContract\" apiman-i18n-key=\"new-contract\" href=\"{{ pluginName }}/new-contract\" class=\"btn btn-primary pull-right\">New Contract</a>\r\n                <button ng-click=\"breakAll()\" apiman-action-btn=\"\" ng-disabled=\"!contracts.length\" apiman-permission=\"clientEdit\" apiman-status=\"Created,Ready,Registered\" data-field=\"breakAllContracts\" apiman-i18n-key=\"break-all-contracts\" placeholder=\"Breaking...\" data-icon=\"fa-cog\" class=\"btn btn-default pull-right\">Break All</button>\r\n              </div>\r\n              <div class=\"clearfix\"></div>\r\n              <!-- The list of contracts -->\r\n              <div class=\"apiman-contracts\" data-field=\"contracts\" ng-repeat=\"contract in filteredContracts\">\r\n                <div class=\"container-fluid apiman-summaryrow\">\r\n                  <div class=\"row\">\r\n                    <div class=\"col-md-10 col-no-padding\">\r\n                      <a href=\"{{ pluginName }}/browse/orgs/{{ contract.apiOrganizationId }}\">{{ contract.apiOrganizationName }}</a> / <span class=\"title\"><a href=\"{{ pluginName }}/browse/orgs/{{ contract.apiOrganizationId }}/{{ contract.apiId }}/{{ contract.apiVersion }}\">{{ contract.apiName }}</a></span>\r\n                      <div class=\"versionAndPlan\">\r\n                        <span apiman-i18n-key=\"client-contract.detail.api-version\">API version</span>\r\n                        <span><a href=\"{{ pluginName }}/browse/orgs/{{ contract.apiOrganizationId }}/{{ contract.apiId }}/{{ contract.apiVersion }}\">{{ contract.apiVersion }}</a></span>\r\n                        <span apiman-i18n-key=\"client-contract.detail.via-plan\">via plan</span>\r\n                        <span><a>{{ contract.planName }}</a></span>\r\n                        <span apiman-i18n-key=\"client-contract.detail.entered-into\">entered into on</span>\r\n                        <i class=\"fa fa-clock-o fa-fw fa-inline\"></i>\r\n                        <span>{{ contract.createdOn | date: \'yyyy-MM-dd\' }}</span>\r\n                      </div>\r\n                      <div class=\"description apiman-label-faded\">\r\n                        {{ contract.apiDescription }}\r\n                      </div>\r\n                    </div>\r\n                    <div class=\"col-md-2 col-no-padding\">\r\n                      <span class=\"actions\"><button apiman-i18n-key=\"break-contract\" apiman-status=\"Created,Ready,Registered\" apiman-permission=\"clientEdit\" ng-click=\"break(contract)\" class=\"btn btn-default\">Break Contract</button></span>\r\n                    </div>\r\n                  </div>\r\n                  <hr />\r\n                </div>\r\n              </div>\r\n              \r\n              <div class=\"apiman-no-content container-fluid\" ng-show=\"filteredContracts.length == 0\">\r\n                <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-client-api-contracts.message\">This Client App doesn\'t appear to have any API contracts (or perhaps none that match your filter above).  Try creating a new Contract to an API - if you do it will get listed here!</p>\r\n              </div>              \r\n              \r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/client/client-metrics.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ClientMetricsController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/client/client_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-metrics\">\r\n          <!-- Content Summary -->\r\n          <div class=\"col-md-12\">\r\n            <div class=\"title\" apiman-i18n-key=\"client-metrics\">Client App Metrics</div>\r\n            <p class=\"explanation\" apiman-i18n-key=\"client-metrics-explanation\">\r\n                Now that this Client App is registered with the gateway, it may be consuming\r\n                one or more APIs.  When this happens, you can use the Metrics\r\n                tab to view basic metrics/analytics information.\r\n            </p>\r\n            <div id=\"apiman-client-metrics-selector\" style=\"margin-top: 15px; padding-top: 8px; border-top: 1px solid #ddd; border-bottom: 1px solid #ddd\">\r\n              <span style=\"margin-right: 5px\" apiman-i18n-key=\"api-metrics.show\">Show</span>\r\n                <select ng-model=\"metricsType\" apiman-select-picker=\"\" class=\"selectpicker apiman-inline-form-dropdown\" data-style=\"btn-default apiman-inline-form-dropdown\">\r\n                  <option value=\"usage\" apiman-i18n-key=\"metrics-usage\">usage</option>\r\n<!--                   <option value=\"responseType\" apiman-i18n-key=\"metrics-responseType\">response type</option> -->\r\n                </select>\r\n              <span style=\"margin-right: 5px\" apiman-i18n-key=\"api-metrics.show-metrics-for\">metrics data for the</span>\r\n              <select ng-model=\"metricsRange\" apiman-select-picker=\"\" class=\"selectpicker apiman-inline-form-dropdown\" data-style=\"btn-default apiman-inline-form-dropdown\">\r\n                <option value=\"90days\" apiman-i18n-key=\"metrics-90days\">last 90 days</option>\r\n                <option value=\"30days\" apiman-i18n-key=\"metrics-30days\">last 30 days</option>\r\n                <option value=\"7days\" apiman-i18n-key=\"metrics-7days\">last 7 days</option>\r\n                <option value=\"24hours\" apiman-i18n-key=\"metrics-24hours\">last 24 hours</option>\r\n                <option value=\"hour\" apiman-i18n-key=\"metrics-hour\">last hour</option>\r\n              </select>\r\n              <button style=\"height:28px\" class=\"btn btn-default pull-right\" apiman-i18n-key=\"refresh\" ng-click=\"refreshCharts()\">Refresh</button>\r\n            </div>\r\n          </div>\r\n          <!-- /Content Summary -->\r\n\r\n          <!-- Usage Metrics -->\r\n          <div id=\"usage-metrics\" ng-show=\"metricsType == \'usage\'\">\r\n            <div class=\"col-md-12\">\r\n              <h3 class=\"apiman-chart-title\" apiman-i18n-key=\"api-usage\">API Usage</h3>\r\n              <div id=\"api-usage-chart\"></div>\r\n              <div style=\"text-align: center\" ng-show=\"apiUsageChartLoading\">\r\n                <div class=\"spinner spinner-lg\" style=\"display: inline-block\"></div>\r\n              </div>\r\n              <div style=\"text-align: center\" ng-show=\"apiUsageChartNoData\">\r\n                <span apiman-i18n-key=\"metrics-no-data\">No data found.</span>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        \r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/client/client-overview.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ClientOverviewController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/client/client_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\">\r\n          <!-- Content Summary -->\r\n          <div class=\"col-md-12\">\r\n            <h1 apiman-i18n-key=\"client-details\">Client App Details</h1>\r\n            <p apiman-i18n-key=\"client-overview.client-description\">\r\n              This is the Client App details page.  Use this page to modify the Client App\'s meta-data,\r\n              policies, and contracts.  There is no need to follow the tabs in order, but note that\r\n              you will need to fill out a minimum amount of data before the Client App can be registered\r\n              with the Gateway.  In particular, the Client App must have at least one API Contract\r\n              (see the \"Contracts\" tab).\r\n            </p>\r\n            \r\n            <h2 apiman-i18n-key=\"contracts\">Contracts</h2>\r\n            <p apiman-i18n-key=\"client-overview.contracts-description\">\r\n              The \'Contracts\' tab is where you can manage all of the API Contracts for this \r\n              Client App.  A API Contract is simply a link between this Client App and a provided\r\n              API the the Client App consumes.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"policies\">Policies</h2>\r\n            <p apiman-i18n-key=\"client-overview.policies-description\">\r\n              The \'Policies\' tab allows you to manage the Client-level policies that should\r\n              be applied whenever a request is made to any API consumed by this Client App.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"apis\" apiman-status=\"Registered\">APIs</h2>\r\n            <p apiman-i18n-key=\"client-overview.apis-description\" apiman-status=\"Registered\">\r\n              The \'APIs\' tab lists all of the APIs consumed by this Client App, including \r\n              showing the API Key and live endpoint for each.  Go here if you want to figure out\r\n              how to invoke an API once you have a Contract for it.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"activity\">Change Log</h2>\r\n            <p apiman-i18n-key=\"client-overview.activity-description\">\r\n              The \'Change Log\' tab shows a history of all the changes made to the Client App.  Essentially\r\n              it is an audit log.\r\n            </p>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/client/client-policies.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ClientPoliciesController\"\r\n         class=\"container page\"\r\n         data-field=\"page\"\r\n         ng-cloak=\"\"\r\n         ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/client/client_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/client/client_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content\">\r\n          <div class=\"col-md-9\">\r\n            <!-- Title and help text -->\r\n            <div class=\"title\"\r\n                 apiman-i18n-key=\"client-client-policies\">Client App Policies</div>\r\n            <div class=\"description\"\r\n                 apiman-i18n-key=\"client-policies-help\">Here is a list of all Policies defined for this Client App.  These Policies will be applied to all API invocations made by the Client App, in addition to whatever Policies are defined by the API itself.</div>\r\n            <hr />\r\n            <!-- The list of policies -->\r\n            <div apiman-permission=\"clientEdit\"\r\n                 apiman-status=\"Created,Ready,Registered\"\r\n                 class=\"apiman-filters apiman-policies-filters\">\r\n              <a apiman-i18n-key=\"add-policy\"\r\n                 href=\"{{ pluginName }}/orgs/{{ org.id }}/clients/{{ client.id }}/{{ version.version }}/new-policy\"\r\n                 class=\"btn btn-primary pull-right\">Add Policy</a>\r\n            </div>\r\n            <div class=\"clearfix\"></div>\r\n            <div class=\"apiman-policies\"\r\n                 data-field=\"policies\">\r\n\r\n              <div class=\"apiman-no-content container-fluid\"\r\n                   ng-hide=\"policies.length > 0\">\r\n                <div class=\"row\">\r\n                  <div class=\"col-md-9\">\r\n                    <p class=\"apiman-no-entities-description\"\r\n                       apiman-i18n-key=\"no-policies-for-client\">It looks like there aren\'t any policies defined! That may be exactly what you want (of course) but if not, you may try defining one using the Add Policy button above...</p>\r\n                  </div>\r\n                  <div apiman-permission=\"apiEdit\"\r\n                       apiman-status=\"Created,Ready,Registered\"\r\n                       class=\"col-md-3\">\r\n                    <div class=\"apiman-no-entities-arrow\"></div>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <div class=\"clearfix\"></div>\r\n              <apiman-policy-list ng-model=\"policies\"\r\n                                  remove-function=\"removePolicy\"\r\n                                  reorder-function=\"reorderPolicies\"\r\n                                  type=\"clients\"\r\n                                  org-id=\"{{ org.id }}\"\r\n                                  page-id=\"{{ client.id }}\"\r\n                                  version=\"{{ version.version }}\"></policy-list>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n      \r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/client/client.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.ClientRedirectController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/consumer/consumer-api-def.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n\r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.ConsumerApiDefController\" class=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n\r\n      <div class=\"container\">\r\n        <div class=\"row\">\r\n          <div class=\"col-md-12\">\r\n            <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\r\n              <li><a id=\"bc-home\" href=\"{{ pluginName }}/\"><i class=\"fa fa-home fa-fw\"></i><span apiman-i18n-key=\"home\">Home</span></a></li>\r\n              <li><a id=\"bc-orgs\" href=\"{{ pluginName }}/browse/orgs\"><i class=\"fa fa-search fa-fw\"></i><span apiman-i18n-key=\"organizations\">Organizations</span></a></li>\r\n              <li><a id=\"bc-org\" href=\"{{ pluginName }}/browse/orgs/{{params.org}}\"><i class=\"fa fa-shield fa-fw\"></i><span>{{ org.name }}</span></a></li>\r\n              <li><a id=\"bc-api\" href=\"{{ pluginName }}/browse/orgs/{{params.org}}/{{params.api}}/{{params.version}}\"><i class=\"fa fa-puzzle-piece fa-fw\"></i><span>{{ api.name }}</span></a></li>\r\n              <li class=\"active\"><i class=\"fa fa-sitemap fa-fw\"></i><span apiman-i18n-key=\"definition\">Definition</span></li>\r\n            </ol>\r\n          </div>\r\n        </div>\r\n        <div class=\"row\">\r\n          <div class=\"col-md-12\">\r\n            <h1 class=\"consumer-top-header\" apiman-i18n-key=\"api-definition\">API Definition</h1>\r\n            <hr />\r\n          </div>\r\n        </div>\r\n\r\n        <div class=\"row\" ng-hide=\"hasDefinition\">\r\n          <div class=\"col-md-12\">\r\n            <div class=\"alert alert-warning\" style=\"margin-top: 15px\">\r\n               <span class=\"pficon pficon-info\"></span>\r\n               <span apiman-i18n-key=\"consumer-api-def.no-api-definition\">This API does not have an API definition file.  Contact the API provider and ask them to supply a valid API definition!</span>\r\n            </div>\r\n          </div>\r\n        </div>\r\n\r\n        <div class=\"row\" ng-show=\"definitionStatus == \'loading\' && !hasError\">\r\n            <div class=\"col-md-12\">\r\n                <div style=\"margin-top: 15px; padding: 20px\" class=\"alert alert-info\">\r\n                    <div style=\"float:left; margin-right: 6px\" class=\"spinner spinner-sm\"></div>\r\n                    <span apiman-i18n-key=\"loading-api-def\">Loading API Definition, please wait...</span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div id=\"apiman-swagger\" class=\"row swagger-section\" ng-show=\"hasDefinition\">\r\n            <div class=\"col-md-12\">\r\n                <div id=\"swagger-ui-container\"></div>\r\n            </div>\r\n        </div>\r\n    </div> <!-- /container-pf-nav-pf-vertical container-fluid -->\r\n    </div>\r\n  </div>\r\n</body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/consumer/consumer-api-redirect.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.ConsumerApiRedirectController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/consumer/consumer-api.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.ConsumerApiController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\r\n            <li><a id=\"bc-home\" href=\"{{ pluginName }}/\"><i class=\"fa fa-home fa-fw\"></i><span apiman-i18n-key=\"home\">Home</span></a></li>\r\n            <li><a id=\"bc-orgs\" href=\"{{ pluginName }}/browse/orgs\"><i class=\"fa fa-search fa-fw\"></i><span apiman-i18n-key=\"organizations\">Organizations</span></a></li>\r\n            <li><a id=\"bc-org\" href=\"{{ pluginName }}/browse/orgs/{{params.org}}\"><i class=\"fa fa-shield fa-fw\"></i><span>{{ org.name }}</span></a></li>\r\n            <li class=\"active\"><i class=\"fa fa-puzzle-piece fa-fw\"></i><span>{{ api.name }}</span></li>\r\n          </ol>\r\n        </div>\r\n      </div>\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <h1 class=\"consumer-top-header\" apiman-i18n-key=\"api-details\">API Details</h1>\r\n        </div>\r\n        <div class=\"col-md-12\">\r\n          <div class=\"vspacer-10\" />\r\n        </div>\r\n      </div>\r\n      <div class=\"row\">\r\n\r\n        <!-- Left column -->\r\n        <div class=\"col-md-4 browse-items\">\r\n          <div class=\"item\" style=\"width: 100%; margin-bottom: 20px;\" data-field=\"apiCard\">\r\n            <div class=\"title\">\r\n              <i class=\"fa fa-puzzle-piece icon\"></i><a href=\"{{ pluginName }}/browse/orgs/{{ api.organization.id }}\" data-field=\"titleOrg\">{{ api.organization.name }}</a>\r\n              <span apiman-i18n-skip> / </span>\r\n              <span class=\"emphasis\">{{ api.name }}</span>\r\n            </div>\r\n            <div class=\"description\" style=\"margin-bottom: 10px;\">{{ api.description }}</div>\r\n            <span class=\"apiman-form-label\" apiman-i18n-key=\"choose-version\">Choose Version:</span>\r\n            <div class=\"btn-group apiman-entity-action\" ng-show=\"versions.length > 0\">\r\n              <select id=\"version\" apiman-select-picker=\"\" ng-model=\"selectedApiVersion\" ng-change=\"setVersion( selectedApiVersion )\"\r\n                title=\"\" class=\"selectpicker\" data-live-search=\"false\" apiman-i18n-skip\r\n                data-field=\"versionSelector\" data-ng-options=\"version as version.version for version in versions\">\r\n              </select>\r\n            </div>\r\n            <div apiman-i18n-key=\"no-published-api-versions-found\" class=\"alert alert-warning no-icon\" ng-hide=\"versions.length > 0\">\r\n              No versions of this API have been published.  You will not be able to\r\n              consume this API until it has been published by its owner!\r\n            </div>\r\n            <div ng-show=\"(version.definitionType == \'SwaggerJSON\' || version.definitionType == \'SwaggerYAML\')\">\r\n              <div class=\"vspacer-10\" />\r\n              <a href=\"{{ pluginName }}/browse/orgs/{{params.org}}/{{params.api}}/{{params.version}}/def\">\r\n                <i class=\"fa fa-fw fa-sitemap\"></i>\r\n                <span apiman-i18n-key=\"view-api-def\">View API Definition</span>\r\n              </a>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        \r\n        <!-- Right column -->\r\n        <div class=\"col-md-8\">\r\n          <div class=\"consumer-section\">\r\n          \r\n            <div ng-show=\"version.status != \'Published\'\">\r\n              <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"version-not-published\">This version of the selected API is not yet published.  You cannot create a contract until the API provider published this version of the API!</p>\r\n            </div>\r\n          \r\n            <div id=\"managed-endpoint-wrap\" ng-show=\"version.publicAPI && version.status == \'Published\'\">\r\n              <h3 apiman-i18n-key=\"public-endpoint\" class=\"consumer-header\">Public Endpoint</h3>\r\n              <p class=\"apiman-label-faded\" apiman-i18n-key=\"consumer-api.public-api-warning\">\r\n                Because this is a Public API, it is possible to invoke it directly, without\r\n                the need for an API Contract with a Client App.  To directly invoke the\r\n                API, send requests to the API Gateway endpoint below.\r\n              </p>\r\n              <div class=\"input-group\" style=\"width: 80%; margin: 25px 0 45px 0;\">\r\n                <input readonly\r\n                       type=\"text\"\r\n                       class=\"apiman-form-control form-control readonly apiman-readonly\"\r\n                       value=\"{{ publicEndpoint.managedEndpoint }}\"\r\n                       style=\"background-color: white; color: black\">\r\n                <span class=\"input-group-btn\">\r\n                  <button clipboard\r\n                          text=\"publicEndpoint.managedEndpoint\"\r\n                          class=\"btn btn-default clipboard\"\r\n                          type=\"button\"\r\n                          on-copied=\"copySuccess()\"\r\n                          on-error=\"copyFail(err)\"\r\n                          ng-mouseleave=\"tooltipReset()\"\r\n                          ng-click=\"tooltipChange()\"\r\n                          style=\"padding: 2px 6px 4px;\"\r\n                          uib-tooltip=\"{{ tooltipTxt }}\">\r\n                    <span class=\"glyphicon glyphicon-copy\"></span>\r\n                  </button>\r\n                </span>\r\n              </div>\r\n            </div>\r\n\r\n            <div id=\"available-plans-wrap\" ng-show=\"version.status == \'Published\'\">\r\n              <h3 apiman-i18n-key=\"available-plans\" class=\"consumer-header\">Available Plans</h3>\r\n              <div class=\"apiman-plans consumer-section\" data-field=\"plans\">\r\n\r\n                <div class=\"apiman-no-content\" ng-hide=\"plans.length > 0\">\r\n                  <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-plans-offered-by-api\">No plans are currently offered by this API.</p>\r\n                </div>\r\n\r\n                <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"plan in plans\">\r\n                  <div class=\"row\">\r\n                    <div class=\"col-md-10 col-no-padding\">\r\n                      <i class=\"fa fa-fw fa-bar-chart-o icon\"></i>\r\n                      <span class=\"title\"><a data-toggle=\"collapse\" ng-click=\"getPolicyChain(plan)\" href=\"#collapse{{ $index }}\">{{ plan.planName }}</a></span>\r\n                      <div class=\"description\">\r\n                        {{ plan.planDescription }}\r\n                      </div>\r\n                    </div>\r\n                    <div class=\"col-md-2 col-no-padding\">\r\n                      <span class=\"actions\"><a apiman-i18n-key=\"create-contract\" href=\"{{ pluginName }}/new-contract?api={{ params.api }}&amp;apiorg={{ params.org }}&amp;apiv={{ params.version }}&amp;planid={{ plan.planId }}\" class=\"btn btn-default\">Create Contract</a></span>\r\n                    </div>\r\n                  </div>\r\n                  <!-- Sub-section - policy chain -->\r\n                  <div class=\"panel-collapse collapse apiman-policy-chain\" id=\"collapse{{ $index }}\" style=\"margin-top: 15px\" >\r\n                  \r\n                    <div ng-hide=\"chains[plan.planId]\">\r\n                      <div class=\"spinner spinner-sm pull-left\"></div>\r\n                      <span apiman-i18n-key=\"loading-policy-chain\" style=\"margin-left: 5px\">Loading policy chain...</span>\r\n                    </div>\r\n                  \r\n                    <div class=\"apiman-policies\" ng-show=\"chains[plan.planId]\">\r\n                      <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"policy in chains[plan.planId]\">\r\n                        <div class=\"row\">\r\n                          <div class=\"col-md-1 col-no-padding\">\r\n                            <i class=\"fa fa-{{ policy.icon }} fa-fw apiman-policy-icon\"></i>\r\n                          </div>\r\n                          <div class=\"col-md-11 col-no-padding\">\r\n                            <div class=\"\">\r\n                              <span class=\"title apiman-label-faded\">{{ policy.name }}</span>\r\n                            </div>\r\n                            <div class=\"description apiman-label-faded\">{{ policy.description }}</div>\r\n                          </div>\r\n                        </div>\r\n                        <div>\r\n                          <hr>\r\n                        </div>\r\n                      </div>\r\n                    </div> <!-- /policy chain -->\r\n                    \r\n                  </div>\r\n                  <hr />\r\n                </div>\r\n              \r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div> <!-- /right-column -->\r\n        \r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/consumer/consumer-apis.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n<head>\r\n    <meta charset=\"utf-8\">\r\n    <meta content=\"width=device-width, initial-scale=1.0\" name=\"viewport\">\r\n</head>\r\n\r\n<body>\r\n<div>\r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-controller=\"Apiman.ConsumerApisController\"\r\n         ng-show=\"pageState == \'loaded\'\">\r\n        <div class=\"row\">\r\n            <div class=\"col-md-12\">\r\n                <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\r\n                    <li>\r\n                      <a href=\"{{ pluginName }}/\" id=\"bc-home\">\r\n                        <i class=\"fa fa-home fa-fw\"></i>\r\n                        <span apiman-i18n-key=\"home\">Home</span>\r\n                      </a>\r\n                    </li>\r\n                    <li class=\"active\">\r\n                      <i class=\"fa fa-search fa-fw\"></i>\r\n                      <span apiman-i18n-key=\"apis\">APIs</span>\r\n                    </li>\r\n                </ol>\r\n            </div>\r\n        </div>\r\n\r\n        <div class=\"row\">\r\n            <div class=\"col-md-12\">\r\n                <h1 apiman-i18n-key=\"find-api\" class=\"consumer-top-header\">Find an API</h1>\r\n            </div>\r\n            <div class=\"col-md-6 no-phone\">\r\n                <p apiman-i18n-key=\"find-api-description\" class=\"description\">Use this page to find APIs you wish to\r\n                    consume. Use the various search options to find APIs, then review them and eventually create\r\n                    Contracts to them.</p>\r\n            </div>\r\n            <div class=\"col-md-6\">\r\n                <form ng-submit=\"searchSvcs(apiName, currentPage, pageSize)\">\r\n                    <input apiman-i18n-key=\"searchfor-apis\" class=\"apiman-form-control form-control input-search\" id=\"apiman-search\"\r\n                           ng-model=\"apiName\" placeholder=\"Search by API name or keyword...\"\r\n                           type=\"text\">\r\n                    <button apiman-i18n-key=\"search\" class=\"btn btn-default btn-search\" data-field=\"searchButton\" id=\"search-btn\"\r\n                            type=\"submit\">Search\r\n                    </button>\r\n                </form>\r\n            </div>\r\n            <div class=\"col-md-12\">\r\n                <hr/>\r\n            </div>\r\n        </div>\r\n\r\n        <!-- Search results -->\r\n        <div class=\"row browse-items\">\r\n            <div class=\"col-md-12\">\r\n\r\n                <div class=\"apiman-no-content container-fluid\" ng-hide=\"apis.length > 0\">\r\n                    <div class=\"row\">\r\n                        <div class=\"col-md-12\">\r\n                            <p apiman-i18n-key=\"consumer-no-apis-found\" class=\"apiman-no-entities-description\">No APIs\r\n                                found. Either no APIs matched the query or you haven\'t queried yet!</p>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class=\"row\">\r\n                    <div ng-show=\"apis.length > 0\">\r\n                        <div class=\"count col-md-8\">\r\n                            Found {{resultCount}} matching APIs.\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class=\"col-md-3 left-spacer-30\" ng-show=\"resultCount > 10\">\r\n                        <span apiman-i18n-key=\"select-page-size\">Select page size </span>\r\n                        <select ng-change=\"searchSvcs(apiName, currentPage, pageSize)\" ng-init=\"pageSize = \'10\'\"\r\n                                ng-model=\"pageSize\">\r\n                            <option ng-selected=\"true\" value=\"10\">10</option>\r\n                            <option value=\"25\">25</option>\r\n                            <option value=\"50\">50</option>\r\n                        </select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class=\"item\" ng-repeat=\"api in apis\">\r\n                    <div class=\"title\">\r\n                        <i class=\"fa fa-puzzle-piece icon\"></i>\r\n                        <a href=\"{{ pluginName }}/browse/orgs/{{api.organizationId}}\">{{ api.organizationName }}</a>\r\n                        <span apiman-i18n-skip> / </span>\r\n                        <b><a href=\"{{ pluginName }}/browse/orgs/{{api.organizationId}}/{{api.id}}\">{{ api.name }}</a></b>\r\n                    </div>\r\n                    <div class=\"description\" title=\"{{ api.description }}\">{{ api.description | limitTo: 60 }}\r\n                      <span ng-show=\"api.description.length > 60\">...</span></div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class=\"row\">\r\n            <div class=\"col-md-6\" ng-show=\"apis.length > 0 && resultCount > pageSize\">\r\n                <uib-pagination boundary-link-numbers=\"true\" direction-links=\"true\" force-ellipses=\"true\"\r\n                                items-per-page=\"pageSize\"\r\n                                max-size=\"5\" ng-change=\"searchSvcs(apiName, currentPage, pageSize)\"\r\n                                ng-init=\"currentPage = 1\" ng-model=\"currentPage\" rotate=\"true\" total-items=\"resultCount\"/>\r\n            </div>\r\n        </div>\r\n    </div> <!-- /container -->\r\n</div>\r\n</body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/consumer/consumer-org.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.ConsumerOrgController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\r\n            <li><a id=\"bc-home\" href=\"{{ pluginName }}/\"><i class=\"fa fa-home fa-fw\"></i><span apiman-i18n-key=\"home\">Home</span></a></li>\r\n            <li><a id=\"bc-orgs\" href=\"{{ pluginName }}/browse/orgs\"><i class=\"fa fa-search fa-fw\"></i><span apiman-i18n-key=\"organizations\">Organizations</span></a></li>\r\n            <li class=\"active\"><span><i class=\"fa fa-shield fa-fw\"></i><span>{{ org.name }}</span></span></li>\r\n          </ol>\r\n        </div>\r\n      </div>\r\n      <div class=\"row\">\r\n        <div class=\"col-md-12\">\r\n          <h1 class=\"consumer-top-header\" apiman-i18n-key=\"organization-details\">Organization Details</h1>\r\n        </div>\r\n        <div class=\"col-md-12\">\r\n          <div class=\"vspacer-10\" />\r\n        </div>\r\n      </div>\r\n      \r\n      <div class=\"row\">\r\n\r\n        <!-- Left column -->\r\n        <div class=\"col-md-4 browse-items\">\r\n          <div class=\"item\" style=\"width: 100%; margin-bottom: 20px;\" data-field=\"organizationCard\">\r\n            <div class=\"title\"><i class=\"fa fa-shield icon\"></i><span data-field=\"title\">{{ org.name }}</span></div>\r\n            <div class=\"description\" data-field=\"description\">{{ org.description }}</div>\r\n            <a ng-show=\"org.isMember\" class=\"ismember\" title=\"You are already a member of this organization.\" href=\"{{ pluginName }}/orgs/{{ org.id }}\" data-field=\"isMemberLink\" apiman-i18n-key=\"is-member\"></a>\r\n          </div>\r\n          \r\n          <div class=\"consumer-section\" ng-show=\"org.isMember\">\r\n            <h3 apiman-i18n-key=\"current-members\" class=\"consumer-header\">Current Members</h3>\r\n            <div class=\"apiman-members\" data-field=\"members\">\r\n              <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"member in members\">\r\n                <div class=\"row\">\r\n                  <span class=\"title\">\r\n                    <i class=\"fa fa-fw fa-user icon\"></i>\r\n                    <span>{{ member.userName }}</span>\r\n                    <span class=\"secondary\">({{ member.userId }})</span>\r\n                  </span>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- Right column -->\r\n        <div class=\"col-md-8\">\r\n          <div class=\"consumer-section\">\r\n            <h3 apiman-i18n-key=\"apis-offered\" class=\"consumer-header\">APIs Offered</h3>\r\n            <div class=\"apiman-filters apiman-apis-filters\">\r\n              <apiman-search-box id=\"api-filter\" apiman-i18n-key=\"filter-consumer-apis\" function=\"filterApis\" placeholder=\"Filter by API name...\" />\r\n            </div>\r\n            <div class=\"apiman-apis consumer-section\">\r\n\r\n              <div class=\"apiman-no-content\" ng-hide=\"apis.length > 0\">\r\n                <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"consumer-no-apis-found-for-org\">No APIs are currently offered by this organization.</p>\r\n              </div>\r\n\r\n              <div class=\"apiman-no-content\" ng-show=\"apis.length > 0 && filteredApis.length == 0\">\r\n                <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"consumer-no-apis-found-for-filter\">No APIs matched the current filter criteria.</p>\r\n              </div>\r\n\r\n              <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"api in filteredApis\">\r\n                <div class=\"row\">\r\n                  <i class=\"fa fa-fw fa-puzzle-piece icon\"></i>\r\n                  <span class=\"title\"><a href=\"{{ pluginName }}/browse/orgs/{{ org.id }}/{{ api.id }}\">{{ api.name }}</a></span>\r\n                </div>\r\n                <div class=\"row\">\r\n                  <span class=\"description\">\r\n                    {{ api.description }}\r\n                  </span>\r\n                </div>\r\n                <hr/>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/consumer/consumer-orgs.html","<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"utf-8\">\n    <meta content=\"width=device-width, initial-scale=1.0\" name=\"viewport\">\n</head>\n\n<body>\n<div>\n    <div ng-include=\"headerInclude\"></div>\n    <div class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-controller=\"Apiman.ConsumerOrgsController\"\n         ng-show=\"pageState == \'loaded\'\">\n        <div class=\"row\">\n            <div class=\"col-md-12\">\n                <ol class=\"breadcrumb\" data-field=\"breadcrumb\">\n                    <li>\n                        <a href=\"{{ pluginName }}/\" id=\"bc-home\">\n                            <i class=\"fa fa-home fa-fw\"></i>\n                            <span apiman-i18n-key=\"home\">Home</span>\n                        </a>\n                    </li>\n                    <li class=\"active\">\n                        <i class=\"fa fa-search fa-fw\"></i>\n                        <span apiman-i18n-key=\"organizations\">Organizations</span>\n                    </li>\n                </ol>\n            </div>\n        </div>\n        <div class=\"row\">\n            <div class=\"col-md-12\">\n                <h1 apiman-i18n-key=\"find-org\" class=\"consumer-top-header\">Find an Organization</h1>\n            </div>\n            <div class=\"col-md-6 no-phone\">\n                <p apiman-i18n-key=\"find-org-description\" class=\"description\">Use this page to find Organizations you\n                    may wish to join.</p>\n            </div>\n            <div class=\"col-md-6\">\n                <form ng-submit=\"searchOrg(orgName, currentPage, pageSize)\">\n                    <input apiman-i18n-key=\"searchfor-orgs\" class=\"apiman-form-control form-control input-search\"\n                           id=\"apiman-search\"\n                           ng-model=\"orgName\" placeholder=\"Enter a word or phrase to search by...\"\n                           type=\"text\">\n                    <button apiman-i18n-key=\"search\" class=\"btn btn-default btn-search\" data-field=\"searchButton\"\n                            id=\"search-btn\"\n                            type=\"submit\">Search\n                    </button>\n                </form>\n            </div>\n            <div class=\"col-md-12\">\n                <hr/>\n            </div>\n        </div>\n\n        <!-- Search results -->\n        <div class=\"row browse-items\">\n            <div class=\"col-md-12\" data-field=\"orgs\">\n\n                <div class=\"apiman-no-content container-fluid\" ng-hide=\"orgs.length > 0\">\n                    <div class=\"row\">\n                        <div class=\"col-md-12\">\n                            <p apiman-i18n-key=\"consumer-no-orgs-found\" class=\"apiman-no-entities-description\">No\n                                organizations found. Either no organizations matched the query or you haven\'t queried\n                                yet!</p>\n                        </div>\n                    </div>\n                </div>\n                <div ng-show=\"orgs.length > 0\">\n                    <div class=\"row\">\n                        <div class=\"count col-md-8\">\n                            Found {{resultCount}} matching organizations.\n                        </div>\n                        <div class=\"col-md-3 left-spacer-30\" ng-show=\"resultCount > 10\">\n                            <span apiman-i18n-key=\"select-page-size\">Select page size </span>\n                            <select ng-change=\"searchOrg(orgName, currentPage, pageSize)\" ng-init=\"pageSize = \'10\'\"\n                                    ng-model=\"pageSize\">\n                                <option ng-selected=\"true\" value=\"10\">10</option>\n                                <option value=\"25\">25</option>\n                                <option value=\"50\">50</option>\n                            </select>\n                        </div>\n\n                    </div>\n                    <div class=\"item\" ng-repeat=\"org in orgs\">\n                        <div class=\"title\">\n                            <i class=\"fa fa-shield icon\"></i>\n                            <a href=\"{{ pluginName }}/browse/orgs/{{ org.id }}\">{{ org.name }}</a>\n                        </div>\n                        <div class=\"description\" title=\"{{ org.description }}\">{{ org.description | limitTo: 60 }}\n                            <span ng-show=\"org.description.length > 60\">...</span>\n                        </div>\n                        <a apiman-i18n-key=\"is-member-badge\" class=\"ismember\"\n                           href=\"{{ pluginName }}/orgs/{{ org.id }}\" ng-show=\"org.isMember\"\n                           title=\"You are already a member of this Organization.\">\n                        </a>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"row\">\n            <div class=\"col-md-6\" ng-show=\"orgs.length > 0 && resultCount > pageSize\">\n                <uib-pagination boundary-link-numbers=\"true\" direction-links=\"true\" force-ellipses=\"true\"\n                                items-per-page=\"pageSize\"\n                                max-size=\"5\" ng-change=\"searchOrg(orgName, currentPage, pageSize)\"\n                                ng-init=\"currentPage = 1\" ng-model=\"currentPage\" rotate=\"true\"\n                                total-items=\"resultCount\"/>\n            </div>\n        </div>\n    </div> <!-- /container -->\n</div>\n</body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/directives/activity.html","<div class=\"apiman-activity\">\n\n  <div class=\"apiman-no-content container-fluid\" ng-hide=\"auditEntries.length > 0\">\n    <div class=\"row\">\n      <div class=\"col-md-12\">\n        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-activity-found-for-user\">No changes were found.  I guess someone should do something first!</p>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"entry in auditEntries\">\n    <div>\n      <apiman-audit-entry model=\"entry\" entity-type=\"{{ entry.what }}\" data-entry-type=\"{{ entry.entityType }}\" />\n    </div>\n    <div class=\"row\">\n      <i class=\"fa fa-fw {{ getEntryIcon(entry) }}\"></i>\n      <div class=\"apiman-timestamp\">{{ entry.createdOn | date : \"yyyy-MM-dd \'@\' h:mm:ss a\" }}</div>\n    </div>\n    <hr/>\n  </div>\n  <div class=\"container-fluid\" style=\"text-align: center\" ng-hide=\"auditEntries.length == 0\">\n    <button ng-show=\"hasMore && auditEntries.length >= 20\" apiman-action-btn=\"\" data-field=\"getMoreButton\" apiman-i18n-key=\"activity.show-more\" placeholder=\"Loading More...\" data-icon=\"fa-cog\" ng-click=\"getMore()\" class=\"btn btn-default\">Show Next 20 Items</button>\n  </div>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/editDescription.html","<div style=\"position: relative;\" class=\"description\">\n    <div editable-textarea=\"descr\"\n         onaftersave=\"saveDescription()\"\n         e-ng-focus=\"focusOnDescription($event)\"\n         e-ng-change=\"changeOnDescription()\"\n         e-class=\"autoExpand\"\n         ng-mouseover=\"descriptionMouseOver($event)\"\n         ng-mouseout=\"descriptionMouseOut($event)\"\n         id=\"descriptionWrapper\">\n            {{ descr || \"&lt;\" + defaultValue + \"&gt;\" }}\n        <!-- ng-style=\"{ left: leftPosition, top: topPosition, height: height }\" -->\n            <a href=\"#\"\n               ng-show=\"showPencil\"\n               class=\"apiman-inline-edit-overlay-edit\"\n               style=\"position: absolute; right: 0; top: 0;\">\n                <i class=\"fa fa-pencil fa-fw\"></i>\n            </a>\n    </div>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/getvalueModal.html","      <div class=\"modal fade\" id=\"valueModal\" tabindex=\"-1\" role=\"dialog\" aria-hidden=\"true\">\n        <div class=\"modal-dialog\">\n          <div class=\"modal-content\">\n            <div class=\"modal-header\">\n              <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\">\n                <span class=\"pficon pficon-close\"></span>\n              </button>\n              <h4 class=\"modal-title\"><span>{{ title }}</span></h4>\n            </div>\n            <div class=\"modal-body\">\n              <div class=\"\" style=\"margin-bottom: 15px\">{{ message }}</div>\n              <dl>\n                <dt>{{ label }}</dt>\n                <dd>\n                  <input ng-model=\"value\" id=\"uservalue\" class=\"apiman-form-control form-control entityname\" type=\"text\">\n                </dd>\n              </dl>\n            </div>\n            <div class=\"modal-footer\">\n              <button ng-click=\"onCancel()\" data-dismiss=\"modal\" type=\"button\" class=\"btn btn-default\" apiman-i18n-key=\"cancel\">Cancel</button>\n              <button ng-click=\"onOK()\" data-dismiss=\"modal\" type=\"button\" class=\"btn btn-primary\"  apiman-i18n-key=\"ok\">OK</button>\n            </div>\n          </div>\n        </div>\n      </div>\n");
$templateCache.put("plugins/api-manager/html/directives/modal.html","<div class=\"modal-header\">\r\n    <h3 class=\"modal-title\">{{ title }}</h3>\r\n</div>\r\n<div class=\"modal-body\">\r\n    {{ message }}\r\n</div>\r\n<div class=\"modal-footer\">\r\n    <button class=\"btn btn-default\"\r\n            type=\"button\"\r\n            ng-click=\"cancel()\"\r\n            apiman-i18n-key=\"cancel\">Cancel</button>\r\n    <button class=\"btn btn-primary\"\r\n            type=\"button\"\r\n            ng-click=\"ok()\"\r\n            apiman-i18n-key=\"ok\">OK</button>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/policyList.html","<div class=\"apiman-policies\" id=\'draggable-ctr\' as-sortable=\"policyListOptions\" ng-model=\"ctrl.policies\">\r\n    <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"policy in ctrl.policies\" as-sortable-item>\r\n        <div class=\"row\" >\r\n            <div as-sortable-item-handle apiman-permission=\"apiEdit\" ng-show=\"!isEntityDisabled()\" class=\"policy-grabber\" style=\"height: 48px\"></div>\r\n            <div class=\"col-md-1 col-no-padding\">\r\n                <i class=\"apiman-policy-icon fa fa-{{ policy.icon }} fa-fw\"></i>\r\n            </div>\r\n            <div class=\"col-md-9 col-no-padding\">\r\n                <div>\r\n                    <span class=\"title\"><a href=\"{{ pluginName }}/orgs/{{ ctrl.org }}/{{ ctrl.type == \'clients\' ? \'clients\' : ctrl.type }}/{{ ctrl.id }}/{{ ctrl.version }}/policies/{{ policy.id }}\">{{ policy.name }}</a></span>\r\n                </div>\r\n                <div class=\"metaData\">\r\n                    <span apiman-i18n-key=\"policyList.policy-created-by\">Policy created by </span>\r\n                    <span><a href=\"{{ pluginName }}/users/{{ policy.createdBy }}\">{{ policy.createdBy }}</a></span>\r\n                    <span apiman-i18n-key=\"on\">on</span>\r\n                    <i class=\"fa fa-clock-o fa-inline\"></i>\r\n                    <span>{{ policy.createdOn | date:\'yyyy-MM-dd\' }}</span>\r\n                </div>\r\n                <div class=\"description apiman-label-faded\">\r\n                    {{ policy.description }}\r\n                </div>\r\n            </div>\r\n            <div class=\"col pull-right\">\r\n                <button apiman-i18n-key=\"remove\" class=\"btn btn-default\" ng-show=\"!isEntityDisabled()\" ng-click=\"ctrl.remove( policy )\">Remove</button>\r\n            </div>\r\n        </div>\r\n        <hr />\r\n    </div>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/requestMethod.html","<select id=\"requestMethod\" ng-model=\"verb\" apiman-select-picker data-width=\"110\" data-live-search=\"false\" ng-disabled=\"isEntityDisabled()\">\n  <option value=\"*\" selected=\"selected\" apiman-i18n-skip=\"\">*</option>\n  <option value=\"GET\" apiman-i18n-skip=\"\">GET</option>\n  <option value=\"POST\" apiman-i18n-skip=\"\">POST</option>\n  <option value=\"PUT\" apiman-i18n-skip=\"\">PUT</option>\n  <option value=\"DELETE\" apiman-i18n-skip=\"\">DELETE</option>\n  <option value=\"OPTIONS\" apiman-i18n-skip=\"\">OPTIONS</option>\n  <option value=\"PATCH\" apiman-i18n-skip=\"\">PATCH</option>\n  <option value=\"HEAD\" apiman-i18n-skip=\"\">HEAD</option>\n  <option value=\"TRACE\" apiman-i18n-skip=\"\">TRACE</option>\n  <option value=\"CONNECT\" apiman-i18n-skip=\"\">CONNECT</option>\n</select>\n");
$templateCache.put("plugins/api-manager/html/directives/requestMethodCachingResourcesOptions.html","<select id=\"requestMethodCachingResourcesOptions\" ng-model=\"httpMethod\" apiman-select-picker data-width=\"110\" data-live-search=\"false\" ng-disabled=\"isEntityDisabled()\">\n  <option value=\"*\" selected=\"selected\" apiman-i18n-skip=\"\">*</option>\n  <option value=\"GET\" apiman-i18n-skip=\"\">GET</option>\n  <option value=\"POST\" apiman-i18n-skip=\"\">POST</option>\n  <option value=\"HEAD\" apiman-i18n-skip=\"\">HEAD</option>\n</select>\n");
$templateCache.put("plugins/api-manager/html/directives/searchBox.html","<table class=\"apiman-search-box input-search\" data-field=\"contractFilter\">\n    <tbody>\n      <tr>\n        <td width=\"99%\">\n          <input id=\"{{ filterId }}\" ng-model=\"value\" ng-change=\"doSearch()\" value=\"\" type=\"text\" placeholder=\"{{ placeholder }}\">\n        </td>\n        <td width=\"1%\">\n          <button id=\"{{ buttonId }}\" ng-click=\"onClick()\" class=\"btn btn-default\"><i class=\"fa fa-fw fa-search\"></i></button>\n        </td>\n      </tr>\n    </tbody>\n</table>\n");
$templateCache.put("plugins/api-manager/html/errors/400.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.Error400Controller\" class=\"container error-page\" data-field=\"error-page\">\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n          <div class=\"error-icon error-403 pull-right\"></div>\n        </div>\n        <div class=\"col-md-8\">\n          <div class=\"title\" apiman-i18n-key=\"error-400-title\">Bad Request!</div>\n          <div class=\"description\" apiman-i18n-key=\"error-400-description\">\n           Bad request!\n          </div>\n        </div>\n      </div>\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/errors/403.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.Error403Controller\" class=\"container error-page\" data-field=\"error-page\">\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n          <div class=\"error-icon error-403 pull-right\"></div>\n        </div>\n        <div class=\"col-md-8\">\n          <div class=\"title\" apiman-i18n-key=\"error-403-title\">Not Allowed!</div>\n          <div class=\"description\" apiman-i18n-key=\"error-403-description\">Uh oh, it looks like you tried to access something you aren\'t allowed to see.  Since you aren\'t that kind of person it was probably our fault. Maybe you should let someone know?</div>\n        </div>\n      </div>\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/errors/404.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.Error404Controller\" class=\"container error-page\" data-field=\"error-page\">\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n          <div class=\"error-icon error-404 pull-right\"></div>\n        </div>\n        <div class=\"col-md-8\">\n          <div class=\"title\" apiman-i18n-key=\"error-404-title\">Oops, Not Found</div>\n          <div class=\"description\" apiman-i18n-key=\"error-404-description\">Oh...well, we couldn\'t find the page you were looking for.  Perhaps it no longer exists?  Or maybe you just got the name wrong?  I doubt it was stolen by badgers, but that\'s not impossible either.</div>\n        </div>\n      </div>\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/errors/409-8002.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.Error409Controller\" class=\"container error-page\" data-field=\"error-page\">\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n          <div class=\"error-icon error-409 pull-right\"></div>\n        </div>\n        <div class=\"col-md-8\">\n          <div class=\"title\" apiman-i18n-key=\"error-409-8002-title\">Entity Still Active</div>\n          <div class=\"description\" apiman-i18n-key=\"error-409-8002-description\">\n            You tried to delete something that could not be deleted in its current\n            state.  See the information below to possibly get an idea of what went\n            wrong, based on what you were attempting to delete.\n          </div>\n        </div>\n      </div>\n      <hr />\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n        </div>\n        <div class=\"col-md-8\">\n          <h1 apiman-i18n-key=\"organizations\">Organizations</h1>\n          <ul>\n            <li apiman-i18n-key=\"error-409-8002.rules.orgs.no-published-apis\">Must have zero published APIs</li>\n            <li apiman-i18n-key=\"error-409-8002.rules.orgs.no-registered-client-apps\">Must have zero registered Client Apps</li>\n          </ul>\n        </div>\n      </div>\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n        </div>\n        <div class=\"col-md-8\">\n          <h1 apiman-i18n-key=\"apis\">APIs</h1>\n          <ul>\n            <li apiman-i18n-key=\"error-409-8002.rules.apis.all-versions-retired\">All versions must be retired (or not yet published)</li>\n          </ul>\n        </div>\n      </div>\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n        </div>\n        <div class=\"col-md-8\">\n          <h1 apiman-i18n-key=\"client-apps\">Client Apps</h1>\n          <ul>\n            <li apiman-i18n-key=\"error-409-8002.rules.client-apps.all-versions-retired\">All versions must be retired (or not yet registered)</li>\n          </ul>\n        </div>\n      </div>\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/errors/409.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.Error409Controller\" class=\"container error-page\" data-field=\"error-page\">\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n          <div class=\"error-icon error-409 pull-right\"></div>\n        </div>\n        <div class=\"col-md-8\">\n          <div class=\"title\" apiman-i18n-key=\"error-409-title\">Already Exists</div>\n          <div class=\"description\" apiman-i18n-key=\"error-409-description\">You\'ve just tried to create something that already exists!  Maybe try again with a different name?</div>\n        </div>\n      </div>\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/errors/500.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    \n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.Error500Controller\" class=\"container error-page\" data-field=\"error-page\">\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n          <div class=\"error-icon error-500 pull-right\"></div>\n        </div>\n        <div class=\"col-md-8\">\n          <div class=\"title\" apiman-i18n-key=\"error-500-title\">Server Error!</div>\n          <div class=\"description\" apiman-i18n-key=\"error-500-message\">Oh boy.  This one is totally on us.  Something really unexpected happened on the server and caused an error.  It\'s not you, it\'s me.  Really.  You could probably just try it again and see what happens.  If it keeps on happening you may need to contact someone about it.</div>\n        </div>\n      </div>\n      <div class=\"row\" ng-show=\"error.data\" style=\"margin-top: 20px\">\n        <div class=\"col-md-3\"></div>\n        <div class=\"col-md-8\">\n          <div class=\"header\" apiman-i18n-key=\"error-message\">Error Message</div>\n          <div>\n            <input data-field=\"errorMessage\" class=\"apiman-form-control form-control errorMessage\" readonly=\"readonly\" value=\"{{ error.data.message }}\" type=\"text\">\n          </div>\n        </div>\n      </div>\n      <div class=\"row\" style=\"margin-top: 15px\" ng-show=\"error.data\">\n        <div class=\"col-md-3\"></div>\n        <div class=\"col-md-8\">\n          <div class=\"header\" apiman-i18n-key=\"error-details\">Error Details</div>\n          <div>\n            <pre data-field=\"errorDetail\">{{ error.data.stacktrace }}</pre>\n          </div>\n        </div>\n      </div>\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/errors/invalid_server.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.ErrorInvalidServerController\" class=\"container error-page\" data-field=\"error-page\">\n      <div class=\"row\">\n        <div class=\"col-md-3\">\n          <div class=\"error-icon error-0 pull-right\"></div>\n        </div>\n        <div class=\"col-md-8\">\n          <div class=\"title\" apiman-i18n-key=\"error-0-title\">Error Communicating With Server</div>\n          <div class=\"description\" apiman-i18n-key=\"error-0-message\">We received an error 0 from the server.  This either means that the server was down, or that CORS was not properly configured.  If this error persists, please contact the system administrator.</div>\n        </div>\n      </div>\n      <div class=\"row\">\n        <hr />\n      </div>\n      <div class=\"row\">\n        <div class=\"col-md-3\"></div>\n        <div class=\"col-md-8\">\n          <h2 apiman-i18n-key=\"more-info\">More Information</h2>\n          <table class=\"table table-bordered\">\n            <tbody>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"version-label\">Version:</span></td>\n                <td>{{ version }}</td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"build-date-label\">Build Date:</span></td>\n                <td>{{ builtOn }}</td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"server-label\">Server:</span></td>\n                <td><a href=\"{{ apiEndpoint }}\">{{ apiEndpoint }}</a></td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"installation-guide-label\">Install Guide:</span></td>\n                <td><a href=\"{{ installGuide }}\">{{ installGuide }}</a></td>\n              </tr>\n              <tr>\n                <td width=\"1%\" nowrap=\"nowrap\"><span class=\"about-label\" apiman-i18n-key=\"cors-label\">CORS Information:</span></td>\n                <td><a href=\"{{ cors }}\">{{ cors }}</a></td>\n              </tr>\n            </tbody>\n          </table>\n        </div>\n      </div>\n    </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/edit-gateway.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.EditGatewayController\" id=\"form-page\" class=\"container apiman-edit-gateway apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <fieldset>\n      <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"edit-gateway\">Edit Gateway</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p apiman-i18n-key=\"edit-gateway-help-text\" class=\"col-md-6 apiman-label-faded\">Update this gateway\'s details, useful when a Gateway\'s endpoint or authentication information is changed.</p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Choose gateway name -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"gateway-name\">Gateway Name</dt>\n          <dd>\n            <input id=\"apiman-gateway-name\" ng-model=\"gateway.name\" data-field=\"name\" type=\"text\" class=\"apiman-form-control form-control name entityname\" placeholder=\"Enter gateway name...\" apiman-i18n-key=\"enter-gateway-name\" disabled=\"disabled\"></input>\n          </dd>\n        </dl>\n      </div>\n      <!-- Description of gateway -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"description\">Description</dt>\n          <dd>\n            <textarea ng-model=\"gateway.description\" data-field=\"description\" type=\"text\" class=\"apiman-form-control form-control description\" id=\"apiman-gateway-description\" apiman-i18n-key=\"enter-gateway-description\" placeholder=\"Enter gateway description (optional)...\"></textarea>\n          </dd>\n        </dl>\n      </div>\n      <!-- Configuration Endpoint -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"config-endpoint\">Configuration Endpoint</dt>\n          <dd>\n            <input ng-model=\"configuration.endpoint\" data-field=\"configEndpoint\" type=\"text\" class=\"apiman-form-control form-control description\" id=\"config-endpoint\" apiman-i18n-key=\"enter-gateway-config-endpoint\" placeholder=\"Enter configuration endpoint...\"></input>\n          </dd>\n        </dl>\n      </div>\n      <!-- Authentication Credentials -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"credentials\">Configuration Endpoint Credentials</dt>\n          <dd>\n            <table class=\"form-table\">\n              <tr>\n                <td class=\"td-label\">\n                  <span apiman-i18n-key=\"username\">Username:</span>\n                </td>\n                <td>\n                  <input id=\"endpoint-username\" ng-model=\"configuration.username\" name=\"username\" type=\"text\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"gateway-auth-username\" placeholder=\"Username...\"></input>\n                </td>\n              </tr>\n              <tr>\n                <td class=\"td-label\">\n                  <span apiman-i18n-key=\"password\">Password:</span>\n                </td>\n                <td>\n                  <input id=\"endpoint-password\" ng-model=\"configuration.password\" name=\"password\" type=\"password\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"gateway-auth-password\" placeholder=\"Password...\"></input>\n                </td>\n              </tr>\n              <tr>\n                <td></td>\n                <td>\n                  <input id=\"endpoint-password-confirm\" ng-model=\"passwordConfirm\" name=\"passwordConfirm\" type=\"password\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"gateway-auth-confirm-pass\" placeholder=\"Confirm Password...\"></input>\n                </td>\n              </tr>\n            </table>\n          </dd>\n        </dl>\n      </div>\n      <div class=\"row\">\n        <button id=\"test-gateway\" ng-disabled=\"!isValid\" ng-click=\"testGateway()\" apiman-action-btn=\"\" class=\"btn btn-default\" data-field=\"testButton\" apiman-i18n-key=\"test-gateway\" placeholder=\"Testing...\" data-icon=\"fa-cog\">Test Gateway</button>\n      </div>\n      <div class=\"row\" ng-show=\"testResult == \'success\'\">\n        <div class=\"alert alert-success description\" style=\"margin-top: 10px\">\n          <span class=\"pficon pficon-ok\"></span>\n          <strong apiman-i18n-key=\"gateway-configuration-valid.title\">Gateway Configuration Valid</strong> \n          <div apiman-i18n-key=\"gateway-configuration-valid.msg\">Your Gateway configuration is correct.  Great job!</div>\n        </div>\n      </div>\n      <div class=\"row\" ng-show=\"testResult == \'error\'\">\n        <div class=\"alert alert-danger description\" style=\"margin-top: 10px\">\n          <span class=\"pficon pficon-error-circle-o\"></span>\n          <strong apiman-i18n-key=\"gateway-configuration-invalid.title\">Gateway Configuration Invalid</strong>\n          <div apiman-i18n-key=\"gateway-configuration-invalid.msg\">Something has gone wrong when testing the Gateway.  Hopefully the details (below) will help you figure out what.</div>\n          <div style=\"margin-top: 8px\">\n            <pre>{{ testErrorMessage }}</pre>\n          </div>\n        </div>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Update Button -->\n      <div class=\"row\">\n        <button id=\"update-gateway\" ng-disabled=\"!isValid || !isDirty\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"updateButton\" apiman-i18n-key=\"update-gateway\" placeholder=\"Updating...\" data-icon=\"fa-cog\" ng-click=\"updateGateway()\">Update Gateway</button>\n        <a id=\"cancel\"\n           ng-click=\"cancel();\"\n           class=\"btn btn-default btn-cancel cancel\"\n           apiman-i18n-key=\"cancel\">Cancel</a>\n        <button id=\"delete-gateway\" apiman-action-btn=\"\" class=\"btn btn-danger\" style=\"margin-left: 100px;\" data-field=\"deleteButton\" apiman-i18n-key=\"delete-gateway\" placeholder=\"Deleting...\" data-icon=\"fa-cog\" ng-click=\"deleteGateway()\">Delete Gateway</button>\n      </div>\n  	  </fieldset>\n    </div> <!-- /container -->\n\n    <div ng-include=\"\'plugins/api-manager/html/modals/confirmModal.html\'\"></div>\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/edit-plugin.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.EditPluginController\" id=\"form-page\" class=\"container apiman-edit-plugin apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"plugin-details\">Plugin Details</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p apiman-i18n-key=\"plugin-details-help-text\" class=\"col-md-6 apiman-label-faded\">Plugins cannot be edited, but details about the plugin can be viewed on this page.  Additionally, the plugin can be deleted via the Delete button below.</p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <div class=\"row container\">\n        <!-- Left column -->\n        <div class=\"col-md-6 container\">\n          <div class=\"row\">\n            <h3 class=\"\" apiman-i18n-key=\"plugin-coordinates\">Plugin Coordinates</h3>\n          </div>\n          <div class=\"row\">\n            <dl>\n              <dt apiman-i18n-key=\"group-id\">Group Id</dt>\n              <dd>\n                <span data-field=\"groupId\">{{ plugin.groupId }}</span>\n              </dd>\n            </dl>\n          </div>\n          <div class=\"row\">\n            <dl>\n              <dt apiman-i18n-key=\"artifact-id\">Artifact Id</dt>\n              <dd>\n                <span data-field=\"artifactId\">{{ plugin.artifactId }}</span>\n              </dd>\n            </dl>\n          </div>\n          <div class=\"row\">\n            <dl>\n              <dt apiman-i18n-key=\"version\">Version</dt>\n              <dd>\n                <span data-field=\"version\">{{ plugin.version }}</span>\n              </dd>\n            </dl>\n          </div>\n          <div class=\"row\" ng-show=\"plugin.classifier\">\n            <dl>\n              <dt apiman-i18n-key=\"classifier\">Classifier</dt>\n              <dd>\n                <span data-field=\"classifier\">{{ plugin.classifier }}</span>\n              </dd>\n            </dl>\n          </div>\n          <div class=\"row\" ng-show=\"plugin.type\">\n            <dl>\n              <dt apiman-i18n-key=\"type\">Type</dt>\n              <dd>\n                <span data-field=\"type\">{{ plugin.type }}</span>\n              </dd>\n            </dl>\n          </div>\n        </div>\n        <!-- Right column -->\n        <div class=\"col-md-6 container\">\n          <div class=\"row\">\n            <h3 class=\"\" apiman-i18n-key=\"plugin-info\">Plugin Info</h3>\n          </div>\n          <div class=\"row\">\n            <dl>\n              <dt apiman-i18n-key=\"name\">Name</dt>\n              <dd>\n                <span data-field=\"name\">{{ plugin.name }}</span>\n              </dd>\n            </dl>\n          </div>\n          <div class=\"row\">\n            <dl>\n              <dt apiman-i18n-key=\"description\">Description</dt>\n              <dd>\n                <span data-field=\"description\">{{ plugin.description }}</span>\n              </dd>\n            </dl>\n          </div>\n        </div>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Create Button -->\n      <div class=\"row\">\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default\" apiman-i18n-key=\"ok\">OK</a>\n        <button style=\"margin-left: 15px\" id=\"reload\" ng-show=\"plugin.isSnapshot\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"reloadButton\" apiman-i18n-key=\"reload\" placeholder=\"Reloading...\" data-icon=\"fa-cog\" ng-click=\"reload()\">Reload</button>\n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/edit-policy.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\"\n          content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.EditPolicyController\"\n         id=\"form-page\"\n         class=\"container apiman-edit-policy apiman-entity-new page\"\n         data-field=\"page\"\n         ng-cloak=\"\"\n         ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <h2 class=\"title\"\n            data-field=\"heading\"\n            apiman-i18n-key=\"edit-policy\">Edit Policy</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p class=\"col-md-6 apiman-label-faded\"\n           apiman-i18n-key=\"edit-policy-help-text\"\n           class=\"apiman-label-faded\">\n          Update this policy\'s configuration settings using the form below.\n        </p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n\n      <!-- Policy Type-specific config -->\n      <div class=\"row\"\n           ng-show=\"include\">\n        <h3 data-field=\"policyHeading\">{{ policy.definition.name }} Configuration</h3>\n        <div class=\"apiman-box col-md-9 container\">\n          <div ng-include=\"include\"></div>\n        </div>\n      </div>\n\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Update Button -->\n      <div class=\"row\">\n        <button id=\"update-policy\"\n                ng-show=\"hasPermission && !isEntityDisabled()\"\n                apiman-action-btn=\"\"\n                ng-click=\"updatePolicy()\"\n                ng-disabled=\"!isValid\"\n                class=\"btn btn-primary\"\n                data-field=\"updateButton\"\n                apiman-i18n-key=\"update-policy\"\n                placeholder=\"Updating...\"\n                data-icon=\"fa-cog\">Update Policy</button>\n        <a id=\"cancel\"\n           data-field=\"cancelButton\"\n           href=\"javascript:window.history.back()\"\n           class=\"btn btn-default btn-cancel\"\n           data-field=\"cancelButton\"\n           apiman-i18n-key=\"cancel\">Cancel</a>\n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/edit-policyDef.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.EditPolicyDefController\" id=\"form-page\" class=\"container apiman-edit-policy apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n\n      <div class=\"row\">\n        <h2 class=\"title\" data-field=\"heading\" apiman-i18n-key=\"edit-policy-def\">Edit Policy Definition</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p class=\"col-md-6 apiman-label-faded\" apiman-i18n-key=\"edit-policy-def-help-text\" class=\"apiman-label-faded\">Update this policy definition\'s configuration settings using the form below.</p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Policy Type-specific config -->\n      <div class=\"row\">\n        <h3 data-field=\"policyHeading\">Policy Configuration<i> </i></h3>\n        <div class=\"apiman-box col-md-9 container\" data-field=\"policyFormWrapper\">\n          <div class=\"form policy-config default\">\n            <span apiman-i18n-key=\"manually-configure-policy-json\">Please manually configure your policy\'s JSON configuration below.</span>\n            <textarea id=\"json\" ng-model=\"policyDefJSON\">{{ policyDefJSON }}</textarea>\n          </div>\n        </div>\n      </div>\n\n      <!-- HR -->\n      <div class=\"row hr-row\" apiman-status=\"Created,Ready\">\n        <hr/>\n      </div>\n      <!-- Update Button -->\n      <div class=\"row\" apiman-status=\"Created,Ready\">\n        <button id=\"update-policy\" class=\"btn btn-primary\" data-field=\"updateButton\" apiman-i18n-key=\"update-policy\" placeholder=\"Updating...\" data-icon=\"fa-cog\" ng-click=\"updatePolicyDef()\">Update Policy</button>\n        <a id=\"cancel\" data-field=\"cancelButton\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/edit-role.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.EditRoleController\" id=\"form-page\" class=\"container apiman-edit-role apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\"><span apiman-i18n-key=\"edit-role\">Edit Role</span></h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"edit-role-help-text\" class=\"col-md-6 apiman-label-faded\">Update this role\'s definition, including description and assigned permissions.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Role name -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"role\">Role</dt>\r\n          <dd>\r\n            <input id=\"apiman-role-name\" ng-model=\"role.name\" type=\"text\" class=\"apiman-form-control form-control name entityname\" disabled=\"disabled\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Description of role -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"description\">Description</dt>\r\n          <dd>\r\n            <textarea ng-model=\"role.description\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-role-description\" placeholder=\"Enter role description (optional)...\"></textarea>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Auto-grant this role -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"auto-grant\">Auto-Grant Role</dt>\r\n          <dd>\r\n             <div class=\"checkbox\">\r\n               <label>\r\n                 <input id=\"auto-grant\" ng-model=\"role.autoGrant\" data-field=\"autoGrant\" type=\"checkbox\"></input> \r\n                 <span apiman-i18n-key=\"grant-role-automatically\">Grant this role automatically when creating a new Organization</span>\r\n               </label>\r\n             </div>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Permissions -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"permissions\">Permissions</dt>\r\n          <dd>\r\n            <div class=\"container\">\r\n              <div class=\"row\" data-field=\"permissions\">\r\n                <div class=\"col-md-3\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"org-view\" ng-model=\"rolePermissions[\'orgView\']\" data-field=\"orgView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.orgView\">Organization View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"org-edit\" ng-model=\"rolePermissions[\'orgEdit\']\" data-field=\"orgEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.orgEdit\">Organization Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"org-admin\" ng-model=\"rolePermissions[\'orgAdmin\']\" data-field=\"orgAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.orgAdmin\">Organization Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n                <div class=\"col-md-2\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"plan-view\" ng-model=\"rolePermissions[\'planView\']\" data-field=\"planView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.planView\">Plan View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"plan-edit\" ng-model=\"rolePermissions[\'planEdit\']\" data-field=\"planEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.planEdit\">Plan Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"plan-admin\" ng-model=\"rolePermissions[\'planAdmin\']\" data-field=\"planAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.planAdmin\">Plan Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n                <div class=\"col-md-2\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"api-view\" ng-model=\"rolePermissions[\'apiView\']\" data-field=\"apiView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.apiView\">API View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"api-edit\" ng-model=\"rolePermissions[\'apiEdit\']\" data-field=\"apiEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.apiEdit\">API Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"api-admin\" ng-model=\"rolePermissions[\'apiAdmin\']\" data-field=\"apiAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.apiAdmin\">API Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n                <div class=\"col-md-2\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"client-view\" ng-model=\"rolePermissions[\'clientView\']\" data-field=\"clientView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.clientView\">Client App View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"client-edit\" ng-model=\"rolePermissions[\'clientEdit\']\" data-field=\"clientEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.clientEdit\">Client App Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"client-admin\" ng-model=\"rolePermissions[\'clientAdmin\']\" data-field=\"clientAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.clientAdmin\">Client App Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"update-role\" ng-disabled=\"!isValid\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"updateButton\" apiman-i18n-key=\"update-role\" placeholder=\"Updating...\" data-icon=\"fa-cog\" ng-click=\"updateRole()\">Update Role</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n        <button id=\"delete-role\" apiman-action-btn=\"\" class=\"btn btn-danger\" style=\"margin-left: 100px;\" data-field=\"deleteButton\" apiman-i18n-key=\"delete-role\" placeholder=\"Deleting...\" data-icon=\"fa-cog\" ng-click=\"deleteRole()\">Delete Role</button>\r\n      </div>\r\n\r\n      <div ng-include=\"\'plugins/api-manager/html/modals/confirmModal.html\'\"></div>\r\n\r\n    </div> <!-- /container -->\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/import-policyDefs.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.ImportPolicyDefsController\" id=\"form-page\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"import-policy-defs\">Import Policy Definition(s)</h2>\n      </div>\n      <div id=\"dataPage\" ng-show=\"isData\">\n        <!-- Helpful hint -->\n        <div class=\"row\">\n          <p apiman-i18n-key=\"import-policy-defs-help-text\" class=\"col-md-6 apiman-label-faded\">Import one or more policy definition.  Simply copy/paste (or drag and drop!) the policy definition data into the text area below and click Import - we\'ll do the rest!  Make sure the data is properly formatted JSON.</p>\n        </div>\n        <!-- HR -->\n        <div class=\"row hr-row\">\n          <hr/>\n        </div>\n        <!-- Choose policyDef name -->\n        <div class=\"row\">\n          <dl>\n            <dt apiman-i18n-key=\"policyDef-data\">Policy Definition Data</dt>\n            <dd>\n              <textarea id=\"data\" apiman-drop-text ng-model=\"policyDefsJSON\" data-field=\"data\" class=\"apiman-form-control form-control apiman-form-data\" width=\"100%\"></textarea>\n              <div class=\"alert alert-warning\" ng-show=\"!isValid && policyDefsJSON\" style=\"margin-top: 15px\">\n                 <span class=\"pficon pficon-info\"></span>\n                 <span apiman-i18n-key=\"invalid-policy-def-data-message\">The policy definition data above is not valid.  Please make sure to type/copy a valid Policy Definition JSON document.</span>\n              </div>\n            </dd>\n          </dl>\n        </div>\n        <!-- HR -->\n        <div class=\"row hr-row\">\n          <hr/>\n        </div>\n        <!-- Import Button -->\n        <div class=\"row\">\n          <button id=\"import\" ng-disabled=\"!isValid\" class=\"btn btn-primary\" apiman-i18n-key=\"import\" placeholder=\"Importing\" data-icon=\"fa-cog\"  ng-click=\"parseJSON()\">Import</button>\n          <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\n        </div>\n      </div>\n\n      <div id=\"confirmPage\" ng-show=\"isConfirm\">\n        <div class=\"row\">\n          <table class=\"table table-striped table-bordered table-hover table-responsive\" data-field=\"policyDefs\">\n            <thead>\n              <tr>\n                <th apiman-i18n-key=\"policy\">Policy</th>\n                <th class=\"no-phone\" apiman-i18n-key=\"implementation.header\">Implementation</th>\n              </tr>\n            </thead>\n            <tbody>\n              <tr ng-repeat=\"policyDef in policyDefs\">\n                <td><i class=\"fa fa-{{policyDef.icon}} fa-fw\"></i><span>{{ policyDef.name }}</span></td>\n                <td class=\"no-phone\">{{ policyDef.policyImpl }}</td>\n              </tr>\n            </tbody>\n          </table>\n        </div>\n        <div class=\"row\">\n          <p apiman-i18n-key=\"confirm-import-policyDefs\">Really import the policy definition(s) listed above?</p>\n        </div>\n        <!-- Confirm Button  -->\n        <div class=\"row\">\n          <button id=\"yes\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"yesButton\" apiman-i18n-key=\"yes\" placeholder=\"Importing...\" data-icon=\"fa-cog\" ng-click=\"importPolicyDefs()\">Yes</button>\n          <a id=\"no\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"noButton\" apiman-i18n-key=\"no\">No</a>\n        </div>\n\n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/new-api.html","    <!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"></meta>\r\n    \r\n  </head>\r\n\r\n  <body>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.NewApiController\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" apiman-i18n-key=\"new-api\">New API</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"new-api-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new API within the specified Organization, allowing Client Apps to begin consuming it.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Choose org and api name -->\r\n      <div ng-show=\"organizations.length > 0\">\r\n        <div class=\"row\">\r\n          <dl class=\"org\">\r\n            <dt apiman-i18n-key=\"organization\">Organization</dt>\r\n            <dd>\r\n              <div class=\"btn-group\" data-field=\"orgSelector\">\r\n                <button type=\"button\" id=\"selector-org\" class=\"btn btn-default dropdown-toggle\" data-toggle=\"dropdown\">\r\n                  <span data-field=\"selectorLabel\" id=\"selector-org-value\">{{selectedOrg.name}}</span> &nbsp;&nbsp;<span class=\"caret\"></span>\r\n                </button>\r\n                <ul class=\"dropdown-menu\" data-field=\"organizations\">\r\n                   <li ng-repeat=\"org in organizations\"><a href=\"#\" ng-click=\"setOrg( org )\">{{ org.name }}</a></li>\r\n                </ul>\r\n              </div>\r\n            </dd>\r\n          </dl>\r\n          <dl class=\"slash\">\r\n            <dt apiman-i18n-skip>&nbsp;</dt>\r\n            <dd>\r\n              <span class=\"divider\" apiman-i18n-skip>/</span>\r\n            </dd>\r\n          </dl>\r\n          <dl class=\"name\">\r\n            <dt apiman-i18n-key=\"api-name\">API Name</dt>\r\n            <dd>\r\n              <input ng-model=\"api.name\" data-field=\"name\" type=\"text\" class=\"apiman-form-control form-control entityname\" id=\"apiman-entityname\" apiman-i18n-key=\"enter-api-name\" placeholder=\"Enter API name...\"></input>\r\n            </dd>\r\n          </dl>\r\n        </div>\r\n        <!-- Initial API Version -->\r\n        <div class=\"row\">\r\n          <dl>\r\n            <dt apiman-i18n-key=\"initial-version\">Initial Version</dt>\r\n            <dd>\r\n              <input ng-model=\"api.initialVersion\" data-field=\"version\" type=\"text\" class=\"apiman-form-control form-control version\" id=\"apiman-version\" value=\"1.0\"></input>\r\n            </dd>\r\n          </dl>\r\n        </div>\r\n        <!-- Description of api -->\r\n        <div class=\"row\">\r\n          <dl>\r\n            <dt apiman-i18n-key=\"description\">Description</dt>\r\n            <dd>\r\n              <textarea ng-model=\"api.description\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-api-description\" placeholder=\"Enter API description (optional)...\"></textarea>\r\n            </dd>\r\n          </dl>\r\n        </div>\r\n      </div>\r\n      <div ng-hide=\"organizations.length > 0\" class=\"apiman-no-content container-fluid\">\r\n        <div class=\"row\">\r\n          <div class=\"col-md-12\">\r\n            <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"missing-create-api-permission\">You don\'t have permission to create an API in any of your Organizations (or you aren\'t in any orgs)!  Please become a member of an existing Organization or create a new one before trying to create an API.</p>\r\n          </div>\r\n        </div>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"create-api\" ng-disabled=\"!api.name || !api.initialVersion || !selectedOrg\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-api\" placeholder=\"Creating...\" data-icon=\"fa-cog\" ng-click=\"saveNewApi()\">Create API</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/new-apiversion.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.NewApiVersionController\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" apiman-i18n-key=\"new-api-version\">New API Version</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"new-apiversion-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new version of this API, allowing multiple different versions of the API to be managed at the same time.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- API Version -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"version\">Version</dt>\r\n          <dd>\r\n            <input ng-model=\"apiversion.version\" data-field=\"version\" type=\"text\" class=\"apiman-form-control form-control version\" id=\"apiman-version\" apiman-i18n-key=\"enter-api-version\" placeholder=\"Enter version...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dd>\r\n            <input ng-model=\"apiversion.clone\" type=\"checkbox\" id=\"cloneCB\" data-field=\"cloneCB\">\r\n            <label for=\"cloneCB\" apiman-i18n-key=\"make-clone\">Make a clone of the previously selected version (copy all policies and settings)</label>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"create-version\" ng-disabled=\"!apiversion.version\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-version\" placeholder=\"Creating...\" data-icon=\"fa-cog\" ng-click=\"saveNewApiVersion()\">Create Version</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/new-client.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"></meta>\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.NewClientController\" id=\"form-page\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" apiman-i18n-key=\"new-client-client\">New Client App</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"new-client-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new Client App within the specified Organization, allowing you to begin connecting provided APIs with your Client App.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Choose org and client name -->\r\n      <div ng-show=\"organizations.length > 0\">\r\n        <div class=\"row\">\r\n          <dl class=\"org\">\r\n            <dt apiman-i18n-key=\"organization\">Organization</dt>\r\n            <dd>\r\n              <div class=\"btn-group\" data-field=\"orgSelector\">\r\n                <button type=\"button\" id=\"selector-org\" class=\"btn btn-default dropdown-toggle\" data-toggle=\"dropdown\" data-field=\"button\">\r\n                  <span id=\"selector-org-value\">{{selectedOrg.name}}</span> &nbsp;&nbsp;<span class=\"caret\"></span>\r\n                </button>\r\n                <ul class=\"dropdown-menu\" data-field=\"organizations\">\r\n                   <li ng-repeat=\"org in organizations\"><a href=\"#\" ng-click=\"setOrg( org )\">{{ org.name }}</a></li>\r\n                </ul>\r\n              </div>\r\n            </dd>\r\n          </dl>\r\n          <dl class=\"slash\">\r\n            <dt apiman-i18n-skip>&nbsp;</dt>\r\n            <dd>\r\n              <span class=\"divider\" apiman-i18n-skip>/</span>\r\n            </dd>\r\n          </dl>\r\n          <dl class=\"name\">\r\n            <dt apiman-i18n-key=\"client-client-name\">Client App Name</dt>\r\n            <dd>\r\n              <input ng-model=\"client.name\" data-field=\"name\" type=\"text\" class=\"apiman-form-control form-control entityname\" id=\"apiman-entityname\" apiman-i18n-key=\"enter-client-name\" placeholder=\"Enter client app name...\"></input>\r\n            </dd>\r\n          </dl>\r\n        </div>\r\n        <!-- Initial Client App Version -->\r\n        <div class=\"row\">\r\n          <dl>\r\n            <dt apiman-i18n-key=\"initial-version\">Initial Version</dt>\r\n            <dd>\r\n              <input ng-model=\"client.initialVersion\" data-field=\"version\" type=\"text\" class=\"apiman-form-control form-control version\" id=\"apiman-version\"></input>\r\n            </dd>\r\n          </dl>\r\n        </div>\r\n        <!-- Description of client -->\r\n        <div class=\"row\">\r\n          <dl>\r\n            <dt apiman-i18n-key=\"description\">Description</dt>\r\n            <dd>\r\n              <textarea ng-model=\"client.description\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-client-description\" placeholder=\"Enter client app description (optional)...\"></textarea>\r\n            </dd>\r\n          </dl>\r\n        </div>\r\n      </div>\r\n      <div ng-hide=\"organizations.length > 0\" class=\"apiman-no-content container-fluid\">\r\n        <div class=\"row\">\r\n          <div class=\"col-md-12\">\r\n            <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"missing-create-client-permission\">You don\'t have permission to create a Client App in any of your Organizations (or you aren\'t in any orgs)!  Please become a member of an existing Organization or create a new one before trying to create a Client App.</p>\r\n          </div>\r\n        </div>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"create-client\" ng-disabled=\"!client.name || !client.initialVersion || !selectedOrg\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-client-client\" placeholder=\"Creating...\" data-icon=\"fa-cog\" ng-click=\"saveNewClient()\">Create Client App</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/new-clientversion.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.NewClientVersionController\" id=\"form-page\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"new-client-version\">New Client App Version</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p apiman-i18n-key=\"new-clientversion-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new version of this Client App, allowing multiple different versions of the Client App to be managed at the same time.</p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Client App Version -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"version\">Version</dt>\n          <dd>\n            <input ng-model=\"clientversion.version\" type=\"text\" class=\"apiman-form-control form-control version\" id=\"apiman-version\" apiman-i18n-key=\"enter-client-version\" placeholder=\"Enter version...\"></input>\n          </dd>\n        </dl>\n      </div>\n      <div class=\"row\">\n        <dl>\n          <dd>\n            <table>\n              <tr>\n                <td><input ng-model=\"clientversion.clone\" type=\"checkbox\" id=\"cloneCB\" data-field=\"cloneCB\"></td>\n                <td><label style=\"margin-left: 4px; padding-top: 2px\" for=\"cloneCB\" apiman-i18n-key=\"make-clone\">Make a clone of the previously selected version (copy all policies and settings)</label></td>\n              </tr>\n            </table>\n          </dd>\n        </dl>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Create Button -->\n      <div class=\"row\">\n        <button id=\"create-version\" ng-disabled=\"!clientversion.version\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-version\" placeholder=\"Creating...\" data-icon=\"fa-cog\" ng-click=\"saveNewClientVersion()\">Create Version</button>\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/new-contract.html","<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"></meta>\n</head>\n\n<body>\n\n<div ng-include=\"headerInclude\"></div>\n<div ng-controller=\"Apiman.NewContractController\" id=\"form-page\" class=\"container apiman-new-contract apiman-entity-new page\" data-field=\"page\">\n    <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"new-contract\">New Contract</h2>\n    </div>\n    <!-- Helpful hint -->\n    <div class=\"row\">\n        <p class=\"col-md-6 apiman-label-faded\" apiman-i18n-key=\"new-contract-help-text\" class=\"apiman-label-faded\">Creating a Contract allows you to connect a Client App to an API via a particular Plan offered by the API. You would want to do this so that your Client App can invoke the API successfully. Note that this is not necessary if the API is public.</p>\n    </div>\n    <!-- HR -->\n    <div class=\"row hr-row\">\n        <hr/>\n    </div>\n\n    <div id=\"new-contract-form\" class=\"new-contract-form row\">\n        <div class=\"col-md-6\">\n            <div class=\"client\" ng-class=\"{ selected : selectedClientVersion }\">\n                <div class=\"title\"><i class=\"fa fa-gears fa-fw\"></i> <span apiman-i18n-key=\"from-client\">From Client App</span></div>\n                <div class=\"body\">\n                    <p apiman-i18n-key=\"new-contract.client-description\">\n                        The Client App that will be used as the source of the new API Contract.  Choose one \n                        of your available Client Apps below, and then choose a Client App version.\n                    </p>\n                    <div class=\"center-content\" ng-show=\"clients.length > 0\">\n                        <ui-select ng-model=\"selectedClient\"\n                                   on-select=\"changedClient($item)\"\n                                   search-enabled=\"true\">\n                            <ui-select-match placeholder=\"Select a Client Application\" apiman-i18n-key=\"select-client\">\n                                <span ng-bind=\"$select.selected.organizationName + \' / \' + $select.selected.name\"></span>\n                            </ui-select-match>\n                            <ui-select-choices repeat=\"client in (clients | filter: $select.search) track by client.id\">\n                                <span ng-bind=\"client.organizationName + \' / \' + client.name\"></span>\n                            </ui-select-choices>\n                        </ui-select>\n                <span class=\"slash\" apiman-i18n-skip=\"\">&nbsp;</span>\n                        <ui-select ng-model=\"selectedClientVersion\"\n                                   search-enabled=\"true\">\n                            <ui-select-match placeholder=\"Select a Version\" apiman-i18n-key=\"select-client-version\">\n                                <span ng-bind=\"$select.selected\"></span>\n                            </ui-select-match>\n                            <ui-select-choices repeat=\"version in (clientVersions | filter: $select.search) track by version\">\n                                <span ng-bind=\"version\"></span>\n                            </ui-select-choices>\n                        </ui-select>\n                    </div>\n\n                    <div class=\"alert alert-warning\" ng-show=\"clients.length > 0 && selectedClient && clientVersions.length == 0\" style=\"margin-top: 10px\">\n                        <span class=\"pficon pficon-info\"></span>\n                 <span apiman-i18n-key=\"new-contract.no-client-versions\">\n                   There are no versions of the selected Client App that can be registered.  For example, if a\n                   Client App is Retired you will not be able to create a Contract for it.\n                 </span>\n                    </div>\n                    <div class=\"alert alert-warning\" ng-show=\"clients.length == 0\">\n                        <span class=\"pficon pficon-info\"></span>\n                 <span apiman-i18n-key=\"new-contract.no-clients-found\">\n                   We couldn\'t find any Client Apps for you - you must manage at least one\n                   Client App in order to create a Contract.\n                 </span>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"clearfix\"></div>\n\n        <div class=\"col-md-6\">\n            <div class=\"arrow to-plan-arrow\" apiman-i18n-skip>&nbsp;</div>\n        </div>\n\n        <div class=\"clearfix\"></div>\n\n        <div class=\"col-md-6\">\n            <div class=\"plan\" ng-class=\"{ selected : selectedPlan }\">\n                <div class=\"title\"><i class=\"fa fa-bar-chart-o fa-fw\"></i> <span apiman-i18n-key=\"using-plan\">Using Plan</span></div>\n                <div class=\"body\">\n                    <p ng-show=\"!plans\" apiman-i18n-key=\"new-contract.choose-valid-api-msg\">\n                      Please choose a valid API below before selecting the Plan you wish to use for\n                      this Contract (either you have not selected an API or the API has no \n                      available plans).\n                    </p>\n                    <p apiman-i18n-key=\"new-contract.plan-description\" ng-show=\"plans\" apiman-i18n-key=\"new-contract.choose-plan-msg\">\n                        Use the drop-down below to choose one of the Plans made available by the selected API.\n                    </p>\n                    <div class=\"center-content\" ng-show=\"plans\">\n                        <ui-select ng-model=\"selectedPlan\"\n                                   on-select=\"changedPlan($item)\">\n                            <ui-select-match placeholder=\"Select a Plan\"\n                                             apiman-i18n-key=\"select-plan\">\n                                <span ng-bind=\"$select.selected.planName\"></span>\n                            </ui-select-match>\n                            <ui-select-choices repeat=\"plan in (plans | filter: $select.search) track by plan.planName\">\n                                <span ng-bind=\"plan.planName\"></span>\n                            </ui-select-choices>\n                        </ui-select>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"clearfix\"></div>\n\n        <div class=\"col-md-6\">\n            <div class=\"arrow to-api-arrow\" apiman-i18n-skip>&nbsp;</div>\n        </div>\n\n        <div class=\"clearfix\"></div>\n\n        <div class=\"col-md-6\">\n            <div class=\"api\" ng-class=\"{ selected : selectedApi }\">\n                <div class=\"title\"><i class=\"fa fa-puzzle-piece fa-fw\"></i> <span apiman-i18n-key=\"to-api\">To API</span></div>\n                <div class=\"body\">\n                    <p apiman-i18n-key=\"new-contract.api-description\">\n                      Use this section to choose what API the Client App will be consuming (aka the\n                      \"target\" of this API Contract).\n                    </p>\n                    <div class=\"center-content\">\n                        <button ng-click=\"selectApi()\" class=\"btn btn-default btn-api\" ng-show=\"selectedApi\">\n                            <span>{{ selectedApi.organizationName }}</span>\n                            <span apiman-i18n-skip> / </span>\n                            <span class=\"emphasis\">{{ selectedApi.name }}</span>\n                            <span apiman-i18n-skip>&#8680;</span>\n                            <span>{{ selectedApi.version }}</span>\n                        </button>\n                        <button id=\"api\" ng-click=\"selectApi()\" class=\"btn btn-default btn-api btn-primary\" ng-show=\"!selectedApi\">\n                            <span apiman-i18n-key=\"select-api\">Select an API</span>\n                        </button>\n                        <div class=\"clearfix\"/>\n                    </div>\n                    <div style=\"text-align: center;\">\n                        <span style=\"font-size: 10px;\" ng-show=\"selectedApi\" apiman-i18n-key=\"new-contract.click-to-change\">(click to change)</span>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div> <!-- /new-contract-form -->\n\n    <div class=\"row hr-row\">\n        <hr/>\n    </div>\n\n    <div class=\"row\">\n        <button id=\"create-contract\" ng-click=\"createContract()\" apiman-action-btn=\"\" ng-disabled=\"isDisabled()\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-contract\" placeholder=\"Creating...\" data-icon=\"fa-cog\">Create Contract</button>\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\n    </div>\n\n    <div ng-include=\"\'plugins/api-manager/html/modals/selectApiModal.html\'\"></div>\n\n</div> <!-- /container -->\n</body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/new-gateway.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>   \r\n    <div ng-controller=\"Apiman.NewGatewayController\" id=\"form-page\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <fieldset>\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" apiman-i18n-key=\"new-gateway\">New Gateway</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"new-gateway-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new API Gateway for use by APIs.  When publishing an API, at least one Gateway must be specified so that API configuration details can be published to the appropriate place.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Choose gateway name -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"gateway-name\">Gateway Name</dt>\r\n          <dd>\r\n            <input id=\"apiman-gateway-name\" ng-model=\"gateway.name\" name=\"name\" type=\"text\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"enter-gateway-name\" placeholder=\"Enter gateway name...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Description of gateway -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"description\">Description</dt>\r\n          <dd>\r\n            <textarea ng-model=\"gateway.description\" data-field=\"description\" type=\"text\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-gateway-description\" placeholder=\"Enter gateway description (optional)...\"></textarea>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Configuration Endpoint -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"config-endpoint\">Configuration Endpoint</dt>\r\n          <dd>\r\n            <input ng-model=\"configuration.endpoint\" type=\"url\" name=\"configEndpoint\" type=\"text\" class=\"apiman-form-control form-control description\" id=\"config-endpoint\" apiman-i18n-key=\"enter-gateway-config-endpoint\" placeholder=\"Enter configuration endpoint...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Authentication Credentials -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"credentials\">Configuration Endpoint Credentials</dt>\r\n          <dd>\r\n            <table class=\"form-table\">\r\n              <tr>\r\n                <td class=\"td-label\">\r\n                  <span apiman-i18n-key=\"username\">Username:</span>\r\n                </td>\r\n                <td>\r\n                  <input id=\"endpoint-username\" ng-model=\"configuration.username\" name=\"username\" type=\"text\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"enter-gateway-username\" placeholder=\"Username...\"></input>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td class=\"td-label\">\r\n                  <span apiman-i18n-key=\"password\">Password:</span>\r\n                </td>\r\n                <td>\r\n                  <input id=\"endpoint-password\" ng-model=\"configuration.password\" data-field=\"password\" type=\"password\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"enter-gateway-password\" placeholder=\"Password...\"></input>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td></td>\r\n                <td>\r\n                  <input id=\"endpoint-password-confirm\" ng-model=\"passwordConfirm\" data-field=\"passwordConfirm\" type=\"password\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"enter-gateway-password-confirm\" placeholder=\"Confirm Password...\"></input>\r\n                </td>\r\n              </tr>\r\n            </table>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <div class=\"row\">\r\n        <button id=\"test-gateway\" ng-disabled=\"!isValid\" apiman-action-btn=\"\" data-field=\"testButton\" ng-click=\"testGateway()\" class=\"btn btn-default\" name=\"testButton\" apiman-i18n-key=\"test-gateway\" placeholder=\"Testing...\" data-icon=\"fa-cog\">Test Gateway</button>\r\n      </div>\r\n      <div class=\"row\" ng-show=\"testResult == \'success\'\">\r\n        <div class=\"alert alert-success description\" style=\"margin-top: 10px\">\r\n          <span class=\"pficon pficon-ok\"></span>\r\n          <strong apiman-i18n-key=\"gateway-config-valid.title\">Gateway Configuration Valid</strong> \r\n          <div apiman-i18n-key=\"gateway-config-valid.msg\">Your Gateway configuration is correct.  Great job!</div>\r\n        </div>\r\n      </div>\r\n      <div class=\"row\" ng-show=\"testResult == \'error\'\">\r\n        <div class=\"alert alert-danger description\" style=\"margin-top: 10px\">\r\n          <span class=\"pficon-layered\">\r\n            <span class=\"pficon pficon-error-octagon\"></span>\r\n            <span class=\"pficon pficon-error-exclamation\"></span>\r\n          </span>\r\n          <strong apiman-i18n-key=\"gateway-config-invalid.title\">Gateway Configuration Invalid</strong>\r\n          <div apiman-i18n-key=\"gateway-config-invalid.msg\">Something has gone wrong when testing the Gateway.  Hopefully the details (below) will help you figure out what.</div>\r\n          <div style=\"margin-top: 8px\">\r\n            <pre>{{ testErrorMessage }}</pre>\r\n          </div>\r\n        </div>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"create-gateway\" ng-disabled=\"!isValid\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" name=\"createButton\" apiman-i18n-key=\"create-gateway\" placeholder=\"Creating...\" data-icon=\"fa-cog\" ng-click=\"createGateway()\">Create Gateway</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n      </fieldset>\r\n    </div> <!-- /container -->\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/new-org.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"></meta>\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.NewOrgController\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" apiman-i18n-key=\"new-organization\">New Organization</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"new-org-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new Organization within which to manage your APIs and Client Apps.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Choose org and client name -->\r\n      <div class=\"row\">\r\n        <dl class=\"name\">\r\n          <dt apiman-i18n-key=\"organization-name\">Organization Name</dt>\r\n          <dd>\r\n            <input ng-model=\"org.name\" data-field=\"name\" type=\"text\" class=\"apiman-form-control form-control entityname\" id=\"apiman-entityname\" apiman-i18n-key=\"enter-org-name\" placeholder=\"Enter organization name...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Description of client -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"description\">Description</dt>\r\n          <dd>\r\n            <input ng-model=\"org.description\" data-field=\"description\" type=\"text\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-org-description\" placeholder=\"Enter description (optional)...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Add Button -->\r\n      <div class=\"row\">\r\n        <button ng-disabled=\"!org.name\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-organization\" placeholder=\"Creating...\" data-icon=\"fa-cog\"  ng-click=\"saveNewOrg()\">Create Organization</button>\r\n        <a href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/new-plan.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"></meta>\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.NewPlanController\" id=\"form-page\" class=\"container apiman-entity-new page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" apiman-i18n-key=\"new-plan\">New Plan</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"new-plan-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new Plan within the specified Organization, allowing you to assign groups of Policies to APIs.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Choose org and plan name -->\r\n      <div class=\"row\">\r\n        <dl class=\"org\">\r\n          <dt apiman-i18n-key=\"organization\">Organization</dt>\r\n          <dd>\r\n            <div class=\"btn-group\">\r\n              <button type=\"button\" id=\"selector-org\" class=\"btn btn-default dropdown-toggle\" data-toggle=\"dropdown\">\r\n                <span id=\"selector-org-value\">{{selectedOrg.name}}</span> &nbsp;&nbsp;<span class=\"caret\"></span>\r\n              </button>\r\n              <ul class=\"dropdown-menu\">\r\n                <li ng-repeat=\"org in organizations\"><a href=\"#\" ng-click=\"setOrg( org )\">{{ org.name }}</a></li>\r\n              </ul>\r\n            </div>\r\n          </dd>\r\n        </dl>\r\n        <dl class=\"slash\">\r\n          <dt apiman-i18n-skip>&nbsp;</dt>\r\n          <dd>\r\n            <span class=\"divider\" apiman-i18n-skip>/</span>\r\n          </dd>\r\n        </dl>\r\n        <dl class=\"name\">\r\n          <dt apiman-i18n-key=\"plan-name\">Plan Name</dt>\r\n          <dd>\r\n            <input ng-model=\"plan.name\" type=\"text\" class=\"apiman-form-control form-control entityname\" id=\"apiman-entityname\" apiman-i18n-key=\"enter-plan-name\" placeholder=\"Enter plan name...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Initial Plan Version -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"initial-version\">Initial Version</dt>\r\n          <dd>\r\n            <input ng-model=\"plan.initialVersion\" type=\"text\" class=\"apiman-form-control form-control version\" id=\"apiman-version\" value=\"1.0\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Description of plan -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"description\">Description</dt>\r\n          <dd>\r\n            <textarea ng-model=\"plan.description\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-plan-description\" placeholder=\"Enter plan description (optional)...\"></textarea>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"create-plan\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-plan\" placeholder=\"Creating...\" data-icon=\"fa-cog\"  ng-click=\"saveNewPlan()\">Create Plan</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n    </div> <!-- /container -->\r\n    </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/new-planversion.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.NewPlanVersionController\" id=\"form-page\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"new-plan-version\">New Plan Version</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p apiman-i18n-key=\"new-planversion-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new version of this Plan, allowing multiple different versions of the Plan to be managed at the same time.</p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Plan Version -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"version\">Version</dt>\n          <dd>\n            <input ng-model=\"planversion.version\" type=\"text\" class=\"apiman-form-control form-control version\" id=\"apiman-version\" apiman-i18n-key=\"enter-plan-version\" placeholder=\"Enter version...\"></input>\n          </dd>\n        </dl>\n      </div>\n      <div class=\"row\">\n        <dl>\n          <dd>\n            <table>\n              <tr>\n                <td><input ng-model=\"planversion.clone\" type=\"checkbox\" id=\"cloneCB\" data-field=\"cloneCB\"></td>\n                <td><label style=\"margin-left: 4px; padding-top: 2px\" for=\"cloneCB\" apiman-i18n-key=\"make-clone\">Make a clone of the previously selected version (copy all policies and settings)</label></td>\n              </tr>\n            </table>\n          </dd>\n        </dl>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Create Button -->\n      <div class=\"row\">\n        <button id=\"create-version\" ng-disabled=\"!planversion.version\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-version\" placeholder=\"Creating...\" data-icon=\"fa-cog\" ng-click=\"saveNewPlanVersion()\">Create Version</button>\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/new-plugin.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.NewPluginController\" id=\"form-page\" class=\"container apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n    <div id=\"form-page\" class=\"\" data-field=\"page\">\n      <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"new-plugin\">Add Plugin</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p apiman-i18n-key=\"new-plugin-help-text\" class=\"col-md-6 apiman-label-faded\">Adds a plugin to the API Manager.  A plugin is identified by its \"coordinates\", which are its maven artifact details (groupId, artifactId, version, classifier, type).  Enter valid values below and click add!</p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <div class=\"row\">\n        <h3 class=\"\" apiman-i18n-key=\"plugin-coordinates\">Plugin Coordinates</h3>\n      </div>\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"group-id\">Group Id</dt>\n          <dd>\n            <input ng-model=\"plugin.groupId\" id=\"apiman-group-id\" data-field=\"groupId\" type=\"text\" class=\"apiman-form-control form-control entityname\" apiman-i18n-key=\"enter-gav-groupid\" placeholder=\"Enter groupId...\"></input>\n          </dd>\n        </dl>\n      </div>\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"artifact-id\">Artifact Id</dt>\n          <dd>\n            <input id=\"artifact-id\" ng-model=\"plugin.artifactId\" type=\"text\" class=\"apiman-form-control form-control entityname\" apiman-i18n-key=\"enter-gav-artifactid\" placeholder=\"Enter artifactId...\"></input>\n          </dd>\n        </dl>\n      </div>\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"version\">Version</dt>\n          <dd>\n            <input id=\"version\" ng-model=\"plugin.version\" type=\"text\" class=\"apiman-form-control form-control entityname\" apiman-i18n-key=\"enter-gav-version\" placeholder=\"Enter version (e.g. 1.0)...\" style=\"width: 175px\"></input>\n          </dd>\n        </dl>\n      </div>\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"classifier.optional\">Classifier (optional)</dt>\n          <dd>\n            <input id=\"classifier\" ng-model=\"plugin.classifier\" type=\"text\" class=\"apiman-form-control form-control entityname\" apiman-i18n-key=\"enter-gav-classifier\" placeholder=\"Enter classifier...\"></input>\n          </dd>\n        </dl>\n      </div>\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"type.optional\">Type (optional)</dt>\n          <dd>\n            <input id=\"type\" ng-model=\"plugin.type\" type=\"text\" class=\"apiman-form-control form-control entityname\" apiman-i18n-key=\"enter-gav-type\" placeholder=\"Enter type (e.g. jar)...\" style=\"width: 175px\"></input>\n          </dd>\n        </dl>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Create Button -->\n      <div class=\"row\">\n        <button id=\"add-plugin\" ng-disabled=\"!isValid\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"addButton\" apiman-i18n-key=\"add-plugin\" placeholder=\"Adding...\" data-icon=\"fa-cog\" ng-click=\"addPlugin()\">Add Plugin</button>\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/forms/new-policy.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.NewPolicyController\" id=\"form-page\" class=\"container apiman-new-policy apiman-entity-new page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" data-field=\"heading\" apiman-i18n-key=\"add-policy\">Add Policy</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p class=\"col-md-6 apiman-label-faded\" apiman-i18n-key=\"new-policy-help-text\" class=\"apiman-label-faded\">Adding a policy will allow its specific functionality to be applied to the API invocation as part of the overall Policy Chain.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Policy Type -->\r\n      <div class=\"row policy-type-row\">\r\n        <dl style=\"width: 100%;\">\r\n          <dt apiman-i18n-key=\"policy-type\">Policy Type</dt>\r\n          <dd>\r\n            <ui-select ng-model=\"selectedDefId\"\r\n                       ng-disabled=\"isEntityDisabled()\"\r\n                       on-select=\"changeSelectedDefId($item)\"\r\n                       style=\"width: 250px\">\r\n              <ui-select-match apiman-i18n-key=\"new-policy.choose-policy-type\" placeholder=\"Choose a policy type...\">\r\n                <i class=\'fa fa-inline fa-fw fa-{{ $select.selected.icon }}\'></i> <span ng-bind=\"$select.selected.name\"></span>\r\n              </ui-select-match>\r\n              <ui-select-choices repeat=\"def in (policyDefs | filter: $select.search | orderBy: \'name.toLowerCase()\')\">\r\n                <i class=\'fa fa-inline fa-fw fa-{{ def.icon }}\'></i> <span ng-bind=\"def.name\"></span>\r\n              </ui-select-choices>\r\n            </ui-select>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n\r\n      <!-- Policy Type-specific config -->\r\n      <div class=\"row\" ng-show=\"include\">\r\n        <h3 data-field=\"policyHeading\">{{ selectedDef.name }} <span apiman-i18n-key=\"configuration\">Configuration</span></h3>\r\n        <div class=\"apiman-box col-md-9 container\">\r\n          <div ng-include=\"include\"></div>\r\n        </div>\r\n      </div>\r\n\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"add-policy\" ng-disabled=\"!isValid\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-policy\" placeholder=\"Adding...\" data-icon=\"fa-cog\" ng-click=\"addPolicy()\">Add Policy</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n    </div> <!-- /container -->\r\n    </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/forms/new-role.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.NewRoleController\" id=\"form-page\" class=\"container apiman-entity-new page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div class=\"row\">\r\n        <h2 class=\"title\" apiman-i18n-key=\"new-role\">New Role</h2>\r\n      </div>\r\n      <!-- Helpful hint -->\r\n      <div class=\"row\">\r\n        <p apiman-i18n-key=\"new-role-help-text\" class=\"col-md-6 apiman-label-faded\">Create a new Role Definition that may be used to grant specific sets of permissions to users within Organizations.</p>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Choose role name -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"role-name\">Role Name</dt>\r\n          <dd>\r\n            <input id=\"apiman-entityname\" ng-model=\"role.name\" type=\"text\" class=\"apiman-form-control form-control name entityname\" apiman-i18n-key=\"enter-role-name\" placeholder=\"Enter role name...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Description of role -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"description\">Description</dt>\r\n          <dd>\r\n            <input data-field=\"description\" ng-model=\"role.description\" type=\"text\" class=\"apiman-form-control form-control description\" id=\"apiman-description\" apiman-i18n-key=\"enter-role-description\" placeholder=\"Enter role description (optional)...\"></input>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Auto-grant this role -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"auto-grant\">Auto-Grant Role</dt>\r\n          <dd>\r\n             <div class=\"checkbox\">\r\n               <label>\r\n                 <input id=\"auto-grant\" ng-model=\"role.autoGrant\" data-field=\"autoGrant\" type=\"checkbox\"></input> \r\n                 <span apiman-i18n-key=\"grant-role-automatically\">Grant this role automatically when creating a new Organization</span>\r\n               </label>\r\n             </div>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- Permissions -->\r\n      <div class=\"row\">\r\n        <dl>\r\n          <dt apiman-i18n-key=\"permissions\">Permissions</dt>\r\n          <dd>\r\n            <div class=\"container\">\r\n              <div class=\"row\" data-field=\"permissions\">\r\n                <div class=\"col-md-3\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"org-view\" ng-model=\"rolePermissions[\'orgView\']\" data-field=\"orgView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.orgView\">Organization View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"org-edit\" ng-model=\"rolePermissions[\'orgEdit\']\" data-field=\"orgEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.orgEdit\">Organization Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"org-admin\" ng-model=\"rolePermissions[\'orgAdmin\']\" data-field=\"orgAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.orgAdmin\">Organization Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n                <div class=\"col-md-2\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"plan-view\" ng-model=\"rolePermissions[\'planView\']\" data-field=\"planView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.planView\">Plan View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"plan-edit\" ng-model=\"rolePermissions[\'planEdit\']\" data-field=\"planEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.planEdit\">Plan Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"plan-admin\" ng-model=\"rolePermissions[\'planAdmin\']\" data-field=\"planAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.planAdmin\">Plan Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n                <div class=\"col-md-2\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"api-view\" ng-model=\"rolePermissions[\'apiView\']\" data-field=\"apiView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.apiView\">API View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"api-edit\" ng-model=\"rolePermissions[\'apiEdit\']\" data-field=\"apiEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.apiEdit\">API Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"api-admin\" ng-model=\"rolePermissions[\'apiAdmin\']\" data-field=\"apiAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.apiAdmin\">API Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n                <div class=\"col-md-2\">\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"client-view\" ng-model=\"rolePermissions[\'clientView\']\" data-field=\"clientView\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.clientView\">Client App View</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"client-edit\" ng-model=\"rolePermissions[\'clientEdit\']\" data-field=\"clientEdit\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.clientEdit\">Client App Edit</span>\r\n                    </label>\r\n                  </div>\r\n                  <div class=\"checkbox\">\r\n                    <label>\r\n                      <input id=\"client-admin\" ng-model=\"rolePermissions[\'clientAdmin\']\" data-field=\"clientAdmin\" type=\"checkbox\"> <span apiman-i18n-key=\"permission.clientAdmin\">Client App Admin</span>\r\n                    </label>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </dd>\r\n        </dl>\r\n      </div>\r\n      <!-- HR -->\r\n      <div class=\"row hr-row\">\r\n        <hr/>\r\n      </div>\r\n      <!-- Create Button -->\r\n      <div class=\"row\">\r\n        <button id=\"create-role\" ng-disabled=\"!isValid\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"createButton\" apiman-i18n-key=\"create-role\" placeholder=\"Creating...\" data-icon=\"fa-cog\" ng-click=\"addRole()\">Create Role</button>\r\n        <a id=\"cancel\" href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" data-field=\"cancelButton\" apiman-i18n-key=\"cancel\">Cancel</a>\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/modals/confirmModal.html","      <!-- Confirm Modal -->\n      <script type=\"text/ng-template\" id=\"confirmModal.html\">\n        <div class=\"modal-header\">\n          <h3 class=\"modal-title\">{{ title }}</h3>\n        </div>\n        <div class=\"modal-body\">\n          {{ message }}\n        </div>\n        <div class=\"modal-footer\">\n          <button class=\"btn btn-default\"\n                  type=\"button\"\n                  ng-click=\"cancel()\"\n                  apiman-i18n-key=\"cancel\">Cancel</button>\n          <button class=\"btn btn-primary\"\n                  type=\"button\"\n                  ng-click=\"ok()\"\n                  apiman-i18n-key=\"ok\">OK</button>\n        </div>\n      </script>\n");
$templateCache.put("plugins/api-manager/html/modals/getValueModal.html","      <!-- Get Value Modal -->\n      <script type=\"text/ng-template\" id=\"getValueModal.html\">\n        <div class=\"modal-header\">\n          <h3 class=\"modal-title\">{{ title }}</h3>\n        </div>\n        <div class=\"modal-body\">\n          <div class=\"\" style=\"margin-bottom: 15px\">{{ message }}</div>\n          <dl>\n            <dt>{{ label }}</dt>\n            <dd>\n              <input ng-model=\"value\" id=\"uservalue\" class=\"apiman-form-control form-control entityname\" type=\"text\">\n            </dd>\n          </dl>\n        </div>\n        <div class=\"modal-footer\">\n          <button class=\"btn btn-default\"\n                  type=\"button\"\n                  ng-click=\"cancel()\"\n                  apiman-i18n-key=\"cancel\">Cancel</button>\n          <button class=\"btn btn-primary\"\n                  type=\"button\"\n                  ng-click=\"ok()\"\n                  apiman-i18n-key=\"ok\">OK</button>\n        </div>\n      </script>\n");
$templateCache.put("plugins/api-manager/html/modals/selectApiModal.html","    <!-- Modal: Select API -->\n    <script type=\"text/ng-template\" id=\"selectApiModal.html\">\n        <div class=\"modal-header\">\n            <h3 class=\"modal-title\" apiman-i18n-key=\"select-api-title\">Select an API</h3>\n        </div>\n        <div class=\"modal-body modal-select-api\">\n            <p apiman-i18n-key=\"select-api-help\">\n                Select an API by searching for an API by name (or part of a name) and choosing one of the matches.\n            </p>\n            <form ng-submit=\"search()\">\n                <input apiman-i18n-key=\"search-api-name\"\n                       ng-model=\"searchText\"\n                       type=\"text\"\n                       class=\"apiman-form-control form-control input-search\"\n                       placeholder=\"Search by API name...\">\n                <button type=\"submit\"\n                        apiman-action-btn=\"\"\n                        class=\"btn btn-default btn-search\"\n                        data-field=\"searchButton\"\n                        apiman-i18n-key=\"search\"\n                        data-icon=\"fa-cog\"\n                        placeholder=\"Searching\">Search\n                </button>\n            </form>\n            <div class=\"clearfix\"></div>\n            <div class=\"panel panel-default input-search-results\">\n                <div class=\"panel-body container-fluid\" data-field=\"apis\">\n                    <a ng-click=\"onApiSelected(api)\"\n                       href=\"#\" class=\"item\" ng-repeat=\"api in apis\"\n                       ng-class=\"{ selected : api.selected }\">\n                        <i class=\"fa fa-puzzle-piece fa-fw\"></i>\n                        <span class=\"\">{{ api.organizationName }}</span>\n                        <span apiman-i18n-skip> / </span>\n                        <span class=\"emphasis\">{{ api.name }}</span>\n                    </a>\n                    <div class=\"alert alert-info\" ng-show=\"!apis && criteria\">\n                        <span class=\"pficon pficon-info\"></span>\n                        <span apiman-i18n-key=\"no-apis-matched\">\n                          No APIs found matching your search.  Please try a different search.\n                        </span>\n                    </div>\n                    <div class=\"alert alert-info\"\n                         ng-show=\"!apis && !criteria\">\n                        <span class=\"pficon pficon-info\"></span>\n                        <span apiman-i18n-key=\"no-api-search-criteria\">\n                          Enter some search criteria above and click Search to find an API.\n                        </span>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"clearfix\"></div>\n            <table ng-show=\"apiVersions\">\n                <tr>\n                    <td>\n                        <span apiman-i18n-key=\"choose-api-version\" class=\"apiman-form-label\">Choose API Version:</span>\n                    </td>\n                    <td style=\"width: 50%;\">\n                        <ui-select ng-model=\"selectedApiVersion\" on-select=\"onApiVersionSelected($item)\" search-enabled=\"true\">\n                            <ui-select-match placeholder=\"Select a Version\" apiman-i18n-key=\"choose-api-version-select\">\n                                <span ng-bind=\"$select.selected.version\"></span>\n                            </ui-select-match>\n                            <ui-select-choices repeat=\"apiVersion in (apiVersions | filter: $select.search) track by apiVersion.version\">\n                                <span ng-bind=\"apiVersion.version\"></span>\n                            </ui-select-choices>\n                        </ui-select>\n                    </td>\n                </tr>\n            </table>\n            <div class=\"alert alert-warning\"\n                 ng-show=\"apiVersions && apiVersions.length == 0\"\n                 style=\"margin-top: 15px\">\n                <span class=\"pficon pficon-info\"></span>\n                <span apiman-i18n-key=\"no-valid-api-versions\">\n                    No valid versions of the selected API were found.\n                </span>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"btn btn-default\"\n                    type=\"button\"\n                    ng-click=\"cancel()\"\n                    apiman-i18n-key=\"cancel\">Cancel</button>\n            <button class=\"btn btn-primary\"\n                    ng-disabled=\"!selectedApiVersion\"\n                    type=\"button\"\n                    ng-click=\"ok()\"\n                    apiman-i18n-key=\"ok\">OK</button>\n        </div>\n    </script>\n");
$templateCache.put("plugins/api-manager/html/org/apiman-user-card-back.html","<div class=\"apiman-card\" data-field=\"card\">\n  <div class=\"back active\">\n    <div class=\"title\">\n      <div class=\"explanation\" data-field=\"editExplanation\">Assign roles to {{member.userId}}</div>\n    </div>\n    <div class=\"body\">\n      <div class=\"card-edit-details\">\n        <div class=\"roles\">\n          <select class=\"selectpicker\" ng-model=\"updatedRoles\" apiman-i18n-key=\"select-member-role\" title=\"Select at least one role...\"\n                  apiman-select-picker=\"\" multiple ng-options=\"role.id as role.name for role in roles\"\n                  ng-select=\"member.roles\">\n          </select>\n        </div>\n        <div class=\"actions\" style=\"margin-top: 5px\">\n          <button class=\"btn btn-primary btn-xs btn-cliently\" apiman-i18n-key=\"apply\" placeholder=\"Applying...\" data-icon=\"fa-cog\" ng-click=\"updateRoles(updatedRoles) && flipCard(front)\">Apply</button>\n\n          <button class=\"btn btn-default btn-xs btn-cancel\" ng-click=\"flipCard(front)\" apiman-i18n-key=\"cancel\">Cancel</button>\n\n          <button class=\"btn btn-danger btn-xs btn-revoke-all\" apiman-i18n-key=\"revoke-all\" placeholder=\"Revoking...\" ng-click=\"revokeAll()\" data-icon=\"fa-cog\">Revoke All</button>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div ng-include=\"\'plugins/api-manager/html/modals/confirmModal.html\'\"></div>\n</div>\n");
$templateCache.put("plugins/api-manager/html/org/apiman-user-card-front.html","<!-- One card per member -->\n<div class=\"apiman-card\" data-field=\"card\">\n  <div class=\"front active\">\n    <div class=\"title\">\n      <div class=\"name\" data-field=\"fullName\" data-role=\"dummy\">{{member.userName}}</div>\n      <div class=\"name\" data-field=\"userId\" data-role=\"dummy\">({{member.userId}})</div>\n      <div class=\"actions\">\n        <a href=\"#\" data-field=\"editButton\" ng-click=\"flipCard(back)\" apiman-i18n-key=\"edit\">Edit</a>\n      </div>\n    </div>\n    <div class=\"body\">\n      <div class=\"card-icon\">\n        <i class=\"fa fa-user\"></i>\n      </div>\n      <div class=\"card-details\">\n        <div class=\"card-details-item\">\n          <div class=\"card-label\" apiman-i18n-key=\"email-label\">Email:</div>\n          <div class=\"card-value\"><a href=\"mailto:{{member.email}}\" data-field=\"email\">{{member.email}}</a></div>\n        </div>\n        <div class=\"card-details-item\">\n          <div class=\"card-label\" apiman-i18n-key=\"roles-label\">Role(s):</div>\n          <div class=\"card-value\" data-field=\"roles\">\n            {{ joinRoles(member.roles) }}\n          </div>\n        </div>\n        <div class=\"card-details-item\">\n          <i class=\"fa fa-clock-o\"></i>\n          <div class=\"apiman-label-faded card-value\" apiman-i18n-key=\"joined-on\">Joined on</div>\n          <div class=\"card-value\" data-field=\"joinedOn\" data-role=\"dummy\">{{ member.joinedOn | date:\'yyyy-MM-dd\' }}</div>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/api-manager/html/org/apiman-user-entry.html","<a href=\"#\" class=\"item\" ng-class=\"{selected: isSelectedUser == true}\" ng-click=\"selectThisUser()\">\n  <i class=\"fa fa-user fa-fw\"></i>\n  <span class=\"\">{{ user.fullName }}</span>\n  <span apiman-i18n-skip>(</span><span class=\"\">{{ user.username }}</span><span apiman-i18n-skip>)</span>\n</a>\n");
$templateCache.put("plugins/api-manager/html/org/org-activity.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    \n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.OrgActivityController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/org/org_bc.include\'\"></div>\n      <div class=\"row\">\n        <div ng-include=\"\'plugins/api-manager/html/org/org_entity.include\'\"></div>\n        <!-- Center Content -->\n        <div class=\"col-md-8\">\n          <div class=\"apiman-entitytabs\">\n            <div ng-include=\"\'plugins/api-manager/html/org/org_tabs.include\'\"></div>\n            <div id=\"entitytabsContent\" class=\"tab-content\">\n\n              <!-- Change Log Tab Content -->\n              <div class=\"tab-pane active\" id=\"tab-activity\">\n                <!-- The org\'s activity stream -->\n                <apiman-activity model=\"auditEntries\" next=\"getNextPage\"/>\n              </div>\n              <!-- End Change Log Tab Content -->\n              \n            </div>\n          </div>\n        </div>\n        <!-- /Center Content -->\n        \n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/org/org-apis.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.OrgApisController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/org/org_bc.include\'\"></div>\r\n      <div class=\"row\">\r\n        <div ng-include=\"\'plugins/api-manager/html/org/org_entity.include\'\"></div>\r\n        <!-- Center Content -->\r\n        <div class=\"col-md-8\">\r\n          <div class=\"apiman-entitytabs\">\r\n            <div ng-include=\"\'plugins/api-manager/html/org/org_tabs.include\'\"></div>\r\n            <div id=\"entitytabsContent\" class=\"tab-content\">\r\n\r\n              <!-- Apis Tab Content -->\r\n              <div class=\"tab-pane active\" id=\"tab-apis\">\r\n                <div class=\"apiman-filters apiman-apis-filters\">\r\n                  <div>\r\n                    <apiman-search-box id=\"apis-filter\" apiman-i18n-key=\"filter-org-apis\" function=\"filterApis\" placeholder=\"Filter by API name...\" />\r\n                  </div>\r\n                  <div apiman-permission=\"apiEdit\" class=\"btn-group pull-right\">\r\n                    <a href=\"{{ pluginName }}/new-api\" class=\"btn btn-primary\" apiman-i18n-key=\"new-api\">New API</a>\r\n                    <button type=\"button\" class=\"btn btn-primary dropdown-toggle\" data-toggle=\"dropdown\">\r\n                      <span class=\"caret\"></span>\r\n                      <span class=\"sr-only\" apiman-i18n-key=\"toggle-dropdown\">Toggle Dropdown</span>\r\n                    </button>\r\n                    <ul class=\"dropdown-menu\" role=\"menu\">\r\n                      <li><a href=\"{{ pluginName }}/orgs/{{ org.id }}/import/apis\" apiman-i18n-key=\"import-apis_\">Import API(s)</a></li>\r\n                    </ul>\r\n                  </div>\r\n                </div>\r\n                <div class=\"clearfix\"></div>\r\n                <!-- The list of apis the user has access to -->\r\n                <div class=\"apiman-apis\" data-field=\"apis\">\r\n\r\n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"apis.length > 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-9\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-apis-found-for-org\">We couldn\'t find any APIs in this organization. Probably because none exist. We hope. Try creating one using the New API button.</p>\r\n                      </div>\r\n                      <div class=\"col-md-3\">\r\n                        <div class=\"apiman-no-entities-arrow\"></div>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"apis.length > 0 && filteredApis.length == 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-12\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-apis-found-for-filter\">No APIs found matching your filter criteria - please try searching for something different.</p>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"api in filteredApis\">\r\n                    <div class=\"row\">\r\n                      <span class=\"title\"><a href=\"{{ pluginName }}/orgs/{{ api.organizationId }}/apis/{{ api.id }}\">{{ api.name }}</a></span>\r\n                      <a class=\"apiman-summaryrow-icon\">\r\n                        <i class=\"fa fa-clock-o fa-fw\"></i>\r\n                        <span class=\"title-summary-item\" apiman-i18n-key=\"created-on\">Created on</span>\r\n                        <span class=\"title-summary-item\">{{ api.createdOn | date:\'yyyy-MM-dd\' }}</span>\r\n                      </a>\r\n                    </div>\r\n                    <div class=\"row\">\r\n                      <span class=\"description\">{{ api.description }}\r\n                      </span>\r\n                    </div>\r\n                    <hr/>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <!-- End Apis Tab Content -->\r\n              \r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Center Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/org/org-clients.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    \n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.OrgClientsController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/org/org_bc.include\'\"></div>\n      <div class=\"row\">\n        <div ng-include=\"\'plugins/api-manager/html/org/org_entity.include\'\"></div>\n        <!-- Center Content -->\n        <div class=\"col-md-8\">\n          <div class=\"apiman-entitytabs\">\n            <div ng-include=\"\'plugins/api-manager/html/org/org_tabs.include\'\"></div>\n            <div id=\"entitytabsContent\" class=\"tab-content\">\n\n              <!-- Client Apps Tab Content -->\n              <div class=\"tab-pane active\" id=\"tab-clients\">\n                <div class=\"apiman-filters apiman-clients-filters\">\n                  <div>\n                    <apiman-search-box id=\"clients-filter\" apiman-i18n-key=\"filter-org-clients\" function=\"filterClients\" placeholder=\"Filter by client app name...\" />\n                  </div>\n                  <a apiman-permission=\"clientEdit\" data-field=\"toNewClient\" href=\"{{ pluginName }}/new-client\" class=\"btn btn-primary pull-right\" apiman-i18n-key=\"new-client\">New Client App</a>\n                </div>\n                <div class=\"clearfix\"></div>\n                <!-- The list of clients in the org -->\n                <div class=\"apiman-clients\" data-field=\"clients\">\n\n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"clients.length > 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-9\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-clients-found-for-org\">It looks like there aren\'t (yet) any client apps in this organization! Now might be a good time to click the New App button up above...</p>\n                      </div>\n                      <div class=\"col-md-3\">\n                        <div class=\"apiman-no-entities-arrow\"></div>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"clients.length > 0 && filteredClients.length == 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-12\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-clients-found-for-filter\">No Client Apps found matching your filter criteria - please try searching for something different.</p>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"client in filteredClients\">\n                    <div class=\"row\">\n                      <span class=\"title\"><a href=\"{{ pluginName }}/orgs/{{org.id}}/clients/{{client.id}}\">{{ client.name }}</a></span>\n                    </div>\n                    <div class=\"row\">\n                      <span class=\"description\">{{ client.description }}\n                      </span>\n                    </div>\n                    <hr/>\n                  </div>\n                </div>\n              </div>\n              <!-- End Client Apps Tab Content -->\n              \n            </div>\n          </div>\n        </div>\n        <!-- /Center Content -->\n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/org/org-manage-members.html","<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n</head>\n\n<body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.OrgManageMembersController as membersCtrl\" class=\"container page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/org/org-manage-members_bc.include\'\"></div>\n      <div class=\"row\">\n        <div class=\"col-md-12\">\n          <div class=\"apiman-filters apiman-members-filters\">\n            <div>\n              <!-- Search for Members by name -->\n              <apiman-search-box id=\"members-filter\" apiman-i18n-key=\"filter-members\" function=\"filterMembers\" placeholder=\"Filter by member name or id...\"></apiman-search-box>\n            </div>\n            <select apiman-i18n-key=\"manage-members.filter-by-roles\" title=\"Filter by role(s)...\" ng-options=\"role.id as role.name for role in roles\" ng-model=\"selectedRoles\" class=\"selectpicker\" apiman-select-picker=\"\" multiple ng-change=\"filterMembers(filterValue)\">\n            </select>\n            <a href=\"{{ pluginName }}/orgs/{{ organizationId }}/new-member\" class=\"btn btn-primary pull-right\" apiman-i18n-key=\"add-member\">Add Member</a>\n          </div>\n        </div>\n      </div>\n      <!-- Member list (cards) -->\n      <div class=\"row\">\n        <div class=\"col-md-12 apiman-manage-members\">\n          <div class=\"container-fluid apiman-cards\" data-field=\"cards\">\n            <div ng-repeat=\"member in filteredMembers\">\n              <apiman-user-card member=\"member\" roles=\"roles\" org-id=\"{{ organizationId }}\"></api-manager-user-card>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</body>\n\n</html>\n");
$templateCache.put("plugins/api-manager/html/org/org-members.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.OrgMembersController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/org/org_bc.include\'\"></div>\r\n      <div class=\"row\">\r\n        <div ng-include=\"\'plugins/api-manager/html/org/org_entity.include\'\"></div>\r\n        <!-- Center Content -->\r\n        <div class=\"col-md-8\">\r\n          <div class=\"apiman-entitytabs\">\r\n            <ul id=\"entitytabs\" class=\"nav nav-tabs\">\r\n              <li apiman-permission=\"planView\"><a href=\"{{ pluginName }}/orgs/{{org.id}}/plans\" data-field=\"toOrgPlans\" apiman-i18n-key=\"plans\">Plans</a></li>\r\n              <li apiman-permission=\"apiView\"><a href=\"{{ pluginName }}/orgs/{{org.id}}/apis\" data-field=\"toOrgAPIs\" apiman-i18n-key=\"apis\">APIs</a></li>\r\n              <li apiman-permission=\"clientView\"><a href=\"{{ pluginName }}/orgs/{{org.id}}/clients\" data-field=\"toOrgClients\" apiman-i18n-key=\"client-clients\">Client Apps</a></li>\r\n              <li class=\"active\"><a href=\"{{ pluginName }}/orgs/{{org.id}}/members\" data-field=\"toOrgMembers\" apiman-i18n-key=\"members\">Members</a></li>\r\n              <li class=\"pull-right\"><a href=\"{{ pluginName }}/orgs/{{org.id}}/activity\" data-field=\"toOrgActivity\" apiman-i18n-key=\"activity\">Change Log</a></li>\r\n            </ul>\r\n            <div id=\"entitytabsContent\" class=\"tab-content\">\r\n\r\n              <!-- Members Tab Content -->\r\n              <div class=\"tab-pane active\" id=\"tab-members\">\r\n                <div class=\"apiman-filters apiman-members-filters\">\r\n                  <div>\r\n                    <apiman-search-box id=\"members-filter\" apiman-i18n-key=\"filter-members\" function=\"filterMembers\" apiman-i18n-key=\"org-members.filter-by-member-name\" placeholder=\"Filter by member name...\" />\r\n                  </div>\r\n                  <a apiman-permission=\"orgAdmin\" href=\"{{ pluginName }}/orgs/{{org.id}}/manage-members\" class=\"btn btn-default pull-right\" data-field=\"toManageMembers\" apiman-i18n-key=\"manage-members\">Manage Members</a>\r\n                </div>\r\n                <div class=\"clearfix\"></div>\r\n                <!-- The organization\'s list of members -->\r\n                <div class=\"apiman-members\" data-field=\"members\">\r\n\r\n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"members.length > 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-12\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-members-found-for-org\">This is very strange, but apparently this Organization has no members!  Highly irregular!</p>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"members.length > 0 && filteredMembers.length == 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-12\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-members-found-for-filter\">No members found matching your filter criteria - please try searching for something different.</p>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"member in filteredMembers\">\r\n                    <div class=\"row\">\r\n                      <span class=\"title\">\r\n                        <a href=\"{{ pluginName }}/users/{{ member.userId }}/orgs\">{{ member.userName }}</a>\r\n                        <span class=\"secondary\">({{ member.userId}})</span>\r\n                      </span>\r\n                      <a class=\"apiman-summaryrow-icon\">\r\n                        <i class=\"fa fa-clock-o fa-fw\"></i>\r\n                        <span apiman-i18n-key=\"joined-on\" class=\"title-summary-item\">Joined on</span>\r\n                        <span class=\"title-summary-item\">{{ member.joinedOn | date:\'yyyy-MM-dd\' }}</span>\r\n                      </a>\r\n                    </div>\r\n                    <div class=\"row\">\r\n                      <span class=\"description\" ng-repeat=\"role in member.roles\">\r\n                        {{ role.roleName}} {{ $last ? \'\' : ($index==member.roles.length-2) ? \' and \' : \', \' }}\r\n                      </span>\r\n                    </div>\r\n                    <hr/>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <!-- End Members Tab Content -->\r\n\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Center Content -->\r\n\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/org/org-new-member.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div id=\"form-page\" class=\"container apiman-entity-new page\" ng-controller=\"Apiman.OrgNewMemberController as onmCtrl\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <h2 class=\"title\" apiman-i18n-key=\"new-member\">New Member</h2>\n      </div>\n      <!-- Helpful hint -->\n      <div class=\"row\">\n        <p apiman-i18n-key=\"new-member-help-text\" class=\"col-md-6 apiman-label-faded\">Add a member to this organization by searching for a User below.  Once the User is located, simply select their roles and click \'Add Member\'.</p>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- User search bar -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"find-user\">Find a User</dt>\n          <dd>\n            <div class=\"\" style=\"line-height: normal\">\n              <form ng-submit=\"findUsers(searchText)\">\n                <input ng-model=\"searchText\" type=\"text\" class=\"apiman-form-control form-control input-search\" apiman-i18n-key=\"new-member.search-by-user\" placeholder=\"Search by user name...\">\n                <button type=\"submit\" apiman-action-btn=\"\" class=\"btn btn-default btn-search\" data-field=\"searchButton\" apiman-i18n-key=\"search\" data-icon=\"fa-cog\" placeholder=\"Searching\">Search</button>\n              </form>\n            </div>\n          </dd>\n        </dl>\n      </div>\n      <!-- User search results -->\n      <div class=\"row\">\n        <div class=\"panel panel-default input-search-results\">\n          <div class=\"panel-body container-fluid\">\n            <div ng-hide=\"searchBoxValue.length > 0\" apiman-i18n-key=\"new-member.search-for-users\">(Search for users above)</div>\n            <div ng-show=\"searchBoxValue.length > 0 && queriedUsers.length == 0\" apiman-i18n-key=\"new-member.no-users-found\">(No users found)</div>\n            <apiman-user-entry user=\"user\" selected-users=\"selectedUsers\" ng-repeat=\"user in queriedUsers\"></apiman-user-entry>\n          </div>\n        </div>\n      </div>\n      <!-- Role selections -->\n      <div class=\"row\">\n        <dl>\n          <dt apiman-i18n-key=\"roles\">Role(s)</dt>\n          <dd>\n            <div>\n              <select apiman-i18n-key=\"new-member.select-roles\" title=\"Select role(s)...\" ng-options=\"role.id as role.name for role in roles\"\n                ng-model=\"selectedRoles\" class=\"selectpicker\" apiman-select-picker=\"\"\n                multiple>\n              </select>\n            </div>\n          </dd>\n        </dl>\n      </div>\n      <!-- HR -->\n      <div class=\"row hr-row\">\n        <hr/>\n      </div>\n      <!-- Create Button -->\n      <div class=\"row\">\n        <button class=\"btn btn-primary\" apiman-i18n-key=\"add-members\" data-icon=\"fa-cog\" placeholder=\"Adding...\"\n                ng-click=\"addMembers()\" data-field=\"addMembersButton\" apiman-action-btn\n                ng-disabled=\"selectedRoles.length === 0 || countObjectKeys(selectedUsers) === 0\">\n          Add Member(s)\n        </button>\n        <a href=\"javascript:window.history.back()\" class=\"btn btn-default btn-cancel\" apiman-i18n-key=\"cancel\">Cancel</a>\n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/org/org-plans.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.OrgPlansController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/org/org_bc.include\'\"></div>\r\n      <div class=\"row\">\r\n        <div ng-include=\"\'plugins/api-manager/html/org/org_entity.include\'\"></div>\r\n        <!-- Center Content -->\r\n        <div class=\"col-md-8\">\r\n          <div class=\"apiman-entitytabs\">\r\n            <div ng-include=\"\'plugins/api-manager/html/org/org_tabs.include\'\"></div>\r\n            <div id=\"entitytabsContent\" class=\"tab-content\">\r\n\r\n              <!-- Plans Tab Content -->\r\n              <div class=\"tab-pane active\" id=\"tab-plans\">\r\n                <div class=\"apiman-filters apiman-plans-filters\">\r\n                  <div>\r\n                    <apiman-search-box id=\"plans-filter\" apiman-i18n-key=\"filter-org-plans\" function=\"filterPlans\" placeholder=\"Filter by plan name...\" />\r\n                  </div>\r\n                  <a apiman-permission=\"planEdit\" data-field=\"toNewPlan\" apiman-i18n-key=\"new-plan\" href=\"{{ pluginName }}/new-plan\" class=\"btn btn-primary pull-right\">New Plan</a>\r\n                </div>\r\n                <div class=\"clearfix\"></div>\r\n                <!-- The list of plans in this organization -->\r\n                <div class=\"apiman-plans\" data-field=\"plans\">\r\n\r\n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"plans.length > 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-9\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-plans-found-for-org\">There aren\'t any plans configured for this organization. That means all published APIs in this organization must be public.</p>\r\n                      </div>\r\n                      <div class=\"col-md-3\">\r\n                        <div class=\"apiman-no-entities-arrow\"></div>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"plans.length > 0 && filteredPlans.length == 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-12\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-plans-found-for-filter\">No plans found matching your filter criteria - please try searching for something different.</p>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"plan in filteredPlans\">\r\n                    <div class=\"row\">\r\n                      <span class=\"title\"><a href=\"{{ pluginName }}/orgs/{{ org.id }}/plans/{{ plan.id}}\">{{ plan.name }}</a></span>\r\n                    </div>\r\n                    <div class=\"row\">\r\n                      <span class=\"description\">{{ plan.description }}\r\n                      </span>\r\n                    </div>\r\n                    <hr/>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <!-- End Plans Tab Content -->\r\n\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Center Content -->\r\n        \r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/org/org.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.OrgRedirectController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/plan/plan-activity.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.PlanActivityController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/plan/plan_bc.include\'\"></div>\n      <!-- Entity Summary Row -->\n      <div ng-include=\"\'plugins/api-manager/html/plan/plan_entity.include\'\"></div>\n\n      <!-- Navigation + Content Row -->\n      <div class=\"row\">\n        <!-- Left hand nav -->\n        <div ng-include=\"\'plugins/api-manager/html/plan/plan_tabs.include\'\"></div>\n        <!-- /Left hand nav -->\n\n        <!-- Content -->\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\" >\n          <!-- Title and help text -->\n          <div class=\"title\" apiman-i18n-key=\"plan-activity\">Plan Activity</div>\n          <div class=\"description\" apiman-i18n-key=\"plan-activity-help\">The list below is all of the configuration changes (made by apiman users) associated with this Plan.</div>\n          <hr />\n          <apiman-activity model=\"auditEntries\" next=\"getNextPage\"/>\n        </div>\n        <!-- /Content -->\n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/plan/plan-overview.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.PlanOverviewController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/plan/plan_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/plan/plan_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/plan/plan_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\" >\r\n          <!-- Content Summary -->\r\n          <div class=\"col-md-12\">\r\n            <h1 apiman-i18n-key=\"plan-details\">Plan Details</h1>\r\n            <p apiman-i18n-key=\"plan-overview.plan-description\">\r\n              This is the plan details page.  Use this page to modify the Plan\'s meta-data and policies.\r\n              Once you have fully configured the Plan, don\'t forget to \"Lock\" it so that it can be used\r\n              by APIs in the org.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"policies\">Policies</h2>\r\n            <p apiman-i18n-key=\"plan-overview.policies-description\">\r\n              The \'Policies\' tab allows you to manage the Policy-level policies that should\r\n              be applied whenever a request is made to an API via this Plan.\r\n            </p>\r\n\r\n            <h2 apiman-i18n-key=\"activity\">Change Log</h2>\r\n            <p apiman-i18n-key=\"plan-overview.activity-description\">\r\n              The \'Change Log\' tab shows a history of all the changes made to the Plan.  Essentially\r\n              it is an audit log.\r\n            </p>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n    </div> <!-- /container -->\r\n  </div>\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/plan/plan-policies.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n  </head>\r\n\r\n  <body>\r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.PlanPoliciesController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/plan/plan_bc.include\'\"></div>\r\n      <!-- Entity Summary Row -->\r\n      <div ng-include=\"\'plugins/api-manager/html/plan/plan_entity.include\'\"></div>\r\n\r\n      <!-- Navigation + Content Row -->\r\n      <div class=\"row\">\r\n        <!-- Left hand nav -->\r\n        <div ng-include=\"\'plugins/api-manager/html/plan/plan_tabs.include\'\"></div>\r\n        <!-- /Left hand nav -->\r\n\r\n        <!-- Content -->\r\n        <div class=\"col-md-10 apiman-entity-content apiman-entity-overview\" >\r\n          <div class=\"col-md-9\">\r\n            <!-- Title and help text -->\r\n            <div class=\"title\" apiman-i18n-key=\"plan-policies\">Plan Policies</div>\r\n            <div class=\"description\" apiman-i18n-key=\"plan-policies-help\">Here is a list of all Policies defined for this Plan.  These Policies will be applied to all API invocations made by Client Apps using this Plan in a Contract (in addition to whatever Policies are defined individually by the Client App and/or API).</div>\r\n            <hr />\r\n            <!-- The list of policies -->\r\n            <div apiman-permission=\"planEdit\" apiman-status=\"Created,Ready\" class=\"apiman-filters apiman-policies-filters\">\r\n              <a apiman-i18n-key=\"add-policy\" href=\"{{ pluginName }}/orgs/{{ org.id }}/plans/{{ plan.id }}/{{ version.version }}/new-policy\" class=\"btn btn-primary pull-right\">Add Policy</a>\r\n            </div>\r\n            <div class=\"clearfix\"></div>\r\n            <div class=\"apiman-policies\" data-field=\"policies\">\r\n\r\n              <div class=\"apiman-no-content container-fluid\" ng-hide=\"policies.length > 0\">\r\n                <div class=\"row\">\r\n                  <div class=\"col-md-9\">\r\n                    <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-policies-for-plan\">It looks like there aren\'t any policies defined! That may be exactly what you want (of course) but if not, you may try defining one using the Add Policy button above...</p>\r\n                  </div>\r\n                  <div apiman-permission=\"planEdit\" apiman-status=\"Created,Ready\" class=\"col-md-3\">\r\n                    <div class=\"apiman-no-entities-arrow\"></div>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <div class=\"clearfix\"></div>\r\n              <apiman-policy-list ng-model=\"policies\" remove-function=\"removePolicy\" reorder-function=\"reorderPolicies\" type=\"plans\" org-id=\"{{ org.id }}\" page-id=\"{{ plan.id }}\" version=\"{{ version.version }}\"></policy-list>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Content -->\r\n      </div>\r\n\r\n    </div> <!-- /container -->\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/plan/plan.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.PlanRedirectController\" class=\"container page\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/user/user-activity.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.UserActivityController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/user/user_bc.include\'\"></div>\n      <div class=\"row\">\n        <!-- Left Hand Side -->\n        <div ng-include=\"\'plugins/api-manager/html/user/user_entity.include\'\"></div>\n        <!-- /Left Hand Side -->\n\n        <!-- Center Content -->\n        <div class=\"col-md-8\">\n          <div class=\"apiman-entitytabs\">\n            <div ng-include=\"\'plugins/api-manager/html/user/user_tabs.include\'\"></div>\n            <div id=\"entitytabsContent\" class=\"tab-content\">\n\n              <!-- Change Log Tab Content -->\n              <div class=\"tab-pane active\" id=\"tab-activity\">\n                <div class=\"clearfix\"></div>\n                <!-- The user\'s activity stream -->\n                <apiman-activity model=\"auditEntries\" next=\"getNextPage\"/>\n              </div>\n              <!-- End Change Log Tab Content -->\n              \n            </div>\n          </div>\n        </div>\n        <!-- /Center Content -->\n        \n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/user/user-apis.html","<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\r\n    \r\n  </head>\r\n\r\n  <body>\r\n  <div>\r\n    \r\n    <div ng-include=\"headerInclude\"></div>\r\n    <div ng-controller=\"Apiman.UserApisController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\r\n      <div ng-include=\"\'plugins/api-manager/html/user/user_bc.include\'\"></div>\r\n      <div class=\"row\">\r\n        <!-- Left Hand Side -->\r\n        <div ng-include=\"\'plugins/api-manager/html/user/user_entity.include\'\"></div>\r\n        <!-- /Left Hand Side -->\r\n\r\n        <!-- Center Content -->\r\n        <div class=\"col-md-8\">\r\n          <div class=\"apiman-entitytabs\">\r\n            <div ng-include=\"\'plugins/api-manager/html/user/user_tabs.include\'\"></div>\r\n            <div id=\"entitytabsContent\" class=\"tab-content\">\r\n\r\n              <!-- Apis Tab Content -->\r\n              <div class=\"tab-pane active\" id=\"tab-apis\">\r\n                <div class=\"apiman-filters apiman-apis-filters\">\r\n                  <div>\r\n                    <apiman-search-box id=\"apis-filter\" apiman-i18n-key=\"filter-user-apis\" function=\"filterApis\" placeholder=\"Filter by org or API name...\" />\r\n                  </div>\r\n                  <a id=\"new-api\" apiman-i18n-key=\"new-api\" data-field=\"toNewApi\" apiman-i18n-key=\"new-api\" href=\"{{ pluginName}}/new-api\" class=\"btn btn-primary pull-right\">New API</a>\r\n                </div>\r\n                <div class=\"clearfix\"></div>\r\n                <!-- The list of apis the user has access to -->\r\n                <div class=\"apiman-apis\">\r\n                  \r\n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"apis.length > 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-9\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-apis-found-for-user\">It looks like this user isn\'t responsible for any APIs. Maybe she\'s just all about the Client Apps? If not, maybe she could log in and try creating a New API.</p>\r\n                      </div>\r\n                      <div class=\"col-md-3\">\r\n                        <div class=\"apiman-no-entities-arrow\"></div>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"apis.length > 0 && filteredApis.length == 0\">\r\n                    <div class=\"row\">\r\n                      <div class=\"col-md-12\">\r\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-apis-found-for-filter\">No APIs found matching your filter criteria - please try searching for something different.</p>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n\r\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"api in filteredApis\">\r\n                    <div class=\"row\">\r\n                      <a href=\"{{ pluginName }}/orgs/{{ api.organizationId }}/apis\">{{ api.organizationName }}</a>\r\n                      <span apiman-i18n-skip>/</span>\r\n                      <span class=\"title\"><a href=\"{{ pluginName }}/orgs/{{ api.organizationId }}/apis/{{ api.id }}\">{{ api.name }}</a></span>\r\n                      <a class=\"apiman-summaryrow-icon\">\r\n                        <i class=\"fa fa-clock-o fa-fw\"></i>\r\n                        <span class=\"title-summary-item\" apiman-i18n-key=\"created-on\">Created on</span>\r\n                        <span class=\"title-summary-item\">{{ api.createdOn | date:\'yyyy-MM-dd\' }}</span>\r\n                      </a>\r\n                    </div>\r\n                    <div class=\"row\">\r\n                      <span class=\"description\">\r\n                        {{ api.description }}\r\n                      </span>\r\n                    </div>\r\n                    <hr/>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <!-- End Apis Tab Content -->\r\n              \r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!-- /Center Content -->\r\n        \r\n      </div>\r\n    </div> <!-- /container -->\r\n  </body>\r\n</html>\r\n");
$templateCache.put("plugins/api-manager/html/user/user-clients.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    \n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>   \n    <div ng-controller=\"Apiman.UserClientsController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/user/user_bc.include\'\"></div>\n      <div class=\"row\">\n        <!-- Left Hand Side -->\n        <div ng-include=\"\'plugins/api-manager/html/user/user_entity.include\'\"></div>\n        <!-- /Left Hand Side -->\n\n        <!-- Center Content -->\n        <div class=\"col-md-8\">\n          <div class=\"apiman-entitytabs\">\n            <div ng-include=\"\'plugins/api-manager/html/user/user_tabs.include\'\"></div>\n            <div id=\"entitytabsContent\" class=\"tab-content\">\n\n              <!-- Client Apps Tab Content -->\n              <div class=\"tab-pane active\" id=\"tab-clients\">\n                <div class=\"apiman-filters apiman-clients-filters\">\n                  <div>\n                    <apiman-search-box id=\"clients-filter\" apiman-i18n-key=\"filter-user-clients\" function=\"filterClients\" placeholder=\"Filter by org or client name...\" />\n                  </div>\n                  <a id=\"new-client\" apiman-i18n-key=\"new-client\" data-field=\"toNewClient\" href=\"{{ pluginName }}/new-client\" class=\"btn btn-primary pull-right\">New Client App</a>\n                </div>\n                <div class=\"clearfix\"></div>\n                <!-- The list of clients the user has access to -->\n                <div class=\"apiman-clients\" data-field=\"clients\">\n                  \n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"clients.length > 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-9\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-clients-found-for-user\">User is not managing any Client Apps. Perhaps that\'s just not her thing. But if it is, she can create a new Client App using the New Client App button above.</p>\n                      </div>\n                      <div class=\"col-md-3\">\n                        <div class=\"apiman-no-entities-arrow\"></div>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"clients.length > 0 && filteredClients.length == 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-12\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-clients-found-for-filter\">No Client Apps found matching your filter criteria - please try searching for something different.</p>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"client in filteredClients\">\n                    <div class=\"row\">\n                      <a href=\"{{ pluginName}}/orgs/{{ client.organizationId }}/clients\">{{ client.organizationName }}</a>\n                      <span apiman-i18n-skip>/</span>\n                      <span class=\"title\"><a href=\"{{ pluginName }}/orgs/{{ client.organizationId }}/clients/{{ client.id}}\">{{ client.name }}</a></span>\n                    </div>\n                    <div class=\"row\">\n                      <span class=\"description\">\n                        {{ client.description }}\n                      </span>\n                    </div>\n                    <hr/>\n                  </div>\n                </div>\n              </div>\n              <!-- End Client Apps Tab Content -->\n              \n            </div>\n          </div>\n        </div>\n        <!-- /Center Content -->\n        \n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/user/user-orgs.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.UserOrgsController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div ng-include=\"\'plugins/api-manager/html/user/user_bc.include\'\"></div>\n      <div class=\"row\">\n        <!-- Left Hand Side -->\n        <div ng-include=\"\'plugins/api-manager/html/user/user_entity.include\'\"></div>\n        <!-- /Left Hand Side -->\n\n        <!-- Center Content -->\n        <div class=\"col-md-8\">\n          <div class=\"apiman-entitytabs\">\n            <div ng-include=\"\'plugins/api-manager/html/user/user_tabs.include\'\"></div>\n            <div id=\"entitytabsContent\" class=\"tab-content\">\n              \n              <!-- Organizations Tab Content -->\n              <div class=\"tab-pane active\" id=\"tab-orgs\">\n                <div class=\"apiman-filters apiman-organizations-filters\">\n                  <div>\n                    <apiman-search-box filter=\"orgs-filter\" apiman-i18n-key=\"filter-user-orgs\" function=\"filterOrgs\" placeholder=\"Filter by organization name...\" />\n                  </div>\n                  <a ng-hide=\"noCreateOrg\" id=\"new-org\" data-field=\"toNewOrg\" href=\"{{ pluginName }}/new-org\" class=\"btn btn-primary pull-right\" apiman-i18n-key=\"new-org\">New Org</a>\n                </div>\n                <div class=\"clearfix\"></div>\n                <!-- The list of organizations the user belongs to -->\n                <div class=\"apiman-organizations\">\n\n                  <div class=\"apiman-no-content container-fluid\" ng-hide=\"organizations.length > 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-9\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-orgs-found-for-user\">No organizations found. This user should be granted membership in an organization or perhaps she can create a new one with the button above.</p>\n                      </div>\n                      <div class=\"col-md-3\">\n                        <div class=\"apiman-no-entities-arrow\"></div>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"apiman-no-content container-fluid\" ng-show=\"organizations.length > 0 && filteredOrgs.length == 0\">\n                    <div class=\"row\">\n                      <div class=\"col-md-12\">\n                        <p class=\"apiman-no-entities-description\" apiman-i18n-key=\"no-orgs-found-for-filter\">No organizations found matching your filter criteria - please try searching for something different.</p>\n                      </div>\n                    </div>\n                  </div>\n\n                  <div class=\"container-fluid apiman-summaryrow\" ng-repeat=\"org in filteredOrgs\">\n                    <div class=\"row\">\n                      <span class=\"title\"><a href=\"{{ pluginName }}/orgs/{{ org.id }}\">{{ org.name }}</a></span>\n                    </div>\n                    <div class=\"row\">\n                      <span class=\"description\">{{ org.description }}</span>\n                    </div>\n                    <hr/>\n                  </div>\n                </div>\n              </div>\n              <!-- End Organizations Tab Content -->\n              \n            </div>\n          </div>\n        </div>\n        <!-- /Center Content -->\n        \n      </div>\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/user/user-profile.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.UserProfileController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n      <div class=\"row\">\n        <div class=\"col-md-12\">\n          <h1><i class=\"fa fa-user fa-fw\"></i> <span apiman-i18n-key=\"user-profile\">User Profile</span></h1>\n          <hr />\n        </div>\n      </div>\n      <div class=\"row apiman-settings\">\n        <div class=\"col-md-6\">\n          <div class=\"settings-detail\">\n            <form role=\"form\">\n              <div class=\"form-group\">\n                <label apiman-i18n-key=\"profile.username\" for=\"usernameInput\">Username</label>\n                <input ng-model=\"user.username\" type=\"text\" class=\"apiman-form-control form-control\" id=\"apiman-username\" disabled=\"disabled\">\n              </div>\n              <div class=\"form-group\">\n                <label apiman-i18n-key=\"profile.full-name\" for=\"nameInput\">Full Name</label>\n                <input ng-model=\"updatedUser.fullName\" type=\"text\" class=\"apiman-form-control form-control\" id=\"apiman-name\" apiman-i18n-key=\"profile.enter-full-name\" placeholder=\"Enter your full name...\">\n              </div>\n              <div class=\"form-group\">\n                <label apiman-i18n-key=\"profile.email\" for=\"emailInput\">Email</label>\n                <input ng-model=\"updatedUser.email\" type=\"email\" class=\"apiman-form-control form-control\" id=\"apiman-email\" apiman-i18n-key=\"profile.enter-email\" placeholder=\"Email address...\">\n              </div>\n              <button id=\"update-profile\" ng-disabled=\"!isDirty || !isValid\" apiman-action-btn=\"\" class=\"btn btn-primary\" data-field=\"updateButton\" apiman-i18n-key=\"update-profile\" placeholder=\"Updating...\" data-icon=\"fa-cog\" ng-click=\"save()\">Update Profile</button>\n              <a id=\"cancel\"\n                 class=\"btn btn-default btn-cancel cancel\"\n                 ng-click=\"cancel();\"\n                 apiman-i18n-key=\"cancel\">Cancel</a>\n            </form>\n          </div>\n        </div>\n      </div>\n    </div> <!-- /container -->\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/user/user.html","<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  </head>\n\n  <body>\n  <div>\n    \n    <div ng-include=\"headerInclude\"></div>\n    <div ng-controller=\"Apiman.UserRedirectController\" class=\"page container\" data-field=\"page\" ng-cloak=\"\" ng-show=\"pageState == \'loaded\'\">\n    </div> <!-- /container -->\n  </div>\n  </body>\n</html>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/auditUnknown.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.did-something-unknown\">did something we didn\'t recognize!</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditAddPolicy.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.added-policy-to\">added a policy to</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <span apiman-i18n-key=\"audit.policy-added\">Policy added:</span>\r\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\r\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditBreakContract.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.broke-contract-with-api\">broke a contract with API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <span apiman-i18n-key=\"audit.contract-broken-between-client\">A contract was broken between client app</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients\">{{ data.clientOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}\">{{ data.clientId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}/{{ data.clientVersion }}\">{{ data.clientVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.and-api\">and API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis\">{{ data.apiOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}\">{{ data.apiId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}/{{ data.apiVersion }}\">{{ data.apiVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.through-version\">through version</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}/{{ data.planVersion }}\">{{ data.planVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.of-plan\">of plan</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}\">{{ data.planId }}</a>\r\n  <span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditCreate.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.created-api\">created API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span ng-show=\"entry.entityVersion\">\r\n    <span apiman-i18n-key=\"audit.version\">version</span>\r\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\r\n  </span>\r\n  <span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditCreateContract.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.created-contract-with-api\">created a contract with API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <span apiman-i18n-key=\"audit.contract-created-between-client\">A contract was created between client app</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients\">{{ data.clientOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}\">{{ data.clientId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}/{{ data.clientVersion }}\">{{ data.clientVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.and-api\">and API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/clients\">{{ data.apiOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}\">{{ data.apiId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}/{{ data.apiVersion }}\">{{ data.apiVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.through-version\">through version</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}/{{ data.planVersion }}\">{{ data.planVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.of-plan\">of plan</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}\">{{ data.planId }}</a>\r\n  <span apiman-i18n-skip>.</span>\r\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditDelete.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.deleted-api\">deleted API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span ng-show=\"entry.entityVersion\">\r\n    <span apiman-i18n-key=\"audit.version\">version</span>\r\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\r\n  </span>\r\n  <span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditDeleteDefinition.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.deleted-api-def\">deleted the API definition from</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditPublish.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.published-api\">published API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditRemovePolicy.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.removed-policy-from\">removed a policy from</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <span apiman-i18n-key=\"audit.policy-removed\">Policy removed:</span>\r\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\r\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditReorderPolicies.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.reordered-policies\">reordered policies in</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditRetire.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.retired-api\">retired API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditUpdate.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.updated-api\">updated API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span ng-show=\"entry.entityVersion\">\r\n    <span apiman-i18n-key=\"audit.version\">version</span>\r\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\r\n  </span>\r\n  <span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <div ng-repeat=\"item in data.changes\">\r\n    <div>\r\n      <span class=\"capitalized emphasis\">{{ item.name }}</span>\r\n    </div>\r\n    <div class=\"activity-value\">\r\n      <span>{{ item.after }}</span>\r\n    </div>\r\n  </div>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditUpdateDefinition.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.updated-api-def\">updated the API definition for</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Api/auditUpdatePolicy.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.updated-policy-in\">updated a policy in</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/apis/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <span apiman-i18n-key=\"audit.policy-updated\">Policy updated:</span>\r\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\r\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditAddPolicy.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.added-policy-to\">added a policy to</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <span apiman-i18n-key=\"audit.policy-added\">Policy added:</span>\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditBreakContract.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.broke-contract-from-client\">broke a contract from client app</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <span apiman-i18n-key=\"audit.contract-broken-between-client\">A contract was broken between client app</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients\">{{ data.clientOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}\">{{ data.clientId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}/{{ data.clientVersion }}\">{{ data.clientVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.and-api\">and API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis\">{{ data.apiOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}\">{{ data.apiId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}/{{ data.apiVersion }}\">{{ data.apiVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.through-version\">through version</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}/{{ data.planVersion }}\">{{ data.planVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.of-plan\">of plan</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}\">{{ data.planId }}</a>\r\n  <span apiman-i18n-skip>.</span>\r\n</div>\r\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditCreate.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.created-client\">created client app</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span ng-show=\"entry.entityVersion\">\n    <span apiman-i18n-key=\"audit.version\">version</span>\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\n  </span>\n  <span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditCreateContract.html","<div class=\"row\">\r\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\r\n  <span apiman-i18n-key=\"audit.created-contract-from-client\">created a contract from client app</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients\">{{ entry.organizationId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\r\n  <span apiman-i18n-key=\"audit.version\">version</span>\r\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\r\n</div>\r\n<div class=\"row boxed-row\">\r\n  <span apiman-i18n-key=\"audit.contract-created-between-client\">A contract was created between client app</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients\">{{ data.clientOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}\">{{ data.clientId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.clientOrgId }}/clients/{{ data.clientId }}/{{ data.clientVersion }}\">{{ data.clientVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.and-api\">and API</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis\">{{ data.apiOrgId }}</a>\r\n  <span apiman-i18n-skip>/</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}\">{{ data.apiId }}</a>\r\n  <span apiman-i18n-skip>:</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.apiOrgId }}/apis/{{ data.apiId }}/{{ data.apiVersion }}\">{{ data.apiVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.through-version\">through version</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}/{{ data.planVersion }}\">{{ data.planVersion }}</a>\r\n  <span apiman-i18n-key=\"audit.of-plan\">of plan</span>\r\n  <a href=\"{{ pluginName }}/orgs/{{ data.planOrgId }}/plans/{{ data.planId }}\">{{ data.planId }}</a>\r\n  <span apiman-i18n-skip>.</span>\r\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditDelete.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.deleted-client\">deleted client app</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditRegister.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.registered-client\">registered client app</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditRemovePolicy.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.removed-policy-from\">removed a policy from</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <span apiman-i18n-key=\"audit.policy-removed\">Policy removed:</span>\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditReorderPolicies.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.reordered-policies-in\">reordered policies in</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditUnregister.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.retired-client\">retired client app</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditUpdate.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.updated-client-client\">updated client app</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span ng-show=\"entry.entityVersion\">\n    <span apiman-i18n-key=\"audit.version\">version</span>\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\n  </span>\n  <span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <div ng-repeat=\"item in data.changes\">\n    <div>\n      <span class=\"capitalized emphasis\">{{ item.name }}</span>\n    </div>\n    <div class=\"activity-value\">\n      <span>{{ item.after }}</span>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Client/auditUpdatePolicy.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.updated-policy-in\">updated a policy in</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/clients/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <span apiman-i18n-key=\"audit.policy-updated\">Policy updated:</span>\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Organization/auditCreate.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.created-org\">created organization</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a><span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Organization/auditDelete.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.deleted-org\">deleted organization</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a><span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Organization/auditGrant.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.granted-memberships\">granted membership(s) in </span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <ul>\n    <li ng-repeat=\"role in data.roles\">\n      <span>\n        <a href=\"{{ pluginName }}/users/{{ data.userId }}/clients\">{{ data.userId }}</a>\n        <span apiman-i18n-key=\"audit.was-given-role\">was given role</span>\n        <span class=\"emphasis\">{{ role }}</span>\n      </span>\n    </li>\n  </ul>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Organization/auditRevoke.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.revoked-memberships\">revoked membership(s) in </span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <ul>\n    <li ng-repeat=\"role in data.roles\" ng-show=\"data.roles[0] != \'*\'\">\n      <span>\n        <span apiman-i18n-key=\"audit.role\">Role</span>\n        <span class=\"emphasis\">{{ role }}</span>\n        <span apiman-i18n-key=\"audit.was-taken-away-from\">was taken away from</span>\n        <a href=\"{{ pluginName }}/users/{{ data.userId }}/clients\">{{ data.userId }}</a><span apiman-i18n-skip>.</span>\n      </span>\n    </li>\n  </ul>\n  <span ng-show=\"data.roles[0] == \'*\'\">\n    <span class=\"emphasis\" apiman-i18n-key=\"audit.all-roles\">All roles</span>\n    <span apiman-i18n-key=\"audit.were-taken-away-from\">were taken away from</span>\n    <a href=\"{{ pluginName }}/users/{{ data.userId }}/clients\">{{ data.userId }}</a><span apiman-i18n-skip>.</span>\n  </span>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Organization/auditUpdate.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.updated-org\">updated organization</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <div ng-repeat=\"item in data.changes\">\n    <div>\n      <span class=\"capitalized emphasis\">{{ item.name }}</span>\n    </div>\n    <div class=\"activity-value\">\n      <span>{{ item.after }}</span>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditAddPolicy.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.added-policy-to\">added a policy to</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <span apiman-i18n-key=\"audit.policy-added\">Policy added:</span>\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditCreate.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.created-plan\">created plan</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span ng-show=\"entry.entityVersion\">\n    <span apiman-i18n-key=\"audit.version\">version</span>\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\n  </span>\n  <span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditDelete.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.deleted-plan\">deleted plan</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span ng-show=\"entry.entityVersion\">\n    <span apiman-i18n-key=\"audit.version\">version</span>\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\n  </span>\n  <span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditLock.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.locked-plan\">locked plan</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditRemovePolicy.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.removed-policy-from\">removed a policy from</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <span apiman-i18n-key=\"audit.policy-removed\">Policy removed:</span>\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\n</div>");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditReorderPolicies.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.reordered-policies\">reordered policies in</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditUpdate.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.updated-plan\">updated plan</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span ng-show=\"entry.entityVersion\">\n    <span apiman-i18n-key=\"audit.version\">version</span>\n    <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a>\n  </span>\n  <span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <div ng-repeat=\"item in data.changes\">\n    <div>\n      <span class=\"capitalized emphasis\">{{ item.name }}</span>\n    </div>\n    <div class=\"activity-value\">\n      <span>{{ item.after }}</span>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/api-manager/html/directives/audit/Plan/auditUpdatePolicy.html","<div class=\"row\">\n  <a href=\"{{ pluginName }}/users/{{ entry.who }}\">{{ entry.who }}</a>\n  <span apiman-i18n-key=\"audit.updated-policy-in\">updated a policy in</span>\n  <a href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans\">{{ entry.organizationId }}</a>\n  <span apiman-i18n-skip>/</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}\">{{ entry.entityId }}</a>\n  <span apiman-i18n-key=\"audit.version\">version</span>\n  <a class=\"emphasis\" href=\"{{ pluginName }}/orgs/{{ entry.organizationId }}/plans/{{ entry.entityId }}/{{ entry.entityVersion }}\">{{ entry.entityVersion }}</a><span apiman-i18n-skip>.</span>\n</div>\n<div class=\"row boxed-row\">\n  <span apiman-i18n-key=\"audit.policy-updated\">Policy updated:</span>\n  <span class=\"emphasis\">{{ data.policyDefId }}</span>\n</div>");}]);