/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.common.util;

import io.apiman.test.common.plan.TestGroupType;
import io.apiman.test.common.plan.TestPlan;
import io.apiman.test.common.plan.TestType;
import io.apiman.test.common.resttest.RestTest;
import io.apiman.test.common.util.TestUtil;
import io.apiman.test.common.util.TestVariableResolver;
import io.apiman.test.common.util.TestVariableResolverFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.NumericNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.junit.Assert;
import org.mvel2.MVEL;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPlanRunner {
    private static Logger logger = LoggerFactory.getLogger(TestPlanRunner.class);
    private CloseableHttpClient client = HttpClientBuilder.create().build();
    private String baseApiUrl;

    public TestPlanRunner(String baseApiUrl) {
        this.baseApiUrl = baseApiUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestPlan(String resourcePath, ClassLoader cl) {
        this.client = HttpClientBuilder.create().build();
        try {
            TestPlan testPlan = TestUtil.loadTestPlan(resourcePath, cl);
            this.log("", new Object[0]);
            this.log("-------------------------------------------------------------------------------", new Object[0]);
            this.log("Executing Test Plan: " + resourcePath, new Object[0]);
            this.log("   Base API URL: " + this.baseApiUrl, new Object[0]);
            this.log("-------------------------------------------------------------------------------", new Object[0]);
            this.log("", new Object[0]);
            for (TestGroupType group : testPlan.getTestGroup()) {
                this.log("-----------------------------------------------------------", new Object[0]);
                this.log("Starting Test Group [{0}]", group.getName());
                this.log("-----------------------------------------------------------", new Object[0]);
                for (TestType test : group.getTest()) {
                    String rtPath = test.getValue();
                    this.log("Executing REST Test [{0}] - {1}", test.getName(), rtPath);
                    RestTest restTest = TestUtil.loadRestTest(rtPath, cl);
                    this.runTest(restTest);
                    this.log("REST Test Completed", new Object[0]);
                    this.log("+++++++++++++++++++", new Object[0]);
                }
                this.log("Test Group [{0}] Completed Successfully", group.getName());
            }
            this.log("", new Object[0]);
            this.log("-------------------------------------------------------------------------------", new Object[0]);
            this.log("Test Plan successfully executed: " + resourcePath, new Object[0]);
            this.log("-------------------------------------------------------------------------------", new Object[0]);
            this.log("", new Object[0]);
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.client = null;
        }
    }

    private void runTest(RestTest restTest) throws Error {
        try {
            StringEntity entity;
            String requestPath = TestUtil.doPropertyReplacement(restTest.getRequestPath());
            URI uri = this.getUri(requestPath);
            HttpGet request = null;
            if (restTest.getRequestMethod().equalsIgnoreCase("GET")) {
                request = new HttpGet();
            } else if (restTest.getRequestMethod().equalsIgnoreCase("POST")) {
                request = new HttpPost();
                entity = new StringEntity(restTest.getRequestPayload());
                ((HttpPost)request).setEntity((HttpEntity)entity);
            } else if (restTest.getRequestMethod().equalsIgnoreCase("PUT")) {
                request = new HttpPut();
                entity = new StringEntity(restTest.getRequestPayload());
                ((HttpPut)request).setEntity((HttpEntity)entity);
            } else if (restTest.getRequestMethod().equalsIgnoreCase("DELETE")) {
                request = new HttpDelete();
            }
            if (request == null) {
                Assert.fail((String)("Unsupported method in REST Test: " + restTest.getRequestMethod()));
            }
            request.setURI(uri);
            Map<String, String> requestHeaders = restTest.getRequestHeaders();
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
            String authorization = this.createBasicAuthorization(restTest.getUsername(), restTest.getPassword());
            if (authorization != null) {
                request.setHeader("Authorization", authorization);
            }
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
            this.assertResponse(restTest, (HttpResponse)response);
        }
        catch (Error e) {
            this.logPlain("[ERROR] " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private String createBasicAuthorization(String username, String password) {
        if (username == null || username.trim().length() == 0) {
            return null;
        }
        String val = username + ":" + password;
        return "Basic " + Base64.encodeBase64String((byte[])val.getBytes()).trim();
    }

    private void assertResponse(RestTest restTest, HttpResponse response) {
        int actualStatusCode = response.getStatusLine().getStatusCode();
        try {
            Assert.assertEquals((String)("Unexpected REST response status code.  Status message: " + response.getStatusLine().getReasonPhrase()), (long)restTest.getExpectedStatusCode(), (long)actualStatusCode);
        }
        catch (Error e) {
            if (actualStatusCode >= 400) {
                try {
                    InputStream content = response.getEntity().getContent();
                    String payload = IOUtils.toString((InputStream)content);
                    System.out.println("------ START ERROR PAYLOAD ------");
                    System.out.println(payload);
                    System.out.println("------ END   ERROR PAYLOAD ------");
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw e;
        }
        for (Map.Entry<String, String> entry : restTest.getExpectedResponseHeaders().entrySet()) {
            String expectedHeaderName = entry.getKey();
            if (expectedHeaderName.startsWith("X-RestTest-")) continue;
            String expectedHeaderValue = entry.getValue();
            Header header = response.getFirstHeader(expectedHeaderName);
            Assert.assertNotNull((String)("Expected header to exist but was not found: " + expectedHeaderName), (Object)header);
            String actualValue = header.getValue();
            Assert.assertEquals((Object)expectedHeaderValue, (Object)actualValue);
        }
        Header ctHeader = response.getFirstHeader("Content-Type");
        if (ctHeader == null) {
            this.assertNoPayload(restTest, response);
        } else {
            String ct = ctHeader.getValue();
            if (ct.equals("application/json")) {
                this.assertJsonPayload(restTest, response);
            } else if (ct.equals("text/plain")) {
                this.assertTextPayload(restTest, response);
            } else {
                Assert.fail((String)("Unsupported response payload type: " + ct));
            }
        }
    }

    private void assertNoPayload(RestTest restTest, HttpResponse response) {
        String expectedPayload = restTest.getExpectedResponsePayload();
        if (expectedPayload != null && expectedPayload.trim().length() > 0) {
            Assert.fail((String)"Expected a payload but didn't get one.");
        }
    }

    private void assertJsonPayload(RestTest restTest, HttpResponse response) {
        InputStream inputStream = null;
        try {
            inputStream = response.getEntity().getContent();
            ObjectMapper jacksonParser = new ObjectMapper();
            JsonNode actualJson = jacksonParser.readTree(inputStream);
            this.bindVariables(actualJson, restTest);
            String expectedPayload = TestUtil.doPropertyReplacement(restTest.getExpectedResponsePayload());
            Assert.assertNotNull((String)"REST Test missing expected JSON payload.", (Object)expectedPayload);
            JsonNode expectedJson = jacksonParser.readTree(expectedPayload);
            try {
                this.assertJson(restTest, expectedJson, actualJson);
            }
            catch (Error e) {
                System.out.println("--- START FAILED JSON PAYLOAD ---");
                System.out.println(actualJson.toString());
                System.out.println("--- END FAILED JSON PAYLOAD ---");
                throw e;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void bindVariables(JsonNode actualJson, RestTest restTest) {
        for (String headerName : restTest.getExpectedResponseHeaders().keySet()) {
            if (!headerName.startsWith("X-RestTest-BindTo-")) continue;
            String bindExpression = restTest.getExpectedResponseHeaders().get(headerName);
            String bindVarName = headerName.substring("X-RestTest-BindTo-".length());
            String bindValue = this.evaluate(bindExpression, actualJson);
            this.log("-- Binding value in response --", new Object[0]);
            this.log("\tExpression: " + bindExpression, new Object[0]);
            this.log("\t    To Var: " + bindVarName, new Object[0]);
            this.log("\t New Value: " + bindValue, new Object[0]);
            if (bindValue == null) {
                System.clearProperty(bindVarName);
                continue;
            }
            System.setProperty(bindVarName, bindValue);
        }
    }

    private String evaluate(String bindExpression, JsonNode json) {
        PropertyHandlerFactory.registerPropertyHandler(ObjectNode.class, (PropertyHandler)new PropertyHandler(){

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                throw new RuntimeException("Not supported!");
            }

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                ObjectNode node = (ObjectNode)contextObj;
                TestVariableResolver resolver = new TestVariableResolver((JsonNode)node, name);
                return resolver.getValue();
            }
        });
        return String.valueOf(MVEL.eval((String)bindExpression, (VariableResolverFactory)new TestVariableResolverFactory(json)));
    }

    private void assertJson(RestTest restTest, JsonNode expectedJson, JsonNode actualJson) {
        if (expectedJson instanceof ArrayNode) {
            int idx;
            JsonNode actualValue = actualJson;
            ArrayNode expectedArray = (ArrayNode)expectedJson;
            Assert.assertEquals((String)("Expected JSON array but found non-array [" + actualValue.getClass().getSimpleName() + "] instead."), expectedJson.getClass(), actualValue.getClass());
            ArrayNode actualArray = (ArrayNode)actualValue;
            Assert.assertEquals((String)"Array size mismatch.", (long)expectedArray.size(), (long)actualArray.size());
            String ordering = restTest.getExpectedResponseHeaders().get("X-RestTest-ArrayOrdering");
            JsonNode[] expected = new JsonNode[expectedArray.size()];
            JsonNode[] actual = new JsonNode[actualArray.size()];
            for (idx = 0; idx < expected.length; ++idx) {
                expected[idx] = expectedArray.get(idx);
                actual[idx] = actualArray.get(idx);
            }
            if ("any".equals(ordering)) {
                Comparator<JsonNode> comparator = new Comparator<JsonNode>(){

                    @Override
                    public int compare(JsonNode o1, JsonNode o2) {
                        int cmp = o1.toString().compareTo(o2.toString());
                        if (cmp == 0) {
                            cmp = 1;
                        }
                        return cmp;
                    }
                };
                Arrays.sort(expected, comparator);
                Arrays.sort(actual, comparator);
            }
            for (idx = 0; idx < expected.length; ++idx) {
                this.assertJson(restTest, expected[idx], actual[idx]);
            }
        } else {
            Iterator fields = expectedJson.getFields();
            while (fields.hasNext()) {
                JsonNode actualValue;
                Object actual;
                JsonNode actualValue2;
                Object expected;
                Map.Entry entry = (Map.Entry)fields.next();
                String expectedFieldName = (String)entry.getKey();
                JsonNode expectedValue = (JsonNode)entry.getValue();
                if (expectedValue instanceof TextNode) {
                    TextNode tn = (TextNode)expectedValue;
                    expected = tn.getTextValue();
                    actualValue2 = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON text field '" + expectedFieldName + "' with value '" + (String)expected + "' but was not found."), (Object)actualValue2);
                    Assert.assertEquals((String)("Expected JSON text field '" + expectedFieldName + "' with value '" + (String)expected + "' but found non-text [" + actualValue2.getClass().getSimpleName() + "] field with that name instead."), TextNode.class, actualValue2.getClass());
                    actual = ((TextNode)actualValue2).getTextValue();
                    Assert.assertEquals((String)("Value mismatch for text field '" + expectedFieldName + "'."), (Object)expected, (Object)actual);
                    continue;
                }
                if (expectedValue instanceof NumericNode) {
                    NumericNode numeric = (NumericNode)expectedValue;
                    expected = numeric.getNumberValue();
                    actualValue2 = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON numeric field '" + expectedFieldName + "' with value '" + expected + "' but was not found."), (Object)actualValue2);
                    Assert.assertEquals((String)("Expected JSON numeric field '" + expectedFieldName + "' with value '" + expected + "' but found non-numeric [" + actualValue2.getClass().getSimpleName() + "] field with that name instead."), expectedValue.getClass(), actualValue2.getClass());
                    actual = ((NumericNode)actualValue2).getNumberValue();
                    Assert.assertEquals((String)("Value mismatch for numeric field '" + expectedFieldName + "'."), (Object)expected, (Object)actual);
                    continue;
                }
                if (expectedValue instanceof BooleanNode) {
                    BooleanNode bool = (BooleanNode)expectedValue;
                    expected = bool.getBooleanValue();
                    actualValue2 = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON boolean field '" + expectedFieldName + "' with value '" + expected + "' but was not found."), (Object)actualValue2);
                    Assert.assertEquals((String)("Expected JSON boolean field '" + expectedFieldName + "' with value '" + expected + "' but found non-boolean [" + actualValue2.getClass().getSimpleName() + "] field with that name instead."), expectedValue.getClass(), actualValue2.getClass());
                    actual = ((BooleanNode)actualValue2).getBooleanValue();
                    Assert.assertEquals((String)("Value mismatch for boolean field '" + expectedFieldName + "'."), (Object)expected, (Object)actual);
                    continue;
                }
                if (expectedValue instanceof ObjectNode) {
                    actualValue = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected parent JSON field '" + expectedFieldName + "' but was not found."), (Object)actualValue);
                    Assert.assertEquals((String)("Expected parent JSON field '" + expectedFieldName + "' but found field of type '" + actualValue.getClass().getSimpleName() + "'."), ObjectNode.class, actualValue.getClass());
                    this.assertJson(restTest, expectedValue, actualValue);
                    continue;
                }
                if (expectedValue instanceof ArrayNode) {
                    actualValue = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON array field '" + expectedFieldName + "' but was not found."), (Object)actualValue);
                    ArrayNode expectedArray = (ArrayNode)expectedValue;
                    Assert.assertEquals((String)("Expected JSON array field '" + expectedFieldName + "' but found non-array [" + actualValue.getClass().getSimpleName() + "] field with that name instead."), expectedValue.getClass(), actualValue.getClass());
                    ArrayNode actualArray = (ArrayNode)actualValue;
                    Assert.assertEquals((String)("Field '" + expectedFieldName + "' array size mismatch."), (long)expectedArray.size(), (long)actualArray.size());
                    this.assertJson(restTest, (JsonNode)expectedArray, (JsonNode)actualArray);
                    continue;
                }
                if (expectedValue instanceof NullNode) {
                    actualValue = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected Null JSON field '" + expectedFieldName + "' but was not found."), (Object)actualValue);
                    Assert.assertEquals((String)("Expected Null JSON field '" + expectedFieldName + "' but found field of type '" + actualValue.getClass().getSimpleName() + "'."), NullNode.class, actualValue.getClass());
                    continue;
                }
                Assert.fail((String)("Unsupported field type: " + expectedValue.getClass().getSimpleName()));
            }
        }
    }

    private void assertTextPayload(RestTest restTest, HttpResponse response) {
        InputStream inputStream = null;
        try {
            inputStream = response.getEntity().getContent();
            List lines = IOUtils.readLines((InputStream)inputStream);
            StringBuilder builder = new StringBuilder();
            for (String line : lines) {
                builder.append(line).append("\n");
            }
            String actual = builder.toString();
            String expected = restTest.getExpectedResponsePayload();
            Assert.assertEquals((String)"Response payload (text/plain) mismatch.", (Object)expected, (Object)actual);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public URI getUri(String path) throws URISyntaxException {
        return new URI(this.baseApiUrl + path);
    }

    private void log(String message, Object ... params) {
        String outmsg = MessageFormat.format(message, params);
        logger.info("    >> " + outmsg);
    }

    private void logPlain(String message) {
        logger.info("    >> " + message);
    }
}

