/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.common.mock;

import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class EchoResponse {
    private String method;
    private String resource;
    private String uri;
    private Map<String, String> headers = new HashMap<String, String>();
    private Long bodyLength;
    private String bodySha1;

    public static EchoResponse from(HttpServletRequest request, boolean withBody) {
        EchoResponse response = new EchoResponse();
        response.setMethod(request.getMethod());
        response.setResource(request.getRequestURI());
        response.setUri(request.getRequestURI());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = request.getHeader(name);
            response.getHeaders().put(name, value);
        }
        if (withBody) {
            long totalBytes = 0L;
            ServletInputStream is = null;
            try {
                is = request.getInputStream();
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                byte[] data = new byte[1024];
                int read = 0;
                while ((read = is.read(data)) != -1) {
                    sha1.update(data, 0, read);
                    totalBytes += (long)read;
                }
                byte[] hashBytes = sha1.digest();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < hashBytes.length; ++i) {
                    sb.append(Integer.toString((hashBytes[i] & 0xFF) + 256, 16).substring(1));
                }
                String fileHash = sb.toString();
                response.setBodyLength(totalBytes);
                response.setBodySha1(fileHash);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return response;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Long getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(Long bodyLength) {
        this.bodyLength = bodyLength;
    }

    public String getBodySha1() {
        return this.bodySha1;
    }

    public void setBodySha1(String bodySha1) {
        this.bodySha1 = bodySha1;
    }
}

