/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.common.mock;

import io.apiman.test.common.mock.EchoResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class EchoServlet
extends HttpServlet {
    private static final long serialVersionUID = 3185466526830586555L;
    private static ObjectMapper mapper = new ObjectMapper();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, true);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, true);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, false);
    }

    protected void doEchoResponse(HttpServletRequest req, HttpServletResponse resp, boolean withBody) {
        EchoResponse response = EchoResponse.from(req, withBody);
        resp.setContentType("application/json");
        try {
            mapper.writeValue((OutputStream)resp.getOutputStream(), (Object)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
    }
}

